/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;
import org.enhydra.shark.toolagent.SingletonPooledExecutor;
import org.enhydra.shark.toolagent.ToolAgentCmdProxy;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;

public class SchedulerToolAgent
extends AbstractToolAgent {
    private static final String TOOL_AGENT_CLASS_EXT_ATTR_NAME = "ToolAgentClass";
    private static final String TOOL_AGENT_CLASS_PROXY_EXT_ATTR_NAME = "ToolAgentClassProxy";

    private void info(String infoString) {
        if (null != this.cus) {
            this.cus.info(infoString);
        }
    }

    private void error(String infoString) {
        if (null != this.cus) {
            this.cus.error(infoString);
        }
    }

    @Override
    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "Wraps a ToolAgent standard call and executes them a separate\nin thread-pool.\n\nTo use define an ToolAgentClass extended attribute to the scheduler\nanother extended attribute 'ToolAgentClassProxy' to the actual\napplication to be called in a separet thread. For example: \n<ExtendedAttributes>\n  <ExtendedAttribute Name=\"ToolAgentClass\" Value=\"org.enhydra.shark.toolagent.SchedulerToolAgent\"/>\n  <ExtendedAttribute Name=\"ToolAgentClassProxy\" Value=\"org.enhydra.shark.toolagent.BshToolAgent\"/>\n  <ExtendedAttribute Name=\"Script\" Value=\"System.out.println(\"I was called...\");\"/>\n</ExtendedAttributes>\n\nTo be able to work with SchedulerToolAgent, you must define some \nproperties, and here is a section from shark's configuration file \"Shark.conf\" \nthat defines these properties:\n# Configure number of threads to execute commands and admin user/password: \nSchedulerToolAgent.threadPoolSize=3\nSchedulerToolAgent.sharkUsername=admin\nSchedulerToolAgent.sharkPassword=enhydra\n";
        return i;
    }

    @Override
    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            String extAttribs = (String)parameters[0].the_value;
            ExtendedAttributes eas = this.readParamsFromExtAttributes(extAttribs);
            ExtendedAttribute eaScheduler = eas.getFirstExtendedAttributeForName(TOOL_AGENT_CLASS_EXT_ATTR_NAME);
            String schedulerClassName = eaScheduler.getVValue();
            ExtendedAttribute eaProxy = eas.getFirstExtendedAttributeForName(TOOL_AGENT_CLASS_PROXY_EXT_ATTR_NAME);
            String proxyClassName = eaProxy.getVValue();
            int idxSchedulerClassName = extAttribs.indexOf(schedulerClassName);
            String newExtAttribs = extAttribs.substring(0, idxSchedulerClassName) + proxyClassName + extAttribs.substring(idxSchedulerClassName + schedulerClassName.length());
            parameters[0].the_value = newExtAttribs;
            this.readParamsFromExtAttributes(newExtAttribs);
            Class<?> cls = Class.forName(proxyClassName);
            ToolAgent ta = (ToolAgent)cls.newInstance();
            String sharkUsername = this.cus.getProperty("SchedulerToolAgent.sharkUsername", "admin");
            String sharkPassword = this.cus.getProperty("SchedulerToolAgent.sharkPassword", "enhydra");
            ta.configure(this.cus);
            ToolAgentCmdProxy taCmdProxy = new ToolAgentCmdProxy(this.cus, ta, proxyClassName, this.username, this.password, this.engineName, this.scope, handle, applicationName, procInstId, assId, parameters, appMode);
            SingletonPooledExecutor.getInstance(this.cus).execute(taCmdProxy);
            this.status = 4L;
        }
        catch (Throwable ex) {
            this.error("SchedulerToolAgent terminated incorrectly: " + ex);
            this.status = -1L;
            throw new ToolAgentGeneralException(ex);
        }
    }
}

