/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.concurrent.Callable;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStopped;
import org.enhydra.shark.api.internal.toolagent.ConnectFailed;
import org.enhydra.shark.api.internal.toolagent.InvalidProcessInstance;
import org.enhydra.shark.api.internal.toolagent.InvalidSessionHandle;
import org.enhydra.shark.api.internal.toolagent.InvalidToolAgentHandle;
import org.enhydra.shark.api.internal.toolagent.InvalidWorkitem;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.xpdl.elements.Tool;

public class SOAPToolAgent
implements ToolAgent {
    private static Callable<ToolAgent> SOAP_TOOL_AGENT_PROVIDER = null;
    private final ToolAgent soapToolAgentImplementation = SOAPToolAgent.instantiateImplementation();

    private static synchronized ToolAgent instantiateImplementation() throws RootException {
        if (SOAP_TOOL_AGENT_PROVIDER == null) {
            throw new RootException("No implementation provider for soap tool agent");
        }
        try {
            return SOAP_TOOL_AGENT_PROVIDER.call();
        }
        catch (Exception e) {
            throw new RootException("Failed to instantiate soap tool agent by provider", (Throwable)e);
        }
    }

    public static synchronized void registerImplementationProvider(Callable<ToolAgent> soapToolAgentProvider) {
        if (SOAP_TOOL_AGENT_PROVIDER != null) {
            throw new IllegalStateException("Soap tool agent provider already registered");
        }
        SOAP_TOOL_AGENT_PROVIDER = soapToolAgentProvider;
    }

    public static synchronized void unregisterImplementationProvider() {
        if (SOAP_TOOL_AGENT_PROVIDER == null) {
            throw new IllegalStateException("Soap tool agent provider already unregistered");
        }
        SOAP_TOOL_AGENT_PROVIDER = null;
    }

    public void configure(CallbackUtilities arg0) throws RootException {
        this.soapToolAgentImplementation.configure(arg0);
    }

    public SessionHandle connect(SharkTransaction arg0, String arg1, String arg2, String arg3, String arg4) throws ConnectFailed, ToolAgentGeneralException {
        return this.soapToolAgentImplementation.connect(arg0, arg1, arg2, arg3, arg4);
    }

    public SessionHandle connect(SharkTransaction arg0, String arg1, String arg2, String arg3, String arg4, Tool arg5) throws ConnectFailed, ToolAgentGeneralException {
        return this.soapToolAgentImplementation.connect(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public void disconnect(SharkTransaction arg0, SessionHandle arg1) throws InvalidSessionHandle, ToolAgentGeneralException {
        this.soapToolAgentImplementation.disconnect(arg0, arg1);
    }

    public void invokeApplication(SharkTransaction arg0, long arg1, String arg2, String arg3, String arg4, AppParameter[] arg5, Integer arg6) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        this.soapToolAgentImplementation.invokeApplication(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public long requestAppStatus(SharkTransaction arg0, long arg1, String arg2, String arg3, AppParameter[] arg4) throws ApplicationBusy, InvalidToolAgentHandle, InvalidWorkitem, InvalidProcessInstance, ToolAgentGeneralException {
        return this.soapToolAgentImplementation.requestAppStatus(arg0, arg1, arg2, arg3, arg4);
    }

    public void terminateApp(SharkTransaction arg0, long arg1, String arg2, String arg3) throws ApplicationNotStopped, InvalidWorkitem, InvalidProcessInstance, ApplicationBusy, ToolAgentGeneralException {
        this.soapToolAgentImplementation.terminateApp(arg0, arg1, arg2, arg3);
    }

    public String getInfo(SharkTransaction arg0) throws ToolAgentGeneralException {
        return this.soapToolAgentImplementation.getInfo(arg0);
    }

    public Object resolveInputParameters() {
        return this.soapToolAgentImplementation.resolveInputParameters();
    }
}

