/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.lang.reflect.Method;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;

public class JavaClassToolAgent
extends AbstractToolAgent {
    private static final String EXECUTION_METHOD_NAME = "execute";

    @Override
    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            this.status = 0L;
            if (this.appName == null || this.appName.trim().length() == 0) {
                this.readParamsFromExtAttributes((String)parameters[0].the_value);
            }
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> c = cl.loadClass(this.appName);
            Class[] parameterTypes = null;
            if (parameters != null) {
                parameterTypes = new Class[parameters.length - 1];
                for (int i = 1; i < parameters.length; ++i) {
                    parameterTypes[i - 1] = AppParameter.class;
                }
            }
            Method m = c.getMethod(EXECUTION_METHOD_NAME, parameterTypes);
            Object[] aps = new AppParameter[parameters.length - 1];
            System.arraycopy(parameters, 1, aps, 0, aps.length);
            m.invoke(null, aps);
            this.status = 4L;
        }
        catch (ClassNotFoundException cnf) {
            this.cus.error("JavaClassToolAgent - application " + this.appName + " terminated incorrectly, can't find class: " + cnf);
            throw new ApplicationNotDefined("Can't find class " + this.appName, (Throwable)cnf);
        }
        catch (NoSuchMethodException nsm) {
            this.cus.error("JavaClassToolAgent - application " + this.appName + " terminated incorrectly, can't find method " + EXECUTION_METHOD_NAME + " : " + nsm);
            throw new ApplicationNotDefined("Class " + this.appName + " doesn't have method " + EXECUTION_METHOD_NAME, (Throwable)nsm);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.cus.error("JavaClassToolAgent - application " + this.appName + " terminated incorrectly, can't find class definition: " + ncdfe);
            throw new ApplicationNotDefined("Class " + this.appName + " can't be executed", (Throwable)ncdfe);
        }
        catch (Throwable ex) {
            this.cus.error("JavaClassToolAgent - application " + this.appName + " terminated incorrectly: " + ex);
            this.status = -1L;
            throw new ToolAgentGeneralException(ex);
        }
    }

    @Override
    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "This tool agent executes Java classes, by calling its static method called \"execute\".\nWhen calling this tool agent's invokeApplication() method, the application \nname parameter should be the full name of the class that should be executed \nby this tool agent (the classes had to be in the class path) \n\nThis tool agent is able to understand the extended attribute with the following name:\n     * AppName - value of this attribute should represent the class name to be executed\n\n NOTE: Tool agent will read extended attributes only if they are called through\n       Default tool agent (not by shark directly) and this is the case when information \n       on which tool agent to start for XPDL application definition is not contained in mappings";
        return i;
    }
}

