/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.scripting;

import bsh.Interpreter;
import java.util.Map;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.working.CallbackUtilities;

public class BshEvaluator
implements Evaluator {
    private static final String LOG_CHANNEL = "Scripting";
    private CallbackUtilities cus;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
    }

    public boolean evaluateCondition(SharkTransaction t, String condition, Map context) throws RootException {
        if (condition == null || condition.trim().length() == 0) {
            return true;
        }
        Object eval = this.evaluateExpression(t, condition, context, Boolean.class);
        try {
            return (Boolean)eval;
        }
        catch (Exception ex) {
            this.cus.error(LOG_CHANNEL, "BshEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            this.cus.error("BshEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            throw new RootException("Result cannot be converted to boolean", (Throwable)ex);
        }
    }

    public Object evaluateExpression(SharkTransaction t, String expr, Map context, Class resultClass) throws RootException {
        Interpreter interpreter = new Interpreter();
        try {
            this.prepareContext(interpreter, context);
            Object eval = interpreter.eval(expr);
            if (eval instanceof Integer) {
                eval = new Long(((Integer)eval).intValue());
            }
            this.cus.debug(LOG_CHANNEL, "BshScriptEvaluator -> Java expression " + expr + " is evaluated to " + eval);
            return eval;
        }
        catch (Throwable ee) {
            this.cus.error(LOG_CHANNEL, "BshEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + ee.getMessage());
            this.cus.error("BshEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + ee.getMessage());
            throw new RootException("Result cannot be evaluated", ee);
        }
    }

    private void prepareContext(Interpreter interpreter, Map context) throws Exception {
        for (Map.Entry me : context.entrySet()) {
            String key = me.getKey().toString();
            Object value = me.getValue();
            interpreter.set(key, value);
        }
    }
}

