package org.enhydra.shark.repositorypersistence;

import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateTransaction;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateRepositoryTransaction
    implements RepositoryTransaction
{

    private final Session session;

    private final Transaction transaction;

    public HibernateRepositoryTransaction( HibernateTransaction hibernateTransaction )
    {
        this.session = hibernateTransaction.getSession();
        this.transaction = hibernateTransaction.getTransaction();
    }

    public Session getSession()
    {
        return session;
    }

    public Transaction getHibernateTransaction()
    {
        return transaction;
    }

    @Override
    public void commit()
        throws TransactionException
    {
        try
        {
            transaction.commit();
        }
        catch ( Exception e )
        {
            throw new TransactionException( "Failed to commit hibernate shark transaction", e );
        }
    }

    @Override
    public void rollback()
        throws TransactionException
    {
        try
        {
            transaction.rollback();
        }
        catch ( Exception e )
        {
            throw new TransactionException( "Failed to rollback hibernate shark transaction", e );
        }
    }

    @Override
    public void release()
        throws TransactionException
    {
        if ( !session.isOpen() )
        {
            return;
        }

        try
        {
            session.close();
        }
        catch ( Exception e )
        {
            throw new TransactionException( "Failed to close hibernate shark session", e );
        }
    }

}
