/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateTransaction;
import org.enhydra.shark.plusworkflow.util.ThreadLocalContext;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateRepositoryTransaction
implements RepositoryTransaction {
    public static final ThreadLocalContext<RepositoryTransaction> LOCAL = new ThreadLocalContext("shark-repository-transaction", true);
    private final Session session;
    private final Transaction transaction;

    public HibernateRepositoryTransaction(HibernateTransaction hibernateTransaction) {
        this.session = hibernateTransaction.getSession();
        this.transaction = hibernateTransaction.getTransaction();
        LOCAL.pushContext((Object)this);
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getHibernateTransaction() {
        return this.transaction;
    }

    public void commit() throws TransactionException {
        try {
            this.transaction.commit();
        }
        catch (Exception e) {
            throw new TransactionException("Failed to commit hibernate shark transaction", (Throwable)e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            this.transaction.rollback();
        }
        catch (Exception e) {
            throw new TransactionException("Failed to rollback hibernate shark transaction", (Throwable)e);
        }
    }

    public void release() throws TransactionException {
        try {
            if (!this.session.isOpen()) {
                return;
            }
            try {
                this.session.close();
            }
            catch (Exception e) {
                throw new TransactionException("Failed to close hibernate shark session", (Throwable)e);
            }
        }
        finally {
            LOCAL.popContext();
        }
    }
}

