package org.enhydra.shark.repositorypersistence;

import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateTransaction;
import org.enhydra.shark.plusworkflow.util.ThreadLocalContext;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateRepositoryTransaction
    implements RepositoryTransaction
{

    public static final ThreadLocalContext<RepositoryTransaction> LOCAL
        = new ThreadLocalContext<>( "shark-repository-transaction", true );

    private final Session session;

    private final Transaction transaction;

    public HibernateRepositoryTransaction( HibernateTransaction hibernateTransaction )
    {
        this.session = hibernateTransaction.getSession();
        this.transaction = hibernateTransaction.getTransaction();

        LOCAL.pushContext( this );
    }

    public Session getSession()
    {
        return session;
    }

    public Transaction getHibernateTransaction()
    {
        return transaction;
    }

    @Override
    public void commit()
        throws TransactionException
    {
        try
        {
            transaction.commit();
        }
        catch ( Exception e )
        {
            throw new TransactionException( "Failed to commit hibernate shark transaction", e );
        }
    }

    @Override
    public void rollback()
        throws TransactionException
    {
        try
        {
            transaction.rollback();
        }
        catch ( Exception e )
        {
            throw new TransactionException( "Failed to rollback hibernate shark transaction", e );
        }
    }

    @Override
    public void release()
        throws TransactionException
    {
        try
        {
            if ( !session.isOpen() )
            {
                return;
            }

            try
            {
                session.close();
            }
            catch ( Exception e )
            {
                throw new TransactionException( "Failed to close hibernate shark session", e );
            }
        }
        finally
        {
            LOCAL.popContext();
        }
    }

}
