/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateConfigBundle;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateDatabaseManager;
import org.enhydra.shark.plusworkflow.databasemanager.HibernateTransaction;
import org.enhydra.shark.plusworkflow.databasemanager.oid.CounterAllocatorException;
import org.enhydra.shark.plusworkflow.databasemanager.oid.ObjectIdAllocatorException;
import org.enhydra.shark.repositorypersistence.HibernateRepositoryTransaction;
import org.enhydra.shark.repositorypersistence.data.NextXPDLVersion;
import org.enhydra.shark.repositorypersistence.data.XPDL;
import org.enhydra.shark.repositorypersistence.data.XPDLData;
import org.enhydra.shark.repositorypersistence.data.XPDLHistory;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryData;
import org.enhydra.shark.repositorypersistence.data.XPDLReference;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateRepositoryPersistenceManager
implements RepositoryPersistenceManager {
    private static final String INITIAL_VERSION = "1";
    private SessionFactory sessionFactory;

    public void configure(CallbackUtilities cus) throws RootException {
        HibernateDatabaseManager hibernateDatabaseManager = this.getHibernateDatabaseManager();
        try {
            HibernateConfigBundle configBundle = HibernateConfigBundle.builder().postgresConfigPath("shark/repository/psql/hibernate.cfg.xml").mssqlConfigPath("shark/repository/mssql/hibernate.cfg.xml").oracleConfigPath("shark/repository/oracle/hibernate.cfg.xml").h2ConfigPath("shark/repository/h2/hibernate.cfg.xml").build();
            this.sessionFactory = hibernateDatabaseManager.buildSessionFactory(configBundle);
            cus.info("Created session factory successfully");
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to configure hibernate session factory", (Throwable)e);
        }
    }

    public void uploadXPDL(RepositoryTransaction t, String xpdlId, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            String xpdlVer = this.updateNextVersion(session, xpdlId);
            XPDL xpdlEntity = this.createXPDL();
            xpdlEntity.setXpdlId(xpdlId);
            xpdlEntity.setXpdlVersion(xpdlVer);
            xpdlEntity.setXpdlClassVersion(xpdlClassVer);
            xpdlEntity.setXpdlUploadTime(new Timestamp(System.currentTimeMillis()));
            XPDLData xpdlDataEntity = this.createXPDLData();
            xpdlDataEntity.setXpdlContent(xpdl);
            xpdlDataEntity.setXpdlClassContent(serializedPkg);
            xpdlDataEntity.setXpdl(xpdlEntity);
            xpdlEntity.getXpdlDatas().add(xpdlDataEntity);
            session.save((Object)xpdlEntity);
            session.save((Object)xpdlDataEntity);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to upload XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    private String updateNextVersion(Session session, String xpdlId) throws RepositoryException {
        String curVersion = INITIAL_VERSION;
        try {
            NextXPDLVersion nextXPDLVersion = (NextXPDLVersion)session.createQuery("from NextXPDLVersion where xpdlId = :xpdlId", NextXPDLVersion.class).setParameter("xpdlId", (Object)xpdlId).uniqueResult();
            if (nextXPDLVersion == null) {
                nextXPDLVersion = this.createNextXPDLVersion();
                nextXPDLVersion.setXpdlId(xpdlId);
                nextXPDLVersion.setNextVersion(INITIAL_VERSION);
            } else {
                curVersion = nextXPDLVersion.getNextVersion();
            }
            int nver = Integer.parseInt(nextXPDLVersion.getNextVersion()) + 1;
            String nextVersion = String.valueOf(nver);
            nextXPDLVersion.setNextVersion(nextVersion);
            session.save((Object)nextXPDLVersion);
        }
        catch (Exception ex) {
            throw new RepositoryException("Internal problem while updating Next XPDL Version", (Throwable)ex);
        }
        return curVersion;
    }

    public void updateXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDL xpdlEntity = this.getXPDLEntity(session, xpdlId, xpdlVersion);
            xpdlEntity.setXpdlClassVersion(xpdlClassVer);
            XPDLData xpdlDataEntity = xpdlEntity.getXpdlDatas().get(0);
            xpdlDataEntity.setXpdlContent(xpdl);
            xpdlDataEntity.setXpdlClassContent(serializedPkg);
            session.save((Object)xpdlEntity);
            session.save((Object)xpdlDataEntity);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to upload XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public void deleteXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDL xpdlEntity = this.getXPDLEntity(session, xpdlId, xpdlVersion);
            session.delete((Object)xpdlEntity);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to delete XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public void moveToHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDL xpdlEntity = this.getXPDLEntity(session, xpdlId, xpdlVersion);
            XPDLData xpdlDataEntity = xpdlEntity.getXpdlDatas().get(0);
            XPDLHistory xpdlHistoryEntity = this.createXPDLHistory();
            xpdlHistoryEntity.setXpdlId(xpdlEntity.getXpdlId());
            xpdlHistoryEntity.setXpdlVersion(xpdlEntity.getXpdlVersion());
            xpdlHistoryEntity.setXpdlUploadTime(xpdlEntity.getXpdlUploadTime());
            xpdlHistoryEntity.setXpdlHistoryUploadTime(new Timestamp(System.currentTimeMillis()));
            XPDLHistoryData xpdlHistoryDataEntity = this.createXPDLHistoryData();
            xpdlHistoryDataEntity.setXpdlContent(xpdlDataEntity.getXpdlContent());
            xpdlHistoryDataEntity.setXpdlHistory(xpdlHistoryEntity);
            xpdlHistoryEntity.getXpdlHistoryDatas().add(xpdlHistoryDataEntity);
            session.delete((Object)xpdlEntity);
            session.save((Object)xpdlHistoryEntity);
            session.save((Object)xpdlHistoryDataEntity);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to move to history XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public void deleteFromHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDLHistory xpdlHistoryEntity = (XPDLHistory)session.createQuery("from XPDLHistory where xpdlId = :xpdlId and xpdlVersion = :xpdlVersion", XPDLHistory.class).setParameter("xpdlId", (Object)xpdlId).setParameter("xpdlVersion", (Object)xpdlVersion).uniqueResult();
            session.delete((Object)xpdlHistoryEntity);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to delete from history XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public void clearRepository(RepositoryTransaction t) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            session.createQuery("delete from XPDL").executeUpdate();
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to clear repository", (Throwable)e);
        }
    }

    public String getCurrentVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getLastVersionXPDL(session, xpdlId).getXpdlVersion();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get current XPDL version for id %s", xpdlId), (Throwable)e);
        }
    }

    public String getNextVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            NextXPDLVersion nextXPDLVersionEntity = (NextXPDLVersion)session.createQuery("from NextXPDLVersion where xpdlId = :xpdlId", NextXPDLVersion.class).setParameter("xpdlId", (Object)xpdlId).uniqueResult();
            return nextXPDLVersionEntity != null ? nextXPDLVersionEntity.getNextVersion() : INITIAL_VERSION;
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get next XPDL version for id %s", xpdlId), (Throwable)e);
        }
    }

    public long getSerializedXPDLObjectVersion(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getXPDLEntity(session, xpdlId, xpdlVersion).getXpdlClassVersion();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get serialized XPDL object version by id %s and version %s", xpdlId, xpdlVersion), (Throwable)e);
        }
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getLastVersionXPDL(session, xpdlId).getXpdlDatas().get(0).getXpdlContent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getLastVersionXPDL(session, xpdlId).getXpdlDatas().get(0).getXpdlClassContent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get serialized XPDL by id %s", xpdlId), (Throwable)e);
        }
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getXPDLEntity(session, xpdlId, xpdlVersion).getXpdlDatas().get(0).getXpdlContent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get XPDL by id %s and version %s", xpdlId, xpdlVersion), (Throwable)e);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.getXPDLEntity(session, xpdlId, xpdlVersion).getXpdlDatas().get(0).getXpdlClassContent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get serialized XPDL by id %s and version %s", xpdlId, xpdlVersion), (Throwable)e);
        }
    }

    public List<String> getXPDLVersions(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            List xpdlVersions = session.createQuery("select xpdlVersion from XPDL where xpdlId = :xpdlId", String.class).setParameter("xpdlId", (Object)xpdlId).list();
            return new ArrayList<String>(xpdlVersions);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get XPDL versions by id %s", xpdlId), (Throwable)e);
        }
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.findLastVersionXPDL(session, xpdlId).isPresent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to check XPDL existence by id %s", xpdlId), (Throwable)e);
        }
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            return this.findXPDLEntity(session, xpdlId, xpdlVersion).isPresent();
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to check XPDL existence by id %s and version %s", xpdlId, xpdlVersion), (Throwable)e);
        }
    }

    public List<String> getExistingXPDLIds(RepositoryTransaction t) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            List xpdlIds = session.createQuery("select distinct xpdlId from XPDL", String.class).list();
            return new ArrayList<String>(xpdlIds);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to get existing XPDL ids", (Throwable)e);
        }
    }

    public void addXPDLReference(RepositoryTransaction t, String referredXPDLId, String referringXPDLId, String referringXPDLVersion, int referredXPDLNumber) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDL referringXpdlEntity = this.getXPDLEntity(session, referringXPDLId, referringXPDLVersion);
            Optional xpdlReferenceEntity = session.createQuery("from XPDLReference where referredXpdlId = :referredXpdlId and referringXpdl = :referringXpdl", XPDLReference.class).setParameter("referredXpdlId", (Object)referredXPDLId).setParameter("referringXpdl", (Object)referringXpdlEntity).uniqueResultOptional();
            if (!xpdlReferenceEntity.isPresent()) {
                XPDLReference newXpdlReferenceEntity = this.createXPDLReference();
                newXpdlReferenceEntity.setReferredXpdlId(referredXPDLId);
                newXpdlReferenceEntity.setReferringXpdl(referringXpdlEntity);
                newXpdlReferenceEntity.setReferredXpdlNumber(referredXPDLNumber);
                referringXpdlEntity.getXpdlReferences().add(newXpdlReferenceEntity);
                session.save((Object)referringXpdlEntity);
                session.save((Object)newXpdlReferenceEntity);
            }
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to add XPDL reference by referred XPDL id %s and referring XPDL id %s", referredXPDLId, referringXPDLId), (Throwable)e);
        }
    }

    public List<String> getReferringXPDLIds(RepositoryTransaction t, String referredXPDLId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            List referringXpdlIds = session.createQuery("select distinct xpdlReference.referringXpdl.xpdlId from XPDLReference xpdlReference join xpdlReference.referringXpdl where xpdlReference.referredXpdlId = :referredXpdlId", String.class).setParameter("referredXpdlId", (Object)referredXPDLId).list();
            return new ArrayList<String>(referringXpdlIds);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get referring XPDL ids by referred XPDL id %s", referredXPDLId), (Throwable)e);
        }
    }

    public List<String> getReferringXPDLVersions(RepositoryTransaction t, String referredXPDLId, String referringXPDLId) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            List referringXpdlVersions = session.createQuery("select xpdlReference.referringXpdl.xpdlVersion from XPDLReference xpdlReference join xpdlReference.referringXpdl where xpdlReference.referredXpdlId = :referredXpdlId and xpdlReference.referringXpdl.xpdlId = :referringXpdlId", String.class).setParameter("referredXpdlId", (Object)referredXPDLId).setParameter("referringXpdlId", (Object)referringXPDLId).list();
            return new ArrayList<String>(referringXpdlVersions);
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get referring XPDL versions by referred XPDL id %s and referring XPDL id %s", referredXPDLId, referringXPDLId), (Throwable)e);
        }
    }

    public List<String> getReferredXPDLIds(RepositoryTransaction t, String referringXPDLId, String referringXPDLVersion) throws RepositoryException {
        try {
            Session session = this.getExtended(t).getSession();
            XPDL referringXpdl = this.getXPDLEntity(session, referringXPDLId, referringXPDLVersion);
            List xpdlReferenceEntities = session.createQuery("from XPDLReference where referringXpdl = :referringXpdl", XPDLReference.class).setParameter("referringXpdl", (Object)referringXpdl).list();
            HashMap<Integer, String> xpdlNumberToXpdlIdMap = new HashMap<Integer, String>();
            for (XPDLReference xpdlReferenceEntity : xpdlReferenceEntities) {
                xpdlNumberToXpdlIdMap.put(xpdlReferenceEntity.getReferredXpdlNumber(), xpdlReferenceEntity.getReferredXpdlId());
            }
            ArrayList xpdlNumbers = new ArrayList(xpdlNumberToXpdlIdMap.keySet());
            Collections.sort(xpdlNumbers);
            ArrayList<String> referredXpdlIds = new ArrayList<String>();
            for (Integer xpdlNumber : xpdlNumbers) {
                referredXpdlIds.add((String)xpdlNumberToXpdlIdMap.get(xpdlNumber));
            }
            return referredXpdlIds;
        }
        catch (Exception e) {
            throw new RepositoryException(String.format("Failed to get referred XPDL ids by referring XPDL id %s and referring XPDL version %s", referringXPDLId, referringXPDLVersion), (Throwable)e);
        }
    }

    private Optional<XPDL> findXPDLEntity(Session session, String xpdlId, String xpdlVersion) {
        return session.createQuery("from XPDL where xpdlId = :xpdlId and xpdlVersion = :xpdlVersion", XPDL.class).setParameter("xpdlId", (Object)xpdlId).setParameter("xpdlVersion", (Object)xpdlVersion).uniqueResultOptional();
    }

    private XPDL getXPDLEntity(Session session, String xpdlId, String xpdlVersion) throws RepositoryException {
        return this.findXPDLEntity(session, xpdlId, xpdlVersion).orElseThrow(() -> new RepositoryException(String.format("Could not find xpdl by id %s and version %s", xpdlId, xpdlVersion)));
    }

    private Optional<XPDL> findLastVersionXPDL(Session session, String xpdlId) {
        return session.createQuery("from XPDL where xpdlId = :xpdlId order by cast(xpdlVersion as long) desc", XPDL.class).setMaxResults(1).setParameter("xpdlId", (Object)xpdlId).uniqueResultOptional();
    }

    private XPDL getLastVersionXPDL(Session session, String xpdlId) throws RepositoryException {
        return this.findLastVersionXPDL(session, xpdlId).orElseThrow(() -> new RepositoryException(String.format("Could not find last xpdl by id %s", xpdlId)));
    }

    public RepositoryTransaction createTransaction() throws TransactionException {
        HibernateTransaction hibernateTransaction = this.getHibernateDatabaseManager().createHibernateTransaction(this.sessionFactory);
        return new HibernateRepositoryTransaction(hibernateTransaction);
    }

    private HibernateRepositoryTransaction getExtended(RepositoryTransaction transaction) {
        return (HibernateRepositoryTransaction)transaction;
    }

    private BigDecimal allocateObjectId() throws RepositoryException {
        try {
            return this.getHibernateDatabaseManager().allocateObjectId();
        }
        catch (ObjectIdAllocatorException e) {
            throw new RepositoryException("Failed to allocate object id", (Throwable)e);
        }
    }

    private XPDL createXPDL() throws ObjectIdAllocatorException {
        XPDL xpdl = new XPDL();
        xpdl.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        xpdl.setObjectVersion(0);
        xpdl.setXpdlDatas(new ArrayList<XPDLData>(1));
        return xpdl;
    }

    private XPDLData createXPDLData() throws ObjectIdAllocatorException, CounterAllocatorException {
        XPDLData xpdlData = new XPDLData();
        xpdlData.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        xpdlData.setObjectVersion(0);
        xpdlData.setCnt(this.getHibernateDatabaseManager().allocateNextXpdlDataCnt());
        return xpdlData;
    }

    private NextXPDLVersion createNextXPDLVersion() throws ObjectIdAllocatorException {
        NextXPDLVersion nextXPDLVersion = new NextXPDLVersion();
        nextXPDLVersion.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        nextXPDLVersion.setObjectVersion(0);
        return nextXPDLVersion;
    }

    private XPDLHistory createXPDLHistory() throws ObjectIdAllocatorException {
        XPDLHistory xpdlHistory = new XPDLHistory();
        xpdlHistory.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        xpdlHistory.setObjectVersion(0);
        xpdlHistory.setXpdlClassVersion(0L);
        xpdlHistory.setXpdlHistoryDatas(new ArrayList<XPDLHistoryData>(1));
        return xpdlHistory;
    }

    private XPDLHistoryData createXPDLHistoryData() throws ObjectIdAllocatorException, CounterAllocatorException {
        XPDLHistoryData xpdlHistoryData = new XPDLHistoryData();
        xpdlHistoryData.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        xpdlHistoryData.setObjectVersion(0);
        xpdlHistoryData.setCnt(this.getHibernateDatabaseManager().allocateNextXpdlHistoryDataCnt());
        xpdlHistoryData.setXpdlClassContent(new byte[]{0});
        return xpdlHistoryData;
    }

    private XPDLReference createXPDLReference() throws ObjectIdAllocatorException {
        XPDLReference xpdlReference = new XPDLReference();
        xpdlReference.setObjectId(this.getHibernateDatabaseManager().allocateObjectId());
        xpdlReference.setObjectVersion(0);
        return xpdlReference;
    }

    private HibernateDatabaseManager getHibernateDatabaseManager() {
        return SharkEngineManager.getInstance().getHibernateDatabaseManager();
    }
}

