/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.repositorypersistence.RefFrom;

class ExternalReferences
extends HashMap
implements Serializable {
    ExternalReferences() {
    }

    public synchronized void addExtRef(String refTo, String refFromId, String refFromVersion, int refToNumber) {
        if (!this.containsKey(refTo)) {
            this.put(refTo, new HashSet());
        }
        Set s = (Set)this.get(refTo);
        this.addToSet(s, new RefFrom(refFromId, refFromVersion, refToNumber));
    }

    public synchronized void remExtRef(String refTo, String refFromId, String refFromVersion) {
        Set s = (Set)this.get(refTo);
        if (s != null) {
            this.removeFromSet(s, new RefFrom(refFromId, refFromVersion));
        }
    }

    public List getExtRefIds(String refTo) {
        HashSet<String> ret = new HashSet<String>();
        Set s = (Set)this.get(refTo);
        if (s != null) {
            for (RefFrom rf : s) {
                ret.add(rf.getRefFromId());
            }
        }
        return new ArrayList(ret);
    }

    public List getExtRefVersions(String refTo, String refFromId) {
        ArrayList<String> ret = new ArrayList<String>();
        Set s = (Set)this.get(refTo);
        if (s != null) {
            for (RefFrom rf : s) {
                if (!rf.getRefFromId().equals(refFromId)) continue;
                ret.add(rf.getRefFromVersion());
            }
        }
        return ret;
    }

    public List getReferrencedIds(String refFromId, String refFromVersion) {
        ArrayList ret = new ArrayList();
        for (Map.Entry me : this.entrySet()) {
            String refTo = (String)me.getKey();
            Set s = (Set)me.getValue();
            for (RefFrom rf : s) {
                HashMap<Integer, String> temp = new HashMap<Integer, String>();
                if (rf.getRefFromId().equals(refFromId) && rf.getRefFromVersion().equals(refFromVersion)) {
                    temp.put(new Integer(rf.getRefNo()), refTo);
                }
                ArrayList tmp = new ArrayList(temp.keySet());
                Collections.sort(tmp);
                for (int i = 0; i < tmp.size(); ++i) {
                    ret.add(temp.get(tmp.get(i)));
                }
            }
        }
        return ret;
    }

    public synchronized void removeReferrencedIds(String refFromId, String refFromVersion) {
        List ret = this.getReferrencedIds(refFromId, refFromVersion);
        for (String refTo : ret) {
            Set s = (Set)this.get(refTo);
            this.removeFromSet(s, new RefFrom(refFromId, refFromVersion));
            if (s.size() != 0) continue;
            this.remove(refTo);
        }
    }

    private void addToSet(Set s, RefFrom rf) {
        Iterator it = s.iterator();
        boolean contains = false;
        while (it.hasNext()) {
            RefFrom rfs = (RefFrom)it.next();
            if (!rfs.equals(rf)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            s.add(rf);
        }
    }

    private void removeFromSet(Set s, RefFrom rf) {
        Iterator it = s.iterator();
        RefFrom toRem = null;
        while (it.hasNext()) {
            RefFrom rfs = (RefFrom)it.next();
            if (!rfs.equals(rf)) continue;
            toRem = rfs;
            break;
        }
        s.remove(toRem);
    }
}

