/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.repositorypersistence.ExternalReferences;
import org.enhydra.shark.repositorypersistence.NextVersions;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.TraverseException;
import org.enhydra.shark.xpdl.XMLUtil;

public class FileSystemRepositoryPersistenceManager
implements RepositoryPersistenceManager {
    private CallbackUtilities cus;
    private String XPDL_REPOSITORY;
    private String XPDL_HISTORY_REPOSITORY;
    private final String EXT_REF_FNAME = "#ext_references#";
    private final String NEXT_IDS_FNAME = "#next_ids#";
    private final String SER_PKG = "#ser_pkg#";
    private final String HASH = "#";
    private String EXT_REFERENCES_FILE_NAME;
    private String NEXT_IDS_FILE_NAME;
    private ExternalReferences extRefs;
    private NextVersions nextVersions;

    public void configure(CallbackUtilities cus) throws RootException {
        File extR;
        File hxrf;
        this.cus = cus;
        String xr = cus.getProperty("FileSystemRepositoryPersistenceManager.XPDL_REPOSITORY");
        String hxr = cus.getProperty("FileSystemRepositoryPersistenceManager.XPDL_HISTORY_REPOSITORY");
        this.XPDL_REPOSITORY = this.getRepositoryFullPath(xr);
        this.XPDL_HISTORY_REPOSITORY = this.getRepositoryFullPath(hxr);
        this.EXT_REFERENCES_FILE_NAME = this.XPDL_REPOSITORY + File.separator + "#ext_references#";
        this.NEXT_IDS_FILE_NAME = this.XPDL_REPOSITORY + File.separator + "#next_ids#";
        File xrf = new File(this.XPDL_REPOSITORY);
        if (!xrf.exists()) {
            xrf.mkdir();
        }
        if (!(hxrf = new File(this.XPDL_HISTORY_REPOSITORY)).exists()) {
            hxrf.mkdir();
        }
        if ((extR = new File(this.EXT_REFERENCES_FILE_NAME)).exists()) {
            try {
                this.extRefs = (ExternalReferences)this.readFile(this.EXT_REFERENCES_FILE_NAME);
            }
            catch (Exception ex) {
                throw new RootException((Throwable)ex);
            }
        } else {
            this.extRefs = new ExternalReferences();
        }
        File nextV = new File(this.NEXT_IDS_FILE_NAME);
        if (nextV.exists()) {
            try {
                this.nextVersions = (NextVersions)this.readFile(this.NEXT_IDS_FILE_NAME);
            }
            catch (Exception ex) {
                throw new RootException((Throwable)ex);
            }
        } else {
            this.nextVersions = new NextVersions();
        }
    }

    public void uploadXPDL(RepositoryTransaction t, String xpdlId, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        try {
            String newVersion = this.nextVersions.updateNextVersion(xpdlId);
            this.writeFile(this.nextVersions, this.NEXT_IDS_FILE_NAME);
            FileOutputStream fos = new FileOutputStream(this.XPDL_REPOSITORY + File.separator + xpdlId + "-" + newVersion);
            fos.write(xpdl);
            fos.flush();
            fos.close();
            fos = new FileOutputStream(this.XPDL_REPOSITORY + File.separator + xpdlId + "-" + "#ser_pkg#" + xpdlClassVer + "#" + "-" + newVersion);
            fos.write(serializedPkg);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            this.cus.error("FileSystemRepositoryPersistenceManager -> The upload of the file " + xpdlId + " failed");
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void updateXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion, byte[] xpdl, byte[] serializedPkg, long xpdlClassVer) throws RepositoryException {
        try {
            this.getXPDLFile(xpdlId, xpdlVersion);
            this.deleteXPDL(t, xpdlId, xpdlVersion);
            FileOutputStream fos = new FileOutputStream(this.XPDL_REPOSITORY + File.separator + xpdlId + "-" + xpdlVersion);
            fos.write(xpdl);
            fos.flush();
            fos.close();
            fos = new FileOutputStream(this.XPDL_REPOSITORY + File.separator + xpdlId + "-" + "#ser_pkg#" + xpdlClassVer + "#" + "-" + xpdlVersion);
            fos.write(serializedPkg);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            this.cus.error("FileSystemRepositoryPersistenceManager -> The update of the file " + xpdlId + "-" + xpdlVersion + " failed");
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void deleteXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            if (!this.getXPDLFile(xpdlId, xpdlVersion).delete()) {
                throw new Exception("File " + xpdlId + "-" + xpdlVersion + " is not deleted from repository");
            }
            if (!this.getSerializedXPDLFile(xpdlId, xpdlVersion).delete()) {
                throw new Exception("The serialized pkg File " + xpdlId + "-" + xpdlVersion + " is not deleted from repository");
            }
            this.extRefs.removeReferrencedIds(xpdlId, xpdlVersion);
            this.writeFile(this.extRefs, this.EXT_REFERENCES_FILE_NAME);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void moveToHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            File f1 = this.getXPDLFile(xpdlId, xpdlVersion);
            File f2 = this.getSerializedXPDLFile(xpdlId, xpdlVersion);
            String historyFolder = this.XPDL_HISTORY_REPOSITORY + File.separator + xpdlId;
            File fhf = new File(historyFolder);
            if (!fhf.exists()) {
                fhf.mkdir();
            }
            String historyFilename1 = historyFolder + File.separator + f1.getName() + ".xpdl";
            String historyFilename2 = historyFolder + File.separator + f2.getName();
            MiscUtilities.copyFile((String)f1.getCanonicalPath(), (String)historyFilename1);
            MiscUtilities.copyFile((String)f2.getCanonicalPath(), (String)historyFilename2);
            if (!f1.delete() || !f2.delete()) {
                throw new Exception("File " + xpdlId + "-" + xpdlVersion + " is not deleted from repository");
            }
            this.extRefs.removeReferrencedIds(xpdlId, xpdlVersion);
            this.writeFile(this.extRefs, this.EXT_REFERENCES_FILE_NAME);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void deleteFromHistory(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        List xpdlFiles = this.getXPDLFiles(this.XPDL_HISTORY_REPOSITORY + File.separator + xpdlId, false, new XPDLIdFilter(xpdlId, xpdlVersion, true, false));
        if (xpdlFiles.size() > 0 && !((File)xpdlFiles.get(0)).delete()) {
            throw new RepositoryException("File is not deleted from history repository");
        }
        xpdlFiles = this.getXPDLFiles(this.XPDL_HISTORY_REPOSITORY + File.separator + xpdlId, false, new XPDLIdFilter(xpdlId, xpdlVersion, false, true));
        if (xpdlFiles.size() > 0 && !((File)xpdlFiles.get(0)).delete()) {
            throw new RepositoryException("File is not deleted from history repository");
        }
        throw new RepositoryException("There is no xpdl with Id=" + xpdlId + ", and version " + xpdlVersion + " in the repository");
    }

    public void clearRepository(RepositoryTransaction t) throws RepositoryException {
        try {
            List xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(null, null, false, false));
            Iterator itXPDL = xpdlFiles.iterator();
            while (itXPDL.hasNext()) {
                if (((File)itXPDL.next()).delete()) continue;
                throw new Exception("Some file is not deleted from repository");
            }
            xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(null, null, false, true));
            itXPDL = xpdlFiles.iterator();
            while (itXPDL.hasNext()) {
                if (((File)itXPDL.next()).delete()) continue;
                throw new Exception("Some file is not deleted from repository");
            }
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public String getCurrentVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            return this.getFileVersion(this.getXPDLFile(xpdlId, null));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public String getNextVersion(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            return this.nextVersions.getNextVersion(xpdlId);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public long getSerializedXPDLObjectVersion(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            return Long.parseLong(this.getSerializedFileVersion(this.getSerializedXPDLFile(xpdlId, xpdlVersion)));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            return this.fileToByteArray(this.getXPDLFile(xpdlId, null));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            return this.fileToByteArray(this.getSerializedXPDLFile(xpdlId, null));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public byte[] getXPDL(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            return this.fileToByteArray(this.getXPDLFile(xpdlId, xpdlVersion));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public byte[] getSerializedXPDLObject(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            return this.fileToByteArray(this.getSerializedXPDLFile(xpdlId, xpdlVersion));
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public List getXPDLVersions(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        List xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(xpdlId, null, false, false));
        if (xpdlFiles.size() == 0) {
            throw new RepositoryException("There is no xpdl with Id=" + xpdlId + " in the repository");
        }
        ArrayList<String> xpdlVersions = new ArrayList<String>();
        for (File f : xpdlFiles) {
            try {
                xpdlVersions.add(this.getFileVersion(f));
            }
            catch (Exception ex) {
                throw new RepositoryException((Throwable)ex);
            }
        }
        return xpdlVersions;
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId) throws RepositoryException {
        try {
            this.getXPDLFile(xpdlId, null);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean doesXPDLExist(RepositoryTransaction t, String xpdlId, String xpdlVersion) throws RepositoryException {
        try {
            this.getXPDLFile(xpdlId, xpdlVersion);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List getExistingXPDLIds(RepositoryTransaction t) throws RepositoryException {
        List xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(null, null, false, false));
        HashSet<String> ids = new HashSet<String>();
        for (File f : xpdlFiles) {
            String n = f.getName();
            int li = n.lastIndexOf("-");
            String fId = n.substring(0, li);
            ids.add(fId);
        }
        return new ArrayList(ids);
    }

    public void addXPDLReference(RepositoryTransaction t, String referredXPDLId, String referringXPDLId, String referringXPDLVersion, int referredXPDLNumber) throws RepositoryException {
        try {
            this.extRefs.addExtRef(referredXPDLId, referringXPDLId, referringXPDLVersion, referredXPDLNumber);
            this.writeFile(this.extRefs, this.EXT_REFERENCES_FILE_NAME);
        }
        catch (Exception ex) {
            this.extRefs.remExtRef(referredXPDLId, referringXPDLId, referringXPDLVersion);
            throw new RepositoryException((Throwable)ex);
        }
    }

    public List getReferringXPDLIds(RepositoryTransaction t, String referredXPDLId) throws RepositoryException {
        return this.extRefs.getExtRefIds(referredXPDLId);
    }

    public List getReferringXPDLVersions(RepositoryTransaction t, String referredXPDLId, String refferingXPDLId) throws RepositoryException {
        return this.extRefs.getExtRefVersions(referredXPDLId, refferingXPDLId);
    }

    public List getReferredXPDLIds(RepositoryTransaction t, String refferingXPDLId, String refferingXPDLVersion) throws RepositoryException {
        return this.extRefs.getReferrencedIds(refferingXPDLId, refferingXPDLVersion);
    }

    public RepositoryTransaction createTransaction() throws TransactionException {
        return null;
    }

    private void writeFile(Object obj, String fName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fName);
        ObjectOutputStream oout = new ObjectOutputStream(fos);
        oout.writeObject(obj);
        oout.flush();
        oout.close();
        ((OutputStream)fos).close();
    }

    private Object readFile(String fName) throws Exception {
        FileInputStream fis = new FileInputStream(fName);
        ObjectInputStream oin = new ObjectInputStream(fis);
        Object obj = oin.readObject();
        oin.close();
        return obj;
    }

    private String getRepositoryFullPath(String path) {
        String rdPath = this.cus.getProperty("RootDirectoryPath");
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(XMLUtil.createPath((String)rdPath, (String)path));
        }
        if (!f.exists() && !f.mkdir()) {
            return path;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (Exception ex) {
            return f.getAbsolutePath();
        }
    }

    private byte[] fileToByteArray(File xpdlFile) throws Exception {
        byte[] utf8Bytes = null;
        if (xpdlFile != null) {
            try {
                FileInputStream fis = new FileInputStream(xpdlFile);
                int noOfBytes = fis.available();
                if (noOfBytes > 0) {
                    int nextB;
                    utf8Bytes = new byte[noOfBytes];
                    int i = 0;
                    while ((nextB = fis.read()) != -1) {
                        utf8Bytes[i++] = (byte)nextB;
                    }
                }
            }
            catch (Throwable ex) {
                this.cus.error("FileSystemRepositoryPersistenceManager -> Problems while getting XPDL file " + xpdlFile);
                throw new Exception();
            }
        }
        return utf8Bytes;
    }

    private File getXPDLFile(String xpdlId, String xpdlVersion) throws Exception {
        List xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(xpdlId, xpdlVersion, false, false));
        if (xpdlFiles.size() > 0) {
            return this.getLastVersionXPDLFile(xpdlFiles);
        }
        throw new Exception("There is no xpdl with Id=" + xpdlId + ", and version " + xpdlVersion + " in the repository");
    }

    private File getSerializedXPDLFile(String xpdlId, String xpdlVersion) throws Exception {
        List xpdlFiles = this.getXPDLFiles(this.XPDL_REPOSITORY, false, new XPDLIdFilter(xpdlId, xpdlVersion, false, true));
        if (xpdlFiles.size() > 0) {
            return this.getLastVersionXPDLFile(xpdlFiles);
        }
        throw new Exception("There is no xpdl with Id=" + xpdlId + ", and version " + xpdlVersion + " in the repository");
    }

    private File getLastVersionXPDLFile(List xpdlFiles) throws Exception {
        File lastFileVersion = null;
        int maxVer = -1;
        for (File f : xpdlFiles) {
            String fv = this.getFileVersion(f);
            int ver = Integer.parseInt(fv);
            if (ver <= maxVer) continue;
            maxVer = ver;
            lastFileVersion = f;
        }
        if (lastFileVersion == null) {
            throw new Exception("Something is wrong in XPDL repository - can't determine file version");
        }
        return lastFileVersion;
    }

    private String getFileVersion(File f) throws RootException {
        String n = f.getName();
        int li = n.lastIndexOf("-");
        String fv = n.substring(li + 1);
        return fv;
    }

    private String getSerializedFileVersion(File f) throws RootException {
        String n = f.getName();
        int li1 = n.indexOf("#ser_pkg#");
        int li2 = n.lastIndexOf("#");
        String fv = n.substring(li1 + "#ser_pkg#".length(), li2);
        return fv;
    }

    private List getXPDLFiles(String repository, boolean traverse, FileFilter ff) throws RepositoryException {
        File startingFolder = new File(repository);
        List<Object> packageFiles = new ArrayList();
        if (traverse) {
            try {
                MiscUtilities.traverse((File)startingFolder, packageFiles, null);
            }
            catch (TraverseException e) {
                throw new RepositoryException(String.format("Could not obtain XPDL files from repository [%s]", repository), (Throwable)e);
            }
        } else {
            packageFiles = Arrays.asList(startingFolder.listFiles(ff));
        }
        return packageFiles;
    }

    class XPDLIdFilter
    implements FileFilter {
        private String xpdlId;
        private String xpdlVersion;
        private boolean hasExtension;
        private boolean retrieveOnlySerialized;

        public XPDLIdFilter(String xpdlId, String xpdlVersion, boolean hasExtension, boolean retrieveOnlySerialized) {
            this.xpdlId = xpdlId;
            this.xpdlVersion = xpdlVersion;
            this.hasExtension = hasExtension;
            this.retrieveOnlySerialized = retrieveOnlySerialized;
        }

        @Override
        public boolean accept(File file) {
            boolean accept;
            if (file.isDirectory()) {
                return false;
            }
            String fileName = file.getName();
            boolean isSerFile = fileName.indexOf("#ser_pkg#") >= 0;
            boolean bl = accept = this.retrieveOnlySerialized && isSerFile || !this.retrieveOnlySerialized && fileName.indexOf("#") < 0;
            if (!accept) {
                return false;
            }
            if (this.xpdlId == null) {
                return true;
            }
            accept = fileName.startsWith(this.xpdlId);
            if (this.xpdlVersion == null) {
                return accept;
            }
            String endsWith = this.xpdlVersion;
            if (this.hasExtension) {
                endsWith = endsWith + ".xpdl";
            }
            return accept && fileName.endsWith(endsWith);
        }
    }
}

