/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.repositorypersistence;

import com.lutris.appserver.server.sql.DBTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.repositorypersistence.DODSRepositoryPersistenceManager;

public class DODSRepositoryTransaction
implements RepositoryTransaction {
    private static int noOfCreations = 0;
    private static int noOfCommits = 0;
    private static int noOfRollbacks = 0;
    private static int noOfReleases = 0;
    private DBTransaction transaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DODSRepositoryTransaction(DBTransaction transaction) {
        if (DODSRepositoryPersistenceManager._debug_) {
            Class<DODSRepositoryTransaction> clazz = DODSRepositoryTransaction.class;
            // MONITORENTER : org.enhydra.shark.repositorypersistence.DODSRepositoryTransaction.class
            System.out.println("CREATING Repository T No" + ++noOfCreations);
            // MONITOREXIT : clazz
        }
        this.transaction = transaction;
    }

    public DBTransaction getDODSTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void commit() throws TransactionException {
        Class<DODSRepositoryTransaction> clazz;
        if (DODSRepositoryPersistenceManager._debug_) {
            clazz = DODSRepositoryTransaction.class;
            // MONITORENTER : org.enhydra.shark.repositorypersistence.DODSRepositoryTransaction.class
            System.out.println("COMMITING Repository T ");
            // MONITOREXIT : clazz
        }
        try {
            this.transaction.commit();
            if (!DODSRepositoryPersistenceManager._debug_) return;
            clazz = DODSRepositoryTransaction.class;
            // MONITORENTER : org.enhydra.shark.repositorypersistence.DODSRepositoryTransaction.class
            System.out.println("COMMITED Repository T No" + ++noOfCommits);
            // MONITOREXIT : clazz
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TransactionException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws TransactionException {
        try {
            if (!DODSRepositoryPersistenceManager._debug_) return;
            Class<DODSRepositoryTransaction> clazz = DODSRepositoryTransaction.class;
            synchronized (DODSRepositoryTransaction.class) {
                System.out.println("ROLLING BACK Repository T" + ++noOfRollbacks);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSRepositoryPersistenceManager._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("ROLLING BACK Repository T FAILED");
            throw new TransactionException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws TransactionException {
        try {
            this.transaction.release();
            if (!DODSRepositoryPersistenceManager._debug_) return;
            Class<DODSRepositoryTransaction> clazz = DODSRepositoryTransaction.class;
            synchronized (DODSRepositoryTransaction.class) {
                System.out.println("RELEASE Repository T " + ++noOfReleases);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!DODSRepositoryPersistenceManager._debug_) throw new TransactionException((Throwable)ex);
            System.out.println("RELEASE Repository T FAILED");
            throw new TransactionException((Throwable)ex);
        }
    }

    public static synchronized void info() {
        if (noOfCreations != noOfReleases) {
            System.err.println("PANIC!!!\nI've lost repository transcaton counts.");
        }
        System.err.println("MTCRE=" + noOfCreations + ", MTCOMM=" + noOfCommits + ", MTROLL=" + noOfRollbacks + ", MTREL=" + noOfReleases);
    }
}

