/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.processlocking;

import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootError;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.processlocking.LockMaster;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.processlocking.data.LockEntryDO;
import org.enhydra.shark.processlocking.data.LockEntryDelete;
import org.enhydra.shark.processlocking.data.LockEntryQuery;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSLockMaster
implements LockMaster {
    private static final String ENG_PARAM_NAME = "enginename";
    private static final String TOUT_PARM_NAME = "DODSLockMaster.Timeout";
    private static final String LWT_PARAM_NAME = "DODSLockMaster.LockWaitTime";
    private static final String DBG_PARAM_NAME = "DODSLockMaster.debug";
    private static final String LDB_PARAM_NAME = "DODSLockMaster.DatabaseName";
    private Long defaultTimeout = null;
    private long lockWaitTime;
    private CallbackUtilities callback;
    private LogicalDatabase db;
    private Map locks = new HashMap();
    private String lockMasterName;
    private boolean cleanStarted = false;
    private boolean _debug_;

    public void configure(CallbackUtilities cbImpl) throws RootException {
        if (null == cbImpl) {
            throw new RootException("Cannot configure without call back impl.");
        }
        this.callback = cbImpl;
        DODSUtilities.init((Properties)this.callback.getProperties());
        if (LockEntryDO.getConfigurationAdministration().getCacheAdministration(0).getMaxCacheSize() > 0) {
            this.callback.error("cache for lock entries isn't allowed!!!");
            throw new RootError("cache for lock entries isn't allowed!!!");
        }
        this.lockMasterName = this.callback.getProperty(ENG_PARAM_NAME, "dodsLockMaster");
        this.defaultTimeout = new Long(this.callback.getProperty(TOUT_PARM_NAME, "-1"));
        this.lockWaitTime = Long.parseLong(this.callback.getProperty(LWT_PARAM_NAME, "100"));
        String dbName = this.callback.getProperty(LDB_PARAM_NAME, DODS.getDatabaseManager().getDefaultDB());
        this._debug_ = Boolean.valueOf(this.callback.getProperty(DBG_PARAM_NAME, "false"));
        try {
            this.db = DODS.getDatabaseManager().findLogicalDatabase(dbName);
        }
        catch (DatabaseManagerException e) {
            throw new RootException("Couldn't find logical database.", (Throwable)e);
        }
        if (!this.cleanStarted) {
            this._cleanAllLocks();
            this.cleanStarted = true;
        }
        this.callback.debug(new StringBuffer(this.lockMasterName).append(" startup, timeout is ").append(this.defaultTimeout).toString());
    }

    public boolean lock(SharkTransaction t, String processId, Long timeout) throws RootException {
        if (t.isReadOnly()) {
            return true;
        }
        boolean ret = true;
        if (null != processId) {
            long limit;
            if (null == timeout) {
                timeout = this.defaultTimeout;
            }
            boolean checkTimeout = 0L < (limit = timeout.longValue());
            limit += System.currentTimeMillis();
            while (this.hasLock(processId)) {
                ret = false;
                try {
                    Thread.sleep(this.lockWaitTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!checkTimeout || System.currentTimeMillis() <= limit) continue;
                RootException tme = new RootException(new StringBuffer("Timeout expired waiting on ").append(processId).toString());
                this.callback.error("DODSLockMaster", tme);
                throw tme;
            }
        }
        if (this._debug_) {
            System.err.println("LOCK:" + processId + ":" + t);
        }
        return ret;
    }

    public boolean lock(SharkTransaction t, String processId) throws RootException {
        return this.lock(t, processId, null);
    }

    public void unlock(SharkTransaction t, String processId) throws RootException {
        if (t.isReadOnly()) {
            return;
        }
        if (null != processId) {
            this.removeLock(processId);
            if (this._debug_) {
                System.err.println("UNLOCK:" + processId + ":" + t);
            }
        }
    }

    public synchronized void unlock(SharkTransaction t) throws RootException {
        if (t.isReadOnly()) {
            return;
        }
        List processLocks = this.retrieveLocks();
        if (null == processLocks) {
            throw new RootException("Transaction hasn't locked anything");
        }
        DBTransaction dbt = this.createTransaction();
        try {
            for (String processId : processLocks) {
                LockEntryQuery qry = new LockEntryQuery(dbt);
                qry.setQueryEngineName(this.lockMasterName);
                qry.setQueryId(processId);
                LockEntryDelete led = new LockEntryDelete(qry);
                led.save();
                this.locks.remove(processId);
                if (!this._debug_) continue;
                System.err.println("gUNLOCK:" + processId + ":" + t);
            }
            dbt.commit();
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            dbt.release();
        }
    }

    public List getLocks(SharkTransaction t) throws RootException {
        if (t.isReadOnly()) {
            return Collections.EMPTY_LIST;
        }
        List transactionLocks = this.retrieveLocks();
        if (null == transactionLocks) {
            throw new RootException("Transaction hasn't locked anything");
        }
        return transactionLocks;
    }

    private List retrieveLocks() {
        ArrayList ret = new ArrayList();
        Set entries = this.locks.entrySet();
        Thread th = Thread.currentThread();
        for (Map.Entry me : entries) {
            if (!th.equals(me.getValue())) continue;
            ret.add(me.getKey());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean hasLock(String processId) throws RootException {
        Thread lockOwner = (Thread)this.locks.get(processId);
        if (null == lockOwner) {
            DBTransaction dbt = this.createTransaction();
            try {
                LockEntryDO le = LockEntryDO.createVirgin(dbt);
                le.setEngineName(this.lockMasterName);
                le.setId(processId);
                le.save();
                dbt.commit();
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                dbt.release();
            }
            this.locks.put(processId, Thread.currentThread());
            return false;
        }
        return !lockOwner.equals(Thread.currentThread());
    }

    private synchronized void removeLock(String processId) throws RootException {
        Thread lockOwner = (Thread)this.locks.get(processId);
        if (Thread.currentThread().equals(lockOwner)) {
            DBTransaction dbt = this.createTransaction();
            try {
                LockEntryQuery qry = new LockEntryQuery(dbt);
                qry.setQueryEngineName(this.lockMasterName);
                qry.setQueryId(processId);
                qry.requireUniqueInstance();
                LockEntryDO row = qry.getNextDO();
                row.delete();
                dbt.commit();
            }
            catch (Exception e) {
                throw new RootException((Throwable)e);
            }
            finally {
                dbt.release();
            }
        } else {
            RootException tme = new RootException(new StringBuffer("Trying to unlock ").append(processId).append(" while it hasn't been locked ?!?").toString());
            this.callback.error("DODSLockMaster", tme);
            throw tme;
        }
        this.locks.remove(processId);
    }

    private void _cleanAllLocks() throws RootException {
        DBTransaction dbt = this.createTransaction();
        try {
            LockEntryQuery leqry = new LockEntryQuery(dbt);
            leqry.setQueryEngineName(this.lockMasterName);
            new LockEntryDelete(leqry).save();
            dbt.commit();
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            dbt.release();
        }
    }

    private DBTransaction createTransaction() throws RootException {
        try {
            return this.db.createTransaction();
        }
        catch (Throwable t) {
            throw new RootException(new StringBuffer("Didn't create transaction, there are ").append(this.db.getActiveConnectionCount()).append(" active connections.").toString(), t);
        }
    }
}

