/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.processlocking.data;

import com.lutris.appserver.server.sql.CachedDBTransaction;
import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.Transaction;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.query.DataObjectException;
import com.lutris.dods.builder.generator.query.QueryBuilder;
import com.lutris.dods.builder.generator.query.QueryException;
import com.lutris.dods.builder.generator.query.RefAssertionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.QueryCache;
import org.enhydra.dods.cache.TransactionQueryCache;
import org.enhydra.dods.exceptions.AssertionDataObjectException;
import org.enhydra.shark.processlocking.data.LockEntryDO;
import org.enhydra.shark.processlocking.data.LockEntryQuery;

public class LockEntryDelete
extends CoreDO {
    private CachedDBTransaction myDBt = null;
    private Vector vecOIdsUpdated = null;
    private LockEntryQuery myQuery;
    private QueryBuilder myQB;
    private ObjectId OId = DODS.getDatabaseManager().allocateObjectId();
    private boolean doSelectOIds;

    public LockEntryDelete(LockEntryQuery query) throws ObjectIdException, DataObjectException, DatabaseManagerException {
        this.myQuery = query;
        this.myDBt = (CachedDBTransaction)query.transaction;
        this.myQB = query.getQueryBuilder();
        this.doSelectOIds = true;
        this.setPersistent(true);
        if (this.myDBt != null && this.isAutoSave()) {
            try {
                this.save((DBTransaction)this.myDBt);
            }
            catch (Exception ex) {
                throw new DataObjectException("Error during transaction's writting data into database", (Throwable)ex);
            }
        }
    }

    public void save(DBTransaction dbt) throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException {
        if (LockEntryDO.cache.getTableConfiguration().isReadOnly()) {
            throw new AssertionDataObjectException("LockEntryDO's cache is read-only. Therefore, DML opertions are not allowed.");
        }
        DBTransaction dbtlocal = dbt;
        boolean needToCommit = false;
        try {
            if (dbtlocal == null) {
                if (this.myDBt == null) {
                    dbtlocal = DODS.getDatabaseManager().createTransaction(this.myQuery.getLogicalDatabase());
                    dbtlocal.setDatabaseName(this.myQuery.getLogicalDatabase());
                    needToCommit = true;
                } else {
                    dbtlocal = this.myDBt;
                }
            } else if (this.myDBt != null && !this.myDBt.equals(dbt)) {
                throw new DatabaseManagerException("DO doesn't belong this transaction.");
            }
            dbtlocal.delete((Transaction)this);
            if (needToCommit) {
                dbtlocal.commit();
                dbtlocal.release();
            }
        }
        catch (SQLException e) {
            StringBuffer message = new StringBuffer("Failed to delete : ");
            message.append(e.getMessage());
            if (needToCommit) {
                try {
                    dbtlocal.rollback();
                    dbtlocal.release();
                }
                catch (SQLException sqle2) {
                    message.insert(0, "\n");
                    message.insert(0, sqle2.getMessage());
                    message.insert(0, "Rollback failed: ");
                }
            }
            throw new SQLException(message.toString());
        }
    }

    public void save() throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException {
        this.save((DBTransaction)this.myDBt);
    }

    public void executeDelete(DBConnection conn) throws SQLException {
        DODS.getLogChannel().write(7, "executing LockEntryDelete");
        if (this.beMorePrecise() && (this.hasTransactionCache() || LockEntryDelete.hasGlobalCache())) {
            this.vecOIdsUpdated = this.myQuery.collectOIds();
        }
        this.myQB.setDeleteQuery();
        this.myQB.executeUpdate(conn);
        if (this.hasTransactionCache()) {
            if (this.beMorePrecise()) {
                ((TransactionQueryCache)this.myDBt.getTransactionCache()).removeEntries(this.vecOIdsUpdated);
            } else {
                ((TransactionQueryCache)this.myDBt.getTransactionCache()).removeEntries(LockEntryDO.class);
            }
        }
    }

    public void finalizeDelete(boolean success) {
        if (success) {
            try {
                if (this.beMorePrecise()) {
                    ((QueryCache)LockEntryDO.cache).removeEntries(this.vecOIdsUpdated);
                } else {
                    ((QueryCache)LockEntryDO.cache).removeEntries();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ObjectId get_OId() {
        return this.OId;
    }

    private boolean hasTransactionCache() {
        return null != this.myDBt && null != this.myDBt.getTransactionCache();
    }

    private static boolean hasGlobalCache() {
        return !LockEntryDO.cache.getCacheType().equals("none");
    }

    protected boolean isAutoSave() {
        boolean flag = false;
        try {
            String dbName = this.myDBt != null ? this.myDBt.getDatabaseName() : LockEntryDO.get_logicalDBName();
            flag = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(dbName)).getDatabaseConfiguration().getAutoSave();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public boolean isSelectOIds() {
        return this.doSelectOIds;
    }

    public void setSelectOIds(boolean arg) {
        this.doSelectOIds = arg;
    }

    protected boolean beMorePrecise() {
        try {
            if (this.doSelectOIds) {
                return LockEntryDO.getConfigurationAdministration().getTableConfiguration().getSelectOids();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void dumpData(boolean incrementVersion) {
    }

    public PreparedStatement getInsertStatement(DBConnection conn) throws SQLException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public PreparedStatement getUpdateStatement(DBConnection conn) throws SQLException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public PreparedStatement getDeleteStatement(DBConnection conn) throws SQLException {
        this.myQB.setDeleteQuery();
        return this.myQB.getStatement(conn);
    }
}

