/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.logging;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.internal.logging.LoggingManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;

public class StandardLoggingManager
implements LoggingManager {
    private static final String defaultLogChannel = "Shark";
    private CallbackUtilities cus;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
        PropertyConfigurator.configure((Properties)cus.getProperties());
    }

    public void error(String msg) throws RootException {
        this.error(defaultLogChannel, msg);
    }

    public void error(String msg, RootException ex) throws RootException {
        this.error(defaultLogChannel, msg, ex);
    }

    public void error(String channel, String msg) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.error((Object)msg);
    }

    public void error(String channel, String msg, RootException ex) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.error((Object)msg, (Throwable)ex);
    }

    public void warn(String msg) throws RootException {
        this.warn(defaultLogChannel, msg);
    }

    public void warn(String msg, RootException ex) throws RootException {
        this.warn(defaultLogChannel, msg, ex);
    }

    public void warn(String channel, String msg) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.warn((Object)msg);
    }

    public void warn(String channel, String msg, RootException ex) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.warn((Object)msg, (Throwable)ex);
    }

    public void info(String msg) throws RootException {
        this.info(defaultLogChannel, msg);
    }

    public void info(String msg, RootException ex) throws RootException {
        this.info(defaultLogChannel, msg, ex);
    }

    public void info(String channel, String msg) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.info((Object)msg);
    }

    public void info(String channel, String msg, RootException ex) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.info((Object)msg, (Throwable)ex);
    }

    public void debug(String msg) throws RootException {
        this.debug(defaultLogChannel, msg);
    }

    public void debug(String msg, RootException ex) throws RootException {
        this.debug(defaultLogChannel, msg, ex);
    }

    public void debug(String channel, String msg) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.debug((Object)msg);
    }

    public void debug(String channel, String msg, RootException ex) throws RootException {
        Logger logger = Logger.getLogger((String)channel);
        if (logger == null) {
            throw new RootException("Logger does not exist!");
        }
        logger.debug((Object)msg, (Throwable)ex);
    }
}

