/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.WfEventAuditWrapper;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.eventaudit.EventAuditException;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.StateEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.working.WfExecutionObjectInternal;
import org.enhydra.shark.api.internal.working.WfStateEventAuditInternal;

public class WfStateEventAuditWrapper
extends WfEventAuditWrapper
implements WfStateEventAuditInternal {
    private String oldState;
    private String newState;

    protected WfStateEventAuditWrapper(SharkTransaction t, WfExecutionObjectInternal object, String eventType, String oldState, String newState) throws BaseException {
        super(t, object, eventType);
        this.oldState = oldState;
        this.newState = newState;
        try {
            this.persist(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    protected WfStateEventAuditWrapper(String userAuth, StateEventAuditPersistenceInterface po) {
        super(userAuth, (EventAuditPersistenceInterface)po);
    }

    public String old_state() throws BaseException {
        return this.oldState;
    }

    public String new_state() throws BaseException {
        return this.newState;
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return;
            }
            StateEventAuditPersistenceInterface po = eam.createStateEventAudit();
            this.fillPersistentObject((EventAuditPersistenceInterface)po);
            eam.persist(po, t);
        }
        catch (EventAuditException pe) {
            pe.printStackTrace();
            throw new TransactionException((Throwable)pe);
        }
    }

    public void refresh() {
    }

    public void delete(SharkTransaction t) throws TransactionException {
    }

    @Override
    protected void fillPersistentObject(EventAuditPersistenceInterface po) {
        super.fillPersistentObject(po);
        StateEventAuditPersistenceInterface spo = (StateEventAuditPersistenceInterface)po;
        spo.setOldState(this.oldState);
        spo.setNewState(this.newState);
    }

    @Override
    protected void restore(EventAuditPersistenceInterface po) {
        super.restore(po);
        StateEventAuditPersistenceInterface spo = (StateEventAuditPersistenceInterface)po;
        this.oldState = spo.getOldState();
        this.newState = spo.getNewState();
    }
}

