/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.NotAssigned;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfAssignmentIterator;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfResourceInternal;

public class WfResourceWrapper
implements WfResource {
    private String userAuth;
    private String username;

    protected WfResourceWrapper(String userAuth, String username) {
        this.userAuth = userAuth;
        this.username = username;
    }

    public int how_many_work_item() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_work_item((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_work_item(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_how_many_work_item(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getAllValidAssignmentsForResource(this.username, t).size();
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public WfAssignmentIterator get_iterator_work_item() throws BaseException {
        WfAssignmentIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_work_item((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignmentIterator get_iterator_work_item(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_get_iterator_work_item(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createAssignmentIteratorWrapper(t, this.userAuth, this.username);
    }

    public WfAssignment[] get_sequence_work_item(int max_number) throws BaseException {
        WfAssignment[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_work_item((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment[] get_sequence_work_item(SharkTransaction t, int max_number) throws BaseException {
        List l;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_get_sequence_work_item(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (l = SharkUtilities.createAssignmentWrappers(t, this.userAuth, this.username)).size() || max_number <= 0) {
            max_number = l.size();
        }
        WfAssignment[] ret = new WfAssignment[l.size()];
        l.subList(0, max_number).toArray(ret);
        return ret;
    }

    public boolean is_member_of_work_items(WfAssignment member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_work_items((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_work_items(SharkTransaction t, WfAssignment member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_is_member_of_work_items(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String resUn = member.assignee(t).resource_key(t);
        return resUn.equals(this.username);
    }

    public String resource_key() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm == null) {
            return this.username;
        }
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.resource_key((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String resource_key(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_resource_key(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.username;
    }

    public String resource_name() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.resource_name((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String resource_name(SharkTransaction t) throws BaseException {
        WfResourceInternal resInternal = WfResourceWrapper.getResourceImpl(t, this.username);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_resource_name(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return resInternal.resource_name(t);
    }

    public void release(WfAssignment from_assigment, String release_info) throws BaseException, NotAssigned {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.release((SharkTransaction)t, from_assigment, release_info);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void release(SharkTransaction t, WfAssignment from_assigment, String release_info) throws BaseException, NotAssigned {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_resource_release(t, this.username, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    public String toString() {
        return "[Id=" + this.username + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfResource)) {
            return false;
        }
        WfResource res = (WfResource)obj;
        try {
            if (obj instanceof WfResourceWrapper) {
                return ((WfResourceWrapper)obj).username.equals(this.username);
            }
            return res.resource_key().equals(this.username);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static WfResourceInternal getResourceImpl(SharkTransaction t, String username) throws BaseException {
        WfResourceInternal res = SharkUtilities.getResource(t, username);
        if (res == null) {
            throw new BaseException("Resource does not exist");
        }
        return res;
    }
}

