/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfservice.WfProcessMgrIterator;
import org.enhydra.shark.api.internal.instancepersistence.ProcessMgrPersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfProcessMgrIteratorWrapper
extends BaseIteratorWrapper
implements WfProcessMgrIterator {
    protected WfProcessMgrIteratorWrapper(SharkTransaction t, String userAuth) throws BaseException {
        super(userAuth);
    }

    public WfProcessMgr get_next_object() throws BaseException {
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr get_next_object(SharkTransaction t) throws BaseException {
        return (WfProcessMgr)super.getNextObject(t);
    }

    public WfProcessMgr get_previous_object() throws BaseException {
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr get_previous_object(SharkTransaction t) throws BaseException {
        return (WfProcessMgr)super.getPreviousObject(t);
    }

    public WfProcessMgr[] get_next_n_sequence(int max_number) throws BaseException {
        WfProcessMgr[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfProcessMgr[] ret = new WfProcessMgr[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfProcessMgr[] get_previous_n_sequence(int max_number) throws BaseException {
        WfProcessMgr[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfProcessMgr[] ret = new WfProcessMgr[l.size()];
        l.toArray(ret);
        return ret;
    }

    @Override
    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<WfProcessMgr> mgrs = new ArrayList<WfProcessMgr>();
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getProcessMgrsWhere(t, this.sqlWhere);
            Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
            for (int i = 0; i < l.size(); ++i) {
                ProcessMgrPersistenceInterface po = (ProcessMgrPersistenceInterface)l.get(i);
                boolean toAdd = true;
                if (this.eval) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("name", po.getName());
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("category")) {
                        String cat = SharkUtilities.getWorkflowProcess(po.getPackageId(), po.getVersion(), po.getProcessDefinitionId()).getAccessLevel();
                        context.put("category", cat);
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("version")) {
                        context.put("version", po.getVersion());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("createdTime_ms")) {
                        context.put("createdTime_ms", new Long(po.getCreated()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("packageId")) {
                        context.put("packageId", po.getPackageId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("processDefinitionId")) {
                        context.put("processDefinitionId", po.getProcessDefinitionId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("enabled")) {
                        context.put("enabled", new Boolean(po.getState() == 0));
                    }
                    toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                }
                if (!toAdd) continue;
                mgrs.add(SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userAuth, po.getName()));
            }
            this.setObjectList(mgrs);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

