/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.AlreadySuspended;
import org.enhydra.shark.api.client.wfmodel.CannotComplete;
import org.enhydra.shark.api.client.wfmodel.CannotReopen;
import org.enhydra.shark.api.client.wfmodel.CannotResume;
import org.enhydra.shark.api.client.wfmodel.CannotStop;
import org.enhydra.shark.api.client.wfmodel.CannotSuspend;
import org.enhydra.shark.api.client.wfmodel.HistoryNotAvailable;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.InvalidPerformer;
import org.enhydra.shark.api.client.wfmodel.InvalidState;
import org.enhydra.shark.api.client.wfmodel.NotRunning;
import org.enhydra.shark.api.client.wfmodel.NotSuspended;
import org.enhydra.shark.api.client.wfmodel.ResultNotAvailable;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfAssignmentIterator;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfEventAuditIterator;
import org.enhydra.shark.api.client.wfmodel.WfExecutionObject;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.client.wfmodel.how_closedType;
import org.enhydra.shark.api.client.wfmodel.while_openType;
import org.enhydra.shark.api.client.wfmodel.why_not_runningType;
import org.enhydra.shark.api.client.wfmodel.workflow_stateType;
import org.enhydra.shark.api.common.SharkConstants;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfActivityInternal;

public class WfActivityWrapper
implements WfActivity {
    private String userAuth;
    private String mgrName;
    private String processId;
    private String id;

    protected WfActivityWrapper(String userAuth, String mgrName, String processId, String id) {
        this.userAuth = userAuth;
        this.mgrName = mgrName;
        this.processId = processId;
        this.id = id;
    }

    public int how_many_assignment() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_assignment((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_assignment(SharkTransaction t) throws BaseException {
        try {
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
                sm.check_activity_how_many_assignment(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getAllValidAssignmentsForActivity(this.id, t).size();
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public WfAssignmentIterator get_iterator_assignment() throws BaseException {
        WfAssignmentIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_assignment((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignmentIterator get_iterator_assignment(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_get_iterator_assignment(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createAssignmentIteratorWrapper(t, this.userAuth, this.processId, this.id);
    }

    public WfAssignment[] get_sequence_assignment(int max_number) throws BaseException {
        WfAssignment[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_assignment((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment[] get_sequence_assignment(SharkTransaction t, int max_number) throws BaseException {
        try {
            List l;
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
                sm.check_activity_get_sequence_assignment(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            if (max_number > (l = SharkUtilities.createAssignmentWrappers(t, this.userAuth, this.processId, this.id)).size() || max_number <= 0) {
                max_number = l.size();
            }
            WfAssignment[] ret = new WfAssignment[l.size()];
            l.subList(0, max_number).toArray(ret);
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public boolean is_member_of_assignment(WfAssignment member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_assignment((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_assignment(SharkTransaction t, WfAssignment member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_is_member_of_assignment(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String actId = member.activity(t).key(t);
        return actId.equals(this.id);
    }

    public WfProcess container() throws BaseException {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.container((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess container(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_container(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userAuth, this.mgrName, this.processId);
    }

    public Map result() throws BaseException, ResultNotAvailable {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.result((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof ResultNotAvailable) {
                throw (ResultNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map result(SharkTransaction t) throws BaseException, ResultNotAvailable {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_result(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.result(t);
    }

    public void set_result(Map results) throws BaseException, InvalidData {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_result((SharkTransaction)t, results);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidData) {
                throw (InvalidData)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_result(SharkTransaction t, Map results) throws BaseException, InvalidData {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_set_result(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.set_result(t, results);
    }

    public void complete() throws BaseException, CannotComplete {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.complete((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotComplete) {
                throw (CannotComplete)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void complete(SharkTransaction t) throws BaseException, CannotComplete {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_complete(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.complete(t);
    }

    public workflow_stateType workflow_state() throws BaseException {
        workflow_stateType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.workflow_state((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public workflow_stateType workflow_state(SharkTransaction t) throws BaseException {
        String state;
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_workflow_state(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = actInternal.state(t)).startsWith("closed")) {
            return workflow_stateType.closed;
        }
        return workflow_stateType.open;
    }

    public while_openType while_open() throws BaseException {
        while_openType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.while_open((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public while_openType while_open(SharkTransaction t) throws BaseException {
        String state;
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_while_open(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = actInternal.state(t)).equals("open.running")) {
            return while_openType.running;
        }
        return while_openType.not_running;
    }

    public why_not_runningType why_not_running() throws BaseException {
        why_not_runningType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.why_not_running((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public why_not_runningType why_not_running(SharkTransaction t) throws BaseException {
        String state;
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_why_not_running(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = actInternal.state(t)).equals("open.not_running.suspended")) {
            return why_not_runningType.suspended;
        }
        return why_not_runningType.not_started;
    }

    public how_closedType how_closed() throws BaseException {
        how_closedType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_closed((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public how_closedType how_closed(SharkTransaction t) throws BaseException {
        String state;
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_how_closed(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = actInternal.state(t)).equals("closed.completed")) {
            return how_closedType.completed;
        }
        if (state.equals("closed.terminated")) {
            return how_closedType.terminated;
        }
        return how_closedType.aborted;
    }

    public String[] valid_states() throws BaseException {
        String[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.valid_states((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String[] valid_states(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_valid_states(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String state = actInternal.state(t);
        List vs = SharkUtilities.valid_activity_states(actInternal.state(t));
        String[] vss = new String[vs.size()];
        vs.toArray(vss);
        return vss;
    }

    public String state() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.state((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String state(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_state(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String state = actInternal.state(t);
        return actInternal.state(t);
    }

    public void change_state(String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.change_state((SharkTransaction)t, new_state);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidState) {
                throw (InvalidState)((Object)e);
            }
            if (e instanceof TransitionNotAllowed) {
                throw (TransitionNotAllowed)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void change_state(SharkTransaction t, String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        String curResUname = actInternal.getResourceUsername(t);
        String curState = actInternal.state(t);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_change_state(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), curResUname, actInternal.getAssignmentResourceIds(t), curState, new_state);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (!SharkConstants.possibleActivityStates.contains(new_state)) {
            throw new InvalidState("Can't change activity state to " + new_state + " - no such state!");
        }
        if (!SharkUtilities.valid_activity_states(actInternal.state(t)).contains(new_state)) {
            throw new TransitionNotAllowed("Current activity state is " + curState + " - can't change to state " + new_state + "!");
        }
        if (new_state.equals("closed.aborted")) {
            try {
                actInternal.abort(t);
            }
            catch (CannotStop cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        if (new_state.equals("closed.completed")) {
            try {
                actInternal.complete(t);
            }
            catch (CannotComplete cnc) {
                throw new TransitionNotAllowed((Throwable)cnc);
            }
        }
        if (new_state.equals("closed.terminated")) {
            try {
                actInternal.terminate(t);
            }
            catch (CannotStop cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        if (new_state.equals("open.not_running.not_started")) {
            try {
                actInternal.set_accepted_status(t, false, this.userAuth);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (new_state.equals("open.not_running.suspended")) {
            try {
                actInternal.suspend(t);
            }
            catch (AlreadySuspended as) {
                throw new TransitionNotAllowed((Throwable)as);
            }
            catch (CannotSuspend cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        if (curState.equals("open.not_running.suspended")) {
            try {
                actInternal.resume(t);
            }
            catch (CannotResume cnr) {
                throw new TransitionNotAllowed((Throwable)cnr);
            }
            catch (NotSuspended ns) {
                throw new TransitionNotAllowed((Throwable)ns);
            }
        }
        try {
            actInternal.set_accepted_status(t, true, this.userAuth);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String name() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.name((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String name(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_name(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.name(t);
    }

    public void set_name(String new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_name((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_name(SharkTransaction t, String new_value) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_set_name(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.set_name(t, new_value);
    }

    public String key() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm == null) {
            return this.id;
        }
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.key((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String key(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_key(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.id;
    }

    public String description() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.description((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String description(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_description(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.description(t);
    }

    public void set_description(String new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_description((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_description(SharkTransaction t, String new_value) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_set_description(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.set_description(t, new_value);
    }

    public Map process_context() throws BaseException {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.process_context((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map process_context(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_process_context(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.process_context(t);
    }

    public void set_process_context(Map new_value) throws BaseException, InvalidData, UpdateNotAllowed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_process_context((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidData) {
                throw (InvalidData)e;
            }
            if (e instanceof UpdateNotAllowed) {
                throw (UpdateNotAllowed)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_process_context(SharkTransaction t, Map new_value) throws BaseException, InvalidData, UpdateNotAllowed {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_set_process_context(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.set_process_context(t, new_value);
    }

    public short priority() throws BaseException {
        short ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.priority((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public short priority(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_priority(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.priority(t);
    }

    public void set_priority(short new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_priority((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_priority(SharkTransaction t, short new_value) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_set_priority(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.set_priority(t, new_value);
    }

    public void resume() throws BaseException, CannotResume, NotSuspended {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.resume((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotResume) {
                throw (CannotResume)((Object)e);
            }
            if (e instanceof NotSuspended) {
                throw (NotSuspended)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void resume(SharkTransaction t) throws BaseException, CannotResume, NotSuspended {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_result(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.resume(t);
    }

    public void suspend() throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.suspend((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotSuspend) {
                throw (CannotSuspend)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof AlreadySuspended) {
                throw (AlreadySuspended)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void suspend(SharkTransaction t) throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_suspend(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.suspend(t);
    }

    public void terminate() throws BaseException, CannotStop, NotRunning {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.terminate((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotStop) {
                throw (CannotStop)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void terminate(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_terminate(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.terminate(t);
    }

    public void abort() throws BaseException, CannotStop, NotRunning {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.abort((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotStop) {
                throw (CannotStop)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void abort(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_abort(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInternal.abort(t);
    }

    public void reopen() throws BaseException, CannotReopen {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reopen((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotReopen) {
                throw (CannotReopen)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reopen(SharkTransaction t) throws BaseException, CannotReopen {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        actInternal.reopen(t);
    }

    public int how_many_history() throws BaseException, HistoryNotAvailable {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_history((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_history(SharkTransaction t) throws BaseException, HistoryNotAvailable {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_how_many_history(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return 0;
            }
            return eam.restoreActivityHistory(this.processId, this.id, t).size();
        }
        catch (Exception ex) {
            throw new BaseException("Problems while retrieving activity's history!", (Throwable)ex);
        }
    }

    public WfEventAuditIterator get_iterator_history(String query, Map names_in_query) throws BaseException, HistoryNotAvailable {
        WfEventAuditIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_history((SharkTransaction)t, query, names_in_query);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAuditIterator get_iterator_history(SharkTransaction t, String query, Map names_in_query) throws BaseException, HistoryNotAvailable {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_get_iterator_history(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfEventAuditIterator it = SharkEngineManager.getInstance().getObjectFactory().createEventAuditIteratorWrapper(t, this.userAuth, this.processId, this.id);
        try {
            it.set_query_expression(t, query);
            it.set_names_in_expression(t, names_in_query);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        return it;
    }

    public WfEventAudit[] get_sequence_history(int max_number) throws BaseException, HistoryNotAvailable {
        WfEventAudit[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_history((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit[] get_sequence_history(SharkTransaction t, int max_number) throws BaseException, HistoryNotAvailable {
        List history;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_get_sequence_history(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (history = SharkUtilities.createActivityHistoryEvents(t, this.userAuth, this.processId, this.id)).size() || max_number <= 0) {
            max_number = history.size();
        }
        WfEventAudit[] eas = new WfEventAudit[max_number];
        history.subList(0, max_number).toArray(eas);
        return eas;
    }

    public boolean is_member_of_history(WfExecutionObject member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_history((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_history(SharkTransaction t, WfExecutionObject member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_is_member_of_history(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        boolean ret = false;
        List history = SharkUtilities.createActivityHistoryEvents(t, this.userAuth, this.processId, this.id);
        for (WfEventAudit ea : history) {
            if (member instanceof WfActivity) {
                WfActivity act = (WfActivity)member;
                if (!act.container(t).key(t).equals(ea.process_key()) || !act.key(t).equals(ea.activity_key())) continue;
                ret = true;
                break;
            }
            if (!member.key(t).equals(ea.process_key())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public UtcT last_state_time() throws BaseException {
        UtcT ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.last_state_time((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public UtcT last_state_time(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_last_state_time(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.last_state_time(t);
    }

    public int how_many_performer() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_performer((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_performer(SharkTransaction t) throws BaseException {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_how_many_performer(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInternal.getPerformerId(t) != null ? 1 : 0;
    }

    public WfProcessIterator get_iterator_performer() throws BaseException {
        WfProcessIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_performer((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessIterator get_iterator_performer(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_get_iterator_performer(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createProcessIteratorWrapper(t, this.userAuth, this.processId, this.id);
    }

    public WfProcess[] get_sequence_performer(int max_number) throws BaseException {
        WfProcess[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_performer((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess[] get_sequence_performer(SharkTransaction t, int max_number) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
            try {
                sm.check_activity_get_sequence_performer(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            List l = SharkUtilities.createActivityPerformerWrapper(t, this.userAuth, this.processId, this.id);
            if (max_number > l.size() || max_number <= 0) {
                max_number = l.size();
            }
            WfProcess[] ret = new WfProcess[l.size()];
            l.subList(0, max_number).toArray(ret);
            return ret;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public boolean is_member_of_performer(WfProcess member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_performer((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_performer(SharkTransaction t, WfProcess member) throws BaseException {
        String performerId;
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_activity_is_member_of_performer(t, this.processId, this.id, this.userAuth, actInternal.container(t).requester(t).getResourceRequesterUsername(t), actInternal.getResourceUsername(t), actInternal.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return (performerId = actInternal.getPerformerId(t)) != null && member.key(t).equals(performerId);
    }

    public void receive_event(WfEventAudit event) throws BaseException, InvalidPerformer {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.receive_event((SharkTransaction)t, event);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void receive_event(SharkTransaction t, WfEventAudit event) throws BaseException, InvalidPerformer {
        WfActivityInternal actInternal = WfActivityWrapper.getActivityImpl(t, this.processId, this.id);
        actInternal.receive_event(t, event, null);
    }

    public String toString() {
        return "[pId=" + this.processId + ",aId=" + this.id + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfActivity)) {
            return false;
        }
        WfActivity act = (WfActivity)obj;
        try {
            if (obj instanceof WfActivityWrapper) {
                return ((WfActivityWrapper)obj).id.equals(this.id);
            }
            return act.key().equals(this.id);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static WfActivityInternal getActivityImpl(SharkTransaction t, String processId, String actId) throws BaseException {
        WfActivityInternal actImpl = SharkUtilities.getActivity(t, processId, actId);
        if (actImpl == null) {
            throw new BaseException("Activity does not exist");
        }
        return actImpl;
    }
}

