/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class UpdateChecker {
    private Package oldPackage;
    private Package newPackage;
    private List processesToRestore;
    private List activitiesToRestore;

    public UpdateChecker(Package oldPackage, Package newPackage, List processesToRestore, List activitiesToRestore) {
        this.oldPackage = oldPackage;
        this.newPackage = newPackage;
        this.processesToRestore = processesToRestore;
        this.activitiesToRestore = activitiesToRestore;
    }

    public boolean isUpdatePossible(SharkTransaction t) throws BaseException {
        for (WfActivityInternal act : this.activitiesToRestore) {
            try {
                if (act.state(t).startsWith("closed")) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Activity actDef = SharkUtilities.getActivityDefinition(t, act, SharkUtilities.getWorkflowProcess(act.container(t).package_id(t), act.container(t).manager_version(t), act.container(t).process_definition_id(t)), act.block_activity(t));
            String processId = null;
            String activitySetId = null;
            XMLCollectionElement owner = (XMLCollectionElement)actDef.getParent().getParent();
            if (owner instanceof WorkflowProcess) {
                processId = owner.getId();
            } else {
                activitySetId = owner.getId();
                processId = XMLUtil.getWorkflowProcess((XMLElement)actDef).getId();
            }
            WorkflowProcess wp = this.newPackage.getWorkflowProcess(processId);
            if (wp == null) {
                return false;
            }
            Activities acts = null;
            if (activitySetId != null) {
                ActivitySet as = wp.getActivitySet(activitySetId);
                if (as == null) {
                    return false;
                }
                acts = as.getActivities();
            } else {
                acts = wp.getActivities();
            }
            if (acts.getActivity(actDef.getId()) != null) continue;
            return false;
        }
        return true;
    }
}

