/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkPackageValidator;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.RepositoryInvalid;
import org.enhydra.shark.api.client.wfservice.RepositoryMgr;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.utilities.TraverseException;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Package;

public class RepositoryManager
implements RepositoryMgr {
    private XMLInterface xmlInterface = SharkEngineManager.getInstance().getXMLInterface();
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();
    private String userId = "Unknown";

    protected RepositoryManager() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public void deletePackage(String relativePath) throws BaseException, RepositoryInvalid {
        String path = SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY + File.separator + relativePath;
        File pkgFile = new File(path);
        if (!pkgFile.exists() || pkgFile.isDirectory()) {
            this.cus.error("RepositoryManager -> deleting of the file " + path + " failed because it does not exist, or it is a directory");
            throw new BaseException("RepositoryManager -> deleting of the file " + path + " failed because it does not exist, or it is a directory");
        }
        boolean isDeleted = false;
        try {
            isDeleted = pkgFile.delete();
        }
        catch (Exception ex) {
            this.cus.error("RepositoryManager -> deleting of the file " + path + " failed - it might be locked");
            throw new BaseException("RepositoryManager -> deleting of the file " + path + " failed - it might be locked");
        }
        if (!isDeleted) {
            throw new BaseException("RepositoryManager -> deleting of the file " + path + " NOT deleted");
        }
        this.cus.info("RepositoryManager -> file " + path + " is successfully deleted from repository");
    }

    public void uploadPackage(byte[] pkgContent, String relativePath) throws BaseException, RepositoryInvalid {
        String path = SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY + File.separator + relativePath;
        File pkgFile = new File(path);
        File parentFile = pkgFile.getParentFile();
        if (pkgFile.exists() || parentFile.exists() && !parentFile.isDirectory()) {
            this.cus.error("RepositoryManager -> upload of the file " + path + " failed because it already exists or its parent is not directory");
            throw new BaseException("RepositoryManager -> upload of the file " + path + " failed because it already exists or its parent is not directory");
        }
        if (!parentFile.exists()) {
            try {
                parentFile.mkdirs();
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(pkgFile);
            fos.write(pkgContent);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            this.cus.error("RepositoryManager -> upload of the file " + path + " failed");
            throw new BaseException((Throwable)ex);
        }
        XMLInterfaceForJDK13 xpdlManager = new XMLInterfaceForJDK13();
        Package updatedPkg = xpdlManager.openPackage(path, false);
        SharkPackageValidator pv = new SharkPackageValidator(updatedPkg, (XMLInterface)xpdlManager, true);
        String xpdlValidationErrors = "";
        if (updatedPkg == null || !pv.validateAll(true)) {
            xpdlValidationErrors = updatedPkg != null ? pv.createXPDLValidationErrorsString() : "Fatal error while checking package";
            xpdlManager.closeAllPackages();
            try {
                pkgFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cus.error("RepositoryManager -> upload of the file " + path + " failed because the package is not valid");
            throw new RepositoryInvalid(xpdlValidationErrors, "Error while uploading package to repository");
        }
        xpdlManager.closeAllPackages();
        this.cus.info("RepositoryManager -> file " + path + " is successfully uploaded into repository");
    }

    public String[] getPackagePaths() throws BaseException {
        List packageFiles;
        try {
            packageFiles = SharkUtilities.getDefinedPackageFiles(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY, true);
        }
        catch (TraverseException e) {
            throw new BaseException("Could not get package paths", (Throwable)e);
        }
        ArrayList<String> pfls = new ArrayList<String>();
        Collections.sort(packageFiles);
        for (File f : packageFiles) {
            String fileName;
            try {
                fileName = f.getCanonicalPath();
            }
            catch (Exception ex) {
                fileName = f.getAbsolutePath();
            }
            fileName = fileName.substring(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY.length() + 1);
            pfls.add(fileName);
        }
        String[] pfs = new String[pfls.size()];
        pfls.toArray(pfs);
        return pfs;
    }

    public Map getPackagePathToIdMapping() throws BaseException {
        List packageFiles;
        try {
            packageFiles = SharkUtilities.getDefinedPackageFiles(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY, true);
        }
        catch (TraverseException e) {
            throw new BaseException("Could not get package path to id mapping", (Throwable)e);
        }
        SequencedHashMap m = new SequencedHashMap();
        Collections.sort(packageFiles);
        for (File f : packageFiles) {
            String pkgId;
            String fileName;
            try {
                fileName = f.getCanonicalPath();
            }
            catch (Exception ex) {
                fileName = f.getAbsolutePath();
            }
            if ((pkgId = this.xmlInterface.getIdFromFile(fileName)) == null || pkgId.length() <= 0) continue;
            fileName = fileName.substring(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY.length() + 1);
            m.put(fileName, pkgId);
        }
        return m;
    }

    public String getPackageId(String relativePath) throws BaseException {
        List packageFiles;
        String pkgId = "";
        relativePath = XMLUtil.convertToSystemPath((String)relativePath);
        try {
            packageFiles = SharkUtilities.getDefinedPackageFiles(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY, true);
        }
        catch (TraverseException e) {
            throw new BaseException(String.format("Could not get package id by relative path [%s]", relativePath), (Throwable)e);
        }
        HashMap m = new HashMap();
        for (File f : packageFiles) {
            String relFileName;
            String fileName;
            try {
                fileName = f.getCanonicalPath();
            }
            catch (Exception ex) {
                fileName = f.getAbsolutePath();
            }
            if (!(relFileName = fileName.substring(SharkUtilities.EXTERNAL_PACKAGES_REPOSITORY.length() + 1)).equals(relativePath)) continue;
            return this.xmlInterface.getIdFromFile(fileName);
        }
        return null;
    }
}

