/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.WfResourceIterator;
import org.enhydra.shark.api.internal.instancepersistence.ResourcePersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfResourceIteratorWrapper
extends BaseIteratorWrapper
implements WfResourceIterator {
    protected WfResourceIteratorWrapper(SharkTransaction t, String userAuth) throws BaseException {
        super(userAuth);
    }

    public WfResource get_next_object() throws BaseException {
        WfResource ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource get_next_object(SharkTransaction t) throws BaseException {
        return (WfResource)super.getNextObject(t);
    }

    public WfResource get_previous_object() throws BaseException {
        WfResource ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource get_previous_object(SharkTransaction t) throws BaseException {
        return (WfResource)super.getPreviousObject(t);
    }

    public WfResource[] get_next_n_sequence(int max_number) throws BaseException {
        WfResource[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfResource[] ret = new WfResource[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfResource[] get_previous_n_sequence(int max_number) throws BaseException {
        WfResource[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfResource[] ret = new WfResource[l.size()];
        l.toArray(ret);
        return ret;
    }

    @Override
    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<WfResource> resources = new ArrayList<WfResource>();
            List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getResourcesWhere(t, this.sqlWhere);
            Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
            for (int i = 0; i < l.size(); ++i) {
                ResourcePersistenceInterface po = (ResourcePersistenceInterface)l.get(i);
                boolean toAdd = true;
                if (this.eval) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("username", po.getUsername());
                    if (this.queryExpression.indexOf("noOfAssignments") != -1) {
                        Long lng = new Long(SharkEngineManager.getInstance().getInstancePersistenceManager().getAllValidAssignmentsForResource(po.getUsername(), t).size());
                        context.put("noOfAssignments", lng);
                    }
                    toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                }
                if (!toAdd) continue;
                resources.add(SharkEngineManager.getInstance().getObjectFactory().createResourceWrapper(this.userAuth, po.getUsername()));
            }
            this.setObjectList(resources);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

