/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.AlreadySuspended;
import org.enhydra.shark.api.client.wfmodel.CannotResume;
import org.enhydra.shark.api.client.wfmodel.CannotStop;
import org.enhydra.shark.api.client.wfmodel.CannotSuspend;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.NotRunning;
import org.enhydra.shark.api.client.wfmodel.NotSuspended;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.working.WfExecutionObjectInternal;
import org.enhydra.shark.api.internal.working.WfStateEventAuditInternal;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ProcessHeader;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public abstract class WfExecutionObjectImpl
implements WfExecutionObjectInternal {
    protected String state = "open.not_running.not_started";
    protected String name;
    protected String key;
    protected String description;
    protected short priority;
    protected long lastStateTime;
    protected long limitTime = 0x3FFFFFFFFFFFFFFFL;
    protected WfStateEventAuditInternal lastStateEventAudit;

    public String state(SharkTransaction t) throws BaseException {
        return this.state;
    }

    public String name(SharkTransaction t) throws BaseException {
        return this.name;
    }

    public void set_name(SharkTransaction t, String new_value) throws BaseException {
        try {
            this.name = new_value;
            if (this.name.length() > 254) {
                this.name = this.name.substring(0, 254);
            }
            this.persist(t);
        }
        catch (Exception tme) {
            throw new BaseException((Throwable)tme);
        }
    }

    public String key(SharkTransaction t) throws BaseException {
        return this.key;
    }

    public String description(SharkTransaction t) throws BaseException {
        return this.description;
    }

    public void set_description(SharkTransaction t, String new_value) throws BaseException {
        try {
            this.description = new_value;
            if (this.description.length() > 63) {
                this.description = this.description.substring(0, 62);
            }
            this.persist(t);
        }
        catch (Exception tme) {
            throw new BaseException((Throwable)tme);
        }
    }

    public Map process_context(SharkTransaction t) throws BaseException {
        Map m = this.getContext(t);
        HashMap ret = new HashMap();
        for (Map.Entry me : m.entrySet()) {
            Object id = me.getKey();
            Object val = me.getValue();
            try {
                ret.put(id, MiscUtilities.cloneWRD(val));
            }
            catch (Throwable thr) {
                throw new BaseException(thr);
            }
        }
        return ret;
    }

    public abstract void set_process_context(SharkTransaction var1, Map var2) throws BaseException, InvalidData, UpdateNotAllowed;

    public short priority(SharkTransaction t) throws BaseException {
        return this.priority;
    }

    public void set_priority(SharkTransaction t, short new_value) throws BaseException {
        if (new_value < 1 || new_value > 5) {
            throw new BaseException("Priority is out of range!");
        }
        if (this.state(t).startsWith("closed")) {
            throw new BaseException("Priority cannot be updated.!");
        }
        this.priority = new_value;
        try {
            this.persist(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void activateLimitAgent(SharkTransaction trans) throws BaseException {
        String limitStr;
        LimitAgentManager mgr = SharkEngineManager.getInstance().getLimitAgentManager();
        if (mgr == null || this.state(trans).startsWith("closed")) {
            return;
        }
        long startTime = -1L;
        XMLCollectionElement xpdlObj = this.getXPDLObject(trans);
        WorkflowProcess wp = XMLUtil.getWorkflowProcess((XMLElement)xpdlObj);
        ProcessHeader ph = wp.getProcessHeader();
        String durationStr = ph.getDurationUnit();
        if (xpdlObj instanceof Activity) {
            limitStr = ((Activity)xpdlObj).getLimit();
            startTime = this.getCreationTime(trans);
        } else {
            limitStr = ph.getLimit();
            startTime = this.getStartTime(trans);
        }
        int durationUnit = 0;
        if (durationStr == null || durationStr.trim().length() == 0) {
            SharkEngineManager.getInstance().getCallbackUtilities().debug("DurationUnit is not set, not setting limit agent");
            return;
        }
        if ("Y".equals(durationStr)) {
            durationUnit = 1;
        } else if ("M".equals(durationStr)) {
            durationUnit = 2;
        } else if ("D".equals(durationStr)) {
            durationUnit = 5;
        } else if ("h".equals(durationStr)) {
            durationUnit = 10;
        } else if ("m".equals(durationStr)) {
            durationUnit = 12;
        } else if ("s".equals(durationStr)) {
            durationUnit = 13;
        }
        int limit = 0;
        if (limitStr == null || limitStr.trim().length() == 0) {
            SharkEngineManager.getInstance().getCallbackUtilities().debug("Limit value is not set, not setting limit agent");
            return;
        }
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (NumberFormatException e) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Defined Limit is not a valid integer, not setting limit : " + limitStr);
            return;
        }
        long runtime = 0L;
        if (durationUnit > 0 && limit > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(startTime));
            cal.add(durationUnit, limit);
            runtime = cal.getTime().getTime();
        }
        Map context = this.process_context(trans);
        if (runtime > 0L) {
            this.notifyStart(trans, context, runtime);
            this.limitTime = runtime;
        }
    }

    public abstract long getCreationTime(SharkTransaction var1) throws BaseException;

    public abstract long getStartTime(SharkTransaction var1) throws BaseException;

    public UtcT last_state_time(SharkTransaction t) throws BaseException {
        return new UtcT(this.lastStateTime, 0, 0, 0);
    }

    public abstract void resume(SharkTransaction var1) throws BaseException, CannotResume, NotSuspended;

    public abstract void suspend(SharkTransaction var1) throws BaseException, CannotSuspend, NotRunning, AlreadySuspended;

    public abstract void terminate(SharkTransaction var1) throws BaseException, CannotStop, NotRunning;

    public abstract void abort(SharkTransaction var1) throws BaseException, CannotStop, NotRunning;

    protected abstract XMLCollectionElement getXPDLObject(SharkTransaction var1) throws BaseException;

    protected abstract void notifyStart(SharkTransaction var1, Map var2, long var3) throws BaseException;
}

