/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.CannotAcceptSuspended;
import org.enhydra.shark.api.client.wfmodel.InvalidResource;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;

public class WfAssignmentWrapper
implements WfAssignment {
    private String userAuth;
    private String mgrName;
    private String processId;
    private String activityId;
    private String username;

    protected WfAssignmentWrapper(String userAuth, String mgrName, String processId, String actId, String username) {
        this.userAuth = userAuth;
        this.mgrName = mgrName;
        this.processId = processId;
        this.activityId = actId;
        this.username = username;
    }

    public WfActivity activity() throws BaseException {
        WfActivity ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.activity((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity activity(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInt = SharkUtilities.getActivity(t, this.processId, this.activityId);
            try {
                sm.check_assignment_activity(t, this.processId, this.activityId, this.username, this.userAuth, actInt.container(t).requester(t).getResourceRequesterUsername(t), actInt.getResourceUsername(t), actInt.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createActivityWrapper(this.userAuth, this.mgrName, this.processId, this.activityId);
    }

    public WfResource assignee() throws BaseException {
        WfResource ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.assignee((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource assignee(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfActivityInternal actInt = SharkUtilities.getActivity(t, this.processId, this.activityId);
            try {
                sm.check_assignment_assignee(t, this.processId, this.activityId, this.username, this.userAuth, actInt.container(t).requester(t).getResourceRequesterUsername(t), actInt.getResourceUsername(t), actInt.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createResourceWrapper(this.userAuth, this.username);
    }

    public void set_assignee(WfResource new_value) throws BaseException, InvalidResource {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_assignee((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidResource) {
                throw (InvalidResource)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_assignee(SharkTransaction t, WfResource new_value) throws BaseException, InvalidResource {
        WfAssignmentInternal assInternal = WfAssignmentWrapper.getAssignmentImpl(t, this.processId, this.activityId, this.username);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_assignment_set_assignee(t, this.processId, this.activityId, this.username, this.userAuth, assInternal.activity(t).container(t).requester(t).getResourceRequesterUsername(t), assInternal.activity(t).getResourceUsername(t), assInternal.activity(t).getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (new_value == null) {
            throw new BaseException("Assignee can't be null");
        }
        assInternal.set_assignee(t, SharkUtilities.getResource(t, new_value.resource_key(t)));
        this.username = new_value.resource_key(t);
    }

    public void set_accepted_status(boolean accept) throws BaseException, CannotAcceptSuspended {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_accepted_status((SharkTransaction)t, accept);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotAcceptSuspended) {
                throw (CannotAcceptSuspended)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_accepted_status(SharkTransaction t, boolean accept) throws BaseException, CannotAcceptSuspended {
        WfActivityInternal actInt = SharkUtilities.getActivity(t, this.processId, this.activityId);
        if (actInt == null) {
            throw new BaseException("Assignment is not valid anymore");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_assignment_set_accepted_status(t, this.processId, this.activityId, this.username, this.userAuth, actInt.container(t).requester(t).getResourceRequesterUsername(t), actInt.getResourceUsername(t), actInt.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        actInt.set_accepted_status(t, accept, this.username);
    }

    public boolean get_accepted_status() throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_accepted_status((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean get_accepted_status(SharkTransaction t) throws BaseException {
        WfActivityInternal actInt = SharkUtilities.getActivity(t, this.processId, this.activityId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_assignment_get_accepted_status(t, this.processId, this.activityId, this.username, this.userAuth, actInt.container(t).requester(t).getResourceRequesterUsername(t), actInt.getResourceUsername(t), actInt.getAssignmentResourceIds(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return actInt.accepted_status(t);
    }

    public String toString() {
        return "[pId=" + this.processId + ",aId=" + this.activityId + "-> un=" + this.username + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfAssignment)) {
            return false;
        }
        WfAssignment ass = (WfAssignment)obj;
        try {
            if (obj instanceof WfAssignmentWrapper) {
                WfAssignmentWrapper aw = (WfAssignmentWrapper)obj;
                return aw.activityId.equals(this.activityId) && aw.username.equals(this.username);
            }
            return ass.activity().key().equals(this.activityId) && ass.assignee().resource_key().equals(this.username);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static WfAssignmentInternal getAssignmentImpl(SharkTransaction t, String procId, String actId, String username) throws BaseException {
        WfAssignmentInternal ass = SharkUtilities.getAssignment(t, procId, actId, username);
        if (ass == null) {
            throw new BaseException("Assignment is not valid anymore");
        }
        return ass;
    }
}

