/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.ApplicationMappingTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMap;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMappingManager;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ConnectFailed;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.ToolAgentManager;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActualParameter;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Tool;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ToolAgentManagerImpl
implements ToolAgentManager {
    private static final long APP_STATUS_INVALID = -1L;
    private static final String DEFAULT_TOOL_AGENT = "DefaultToolAgent";
    private String defaultToolAgentClassName;
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();

    protected ToolAgentManagerImpl() {
        Properties props = this.cus.getProperties();
        try {
            this.defaultToolAgentClassName = (String)props.get(DEFAULT_TOOL_AGENT);
        }
        catch (Throwable ex) {
            this.cus.error("ToolAgentManagerImpl -> Can't read default tool agent name - can't work without mappings !!!");
        }
    }

    public void executeActivity(SharkTransaction t, WfActivityInternal act) throws BaseException, ToolAgentGeneralException {
        ToolRunner tr = new ToolRunner(t, act);
        tr.run();
    }

    protected class ToolRunner {
        protected WfActivityInternal activity;
        protected Activity actDef;
        protected SharkTransaction transaction;

        protected ToolRunner(SharkTransaction t, WfActivityInternal wai) throws BaseException {
            this.transaction = t;
            this.activity = wai;
            WfProcessInternal pr = wai.container(t);
            WorkflowProcess wp = SharkUtilities.getWorkflowProcess(pr.package_id(t), pr.manager_version(t), pr.process_definition_id(t));
            this.actDef = SharkUtilities.getActivityDefinition(t, wai, wp, wai.block_activity(t));
        }

        public void run() throws BaseException, ToolAgentGeneralException {
            Iterator tools = null;
            for (Tool tool : this.actDef.getActivityTypes().getImplementation().getImplementationTypes().getTools().toElements()) {
                ToolAgentManagerImpl.this.cus.info("Activity" + this.activity.toString() + " - Executing tool [id=" + tool.getId() + "]");
                try {
                    this.invokeApplication(tool);
                }
                catch (Throwable ex) {
                    ToolAgentManagerImpl.this.cus.error("Activity" + this.activity.toString() + " - failed to execute tool [id=" + tool.getId() + "]");
                    if (ex instanceof ToolAgentGeneralException) {
                        throw (ToolAgentGeneralException)ex;
                    }
                    throw new BaseException(ex);
                }
            }
        }

        protected Map createContextMap(ActualParameters aps, FormalParameters fps) throws Exception {
            return SharkUtilities.createContextMap(this.transaction, this.activity, aps, fps);
        }

        protected String getAssignmentId(String procId, String actId) throws Exception {
            String actRes = this.activity.getResourceRequesterUsername(this.transaction);
            String assId = SharkUtilities.createAssignmentKey(actId, actRes);
            return assId;
        }

        protected Optional<Object> invokeApplication(Tool tool) throws Throwable {
            String applicationId = tool.getId();
            Application app = SharkUtilities.getApplication((XMLElement)tool, applicationId);
            ArrayList<AppParameter> parameters = new ArrayList<AppParameter>();
            String appPStr = app.getExtendedAttributes().getExtendedAttributesString();
            AppParameter param = new AppParameter("ExtendedAttributes", "ExtendedAttributes", "IN", (Object)appPStr, String.class);
            parameters.add(param);
            ActualParameters aps = tool.getActualParameters();
            FormalParameters fps = app.getApplicationTypes().getFormalParameters();
            Map m = this.createContextMap(aps, fps);
            Iterator itFps = fps.toElements().iterator();
            Iterator itAps = aps.toElements().iterator();
            while (itFps.hasNext() && itAps.hasNext()) {
                FormalParameter fp = (FormalParameter)itFps.next();
                ActualParameter ap = (ActualParameter)itAps.next();
                String fpMode = fp.getMode();
                String fpId = fp.getId();
                Object paramVal = m.get(fpId);
                param = new AppParameter(ap.toValue(), fpId, fpMode, paramVal, SharkUtilities.getJavaClass((XMLCollectionElement)fp));
                parameters.add(param);
            }
            ApplicationMappingManager mm = SharkEngineManager.getInstance().getApplicationMapPersistenceManager();
            ApplicationMap tad = null;
            if (mm != null) {
                XMLComplexElement cOwn = (XMLComplexElement)app.getParent().getParent();
                boolean isProcessApp = cOwn instanceof WorkflowProcess;
                ApplicationMappingTransaction t = null;
                try {
                    t = SharkUtilities.createApplicationMappingTransaction();
                    tad = SharkEngineManager.getInstance().getApplicationMapPersistenceManager().getApplicationMap(t, XMLUtil.getPackage((XMLElement)app).getId(), isProcessApp ? cOwn.get("Id").toValue() : null, applicationId);
                }
                catch (RootException e) {
                    throw e;
                }
                finally {
                    SharkUtilities.releaseMappingTransaction(t);
                }
            }
            SessionHandle shandle = null;
            String tacn = tad != null ? tad.getToolAgentClassName() : ToolAgentManagerImpl.this.defaultToolAgentClassName;
            String uname = tad != null ? tad.getUsername() : "";
            String pwd = tad != null ? tad.getPassword() : "";
            String appN = tad != null ? tad.getApplicationName() : "";
            Integer appM = tad != null ? tad.getApplicationMode() : null;
            ToolAgent ta = SharkEngineManager.getInstance().getToolAgentFactory().createToolAgent(this.transaction, tacn);
            try {
                shandle = ta.connect(this.transaction, uname, pwd, ToolAgentManagerImpl.this.cus.getProperty("enginename", "imaobihostrezube"), "", tool);
            }
            catch (ConnectFailed cf) {
                ToolAgentManagerImpl.this.cus.error("Activity" + this.activity.toString() + " - connection to Tool agent " + tacn + " failed !");
                throw cf;
            }
            String procId = this.activity.container(this.transaction).key(this.transaction);
            String actKey = this.activity.key(this.transaction);
            String assId = this.getAssignmentId(procId, actKey);
            AppParameter[] aprs = parameters.toArray(new AppParameter[parameters.size()]);
            ta.invokeApplication(this.transaction, shandle.getHandle(), appN, procId, assId, aprs, appM);
            long appStatus = ta.requestAppStatus(this.transaction, shandle.getHandle(), procId, assId, aprs);
            if (appStatus == -1L) {
                ta.disconnect(this.transaction, shandle);
                throw new Exception("Tool agent status is invalid!");
            }
            Object resolvedInputParameters = ta.resolveInputParameters();
            ta.disconnect(this.transaction, shandle);
            AppParameter[] returnValues = aprs;
            HashMap<String, Object> newData = new HashMap<String, Object>();
            for (int i = 0; i < returnValues.length; ++i) {
                if (!returnValues[i].the_mode.equals("OUT") && !returnValues[i].the_mode.equals("INOUT")) continue;
                String name = returnValues[i].the_actual_name;
                Object value = returnValues[i].the_value;
                newData.put(name, value);
            }
            this.activity.set_result(this.transaction, newData);
            return Optional.ofNullable(resolvedInputParameters);
        }
    }
}

