/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.io.Serializable;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidRequester;
import org.enhydra.shark.api.client.wfmodel.NotEnabled;
import org.enhydra.shark.api.client.wfmodel.RequesterRequired;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;

public class SharkConnectionImpl
implements SharkConnection,
Serializable {
    private String userId;
    private boolean connected = false;
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();

    protected SharkConnectionImpl() {
    }

    public SharkConnectionImpl(SharkTransaction t, UserTransaction ut, String userId) {
        this();
        try {
            this.connect(t, ut, userId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(SharkTransaction t, UserTransaction ut, String userId) throws BaseException, ConnectFailed {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_sharkconnection_connect(t, userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            if (!uga.doesUserExist(ut, userId)) {
                this.cus.info("SharkConnectionImpl -> Login failed: Invalid username " + userId);
                throw new ConnectFailed("Connection failed, invalid username");
            }
            if (SharkUtilities.getResource(t, userId) == null) {
                WfResourceInternal wfResourceInternal = SharkEngineManager.getInstance().getObjectFactory().createResource(t, userId);
            }
            this.connected = true;
            this.userId = userId;
            this.cus.info("SharkConnectionImpl -> User " + userId + " is logged on");
        }
        catch (Exception ex) {
            if (ex instanceof ConnectFailed) {
                throw (ConnectFailed)ex;
            }
            this.cus.info("SharkConnectionImpl -> Unexpected error while user " + userId + " loggs on");
            ex.printStackTrace();
            throw new BaseException((Throwable)ex);
        }
    }

    public void connect(String userId, String password, String engineName, String scope) throws BaseException, ConnectFailed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.connect((SharkTransaction)t, userId, password, engineName, scope);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof ConnectFailed) {
                throw (ConnectFailed)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void connect(SharkTransaction t, String userId, String password, String engineName, String scope) throws BaseException, ConnectFailed {
        UserTransaction ut = null;
        try {
            ut = SharkUtilities.createUserTransaction();
            this.connect(t, ut, userId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(ut);
        }
    }

    public void disconnect() throws BaseException, NotConnected {
    }

    public void disconnect(SharkTransaction t) throws BaseException, NotConnected {
    }

    public WfResource getResourceObject() throws BaseException, NotConnected {
        WfResource ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getResourceObject((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource getResourceObject(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_sharkconnection_getResourceObject(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            WfResource ret = SharkEngineManager.getInstance().getObjectFactory().createResourceWrapper(this.userId, this.userId);
            return ret;
        }
        catch (Exception ex) {
            this.cus.info("SharkConnectionImpl -> Unexpected error while user " + this.userId + " tries to get its resource object");
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcess createProcess(String pkgId, String pDefId) throws BaseException, NotConnected, NotEnabled {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.createProcess((SharkTransaction)t, pkgId, pDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof NotEnabled) {
                throw (NotEnabled)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess createProcess(SharkTransaction t, String pkgId, String pDefId) throws BaseException, NotConnected, NotEnabled {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, true);
        WfRequesterInternal req = SharkEngineManager.getInstance().getObjectFactory().createDefaultRequester(this.userId, null);
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, SharkUtilities.createProcessMgrKey(pkgId, curVer, pDefId));
        if (mgr == null) {
            throw new BaseException("Can't create process for given definition - can't find manager");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_sharkconnection_createProcess(t, mgr.name(t), this.userId, pkgId, curVer, pDefId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            WfProcessInternal procInternal = mgr.create_process(t, req);
            WfProcess proc = SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userId, procInternal.manager_name(t), procInternal.key(t));
            return proc;
        }
        catch (InvalidRequester ir) {
            throw new BaseException((Throwable)ir);
        }
        catch (RequesterRequired rr) {
            throw new BaseException((Throwable)rr);
        }
    }

    public WfProcess createProcess(WfRequester r, String pkgId, String pDefId) throws BaseException, NotConnected, NotEnabled, InvalidRequester, RequesterRequired {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.createProcess((SharkTransaction)t, r, pkgId, pDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof NotEnabled) {
                throw (NotEnabled)e;
            }
            if (e instanceof InvalidRequester) {
                throw (InvalidRequester)((Object)e);
            }
            if (e instanceof RequesterRequired) {
                throw (RequesterRequired)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess createProcess(SharkTransaction t, WfRequester r, String pkgId, String pDefId) throws BaseException, NotConnected, NotEnabled, InvalidRequester, RequesterRequired {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        if (r == null) {
            throw new BaseException("Trying to create process with external requester which is null!");
        }
        String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, true);
        WfRequesterInternal req = SharkEngineManager.getInstance().getObjectFactory().createDefaultRequester(this.userId, r);
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, SharkUtilities.createProcessMgrKey(pkgId, curVer, pDefId));
        if (mgr == null) {
            throw new BaseException("Can't create process for given definition - can't find manager");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_sharkconnection_createProcess(t, mgr.name(t), this.userId, pkgId, curVer, pDefId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfProcessInternal procInternal = mgr.create_process(t, req);
        WfProcess proc = SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userId, procInternal.manager_name(t), procInternal.key(t));
        return proc;
    }

    public void finalize() throws Throwable {
    }
}

