/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfbase.BaseIterator;
import org.enhydra.shark.api.client.wfbase.GrammarNotSupported;
import org.enhydra.shark.api.client.wfbase.InvalidQuery;
import org.enhydra.shark.api.client.wfbase.NameMismatch;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public abstract class BaseIteratorWrapper
implements BaseIterator {
    protected String userAuth;
    protected List objectList;
    protected ListIterator objectListIterator;
    protected String queryExpression = "";
    protected Map namesInExpression;
    protected String queryGrammar = "text/java";
    protected boolean eval;
    protected String sqlWhere;
    protected String usedContext;
    protected boolean ignoreUsedContext;

    protected BaseIteratorWrapper(String userAuth) throws BaseException {
        this.userAuth = userAuth;
    }

    public String query_expression() throws BaseException {
        return this.queryExpression;
    }

    public String query_expression(SharkTransaction t) throws BaseException {
        return this.queryExpression;
    }

    public void set_query_expression(String query) throws BaseException, InvalidQuery {
        this.set_query_expression(null, query);
    }

    public void set_query_expression(SharkTransaction t, String query) throws BaseException, InvalidQuery {
        this.queryExpression = query;
        if (this.queryExpression == null) {
            this.queryExpression = "";
        }
        this.clearObjectList();
        this.eval = this.queryExpression.trim().length() > 0;
        this.sqlWhere = null;
        this.usedContext = "";
        this.ignoreUsedContext = true;
        if (this.eval) {
            int usedBeginIndex;
            int sqlBeginIndex = this.queryExpression.indexOf("/*sql ") + 6;
            int sqlEndIndex = this.queryExpression.indexOf(" sql*/");
            if (5 < sqlBeginIndex) {
                this.sqlWhere = this.queryExpression.substring(sqlBeginIndex, sqlEndIndex);
                if (0 > this.queryExpression.indexOf("/*FORCE*/")) {
                    this.eval = false;
                }
            }
            if ((usedBeginIndex = this.queryExpression.indexOf("/*used ")) == -1) {
                return;
            }
            int usedEndIndex = this.queryExpression.indexOf(" used*/");
            if (6 < (usedBeginIndex += 7)) {
                this.usedContext = this.queryExpression.substring(usedBeginIndex, usedEndIndex);
                this.ignoreUsedContext = false;
            }
        }
    }

    public Map names_in_expression() throws BaseException {
        return this.namesInExpression;
    }

    public Map names_in_expression(SharkTransaction t) throws BaseException {
        return this.namesInExpression;
    }

    public void set_names_in_expression(Map query) throws BaseException, NameMismatch {
        this.namesInExpression = query;
    }

    public void set_names_in_expression(SharkTransaction t, Map query) throws BaseException, NameMismatch {
        this.namesInExpression = query;
    }

    public String query_grammar() throws BaseException {
        return this.queryGrammar;
    }

    public String query_grammar(SharkTransaction t) throws BaseException {
        return this.queryGrammar;
    }

    public void set_query_grammar(String query_grammar) throws BaseException, GrammarNotSupported {
        if (query_grammar == null || !query_grammar.equals("text/java") && !query_grammar.equals("text/javascript") && !query_grammar.equals("text/pythonscript")) {
            String errMsg = "Unsupported grammar " + query_grammar + ". Supported grammars are:" + "text/java" + ", " + "text/javascript" + " and " + "text/pythonscript" + ".";
            throw new GrammarNotSupported(errMsg);
        }
        this.queryGrammar = query_grammar;
        this.clearObjectList();
    }

    public void set_query_grammar(SharkTransaction t, String query_grammar) throws BaseException, GrammarNotSupported {
        if (query_grammar == null || !query_grammar.equals("text/java") && !query_grammar.equals("text/javascript") && !query_grammar.equals("text/pythonscript")) {
            String errMsg = "Unsupported grammar " + query_grammar + ". Supported grammars are:" + "text/java" + ", " + "text/javascript" + " and " + "text/pythonscript" + ".";
            throw new GrammarNotSupported(errMsg);
        }
        this.queryGrammar = query_grammar;
        this.clearObjectList();
    }

    public int how_many() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many(SharkTransaction t) throws BaseException {
        this.fillObjectList(t);
        return this.objectList.size();
    }

    public void goto_start() throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.goto_start((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void goto_start(SharkTransaction t) throws BaseException {
        this.fillObjectList(t);
        while (this.objectListIterator.hasPrevious()) {
            this.objectListIterator.previous();
        }
    }

    public void goto_end() throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.goto_end((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void goto_end(SharkTransaction t) throws BaseException {
        this.fillObjectList(t);
        while (this.objectListIterator.hasNext()) {
            this.objectListIterator.next();
        }
    }

    protected void setObjectList(List lst) {
        this.objectList = lst;
        this.objectListIterator = this.objectList.listIterator();
    }

    protected void clearObjectList() {
        this.objectList = null;
        this.objectListIterator = null;
    }

    protected abstract void fillObjectList(SharkTransaction var1) throws BaseException;

    protected Object getNextObject(SharkTransaction t) throws BaseException {
        this.fillObjectList(t);
        Object ret = null;
        if (this.objectListIterator.hasNext()) {
            ret = this.objectListIterator.next();
        }
        if (ret == null) {
            throw new BaseException("There is no next object!");
        }
        return ret;
    }

    protected Object getPreviousObject(SharkTransaction t) throws BaseException {
        this.fillObjectList(t);
        Object ret = null;
        if (this.objectListIterator.hasPrevious()) {
            ret = this.objectListIterator.previous();
        }
        if (ret == null) {
            throw new BaseException("No previous object!");
        }
        return ret;
    }

    protected List getNextNSequence(SharkTransaction t, int max_number) throws BaseException {
        this.fillObjectList(t);
        ArrayList ret = new ArrayList();
        if (max_number <= 0) {
            max_number = Integer.MAX_VALUE;
        }
        for (int i = 0; this.objectListIterator.hasNext() && i < max_number; ++i) {
            Object next = this.objectListIterator.next();
            ret.add(next);
        }
        return ret;
    }

    protected List getPreviousNSequence(SharkTransaction t, int max_number) throws BaseException {
        this.fillObjectList(t);
        ArrayList ret = new ArrayList();
        if (max_number <= 0) {
            max_number = Integer.MAX_VALUE;
        }
        for (int i = 0; this.objectListIterator.hasPrevious() && i < max_number; ++i) {
            Object prev = this.objectListIterator.previous();
            ret.add(prev);
        }
        return ret;
    }
}

