/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.xpdl.XpdlCacheSynchronizer;
import org.enhydra.shark.xpdl.Version;
import org.enhydra.shark.xpdl.XMLInterface;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;

public class StandardXpdlCacheSynchronizer
implements XpdlCacheSynchronizer {
    private Map currentPkgVersions = new HashMap();

    public boolean synchronizeXPDLCache(RepositoryTransaction t) throws BaseException {
        boolean hasChanges = false;
        SharkEngineManager.getInstance().getCallbackUtilities().info("SharkUtilities -> synchronizing XPDL cache");
        HashMap<String, String> newCurrentVersions = new HashMap<String, String>();
        XMLInterface xmlInterface = SharkEngineManager.getInstance().getXMLInterface();
        XMLInterfaceForJDK13 xpdlHandler = new XMLInterfaceForJDK13();
        xpdlHandler.setValidation(false);
        xpdlHandler.synchronizePackages(xmlInterface);
        RepositoryPersistenceManager repMgr = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        try {
            long version = Version.getVersion();
            HashSet enginePkgIds = new HashSet(xpdlHandler.getAllPackageIds());
            HashSet<String> enginePkgIdsWithVersionAndClassVersion = new HashSet<String>();
            for (String epid : enginePkgIds) {
                Collection c = xpdlHandler.getAllPackageVersions(epid);
                Iterator prepc = c.iterator();
                while (prepc.hasNext()) {
                    String epidWithVersion = SharkUtilities.createPkgIdWithVersionAndClassVersion(epid, (String)prepc.next(), version);
                    enginePkgIdsWithVersionAndClassVersion.add(epidWithVersion);
                }
            }
            HashSet<String> reposPkgIdsWithVersionAndClassVersion = new HashSet<String>();
            HashSet allPkgIds = new HashSet(repMgr.getExistingXPDLIds(t));
            for (String pkgId : allPkgIds) {
                HashSet pkgVers = new HashSet(repMgr.getXPDLVersions(t, pkgId));
                HashSet<String> pkgVersAndClassVers = new HashSet<String>();
                for (String pkgVer : pkgVers) {
                    pkgVersAndClassVers.add(SharkUtilities.createPkgVersionAndClassVersion(pkgVer, repMgr.getSerializedXPDLObjectVersion(t, pkgId, pkgVer)));
                }
                newCurrentVersions.put(pkgId, repMgr.getCurrentVersion(t, pkgId));
                for (String pkgVerAndClassVer : pkgVersAndClassVers) {
                    String pkgIdWithVersionAndClassVersion = SharkUtilities.createPkgIdWithVersionAndClassVersion(pkgId, pkgVerAndClassVer);
                    reposPkgIdsWithVersionAndClassVersion.add(pkgIdWithVersionAndClassVersion);
                }
            }
            HashSet pkgsToLoad = new HashSet(reposPkgIdsWithVersionAndClassVersion);
            pkgsToLoad.removeAll(enginePkgIdsWithVersionAndClassVersion);
            HashSet pkgsToUnload = new HashSet(enginePkgIdsWithVersionAndClassVersion);
            pkgsToUnload.removeAll(reposPkgIdsWithVersionAndClassVersion);
            for (String pkgIdWithVersionAndClassVersion : pkgsToUnload) {
                xpdlHandler.closePackageVersion(SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion), SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion));
            }
            for (String pkgIdWithVersionAndClassVersion : pkgsToLoad) {
                String pkgVer;
                String pkgId = SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion);
                if (SharkUtilities.restorePackage(t, (XMLInterface)xpdlHandler, pkgId, pkgVer = SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion)) != null) continue;
                throw new BaseException("Problems while restoring packages!");
            }
            if (pkgsToLoad.size() > 0 || pkgsToUnload.size() > 0) {
                hasChanges = true;
            }
            xmlInterface.synchronizePackages((XMLInterface)xpdlHandler);
            this.currentPkgVersions = newCurrentVersions;
            xpdlHandler.closeAllPackages();
            xpdlHandler = null;
            return hasChanges;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String getCurrentPkgVersion(String pkgId, boolean fromCache) throws BaseException {
        String curVer = null;
        if (fromCache) {
            curVer = (String)this.currentPkgVersions.get(pkgId);
        }
        if (curVer != null) {
            return curVer;
        }
        RepositoryTransaction rt = null;
        try {
            rt = SharkUtilities.createRepositoryTransaction();
            curVer = SharkEngineManager.getInstance().getRepositoryPersistenceManager().getCurrentVersion(rt, pkgId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(rt);
        }
        return curVer;
    }
}

