/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfAssignmentIterator;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfAssignmentIteratorWrapper
extends BaseIteratorWrapper
implements WfAssignmentIterator {
    private String procId;
    private String actId;
    private String username;

    protected WfAssignmentIteratorWrapper(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        super(userAuth);
        this.procId = procId;
        this.actId = actId;
    }

    protected WfAssignmentIteratorWrapper(SharkTransaction t, String userAuth, String username) throws BaseException {
        super(userAuth);
        this.username = username;
    }

    public WfAssignment get_next_object() throws BaseException {
        WfAssignment ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment get_next_object(SharkTransaction t) throws BaseException {
        return (WfAssignment)super.getNextObject(t);
    }

    public WfAssignment get_previous_object() throws BaseException {
        WfAssignment ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment get_previous_object(SharkTransaction t) throws BaseException {
        return (WfAssignment)super.getPreviousObject(t);
    }

    public WfAssignment[] get_next_n_sequence(int max_number) throws BaseException {
        WfAssignment[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfAssignment[] ret = new WfAssignment[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfAssignment[] get_previous_n_sequence(int max_number) throws BaseException {
        WfAssignment[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfAssignment[] ret = new WfAssignment[l.size()];
        l.toArray(ret);
        return ret;
    }

    @Override
    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<WfAssignment> assignments = new ArrayList<WfAssignment>();
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ActivityPersistenceInterface apo = null;
            ProcessPersistenceInterface ppo = null;
            List l = new ArrayList();
            boolean createNewPOs = true;
            if (this.sqlWhere != null) {
                l = ipm.getAssignmentsWhere(t, this.sqlWhere);
            } else if (this.username != null) {
                l.addAll(ipm.getAllValidAssignmentsForResource(this.username, t));
            } else if (this.procId != null && this.actId != null) {
                l.addAll(ipm.getAllValidAssignmentsForActivity(this.actId, t));
                ppo = ipm.restoreProcess(this.procId, t);
                apo = ipm.restoreActivity(this.actId, t);
                createNewPOs = false;
            }
            Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
            for (int i = 0; i < l.size(); ++i) {
                AssignmentPersistenceInterface po = (AssignmentPersistenceInterface)l.get(i);
                boolean toAdd = true;
                if (this.eval) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("processId", po.getProcessId());
                    context.put("resourceUsername", po.getResourceUsername());
                    if (createNewPOs) {
                        ppo = ipm.restoreProcess(po.getProcessId(), t);
                        apo = ipm.restoreActivity(po.getActivityId(), t);
                    }
                    String mgrName = ppo.getProcessMgrName();
                    String pkgId = SharkUtilities.getProcessMgrPkgId(mgrName);
                    String pDefId = SharkUtilities.getProcessMgrProcDefId(mgrName);
                    String ver = SharkUtilities.getProcessMgrVersion(mgrName);
                    context.put("accepted", new Boolean(apo.getResourceUsername() != null));
                    context.put("packageId", pkgId);
                    context.put("packageVersion", ver);
                    context.put("processDefinitionId", pDefId);
                    context.put("activitySetDefinitionId", apo.getActivitySetDefinitionId());
                    context.put("activityDefinitionId", apo.getActivityDefinitionId());
                    context.put("activityId", po.getActivityId());
                    toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                }
                if (!toAdd) continue;
                assignments.add(SharkEngineManager.getInstance().getObjectFactory().createAssignmentWrapper(this.userAuth, po.getProcessMgrName(), po.getProcessId(), po.getActivityId(), po.getResourceUsername()));
            }
            this.setObjectList(assignments);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

