/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.ApplicationMappingTransaction;
import org.enhydra.shark.api.ParticipantMappingTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootError;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.ScriptMappingTransaction;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.AdminInterface;
import org.enhydra.shark.api.client.wfservice.ExpressionBuilderManager;
import org.enhydra.shark.api.client.wfservice.RepositoryMgr;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.SharkInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ResourcePersistenceInterface;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;
import org.enhydra.shark.utilities.MiscUtilities;

public final class Shark
implements SharkInterface {
    private static final String initCachesBoundary = ",";
    private static final String initAllCachesString = "*";
    private static final String defaultLogChannel = "Shark";
    private static boolean isConfigured = false;
    private static Shark shark = new Shark();
    private Properties properties;
    private ExpressionBuilderManager expressionBuilderManager;

    public static void configure(Properties props) {
        if (isConfigured) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Trying to configure shark instance that is already configured !!!");
            return;
        }
        if (props == null) {
            throw new RootError("Shark need to be configured properly - given Poperties have null value!!!");
        }
        Shark.configureFromJar();
        Shark.adjustSharkProperties(props);
        isConfigured = true;
        shark.init();
    }

    public static void configure(String filePath) {
        if (isConfigured) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Trying to configure shark instance that is already configured !!!");
            return;
        }
        if (filePath == null) {
            throw new RootError("Shark need to be configured properly - given path to configuration file is null!!!");
        }
        File config = new File(filePath);
        Shark.configure(config);
    }

    public static void configure(File configFile) {
        if (isConfigured) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Trying to configure shark instance that is already configured !!!");
            return;
        }
        if (configFile == null) {
            throw new RootError("Shark need to be configured properly - given configuration file is null!!!");
        }
        if (!configFile.isAbsolute()) {
            configFile = configFile.getAbsoluteFile();
        }
        if (configFile.exists()) {
            Shark.configureFromJar();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(configFile);
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                Shark.adjustSharkProperties(props);
            }
            catch (Exception ex) {
                throw new RootError("Something went wrong while reading of configuration from the file!!!", (Throwable)ex);
            }
            try {
                Shark.shark.properties.put("RootDirectoryPath", configFile.getParentFile().getCanonicalPath());
            }
            catch (Exception ex) {
                Shark.shark.properties.put("RootDirectoryPath", configFile.getParentFile().getAbsolutePath());
            }
        } else {
            throw new RootError("Shark need to be configured properly - configuration file " + configFile + " does not exist!!!");
        }
        isConfigured = true;
        shark.init();
    }

    public static void configure() {
        if (isConfigured) {
            SharkEngineManager.getInstance().getCallbackUtilities().info("Trying to configure shark instance that is already configured !!!");
            return;
        }
        Shark.configureFromJar();
        isConfigured = true;
        shark.init();
    }

    public static Shark getInstance() {
        if (!isConfigured) {
            throw new RootError("Can't use Shark - it is not configured !!!");
        }
        return shark;
    }

    private Shark() {
    }

    public AdminInterface getAdminInterface() {
        return SharkEngineManager.getInstance().getObjectFactory().createAdminInterface();
    }

    public RepositoryMgr getRepositoryManager() {
        return SharkEngineManager.getInstance().getObjectFactory().createRepositoryManager();
    }

    public SharkConnection getSharkConnection() {
        return SharkEngineManager.getInstance().getObjectFactory().createSharkConnection();
    }

    public ExpressionBuilderManager getExpressionBuilderManager() {
        block4: {
            if (this.expressionBuilderManager == null) {
                String ebmClassName = this.properties.getProperty("ExpressionBuilderManagerClassName", "org.enhydra.shark.ExpressionBuilderMgr");
                ClassLoader cl = this.getClass().getClassLoader();
                try {
                    this.expressionBuilderManager = (ExpressionBuilderManager)cl.loadClass(ebmClassName).newInstance();
                    SharkEngineManager.getInstance().getCallbackUtilities().info("Shark -> Working with '" + ebmClassName + "' implementation of ExpressionBuilderManager API");
                }
                catch (Throwable ex) {
                    if (ebmClassName == null || ebmClassName.trim().equals("")) {
                        SharkEngineManager.getInstance().getCallbackUtilities().info("Shark -> Working without ExpressionBuilderManager implementation.");
                    }
                    if (this.expressionBuilderManager != null) break block4;
                    SharkEngineManager.getInstance().getCallbackUtilities().info("Shark -> Can't find ExpressionBuilderManager class '" + ebmClassName + "' in classpath!");
                }
            }
        }
        return this.expressionBuilderManager;
    }

    public SharkTransaction createTransaction() throws TransactionException {
        try {
            return SharkUtilities.createTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create SharkTransaction", (Throwable)ex);
        }
    }

    public ParticipantMappingTransaction createParticipantMappingTransaction() throws TransactionException {
        try {
            return SharkEngineManager.getInstance().getParticipantMapPersistenceManager().getParticipantMappingTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create ParticipantMappingTransaction", (Throwable)ex);
        }
    }

    public ApplicationMappingTransaction createApplicationMappingTransaction() throws TransactionException {
        try {
            return SharkEngineManager.getInstance().getApplicationMapPersistenceManager().getApplicationMappingTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create ApplicationMappingTransaction", (Throwable)ex);
        }
    }

    public ScriptMappingTransaction createScriptMappingTransaction() throws TransactionException {
        try {
            return SharkEngineManager.getInstance().getScriptMapPersistenceManager().getScriptMappingTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create ScriptMappingTransaction", (Throwable)ex);
        }
    }

    public UserTransaction createUserTransaction() throws TransactionException {
        try {
            return SharkEngineManager.getInstance().getUserTransactionFactory().createTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create UserTransaction", (Throwable)ex);
        }
    }

    public RepositoryTransaction createRepositoryTransaction() throws TransactionException {
        try {
            return SharkEngineManager.getInstance().getRepositoryPersistenceManager().createTransaction();
        }
        catch (Exception ex) {
            throw new TransactionException("Can't create UserTransaction", (Throwable)ex);
        }
    }

    public void unlockProcesses(SharkTransaction t) throws TransactionException {
        SharkUtilities.unlock(t);
    }

    public void emptyCaches(SharkTransaction t) {
        SharkUtilities.emptyCaches(t);
    }

    public Properties getProperties() {
        Properties copy = new Properties();
        for (Map.Entry<Object, Object> me : this.properties.entrySet()) {
            copy.setProperty((String)me.getKey(), (String)me.getValue());
        }
        return copy;
    }

    public boolean validateUser(String username, String pwd) {
        try {
            return SharkUtilities.validateUser(username, pwd);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void configureFromJar() {
        String rootDirectoryPath = System.getProperty("user.dir");
        try {
            URL u = Shark.class.getClassLoader().getResource("Shark.conf.forJar");
            URLConnection urlConnection = u.openConnection();
            InputStream is = urlConnection.getInputStream();
            Shark.shark.properties = new Properties();
            Shark.shark.properties.load(is);
            Shark.shark.properties.put("RootDirectoryPath", rootDirectoryPath);
        }
        catch (Exception ex) {
            throw new RootError("Shark need to be configured properly - Can't read Shark's default configuration from JAR!!!", (Throwable)ex);
        }
    }

    private static void adjustSharkProperties(Properties external) {
        for (Map.Entry<Object, Object> me : external.entrySet()) {
            String key = (String)me.getKey();
            String val = (String)me.getValue();
            Shark.shark.properties.setProperty(key, val);
        }
    }

    private void init() {
        long tStart = System.currentTimeMillis();
        System.out.println("SharkEngineManager -> Shark engine is being initialized ...");
        SharkEngineManager.getInstance().init(this.properties);
        shark.initCaches();
        shark.reevaluateAssignments();
        shark.initLimitManager();
        long tEnd = System.currentTimeMillis();
        System.out.println("Shark -> shark engine initialization is finished, it lasted " + MiscUtilities.getTimeDiff((long)tStart, (long)tEnd));
        System.out.println("Shark -> " + this.properties.getProperty("enginename", defaultLogChannel) + " ready and waiting ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCaches() {
        String initPCS = this.properties.getProperty("Cache.InitProcessCacheString", "");
        String initRCS = this.properties.getProperty("Cache.InitResourceCacheString", "");
        SharkInternalTransaction t = null;
        try {
            List l;
            t = SharkUtilities.createTransaction();
            if (!initPCS.trim().equals("")) {
                SharkEngineManager.getInstance().getCallbackUtilities().info("Initializing Process cache using string " + initPCS);
                if (initPCS.trim().equalsIgnoreCase(initAllCachesString)) {
                    l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcesses((SharkTransaction)t);
                    for (ProcessPersistenceInterface po : l) {
                        SharkEngineManager.getInstance().getObjectFactory().createProcess(po);
                    }
                } else {
                    String[] procIds = MiscUtilities.tokenize((String)initPCS.trim(), (String)initCachesBoundary);
                    if (procIds != null) {
                        for (int i = 0; i < procIds.length; ++i) {
                            WfProcessInternal proc = SharkUtilities.getProcess((SharkTransaction)t, procIds[i]);
                            if (proc != null) continue;
                            SharkEngineManager.getInstance().getCallbackUtilities().info("Process cache initialization - process with Id=" + procIds[i] + " does not exist");
                        }
                    }
                }
            }
            if (!initRCS.trim().equals("")) {
                SharkEngineManager.getInstance().getCallbackUtilities().info("Initializing Resource cache using string " + initRCS);
                if (initRCS.equalsIgnoreCase(initAllCachesString)) {
                    l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllResources((SharkTransaction)t);
                    for (ProcessPersistenceInterface po : l) {
                        SharkEngineManager.getInstance().getObjectFactory().createResource((ResourcePersistenceInterface)po);
                    }
                } else {
                    String[] resIds = MiscUtilities.tokenize((String)initRCS.trim(), (String)initCachesBoundary);
                    if (resIds != null) {
                        for (int i = 0; i < resIds.length; ++i) {
                            WfResourceInternal res = SharkUtilities.getResource((SharkTransaction)t, resIds[i]);
                            if (res != null) continue;
                            SharkEngineManager.getInstance().getCallbackUtilities().info("Resource cache initialization - resource with username=" + resIds[i] + " does not exist");
                        }
                    }
                }
            }
            SharkUtilities.restorePackages();
        }
        catch (Throwable e) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Problem while initializing caches !!!");
            e.printStackTrace();
        }
        finally {
            try {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            catch (BaseException resIds) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reevaluateAssignments() {
        boolean reeval = new Boolean(this.properties.getProperty("Assignments.InitialReevaluation", "false"));
        if (!reeval) {
            return;
        }
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            SharkUtilities.reevaluateAssignments((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (Throwable e) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Problem while reevaluating assignments !!!");
            try {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, new RootException(e));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            catch (BaseException baseException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLimitManager() {
        SharkInternalTransaction t = null;
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
        if (null != lam) {
            try {
                t = SharkUtilities.createTransaction();
                for (ProcessPersistenceInterface po : pmi.getAllProcesses((SharkTransaction)t)) {
                    if (po.getState().startsWith("closed")) continue;
                    WfProcessInternal theProcess = SharkUtilities.getProcess((SharkTransaction)t, po.getId());
                    theProcess.activateLimitAgent((SharkTransaction)t);
                    Iterator activeActivities = theProcess.getActiveActivities((SharkTransaction)t).iterator();
                    while (activeActivities.hasNext()) {
                        ((WfActivityInternal)activeActivities.next()).activateLimitAgent((SharkTransaction)t);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                SharkEngineManager.getInstance().getCallbackUtilities().error("Limit agent manager initialization didn't work");
            }
            finally {
                try {
                    SharkUtilities.releaseTransaction((SharkTransaction)t);
                }
                catch (BaseException processes) {}
            }
        }
    }
}

