/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.LimitAdministration;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class LimitAdmin
implements LimitAdministration {
    private String userId = "Unknown";

    protected LimitAdmin() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public void checkLimits() throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.checkLimits((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkLimits(SharkTransaction t) throws BaseException {
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        if (lam == null) {
            throw new BaseException("Shark is working without implementation of Limit API!");
        }
        try {
            lam.checkLimits(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void checkLimits(String[] procIds) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.checkLimits((SharkTransaction)t, procIds);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkLimits(SharkTransaction t, String[] procIds) throws BaseException {
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        if (lam == null) {
            throw new BaseException("Shark is working without implementation of Limit API!");
        }
        if (procIds == null) {
            throw new BaseException("Invalid null value for parameter procIds");
        }
        try {
            for (int i = 0; i < procIds.length; ++i) {
                lam.checkLimits(t, procIds[i]);
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void checkLimits(String procId) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.checkLimits((SharkTransaction)t, procId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkLimits(SharkTransaction t, String procId) throws BaseException {
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        if (lam == null) {
            throw new BaseException("Shark is working without implementation of Limit API!");
        }
        if (procId == null) {
            throw new BaseException("Invalid null value for parameter procId");
        }
        try {
            lam.checkLimits(t, procId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void checkProcessLimit(String procId) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.checkProcessLimit((SharkTransaction)t, procId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkProcessLimit(SharkTransaction t, String procId) throws BaseException {
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        if (lam == null) {
            throw new BaseException("Shark is working without implementation of Limit API!");
        }
        if (procId == null) {
            throw new BaseException("Invalid null value for parameter procId");
        }
        try {
            lam.checkProcessLimit(t, procId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void checkActivityLimit(String procId, String actId) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.checkActivityLimit((SharkTransaction)t, procId, actId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void checkActivityLimit(SharkTransaction t, String procId, String actId) throws BaseException {
        LimitAgentManager lam = SharkEngineManager.getInstance().getLimitAgentManager();
        if (lam == null) {
            throw new BaseException("Shark is working without implementation of Limit API!");
        }
        if (procId == null) {
            throw new BaseException("Invalid null value for parameter procId");
        }
        if (actId == null) {
            throw new BaseException("Invalid null value for parameter actId");
        }
        try {
            lam.checkActivityLimit(t, procId, actId);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

