package org.enhydra.shark.xpdl;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.xpdl.XpdlCacheSynchronizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StandardXpdlCacheSynchronizer
    implements XpdlCacheSynchronizer
{

    private Map currentPkgVersions=new HashMap();

    @Override
    public boolean synchronizeXPDLCache (RepositoryTransaction t) throws BaseException
    {
        boolean hasChanges=false;
        SharkEngineManager.getInstance().getCallbackUtilities().info( "SharkUtilities -> synchronizing XPDL cache");
        //long st=System.currentTimeMillis();
        Map newCurrentVersions=new HashMap();

        XMLInterface xmlInterface=SharkEngineManager.getInstance().getXMLInterface();
        XMLInterface xpdlHandler=new XMLInterfaceForJDK13();
        xpdlHandler.setValidation(false);
        // synchronizing XPDL handler, so all operations will be performed
        // on the copy of XPDL cache, and after synchronizing is finished, the changes are
        // applied to original.
        xpdlHandler.synchronizePackages(xmlInterface);
        RepositoryPersistenceManager repMgr=SharkEngineManager
            .getInstance()
            .getRepositoryPersistenceManager();
        try {
            // get info about engine XPDL caches
            long version=Version.getVersion();
            Set enginePkgIds=new HashSet( xpdlHandler.getAllPackageIds());
            Set enginePkgIdsWithVersionAndClassVersion=new HashSet();
            Iterator prep=enginePkgIds.iterator();
            while (prep.hasNext()) {
                String epid=(String)prep.next();
                Collection c=xpdlHandler.getAllPackageVersions( epid);
                Iterator prepc=c.iterator();
                while (prepc.hasNext()) {
                    String epidWithVersion= SharkUtilities.createPkgIdWithVersionAndClassVersion( epid, (String)prepc.next(), version);
                    enginePkgIdsWithVersionAndClassVersion.add(epidWithVersion);
                }
            }
            // get current state from repository
            //Map reposPkgIdsToVersionsAndClassVersions=new HashMap();
            Set reposPkgIdsWithVersionAndClassVersion=new HashSet();
            Set allPkgIds=new HashSet(repMgr.getExistingXPDLIds(t));
            Iterator it=allPkgIds.iterator();
            while (it.hasNext()) {
                String pkgId=(String)it.next();
                Set pkgVers=new HashSet(repMgr.getXPDLVersions(t,pkgId));
                Set pkgVersAndClassVers=new HashSet();
                Iterator pv=pkgVers.iterator();
                while (pv.hasNext()) {
                    String pkgVer=(String)pv.next();
                    pkgVersAndClassVers.add(SharkUtilities.createPkgVersionAndClassVersion(pkgVer, repMgr.getSerializedXPDLObjectVersion(t, pkgId, pkgVer)));
                }
                newCurrentVersions.put(pkgId,repMgr.getCurrentVersion(t,pkgId));
                //reposPkgIdsToVersionsAndClassVersions.put(pkgId,pkgVersAndClassVers);
                Iterator it2=pkgVersAndClassVers.iterator();
                while (it2.hasNext()) {
                    String pkgVerAndClassVer=(String)it2.next();
                    String pkgIdWithVersionAndClassVersion=SharkUtilities.createPkgIdWithVersionAndClassVersion(pkgId,pkgVerAndClassVer);
                    reposPkgIdsWithVersionAndClassVersion.add(pkgIdWithVersionAndClassVersion);
                }
            }

            //System.out.println("E="+enginePkgIdsWithVersionAndClassVersion);
            //System.out.println("R="+reposPkgIdsWithVersionAndClassVersion);
            // find packages that need to be loaded/reloaded/unloaded

            Set pkgsToLoad=new HashSet(reposPkgIdsWithVersionAndClassVersion);
            pkgsToLoad.removeAll(enginePkgIdsWithVersionAndClassVersion);

            Set pkgsToUnload=new HashSet(enginePkgIdsWithVersionAndClassVersion);
            pkgsToUnload.removeAll(reposPkgIdsWithVersionAndClassVersion);

         /*Set pkgsToReload=new HashSet();
         it=pkgsToLoad.iterator();
         while (it.hasNext()) {
            String pkgToLoad=SharkUtilities.getPkgId((String)it.next());
            //Set refIds=new HashSet(repMgr.getReferringXPDLIds(t,pkgToLoad));
            Set refIds=SharkUtilities.getAllReferences(t,repMgr,pkgToLoad); //new HashSet(repMgr.getReferringXPDLIds(t,pkgToLoad));
            //System.out.println("RefIds for "+pkgToLoad+"="+refIds);
            Iterator it2=refIds.iterator();
            while (it2.hasNext()) {
               String refId=(String)it2.next();
               Set vers=(Set)reposPkgIdsToVersionsAndClassVersions.get(refId);
               Iterator itv=vers.iterator();
               while (itv.hasNext()) {
                  String refVer=(String)itv.next();
                  String pkgIdWithVer=SharkUtilities.createPkgIdWithVersionAndClassVersion(refId,refVer,repMgr.getSerializedXPDLObjectVersion(t, refId, refVer));
                  if (!pkgsToLoad.contains(pkgIdWithVer)) {
                     pkgsToReload.add(pkgIdWithVer);
                  }
               }
            }
         }*/


         /*System.out.println("EPIDWW="+enginePkgIdsWithVersion);
          System.out.println("PTU="+pkgsToUnload);
          System.out.println("PTL="+pkgsToLoad);
          System.out.println("PTRL="+pkgsToReload);*/

            //pkgsToUnload.addAll(pkgsToReload);
            //pkgsToLoad.addAll(pkgsToReload);

            it=pkgsToUnload.iterator();
            while (it.hasNext()) {
                String pkgIdWithVersionAndClassVersion=(String)it.next();
                xpdlHandler.closePackageVersion(SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion), SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion));
            }
            it=pkgsToLoad.iterator();
            while (it.hasNext()) {
                String pkgIdWithVersionAndClassVersion=(String)it.next();
                String pkgId=SharkUtilities.getPkgId(pkgIdWithVersionAndClassVersion);
                String pkgVer=SharkUtilities.getPkgVersion(pkgIdWithVersionAndClassVersion);
                //SharkEngineManager.getInstance().getCallbackUtilities().info("Restoring pkg "+pkgIdWithVersion);
                if (SharkUtilities.restorePackage(t,xpdlHandler,pkgId,pkgVer)==null) {
                    throw new BaseException("Problems while restoring packages!");
                }
            }

            if (pkgsToLoad.size()>0 || pkgsToUnload.size()>0) {
                hasChanges=true;
            }
         /*if (pkgsToReload.size()>0) {
            SharkUtilities.clearProcessCache();
         }*/
            xmlInterface.synchronizePackages(xpdlHandler);
            currentPkgVersions=newCurrentVersions;
            xpdlHandler.closeAllPackages();
            xpdlHandler=null;
         /*System.gc();
          ((XMLInterfaceForJDK13)xmlInterface).printDebug();
          */
            return hasChanges;
        } catch (Exception ex) {
            throw new BaseException(ex);
        }
    }

    @Override
    public String getCurrentPkgVersion( String pkgId, boolean fromCache ) throws BaseException {
        String curVer=null;
        if (fromCache) {
            curVer=(String)currentPkgVersions.get(pkgId);
        }
        if (curVer!=null) {
            return curVer;
        }
        RepositoryTransaction rt=null;
        try {
            rt=SharkUtilities.createRepositoryTransaction();
            curVer=SharkEngineManager
                .getInstance()
                .getRepositoryPersistenceManager()
                .getCurrentVersion(rt,pkgId);
        } catch (Exception ex) {
            throw new BaseException(ex);
        } finally {
            SharkUtilities.releaseRepositoryTransaction(rt);
        }

        return curVer;
    }

}
