/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidRequester;
import org.enhydra.shark.api.client.wfmodel.NotEnabled;
import org.enhydra.shark.api.client.wfmodel.RequesterRequired;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.process_mgr_stateType;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.ProcessMgrPersistenceInterface;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class WfProcessMgrImpl
implements WfProcessMgrInternal {
    private WorkflowProcess wp;
    private String packageId;
    private String processDefinitionId;
    private String name;
    private process_mgr_stateType state = process_mgr_stateType.enabled;
    Map contextSignature;
    Map resultSignature;
    Map inputSignature;
    private String version;
    private long created;
    private boolean justCreated = false;

    protected WfProcessMgrImpl(SharkTransaction t, String pkgId, String version, String pDefId) throws BaseException {
        this.justCreated = true;
        this.name = SharkUtilities.createProcessMgrKey(pkgId, version, pDefId);
        if (this.name == null) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("ERROR - MGR NAME NULL WHILE CRE OF PROCMGR");
            throw new BaseException("Problems while determining process mgr name");
        }
        this.packageId = pkgId;
        this.processDefinitionId = pDefId;
        this.version = version;
        this.created = System.currentTimeMillis();
        try {
            this.persist(t);
        }
        catch (TransactionException tme) {
            throw new BaseException((Throwable)tme);
        }
    }

    protected WfProcessMgrImpl(ProcessMgrPersistenceInterface po) {
        this.restore(po);
    }

    public process_mgr_stateType process_mgr_state(SharkTransaction t) throws BaseException {
        return this.state;
    }

    public void set_process_mgr_state(SharkTransaction t, process_mgr_stateType new_state) throws BaseException, TransitionNotAllowed {
        if (!this.state.equals(new_state)) {
            this.state = new_state;
            try {
                this.persist(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            String msg = "ProcessDefinition " + this.toString() + " - the instantiation from process definition is ";
            msg = this.state.equals(process_mgr_stateType.enabled) ? msg + "enabled" : msg + "disabled";
            SharkEngineManager.getInstance().getCallbackUtilities().info(msg);
        }
    }

    public final String name(SharkTransaction t) throws BaseException {
        return this.name;
    }

    public String description(SharkTransaction t) throws BaseException {
        try {
            String desc = this.getProcessDefinition().getProcessHeader().getDescription();
            return desc;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String category(SharkTransaction t) throws BaseException {
        try {
            String cat = this.getProcessDefinition().getAccessLevel();
            return cat;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public final String version(SharkTransaction t) throws BaseException {
        return this.version;
    }

    public Map context_signature(SharkTransaction t) throws BaseException {
        try {
            if (this.contextSignature == null) {
                this.buildSignatures(t);
            }
            return new HashMap(this.contextSignature);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public Map result_signature(SharkTransaction t) throws BaseException {
        try {
            if (this.resultSignature == null) {
                this.buildSignatures(t);
            }
            return new HashMap(this.resultSignature);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public Map input_signature(SharkTransaction t) throws BaseException {
        try {
            if (this.inputSignature == null) {
                this.buildSignatures(t);
            }
            return new HashMap(this.inputSignature);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessInternal create_process(SharkTransaction t, WfRequesterInternal requester) throws BaseException, NotEnabled, InvalidRequester, RequesterRequired {
        if (this.state.value() == 1) {
            throw new NotEnabled("Can't create process based on WfProcessMgr '" + this + "' - it is disabled!");
        }
        if (requester == null) {
            throw new RequesterRequired("Can't create process based on WfProcessMgr '" + this + "' - the requester is required!");
        }
        String procId = this.getNextProcessKey();
        WfProcessInternal process = SharkEngineManager.getInstance().getObjectFactory().createProcess(t, (WfProcessMgrInternal)this, requester, procId);
        EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
        if (eam != null) {
            eam.processCreated(process, requester, t);
        }
        return process;
    }

    public final String process_definition_id(SharkTransaction t) throws BaseException {
        return this.processDefinitionId;
    }

    public final String package_id(SharkTransaction t) throws BaseException {
        return this.packageId;
    }

    public String process_definition_name(SharkTransaction t) throws BaseException {
        try {
            return this.getProcessDefinition().getName();
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    private void buildSignatures(SharkTransaction t) throws BaseException {
        String javaType;
        this.contextSignature = new HashMap();
        this.resultSignature = new HashMap();
        this.inputSignature = new HashMap();
        FormalParameters fps = this.getProcessDefinition().getFormalParameters();
        for (FormalParameter fp : fps.toElements()) {
            String id = fp.getId();
            String mode = fp.getMode();
            javaType = SharkUtilities.getJavaClass((XMLCollectionElement)fp).getName();
            if (mode.equals("IN") || mode.equals("INOUT")) {
                this.inputSignature.put(id, javaType);
            }
            if (!mode.equals("OUT") && !mode.equals("INOUT")) continue;
            this.resultSignature.put(id, javaType);
        }
        Collection dfsAndFPs = this.getProcessDefinition().getAllVariables().values();
        for (XMLCollectionElement dfOrFp : dfsAndFPs) {
            String id = dfOrFp.getId();
            javaType = SharkUtilities.getJavaClass(dfOrFp).getName();
            this.contextSignature.put(id, javaType);
        }
    }

    protected String getNextProcessKey() {
        String pk = SharkUtilities.getNextId("_process_");
        if (pk == null || this.packageId == null || this.processDefinitionId == null) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("PK=" + pk + ", packageId=" + this.packageId + ", pDefId=" + this.processDefinitionId);
        }
        if ((pk = pk + "_" + this.packageId + "_" + this.processDefinitionId).length() > 100) {
            pk = pk.substring(0, 100);
        }
        return pk;
    }

    private WorkflowProcess getProcessDefinition() throws BaseException {
        if (this.wp == null) {
            this.wp = SharkUtilities.getWorkflowProcess(this.packageId, this.version, this.processDefinitionId);
        }
        return this.wp;
    }

    public String toString() {
        return "[name=" + this.name + ",version=" + this.version + ",pkgId=" + this.packageId + ",pDefId=" + this.processDefinitionId + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfProcessMgrImpl)) {
            return false;
        }
        return ((WfProcessMgrImpl)obj).name.equals(this.name);
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().persist(this.createAndFillPersistentObject(), this.justCreated, t);
            this.justCreated = false;
        }
        catch (PersistenceException pe) {
            throw new TransactionException((Throwable)pe);
        }
    }

    public void delete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteProcessMgr(this.name, t);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting ProcessMgr", (Throwable)ex);
        }
    }

    private ProcessMgrPersistenceInterface createAndFillPersistentObject() {
        ProcessMgrPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createProcessMgr();
        this.fillPersistentObject(po);
        return po;
    }

    private void fillPersistentObject(ProcessMgrPersistenceInterface po) {
        po.setName(this.name);
        po.setPackageId(this.packageId);
        po.setProcessDefinitionId(this.processDefinitionId);
        po.setState(this.state.value());
        po.setVersion(this.version);
        po.setCreated(this.created);
    }

    private void restore(ProcessMgrPersistenceInterface po) {
        this.name = po.getName();
        if (this.name == null) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("ERROR - MGR NAME NULL WHILE REST OF PROCMGR");
        }
        this.packageId = po.getPackageId();
        this.processDefinitionId = po.getProcessDefinitionId();
        this.state = process_mgr_stateType.from_int((int)po.getState());
        this.version = po.getVersion();
        this.created = po.getCreated();
    }
}

