/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.WfEventAuditWrapper;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.SourceNotAvailable;
import org.enhydra.shark.api.client.wfmodel.WfExecutionObject;
import org.enhydra.shark.api.client.wfservice.WfPackageEventAudit;
import org.enhydra.shark.persistence.PackageEventAuditPersistenceInterface;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.xpdl.elements.Package;

public class WfPackageEventAuditImpl
extends WfEventAuditWrapper
implements WfPackageEventAudit,
PackageEventAuditPersistenceInterface {
    private String packageVersion;
    private String resourceUsername;

    protected WfPackageEventAuditImpl(Package pkg, String eventType, String resourceUsername) throws BaseException {
        this.timeStamp = new UtcT(MiscUtilities.getAbsoluteTimeInUTCFormat(), 0, 0, 0);
        this.eventType = eventType;
        this.packageId = pkg.getId();
        this.packageVersion = pkg.getInternalVersion();
        this.resourceUsername = resourceUsername;
        try {
            this.persist(null);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String package_version() {
        return this.packageVersion;
    }

    public String resource_username() {
        return this.resourceUsername;
    }

    @Override
    public WfExecutionObject source() throws BaseException, SourceNotAvailable {
        throw new SourceNotAvailable("The source of WfPackageEventAudit is not available!");
    }

    public WfPackageEventAuditImpl() {
    }

    @Override
    public void setPackageVersion(String pkgVersion) {
        this.packageVersion = pkgVersion;
    }

    @Override
    public String getPackageVersion() {
        return this.packageVersion;
    }

    @Override
    public void setResourceUsername(String resUsername) {
        this.resourceUsername = resUsername;
    }

    @Override
    public String getResourceUsername() {
        return this.resourceUsername;
    }

    public void setUTCTime(String time) {
        try {
            this.timeStamp = new UtcT(Long.parseLong(time), 0, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUTCTime() {
        return String.valueOf(this.timeStamp.time);
    }

    public void setType(String type) {
        this.eventType = type;
    }

    public String getType() {
        return this.eventType;
    }

    public void setActivityId(String aId) {
    }

    public String getActivityId() {
        return null;
    }

    public void setActivityName(String an) {
    }

    public String getActivityName() {
        return null;
    }

    public void setProcessId(String pId) {
    }

    public String getProcessId() {
        return null;
    }

    public void setProcessName(String n) {
    }

    public String getProcessName() {
        return null;
    }

    public void setProcessDefinitionName(String pn) {
    }

    public String getProcessDefinitionName() {
        return null;
    }

    public void setProcessDefinitionVersion(String pdv) {
    }

    public String getProcessDefinitionVersion() {
        return null;
    }

    public void setActivityDefinitionId(String adId) {
    }

    public String getActivityDefinitionId() {
        return null;
    }

    public void setActivitySetDefinitionId(String asdId) {
    }

    public String getActivitySetDefinitionId() {
        return null;
    }

    public void setProcessDefinitionId(String pdId) {
    }

    public String getProcessDefinitionId() {
        return null;
    }

    public void setPackageId(String pkgId) {
        this.packageId = pkgId;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void persist(SharkTransaction t) throws TransactionException {
        String log = "UTCTime=" + this.getUTCTime() + ",EventType=" + this.getType() + ",PackageId=" + this.getPackageId() + ",PackageVersion=" + this.getPackageVersion() + ",EventPerformedBy=" + this.getResourceUsername();
        SharkEngineManager.getInstance().getCallbackUtilities().info("PackageEventLogger", log);
    }

    public void refresh() {
    }

    public void delete(SharkTransaction t) throws TransactionException {
    }
}

