/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.ParticipantMappingTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ParticipantMappingAdministration;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMap;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMappingManager;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Participants;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ParticipantMappingsAdministrationImpl
implements ParticipantMappingAdministration {
    private ParticipantMappingManager pmanager = SharkEngineManager.getInstance().getParticipantMapPersistenceManager();
    private String userId = "Unknown";

    protected ParticipantMappingsAdministrationImpl() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants() throws BaseException {
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] retVal;
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            retVal = this.getAllParticipants(t);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants(ParticipantMappingTransaction t) throws BaseException {
        ArrayList pl = new ArrayList();
        List packageIds = null;
        RepositoryPersistenceManager rpm = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        RepositoryTransaction rt = null;
        try {
            rt = SharkUtilities.createRepositoryTransaction();
            packageIds = rpm.getExistingXPDLIds(rt);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(rt);
        }
        for (String pkgId : packageIds) {
            pl.addAll(this.getParticipantsFromPackage(pkgId));
        }
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] pms = new org.enhydra.shark.api.client.wfservice.ParticipantMap[pl.size()];
        pl.toArray(pms);
        return pms;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipantMappings() throws BaseException {
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] retVal;
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            retVal = this.getAllParticipantMappings(t);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipantMappings(ParticipantMappingTransaction t) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap> clientMapList = new ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap>();
            List persistentMapList = this.pmanager.getAllParticipantMappings(t);
            for (int i = 0; i < persistentMapList.size(); ++i) {
                clientMapList.add(this.createClientMapFromPersistentParticipantMap((ParticipantMap)persistentMapList.get(i)));
            }
            org.enhydra.shark.api.client.wfservice.ParticipantMap[] pma = new org.enhydra.shark.api.client.wfservice.ParticipantMap[clientMapList.size()];
            clientMapList.toArray(pma);
            return pma;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants(String pkgId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] retVal;
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            retVal = this.getAllParticipants(t, pkgId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants(ParticipantMappingTransaction trans, String pkgId) throws BaseException {
        if (pkgId == null) {
            throw new BaseException("The package Id can't be null");
        }
        List pl = this.getParticipantsFromPackage(pkgId);
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] pms = new org.enhydra.shark.api.client.wfservice.ParticipantMap[pl.size()];
        pl.toArray(pms);
        return pms;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants(String pkgId, String pDefId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] retVal;
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            retVal = this.getAllParticipants(t, pkgId, pDefId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getAllParticipants(ParticipantMappingTransaction trans, String pkgId, String pDefId) throws BaseException {
        if (pkgId == null) {
            throw new BaseException("The package Id can't be null");
        }
        List pl = this.getParticipantsFromPackageProcess(pkgId, pDefId);
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] pms = new org.enhydra.shark.api.client.wfservice.ParticipantMap[pl.size()];
        pl.toArray(pms);
        return pms;
    }

    private List getParticipantsFromPackageProcess(String pkgId, String pDefId) throws BaseException {
        ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap> pl = new ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap>();
        Package pkg = SharkEngineManager.getInstance().getXMLInterface().getPackageById(pkgId);
        if (pkg == null) {
            throw new BaseException("Can't find package with Id=" + pkgId);
        }
        WorkflowProcess wp = pkg.getWorkflowProcesses().getWorkflowProcess(pDefId);
        if (wp == null) {
            throw new BaseException("Can't find process definition with Id=" + pDefId + " in pkg " + pkgId);
        }
        Participants ps = wp.getParticipants();
        for (Participant p : ps.toElements()) {
            org.enhydra.shark.api.client.wfservice.ParticipantMap pm = SharkEngineManager.getInstance().getObjectFactory().createParticipantMap();
            pm.setPackageId(pkgId);
            pm.setProcessDefinitionId(wp.getId());
            pm.setParticipantId(p.getId());
            pl.add(pm);
        }
        return pl;
    }

    private List getParticipantsFromPackage(String pkgId) throws BaseException {
        ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap> pl = new ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap>();
        Package pkg = SharkEngineManager.getInstance().getXMLInterface().getPackageById(pkgId);
        if (pkg == null) {
            throw new BaseException("Can't find package with Id=" + pkgId);
        }
        Participants ps = pkg.getParticipants();
        for (Participant p : ps.toElements()) {
            org.enhydra.shark.api.client.wfservice.ParticipantMap pm = SharkEngineManager.getInstance().getObjectFactory().createParticipantMap();
            pm.setPackageId(pkgId);
            pm.setParticipantId(p.getId());
            pl.add(pm);
        }
        Iterator processes = pkg.getWorkflowProcesses().toElements().iterator();
        while (processes.hasNext()) {
            String pDefId = ((WorkflowProcess)processes.next()).getId();
            pl.addAll(this.getParticipantsFromPackageProcess(pkgId, pDefId));
        }
        return pl;
    }

    public void addParticipantMapping(org.enhydra.shark.api.client.wfservice.ParticipantMap pm) throws BaseException {
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            this.addParticipantMapping(t, pm);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void addParticipantMapping(ParticipantMappingTransaction t, org.enhydra.shark.api.client.wfservice.ParticipantMap pm) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.saveParticipantMapping(t, this.createPersistentParticipantMapFromClientMap(pm));
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeParticipantMapping(org.enhydra.shark.api.client.wfservice.ParticipantMap pm) throws BaseException {
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            this.removeParticipantMapping(t, pm);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void removeParticipantMapping(ParticipantMappingTransaction t, org.enhydra.shark.api.client.wfservice.ParticipantMap pm) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.deleteParticipantMapping(t, this.createPersistentParticipantMapFromClientMap(pm));
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getParticipantMappings(String packageId, String processDefinitionId, String participantId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] retVal;
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            retVal = this.getParticipantMappings(t, packageId, processDefinitionId, participantId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap[] getParticipantMappings(ParticipantMappingTransaction t, String packageId, String processDefinitionId, String participantId) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        org.enhydra.shark.api.client.wfservice.ParticipantMap[] pma = null;
        try {
            List persistentMapList = this.pmanager.getParticipantMappings(t, packageId, processDefinitionId, participantId);
            ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap> clientMapList = new ArrayList<org.enhydra.shark.api.client.wfservice.ParticipantMap>();
            for (int i = 0; i < persistentMapList.size(); ++i) {
                clientMapList.add(this.createClientMapFromPersistentParticipantMap((ParticipantMap)persistentMapList.get(i)));
            }
            pma = new org.enhydra.shark.api.client.wfservice.ParticipantMap[clientMapList.size()];
            clientMapList.toArray(pma);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        return pma;
    }

    public void removeParticipantMappings(String packageId, String processDefinitionId, String participantId) throws BaseException {
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            this.removeParticipantMappings(t, packageId, processDefinitionId, participantId);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void removeParticipantMappings(ParticipantMappingTransaction t, String packageId, String processDefinitionId, String participantId) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.deleteParticipantMappings(t, packageId, processDefinitionId, participantId);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeParticipantMappings(String username) throws BaseException {
        ParticipantMappingTransaction t = null;
        try {
            t = SharkUtilities.createParticipantMappingTransaction();
            this.removeParticipantMappings(t, username);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void removeParticipantMappings(ParticipantMappingTransaction t, String username) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.deleteParticipantMappings(t, username);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap createParticipantMap() {
        return SharkEngineManager.getInstance().getObjectFactory().createParticipantMap();
    }

    public org.enhydra.shark.api.client.wfservice.ParticipantMap createParticipantMap(ParticipantMappingTransaction t) {
        return SharkEngineManager.getInstance().getObjectFactory().createParticipantMap();
    }

    public String[] getAllGroupnames() throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllGroupnames();
    }

    public String[] getAllGroupnames(ParticipantMappingTransaction t) throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllGroupnames();
    }

    public String[] getAllUsers() throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllUsers();
    }

    public String[] getAllUsers(ParticipantMappingTransaction t) throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllUsers();
    }

    public String[] getAllUsers(String groupName) throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllUsers(groupName);
    }

    public String[] getAllUsers(ParticipantMappingTransaction t, String groupName) throws BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createUserGroupAdministration().getAllUsers(groupName);
    }

    private ParticipantMap createPersistentParticipantMapFromClientMap(org.enhydra.shark.api.client.wfservice.ParticipantMap pm) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        ParticipantMap pmpersistent = null;
        try {
            pmpersistent = this.pmanager.createParticipantMap();
            pmpersistent.setUsername(pm.getUsername());
            pmpersistent.setProcessDefinitionId(pm.getProcessDefinitionId());
            pmpersistent.setParticipantId(pm.getParticipantId());
            pmpersistent.setPackageId(pm.getPackageId());
            pmpersistent.setIsGroupUser(pm.getIsGroupUser());
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        return pmpersistent;
    }

    private org.enhydra.shark.api.client.wfservice.ParticipantMap createClientMapFromPersistentParticipantMap(ParticipantMap pm) {
        if (pm == null) {
            return null;
        }
        org.enhydra.shark.api.client.wfservice.ParticipantMap pmClient = this.createParticipantMap();
        pmClient.setUsername(pm.getUsername());
        pmClient.setProcessDefinitionId(pm.getProcessDefinitionId());
        pmClient.setParticipantId(pm.getParticipantId());
        pmClient.setPackageId(pm.getPackageId());
        pmClient.setIsGroupUser(pm.getIsGroupUser());
        return pmClient;
    }
}

