/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.Shark;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfAssignmentIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.api.client.wfservice.WfProcessMgrIterator;
import org.enhydra.shark.api.client.wfservice.WfResourceIterator;
import org.enhydra.shark.api.internal.caching.CacheMgr;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ActivityVariablePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessVariablePersistenceInterface;
import org.enhydra.shark.api.internal.processlocking.LockMaster;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;

public class ExecutionAdmin
implements ExecutionAdministration {
    private String userId;
    private boolean connected = false;
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();

    protected ExecutionAdmin() {
    }

    public ExecutionAdmin(SharkTransaction t, UserTransaction ut, String userId) {
        this();
        try {
            this.connect(t, ut, userId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void connect(SharkTransaction t, UserTransaction ut, String userId) throws BaseException, ConnectFailed {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_connect(t, userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            if (!uga.doesUserExist(ut, userId)) {
                this.cus.info("ExecutionAdmin -> Login failed: Invalid username" + userId);
                throw new ConnectFailed("Connection failed, invalid username");
            }
            if (SharkUtilities.getResource(t, userId) == null) {
                WfResourceInternal wfResourceInternal = SharkEngineManager.getInstance().getObjectFactory().createResource(t, userId);
            }
            this.connected = true;
            this.userId = userId;
            this.cus.info("ExecutionAdmin -> User " + userId + " is logged on");
        }
        catch (Exception ex) {
            if (ex instanceof ConnectFailed) {
                throw (ConnectFailed)ex;
            }
            this.cus.info("ExecutionAdmin -> Unexpected error while user " + userId + " loggs on");
            ex.printStackTrace();
            throw new BaseException((Throwable)ex);
        }
    }

    public void connect(String userId, String password, String engineName, String scope) throws BaseException, ConnectFailed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.connect((SharkTransaction)t, userId, password, engineName, scope);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof ConnectFailed) {
                throw (ConnectFailed)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void connect(SharkTransaction t, String userId, String password, String engineName, String scope) throws BaseException, ConnectFailed {
        UserTransaction ut = null;
        try {
            ut = SharkUtilities.createUserTransaction();
            this.connect(t, ut, userId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(ut);
        }
    }

    public void disconnect() throws BaseException, NotConnected {
    }

    public void disconnect(SharkTransaction t) throws BaseException, NotConnected {
    }

    public WfProcessMgrIterator get_iterator_processmgr() throws BaseException, NotConnected {
        WfProcessMgrIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_processmgr((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgrIterator get_iterator_processmgr(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_get_iterator_processmgr(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            WfProcessMgrIterator ret = SharkEngineManager.getInstance().getObjectFactory().createProcessMgrIteratorWrapper(t, this.userId);
            return ret;
        }
        catch (Exception ex) {
            this.cus.info("ExecutionAdmin -> Unexpected error while user tries to get process managers iterator");
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessMgr[] get_sequence_processmgr(int max_number) throws BaseException, NotConnected {
        WfProcessMgr[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_processmgr((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr[] get_sequence_processmgr(SharkTransaction t, int max_number) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_get_sequence_processmgr(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getObjectFactory().createProcessMgrIteratorWrapper(t, this.userId).get_next_n_sequence(t, max_number);
        }
        catch (Exception ex) {
            this.cus.info("ExecutionAdmin -> Unexpected error while user tries to get the list of process managers");
            throw new BaseException((Throwable)ex);
        }
    }

    public WfResourceIterator get_iterator_resource() throws BaseException, NotConnected {
        WfResourceIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_resource((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResourceIterator get_iterator_resource(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_get_iterator_resource(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getObjectFactory().createResourceIteratorWrapper(t, this.userId);
        }
        catch (Exception ex) {
            this.cus.info("ExecutionAdmin -> Unexpected error while user tries to get resource's iterator");
            throw new BaseException((Throwable)ex);
        }
    }

    public WfResource[] get_sequence_resource(int max_number) throws BaseException, NotConnected {
        WfResource[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_resource((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource[] get_sequence_resource(SharkTransaction t, int max_number) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_get_sequence_resource(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getObjectFactory().createResourceIteratorWrapper(t, this.userId).get_next_n_sequence(max_number);
        }
        catch (Exception ex) {
            this.cus.info("ExecutionAdmin -> Unexpected error while user tries to get the list of resources");
            throw new BaseException((Throwable)ex);
        }
    }

    public Map getLoggedUsers() throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getLoggedUsers((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getLoggedUsers(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_getLoggedUsers(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            Map ret = SharkUtilities.getLoggedUsers();
            return ret;
        }
        catch (Exception ex) {
            this.cus.info("ExecutionAdmin -> Unexpected error while user tries to get logged users");
            throw new BaseException((Throwable)ex);
        }
    }

    public String startActivity(String procId, String blockActId, String actDefId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            String actId = this.startActivity((SharkTransaction)t, procId, blockActId, actDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
            String string = actId;
            return string;
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public String startActivity(SharkTransaction t, String procId, String blockActId, String actDefId) throws BaseException, NotConnected {
        return this.startActivity(t, procId, blockActId, actDefId, null);
    }

    public String startActivity(SharkTransaction t, String procId, String blockActId, String actDefId, String username) throws BaseException, NotConnected {
        return this.startActivityFrom(t, procId, blockActId, actDefId, username, new WfActivity[0]);
    }

    public String startActivityFrom(SharkTransaction t, String procId, String blockActId, String actDefId, String username, WfActivity ... previousActivities) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                sm.check_executionadministration_startActivity(t, procId, this.userId, proc.requester(t).getResourceRequesterUsername(t));
            }
            return proc.start_activity_from(t, actDefId, blockActId, username, previousActivities);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessMgr getProcessMgr(String name) throws BaseException, NotConnected {
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgr((SharkTransaction)t, name);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr getProcessMgr(SharkTransaction t, String name) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_getProcessMgr(t, name, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return null != SharkUtilities.getProcessMgr(t, name) ? SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userId, name) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessMgr getProcessMgr(String pkgId, String pDefId) throws BaseException, NotConnected {
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgr((SharkTransaction)t, pkgId, pDefId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr getProcessMgr(SharkTransaction t, String pkgId, String pDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            String curVer = SharkUtilities.getCurrentPkgVersion(pkgId, false);
            String mgrName = SharkUtilities.createProcessMgrKey(pkgId, curVer, pDefId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                sm.check_executionadministration_getProcessMgr(t, mgrName, this.userId);
            }
            return null != SharkUtilities.getProcessMgr(t, mgrName) ? SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userId, mgrName) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcessMgr getProcessMgr(String pkgId, String pkgVer, String pDefId) throws BaseException, NotConnected {
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgr((SharkTransaction)t, pkgId, pkgVer, pDefId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr getProcessMgr(SharkTransaction t, String pkgId, String pkgVer, String pDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            String mgrName = SharkUtilities.createProcessMgrKey(pkgId, pkgVer, pDefId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                sm.check_executionadministration_getProcessMgr(t, mgrName, this.userId);
            }
            return null != SharkUtilities.getProcessMgr(t, mgrName) ? SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userId, mgrName) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfProcess getProcess(String procId) throws BaseException, NotConnected {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcess((SharkTransaction)t, procId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess getProcess(SharkTransaction t, String procId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null && proc != null) {
                sm.check_executionadministration_getProcess(t, procId, this.userId, proc.requester(t).getResourceRequesterUsername(t));
            }
            return null != proc ? SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userId, proc.manager_name(t), procId) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfActivity getActivity(String procId, String actId) throws BaseException, NotConnected {
        WfActivity ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getActivity((SharkTransaction)t, procId, actId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity getActivity(SharkTransaction t, String procId, String actId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfActivityInternal act = SharkUtilities.getActivity(t, procId, actId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null && act != null) {
                sm.check_executionadministration_getActivity(t, procId, actId, this.userId, act.container(t).requester(t).getResourceRequesterUsername(t), act.getResourceUsername(t), act.getAssignmentResourceIds(t));
            }
            return null != act ? SharkEngineManager.getInstance().getObjectFactory().createActivityWrapper(this.userId, act.manager_name(t), procId, actId) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfResource getResource(String username) throws BaseException, NotConnected {
        WfResource ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getResource((SharkTransaction)t, username);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfResource getResource(SharkTransaction t, String username) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_getResource(t, username, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return null != SharkUtilities.getResource(t, username) ? SharkEngineManager.getInstance().getObjectFactory().createResourceWrapper(this.userId, username) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfAssignment getAssignment(String procId, String actId, String username) throws BaseException, NotConnected {
        WfAssignment ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getAssignment((SharkTransaction)t, procId, actId, username);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment getAssignment(SharkTransaction t, String procId, String actId, String username) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfAssignmentInternal ass = SharkUtilities.getAssignment(t, procId, actId, username);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null && ass != null) {
                sm.check_executionadministration_getAssignment(t, procId, actId, username, this.userId, ass.activity(t).container(t).requester(t).getResourceRequesterUsername(t), ass.activity(t).getResourceUsername(t), ass.activity(t).getAssignmentResourceIds(t));
            }
            return null != ass ? SharkEngineManager.getInstance().getObjectFactory().createAssignmentWrapper(this.userId, ass.managerName(t), procId, actId, username) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfAssignment getAssignment(String procId, String assId) throws BaseException, NotConnected {
        WfAssignment ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getAssignment((SharkTransaction)t, procId, assId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignment getAssignment(SharkTransaction t, String procId, String assId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null && proc != null) {
                sm.check_executionadministration_getAssignment(t, procId, assId, this.userId, proc.requester(t).getResourceRequesterUsername(t));
            }
            return null != proc ? SharkUtilities.getAssignmentWrapper(t, this.userId, procId, assId) : null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void reevaluateAssignments() throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reevaluateAssignments((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reevaluateAssignments(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_reevaluateAssignments(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        SharkUtilities.reevaluateAssignments(t);
    }

    public void reevaluateAssignments(String pkgId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reevaluateAssignments((SharkTransaction)t, pkgId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reevaluateAssignments(SharkTransaction t, String pkgId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_reevaluateAssignments(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfProcessMgrIterator iter = SharkEngineManager.getInstance().getObjectFactory().createProcessMgrIteratorWrapper(t, this.userId);
        String query = "packageId.equals(\"" + pkgId + "\")";
        try {
            iter.set_query_expression(t, query);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        WfProcessMgr[] mgrs = iter.get_next_n_sequence(t, 0);
        if (mgrs != null) {
            for (int i = 0; i < mgrs.length; ++i) {
                String mgrName = mgrs[i].name(t);
                SharkUtilities.reevalAssignments(t, mgrName);
            }
        }
    }

    public void reevaluateAssignments(String pkgId, String pDefId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reevaluateAssignments((SharkTransaction)t, pkgId, pDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reevaluateAssignments(SharkTransaction t, String pkgId, String pDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_reevaluateAssignments(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfProcessMgrIterator iter = SharkEngineManager.getInstance().getObjectFactory().createProcessMgrIteratorWrapper(t, this.userId);
        String query = "packageId.equals(\"" + pkgId + "\") && processDefinitionId.equals(\"" + pDefId + "\")";
        try {
            iter.set_query_expression(t, query);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        WfProcessMgr[] mgrs = iter.get_next_n_sequence(t, 0);
        if (mgrs != null) {
            for (int i = 0; i < mgrs.length; ++i) {
                String mgrName = mgrs[i].name(t);
                SharkUtilities.reevalAssignments(t, mgrName);
            }
        }
    }

    public void reevaluateAssignments(String pkgId, String pDefId, String aDefId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reevaluateAssignments((SharkTransaction)t, pkgId, pDefId, aDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reevaluateAssignments(SharkTransaction t, String pkgId, String pDefId, String aDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_reevaluateAssignments(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfProcessMgrIterator iter = SharkEngineManager.getInstance().getObjectFactory().createProcessMgrIteratorWrapper(t, this.userId);
        String query = "packageId.equals(\"" + pkgId + "\") && processDefinitionId.equals(\"" + pDefId + "\")";
        try {
            iter.set_query_expression(t, query);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        WfProcessMgr[] mgrs = iter.get_next_n_sequence(t, 0);
        if (mgrs != null) {
            for (int i = 0; i < mgrs.length; ++i) {
                String mgrName = mgrs[i].name(t);
                List l = SharkUtilities.createProcessMgrsProcessWrappers(t, this.userId, mgrName);
                for (WfProcess p : l) {
                    String procId = p.key(t);
                    WfActivityIterator actIter = SharkEngineManager.getInstance().getObjectFactory().createActivityIteratorWrapper(t, this.userId, procId);
                    String actQuery = "definitionId.equals(\"" + aDefId + "\")";
                    try {
                        actIter.set_query_expression(t, actQuery);
                    }
                    catch (Exception ex) {
                        throw new BaseException((Throwable)ex);
                    }
                    WfActivity[] acts = actIter.get_next_n_sequence(t, 0);
                    for (int j = 0; j < acts.length; ++j) {
                        WfActivity act = acts[j];
                        WfActivityInternal aint = SharkUtilities.getActivity(t, procId, act.key(t));
                        aint.reevaluateAssignments(t);
                    }
                }
            }
        }
    }

    public void deleteClosedProcesses() throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcesses((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcesses(SharkTransaction t) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_reevaluateAssignments(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes:");
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcesses(Date closedBefore) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcesses((SharkTransaction)t, closedBefore);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcesses(SharkTransaction t, Date closedBefore) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t, closedBefore);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " processes closed before " + closedBefore + ":");
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcesses(String pkgId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcesses((SharkTransaction)t, pkgId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcesses(SharkTransaction t, String pkgId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t, pkgId);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes for package Id=" + pkgId + ":");
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcessesForMgr(String mgrName) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcessesForMgr((SharkTransaction)t, mgrName);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcessesForMgr(SharkTransaction t, String mgrName) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            String pkgId = SharkUtilities.getProcessMgrPkgId(mgrName);
            String pDefId = SharkUtilities.getProcessMgrProcDefId(mgrName);
            String pkgVer = SharkUtilities.getProcessMgrVersion(mgrName);
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t, pkgId, pDefId, pkgVer);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes for package Id=" + pkgId + ", version=" + pkgVer + ", pDefId= :" + pDefId);
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcessesWithVersion(String pkgId, String pkgVer) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcessesWithVersion((SharkTransaction)t, pkgId, pkgVer);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcessesWithVersion(SharkTransaction t, String pkgId, String pkgVer) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t, pkgId, null, pkgVer);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes for package Id=" + pkgId + ", version=" + pkgVer + " :");
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcesses(String pkgId, String pDefId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcesses((SharkTransaction)t, pkgId, pDefId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcesses(SharkTransaction t, String pkgId, String pDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            List procs = ipm.getAllFinishedProcesses(t, pkgId, pDefId);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes for packageId=" + pkgId + "and processDefinitionId=" + pDefId + ":");
            for (ProcessPersistenceInterface po : procs) {
                ActivityPersistenceInterface apo;
                if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                    this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                    continue;
                }
                this.cus.info("... Deleting process " + po.getId());
                if (lm != null) {
                    lm.lock(t, po.getId());
                }
                ipm.deleteProcess(po.getId(), true, t);
                CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                if (cm == null) continue;
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void deleteClosedProcess(String procId) throws BaseException, NotConnected {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.deleteClosedProcess((SharkTransaction)t, procId);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void deleteClosedProcess(SharkTransaction t, String procId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_executionadministration_deleteClosedProcesses(t, this.userId);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        try {
            ActivityPersistenceInterface apo;
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ProcessPersistenceInterface po = ipm.restoreProcess(procId, t);
            if (po.getState().startsWith("open")) {
                throw new BaseException("Can't delete processes which are not closed");
            }
            if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), t)) != null && apo.getState().startsWith("open")) {
                this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                return;
            }
            this.cus.info("... Deleting process " + po.getId());
            if (lm != null) {
                lm.lock(t, po.getId());
            }
            ipm.deleteProcess(po.getId(), true, t);
            CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
            if (cm != null) {
                cm.getProcessCache().remove(po.getId());
            }
        }
        catch (Exception ex) {
            throw new BaseException("Problems with deleting process for Id " + procId, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] deleteClosedProcessesForMgr(String mgrName, int procPerTrans, int failures2ignore) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            SharkInternalTransaction t = null;
            try {
                t = SharkUtilities.createTransaction();
                sm.check_executionadministration_deleteClosedProcesses((SharkTransaction)t, this.userId);
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
                if (e instanceof NotConnected) {
                    throw (NotConnected)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)((Object)e);
                }
                throw new BaseException((Throwable)e);
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
        }
        ArrayList instancesFailed2check = new ArrayList();
        Iterator iterProcesses = null;
        ArrayList<String> currentBatch = null;
        List procs = null;
        SharkInternalTransaction t = null;
        PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
        try {
            t = SharkUtilities.createTransaction();
            procs = ipm.getAllFinishedProcesses((SharkTransaction)t);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes:");
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        do {
            t = null;
            currentBatch = new ArrayList<String>();
            try {
                t = SharkUtilities.createTransaction();
                String pkgId = SharkUtilities.getProcessMgrPkgId(mgrName);
                String pDefId = SharkUtilities.getProcessMgrProcDefId(mgrName);
                String pkgVer = SharkUtilities.getProcessMgrVersion(mgrName);
                iterProcesses = procs.iterator();
                for (int n = 0; n < procPerTrans && iterProcesses.hasNext(); ++n) {
                    ActivityPersistenceInterface apo;
                    ProcessPersistenceInterface po = (ProcessPersistenceInterface)iterProcesses.next();
                    iterProcesses.remove();
                    if (po.getActivityRequesterId() != null && (apo = ipm.restoreActivity(po.getActivityRequesterId(), (SharkTransaction)t)) != null && apo.getState().startsWith("open")) {
                        this.cus.info("... Process " + po.getId() + " can't be deleted yet because it has active activity requester!");
                        continue;
                    }
                    this.cus.info("... Deleting process " + po.getId());
                    if (lm != null) {
                        lm.lock((SharkTransaction)t, po.getId());
                    }
                    ipm.deleteProcess(po.getId(), true, (SharkTransaction)t);
                    CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                    if (cm != null) {
                        cm.getProcessCache().remove(po.getId());
                    }
                    currentBatch.add(po.getId());
                }
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException _) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, _);
                instancesFailed2check.addAll(currentBatch);
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            System.err.println("\ttransaction finished: batch size:" + currentBatch.size());
        } while (instancesFailed2check.size() <= failures2ignore && iterProcesses.hasNext());
        String[] ret = new String[instancesFailed2check.size()];
        instancesFailed2check.toArray(ret);
        System.err.println("  deleting finished: failed:" + ret.length);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] deleteClosedProcesses(int procPerTrans, int failures2ignore) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            SharkInternalTransaction t = null;
            try {
                t = SharkUtilities.createTransaction();
                sm.check_executionadministration_deleteClosedProcesses((SharkTransaction)t, this.userId);
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException e) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
                if (e instanceof NotConnected) {
                    throw (NotConnected)e;
                }
                if (e instanceof BaseException) {
                    throw (BaseException)((Object)e);
                }
                throw new BaseException((Throwable)e);
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
        }
        ArrayList instancesFailed2check = new ArrayList();
        Iterator iterProcesses = null;
        ArrayList<String> currentBatch = null;
        List procs = null;
        SharkInternalTransaction t = null;
        PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
        try {
            t = SharkUtilities.createTransaction();
            procs = ipm.getAllFinishedProcesses((SharkTransaction)t);
            this.cus.info("ExecutionAdmin -> Deleting " + procs.size() + " closed processes:");
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        LockMaster lm = SharkEngineManager.getInstance().getLockMaster();
        do {
            t = null;
            currentBatch = new ArrayList<String>();
            try {
                t = SharkUtilities.createTransaction();
                iterProcesses = procs.iterator();
                for (int n = 0; n < procPerTrans && iterProcesses.hasNext(); ++n) {
                    ProcessPersistenceInterface po = (ProcessPersistenceInterface)iterProcesses.next();
                    iterProcesses.remove();
                    this.cus.info("... Deleting process " + po.getId());
                    if (lm != null) {
                        lm.lock((SharkTransaction)t, po.getId());
                    }
                    ipm.deleteProcess(po.getId(), true, (SharkTransaction)t);
                    CacheMgr cm = SharkEngineManager.getInstance().getCacheManager();
                    if (cm != null) {
                        cm.getProcessCache().remove(po.getId());
                    }
                    currentBatch.add(po.getId());
                }
                SharkUtilities.commitTransaction((SharkTransaction)t);
            }
            catch (RootException _) {
                SharkUtilities.rollbackTransaction((SharkTransaction)t, _);
                instancesFailed2check.addAll(currentBatch);
            }
            finally {
                SharkUtilities.releaseTransaction((SharkTransaction)t);
            }
            System.err.println("\ttransaction finished: batch size:" + currentBatch.size());
        } while (instancesFailed2check.size() <= failures2ignore && iterProcesses.hasNext());
        String[] ret = new String[instancesFailed2check.size()];
        instancesFailed2check.toArray(ret);
        System.err.println("  deleting finished: failed:" + ret.length);
        return ret;
    }

    public Map getProcessMgrInputSignature(String name) throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgrInputSignature((SharkTransaction)t, name);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getProcessMgrInputSignature(SharkTransaction t, String name) throws BaseException, NotConnected {
        return this.getProcessMgrInputSignature(t, SharkUtilities.getProcessMgrPkgId(name), SharkUtilities.getProcessMgrVersion(name), SharkUtilities.getProcessMgrProcDefId(name));
    }

    public Map getProcessMgrInputSignature(String pkgId, String pDefId) throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgrInputSignature((SharkTransaction)t, pkgId, pDefId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getProcessMgrInputSignature(SharkTransaction t, String pkgId, String pDefId) throws BaseException, NotConnected {
        return this.getProcessMgrInputSignature(t, pkgId, SharkUtilities.getCurrentPkgVersion(pkgId, false), pDefId);
    }

    public Map getProcessMgrInputSignature(String pkgId, String pkgVer, String pDefId) throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessMgrInputSignature((SharkTransaction)t, pkgId, pkgVer, pDefId);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getProcessMgrInputSignature(SharkTransaction t, String pkgId, String pkgVer, String pDefId) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            WfProcessMgrInternal a;
            String mgrName = SharkUtilities.createProcessMgrKey(pkgId, pkgVer, pDefId);
            SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
            if (sm != null) {
                sm.check_executionadministration_getProcessMgr(t, mgrName, this.userId);
            }
            if (null != (a = SharkUtilities.getProcessMgr(t, mgrName))) {
                return a.input_signature(t);
            }
            return null;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public Object getProcessContext(String procId, String variableName) throws BaseException, NotConnected {
        Object ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessContext((SharkTransaction)t, procId, variableName);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Object getProcessContext(SharkTransaction t, String procId, String variableName) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ProcessVariablePersistenceInterface a = ipm.createProcessVariable();
            a.setDefinitionId(variableName);
            a.setProcessId(procId);
            if (ipm.restore(a, t)) {
                return a.getValue();
            }
        }
        catch (PersistenceException ex) {
            throw new BaseException((Throwable)ex);
        }
        throw new BaseException("variable not found");
    }

    public Map getProcessContext(String procId, String[] variableNames) throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getProcessContext((SharkTransaction)t, procId, variableNames);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getProcessContext(SharkTransaction t, String procId, String[] variableNames) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int i = 0; i < variableNames.length; ++i) {
            ret.put(variableNames[i], this.getProcessContext(t, procId, variableNames[i]));
        }
        return ret;
    }

    public Object getActivityContext(String procId, String actId, String variableName) throws BaseException, NotConnected {
        Object ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getActivityContext((SharkTransaction)t, procId, actId, variableName);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Object getActivityContext(SharkTransaction t, String procId, String actId, String variableName) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        try {
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ActivityVariablePersistenceInterface a = ipm.createActivityVariable();
            a.setDefinitionId(variableName);
            a.setActivityId(actId);
            if (ipm.restore(a, t)) {
                return a.getValue();
            }
        }
        catch (PersistenceException ex) {
            throw new BaseException((Throwable)ex);
        }
        throw new BaseException("variable not found");
    }

    public Map getActivityContext(String procId, String actId, String[] variableNames) throws BaseException, NotConnected {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.getActivityContext((SharkTransaction)t, procId, actId, variableNames);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map getActivityContext(SharkTransaction t, String procId, String actId, String[] variableNames) throws BaseException, NotConnected {
        if (!this.connected) {
            throw new NotConnected("The connection is not established...");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int i = 0; i < variableNames.length; ++i) {
            ret.put(variableNames[i], this.getActivityContext(t, procId, actId, variableNames[i]));
        }
        return ret;
    }

    public WfAssignmentIterator get_iterator_assignment() throws NotConnected, BaseException {
        WfAssignmentIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_assignment((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfAssignmentIterator get_iterator_assignment(SharkTransaction t) throws NotConnected, BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createAssignmentIteratorWrapper(t, this.userId, null);
    }

    public WfProcessIterator get_iterator_process() throws NotConnected, BaseException {
        WfProcessIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_process((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessIterator get_iterator_process(SharkTransaction t) throws NotConnected, BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createProcessIteratorWrapper(t, this.userId, null, false);
    }

    public WfActivityIterator get_iterator_activity() throws NotConnected, BaseException {
        WfActivityIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_activity((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof NotConnected) {
                throw (NotConnected)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivityIterator get_iterator_activity(SharkTransaction t) throws NotConnected, BaseException {
        return SharkEngineManager.getInstance().getObjectFactory().createActivityIteratorWrapper(t, this.userId, null);
    }

    public void finalize() throws Throwable {
    }
}

