/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.ApplicationMappingTransaction;
import org.enhydra.shark.api.RepositoryTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ApplicationMappingAdministration;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMap;
import org.enhydra.shark.api.internal.appmappersistence.ApplicationMappingManager;
import org.enhydra.shark.api.internal.repositorypersistence.RepositoryPersistenceManager;
import org.enhydra.shark.api.internal.toolagent.ToolAgentFactory;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.Applications;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ApplicationMappingsAdministrationImpl
implements ApplicationMappingAdministration {
    private ApplicationMappingManager pmanager = SharkEngineManager.getInstance().getApplicationMapPersistenceManager();
    private String userId = "Unknown";

    protected ApplicationMappingsAdministrationImpl() {
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications() throws BaseException {
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getAllApplications(t);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications(ApplicationMappingTransaction t) throws BaseException {
        ArrayList al = new ArrayList();
        List packageIds = null;
        RepositoryPersistenceManager rpm = SharkEngineManager.getInstance().getRepositoryPersistenceManager();
        RepositoryTransaction rt = null;
        try {
            rt = SharkUtilities.createRepositoryTransaction();
            packageIds = rpm.getExistingXPDLIds(rt);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseRepositoryTransaction(rt);
        }
        for (String pkgId : packageIds) {
            al.addAll(this.getApplicationsFromPackage(pkgId));
        }
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] ams = new org.enhydra.shark.api.client.wfservice.ApplicationMap[al.size()];
        al.toArray(ams);
        return ams;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications(String pkgId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getAllApplications(t, pkgId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications(ApplicationMappingTransaction t, String pkgId) throws BaseException {
        if (pkgId == null) {
            throw new BaseException("The package Id can't be null");
        }
        List al = this.getApplicationsFromPackage(pkgId);
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] ams = new org.enhydra.shark.api.client.wfservice.ApplicationMap[al.size()];
        al.toArray(ams);
        return ams;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications(String pkgId, String pDefId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getAllApplications(t, pkgId, pDefId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getAllApplications(ApplicationMappingTransaction t, String pkgId, String pDefId) throws BaseException {
        if (pkgId == null) {
            throw new BaseException("The package Id can't be null");
        }
        List al = this.getApplicationsFromPackageProcess(pkgId, pDefId);
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] ams = new org.enhydra.shark.api.client.wfservice.ApplicationMap[al.size()];
        al.toArray(ams);
        return ams;
    }

    private List getApplicationsFromPackage(String pkgId) throws BaseException {
        ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap> al = new ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap>();
        Package pkg = SharkEngineManager.getInstance().getXMLInterface().getPackageById(pkgId);
        if (pkg == null) {
            throw new BaseException("Can't find package with Id=" + pkgId);
        }
        Applications aps = pkg.getApplications();
        for (Application a : aps.toElements()) {
            org.enhydra.shark.api.client.wfservice.ApplicationMap am = SharkEngineManager.getInstance().getObjectFactory().createApplicationMap();
            am.setPackageId(pkgId);
            am.setApplicationDefinitionId(a.getId());
            al.add(am);
        }
        Iterator processes = pkg.getWorkflowProcesses().toElements().iterator();
        while (processes.hasNext()) {
            String pDefId = ((WorkflowProcess)processes.next()).getId();
            al.addAll(this.getApplicationsFromPackageProcess(pkgId, pDefId));
        }
        return al;
    }

    private List getApplicationsFromPackageProcess(String pkgId, String pDefId) throws BaseException {
        ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap> al = new ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap>();
        Package pkg = SharkEngineManager.getInstance().getXMLInterface().getPackageById(pkgId);
        if (pkg == null) {
            throw new BaseException("Can't find package with Id=" + pkgId);
        }
        WorkflowProcess wp = pkg.getWorkflowProcesses().getWorkflowProcess(pDefId);
        if (wp == null) {
            throw new BaseException("Can't find process definition with Id=" + pDefId + " in pkg " + pkgId);
        }
        Applications aps = wp.getApplications();
        for (Application a : aps.toElements()) {
            org.enhydra.shark.api.client.wfservice.ApplicationMap am = SharkEngineManager.getInstance().getObjectFactory().createApplicationMap();
            am.setPackageId(pkgId);
            am.setProcessDefinitionId(wp.getId());
            am.setApplicationDefinitionId(a.getId());
            al.add(am);
        }
        return al;
    }

    public String[] getDefinedToolAgents() throws BaseException {
        String[] retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getDefinedToolAgents(t);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public String[] getDefinedToolAgents(ApplicationMappingTransaction t) throws BaseException {
        ToolAgentFactory taf = SharkEngineManager.getInstance().getToolAgentFactory();
        if (taf == null) {
            throw new BaseException("Working without tool agents !");
        }
        SharkInternalTransaction st = null;
        try {
            st = SharkUtilities.createTransaction();
            List l = taf.getDefinedToolAgents((SharkTransaction)st);
            String[] ata = new String[l.size()];
            l.toArray(ata);
            String[] stringArray = ata;
            return stringArray;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)st);
        }
    }

    public Map getToolAgentsInfo() throws BaseException {
        Map retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getToolAgentsInfo(t);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public Map getToolAgentsInfo(ApplicationMappingTransaction t) throws BaseException {
        ToolAgentFactory taf = SharkEngineManager.getInstance().getToolAgentFactory();
        if (taf == null) {
            throw new BaseException("Working without tool agents !");
        }
        SharkInternalTransaction st = null;
        try {
            st = SharkUtilities.createTransaction();
            List l = taf.getDefinedToolAgents((SharkTransaction)st);
            HashMap<String, String> m = new HashMap<String, String>();
            for (String tan : l) {
                m.put(tan, taf.createToolAgent((SharkTransaction)st, tan).getInfo((SharkTransaction)st));
            }
            HashMap<String, String> hashMap = m;
            return hashMap;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)st);
        }
    }

    public String getToolAgentInfo(String toolAgentFullClassName) throws BaseException {
        String retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getToolAgentInfo(t, toolAgentFullClassName);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public String getToolAgentInfo(ApplicationMappingTransaction t, String toolAgentFullClassName) throws BaseException {
        ToolAgentFactory taf = SharkEngineManager.getInstance().getToolAgentFactory();
        if (taf == null) {
            throw new BaseException("Working without tool agents !");
        }
        SharkInternalTransaction st = null;
        try {
            st = SharkUtilities.createTransaction();
            String string = taf.createToolAgent((SharkTransaction)st, toolAgentFullClassName).getInfo((SharkTransaction)st);
            return string;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)st);
        }
    }

    public void addApplicationMapping(org.enhydra.shark.api.client.wfservice.ApplicationMap am) throws BaseException {
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            this.addApplicationMapping(t, am);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void addApplicationMapping(ApplicationMappingTransaction trans, org.enhydra.shark.api.client.wfservice.ApplicationMap am) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.saveApplicationMapping(trans, this.createPersistentApplicationMapFromClientMap(am));
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap getApplicationMapping(String pkgId, String pDefId, String appDefId) throws BaseException {
        org.enhydra.shark.api.client.wfservice.ApplicationMap retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getApplicationMapping(t, pkgId, pDefId, appDefId);
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap getApplicationMapping(ApplicationMappingTransaction trans, String pkgId, String pDefId, String appDefId) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            org.enhydra.shark.api.client.wfservice.ApplicationMap am = this.createClientMapFromPersistentApplicationMap(this.pmanager.getApplicationMap(trans, pkgId, pDefId, appDefId));
            return am;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeApplicationMapping(String packageId, String processDefinitionId, String applicationId) throws BaseException {
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            this.removeApplicationMapping(t, packageId, processDefinitionId, applicationId);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
    }

    public void removeApplicationMapping(ApplicationMappingTransaction trans, String packageId, String processDefinitionId, String applicationId) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            this.pmanager.deleteApplicationMapping(trans, packageId, processDefinitionId, applicationId);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getApplicationMappings() throws BaseException {
        org.enhydra.shark.api.client.wfservice.ApplicationMap[] retVal;
        ApplicationMappingTransaction t = null;
        try {
            t = SharkUtilities.createApplicationMappingTransaction();
            retVal = this.getApplicationMappings(t);
            SharkUtilities.commitMappingTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackMappingTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseMappingTransaction(t);
        }
        return retVal;
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap[] getApplicationMappings(ApplicationMappingTransaction trans) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        try {
            ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap> clientMapList = new ArrayList<org.enhydra.shark.api.client.wfservice.ApplicationMap>();
            List persistentMapList = this.pmanager.getAllApplicationMappings(trans);
            for (int i = 0; i < persistentMapList.size(); ++i) {
                clientMapList.add(this.createClientMapFromPersistentApplicationMap((ApplicationMap)persistentMapList.get(i)));
            }
            org.enhydra.shark.api.client.wfservice.ApplicationMap[] ama = new org.enhydra.shark.api.client.wfservice.ApplicationMap[clientMapList.size()];
            clientMapList.toArray(ama);
            return ama;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap createApplicationMap() {
        return SharkEngineManager.getInstance().getObjectFactory().createApplicationMap();
    }

    public org.enhydra.shark.api.client.wfservice.ApplicationMap createApplicationMap(ApplicationMappingTransaction t) {
        return SharkEngineManager.getInstance().getObjectFactory().createApplicationMap();
    }

    private ApplicationMap createPersistentApplicationMapFromClientMap(org.enhydra.shark.api.client.wfservice.ApplicationMap am) throws BaseException {
        if (this.pmanager == null) {
            throw new BaseException("The shark is configured to work without internal implementation of this API");
        }
        ApplicationMap ampersistent = null;
        try {
            ampersistent = this.pmanager.createApplicationMap();
            ampersistent.setUsername(am.getUsername());
            ampersistent.setPassword(am.getPassword());
            ampersistent.setApplicationDefinitionId(am.getApplicationDefinitionId());
            ampersistent.setApplicationMode(am.getApplicationMode());
            ampersistent.setApplicationName(am.getApplicationName());
            ampersistent.setProcessDefinitionId(am.getProcessDefinitionId());
            ampersistent.setToolAgentClassName(am.getToolAgentClassName());
            ampersistent.setPackageId(am.getPackageId());
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        return ampersistent;
    }

    private org.enhydra.shark.api.client.wfservice.ApplicationMap createClientMapFromPersistentApplicationMap(ApplicationMap am) {
        if (am == null) {
            return null;
        }
        org.enhydra.shark.api.client.wfservice.ApplicationMap ampClient = this.createApplicationMap();
        ampClient.setUsername(am.getUsername());
        ampClient.setPassword(am.getPassword());
        ampClient.setApplicationDefinitionId(am.getApplicationDefinitionId());
        ampClient.setApplicationMode(am.getApplicationMode());
        ampClient.setApplicationName(am.getApplicationName());
        ampClient.setProcessDefinitionId(am.getProcessDefinitionId());
        ampClient.setToolAgentClassName(am.getToolAgentClassName());
        ampClient.setPackageId(am.getPackageId());
        return ampClient;
    }
}

