/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessVariablePersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfProcessIteratorWrapper
extends BaseIteratorWrapper
implements WfProcessIterator {
    private String mgrName;
    private String procId;
    private String actId;
    private String username;

    protected WfProcessIteratorWrapper(SharkTransaction t, String userAuth, String mgrName) throws BaseException {
        super(userAuth);
        this.mgrName = mgrName;
    }

    protected WfProcessIteratorWrapper(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        super(userAuth);
        this.procId = procId;
        this.actId = actId;
    }

    protected WfProcessIteratorWrapper(SharkTransaction t, String userAuth, String resUname, boolean ext) throws BaseException {
        super(userAuth);
        this.username = resUname;
    }

    protected WfProcessIteratorWrapper(SharkTransaction t, String userAuth, List collection) throws BaseException {
        super(userAuth);
    }

    public WfProcess get_next_object() throws BaseException {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess get_next_object(SharkTransaction t) throws BaseException {
        return (WfProcess)super.getNextObject(t);
    }

    public WfProcess get_previous_object() throws BaseException {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess get_previous_object(SharkTransaction t) throws BaseException {
        return (WfProcess)super.getPreviousObject(t);
    }

    public WfProcess[] get_next_n_sequence(int max_number) throws BaseException {
        WfProcess[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfProcess[] ret = new WfProcess[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfProcess[] get_previous_n_sequence(int max_number) throws BaseException {
        WfProcess[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfProcess[] ret = new WfProcess[l.size()];
        l.toArray(ret);
        return ret;
    }

    @Override
    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<WfProcess> processes = new ArrayList<WfProcess>();
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            ArrayList l = new ArrayList();
            if (null != this.sqlWhere) {
                l.addAll(ipm.getProcessesWhere(t, this.sqlWhere));
            } else if (this.mgrName != null) {
                l.addAll(ipm.getAllProcessesForMgr(this.mgrName, t));
            } else if (this.procId != null && this.actId != null) {
                ActivityPersistenceInterface apo = ipm.restoreActivity(this.actId, t);
                String performerId = apo.getSubflowProcessId();
                if (performerId != null) {
                    processes.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userAuth, apo.getProcessMgrName(), performerId));
                }
            } else if (this.username != null) {
                List ids = ipm.getResourceRequestersProcessIds(this.username, t);
                for (int i = 0; i < ids.size(); ++i) {
                    String pId = (String)ids.get(i);
                    ProcessPersistenceInterface ppo = ipm.restoreProcess(pId, t);
                    processes.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userAuth, ppo.getProcessMgrName(), ppo.getId()));
                }
            }
            Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
            for (int i = 0; i < l.size(); ++i) {
                ProcessPersistenceInterface po = (ProcessPersistenceInterface)l.get(i);
                boolean toAdd = true;
                if (this.eval) {
                    List pc;
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("packageId")) {
                        context.put("packageId", SharkUtilities.getProcessMgrPkgId(po.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("processDefinitionId")) {
                        context.put("processDefinitionId", SharkUtilities.getProcessMgrProcDefId(po.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("version")) {
                        context.put("version", SharkUtilities.getProcessMgrVersion(po.getProcessMgrName()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("mgrName")) {
                        context.put("mgrName", po.getProcessMgrName());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("state")) {
                        context.put("state", po.getState());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("key")) {
                        context.put("key", po.getId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("name")) {
                        context.put("name", po.getName());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("priority")) {
                        context.put("priority", new Integer(po.getPriority()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("description")) {
                        context.put("description", po.getDescription());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("requesterId")) {
                        context.put("requesterId", po.getActivityRequesterId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("resourceRequesterId")) {
                        context.put("resourceRequesterId", po.getResourceRequesterId());
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("createdTime_ms")) {
                        context.put("createdTime_ms", new Long(po.getCreatedTime()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("startTime_ms")) {
                        context.put("startTime_ms", new Long(po.getStartedTime()));
                    }
                    if (this.ignoreUsedContext || !this.ignoreUsedContext && 0 <= this.usedContext.indexOf("lastStateTime_ms")) {
                        context.put("lastStateTime_ms", new Long(po.getLastStateTime()));
                    }
                    if (this.queryExpression.indexOf("activeActivitiesNo") != -1) {
                        context.put("activeActivitiesNo", new Long(ipm.getAllActiveActivitiesForProcess(po.getId(), t).size()));
                    }
                    if (this.queryExpression.indexOf("context_") != -1 && (pc = ipm.getAllVariablesForProcess(po.getId(), t)) != null) {
                        for (ProcessVariablePersistenceInterface pvpo : pc) {
                            try {
                                String name = "context_" + pvpo.getDefinitionId();
                                Object value = pvpo.getValue();
                                context.put(name, value);
                            }
                            catch (Exception ex) {
                                throw new BaseException((Throwable)ex);
                            }
                        }
                    }
                    toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                }
                if (!toAdd) continue;
                processes.add(SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userAuth, po.getProcessMgrName(), po.getId()));
            }
            this.setObjectList(processes);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

