/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidPerformer;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;

public class WfDefaultRequester
implements WfRequesterInternal {
    private String resourceUsername;
    private WfRequester externalRequester;

    protected WfDefaultRequester(String resourceUsername, WfRequester extRequester) {
        this.resourceUsername = resourceUsername;
        this.externalRequester = extRequester;
    }

    public String getResourceRequesterUsername(SharkTransaction t) throws BaseException {
        return this.resourceUsername;
    }

    public WfRequester getExternalRequester(SharkTransaction t) throws BaseException {
        return this.externalRequester;
    }

    public void receive_event(SharkTransaction t, WfEventAudit event, WfProcessInternal process) throws BaseException, InvalidPerformer {
        if (this.externalRequester != null) {
            try {
                this.externalRequester.receive_event(t, event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private List getPerformerIds(SharkTransaction t) throws BaseException {
        try {
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getResourceRequestersProcessIds(this.resourceUsername, t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public String toString() {
        return "Default requester - " + this.resourceUsername;
    }
}

