/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.WfEventAuditWrapper;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.internal.eventaudit.CreateProcessEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditException;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfCreateProcessEventAuditInternal;
import org.enhydra.shark.api.internal.working.WfExecutionObjectInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;

public class WfCreateProcessEventAuditWrapper
extends WfEventAuditWrapper
implements WfCreateProcessEventAuditInternal {
    private String pActivityId;
    private String pProcessId;
    private String pProcessName;
    private String pProcessMgrName;
    private String pProcessMgrVersion;
    private String pActivityDefinitionId;
    private String pActivitySetDefinitionId;
    private String pProcessDefinitionId;
    private String pPackageId;

    protected WfCreateProcessEventAuditWrapper(SharkTransaction t, WfProcessInternal process, WfRequesterInternal requester) throws BaseException {
        super(t, (WfExecutionObjectInternal)process, "processCreated");
        try {
            if (requester != null && requester instanceof WfActivityInternal) {
                WfActivityInternal req = (WfActivityInternal)requester;
                this.pActivityId = req.key(t);
                this.pProcessId = req.container(t).key(t);
                this.pProcessName = req.container(t).name(t);
                this.pProcessMgrName = req.container(t).manager_name(t);
                this.pProcessMgrVersion = req.container(t).manager_version(t);
                this.pActivityDefinitionId = req.activity_definition_id(t);
                this.pActivitySetDefinitionId = req.activity_set_definition_id(t);
                this.pProcessDefinitionId = req.container(t).process_definition_id(t);
                this.pPackageId = req.container(t).package_id(t);
            }
            this.persist(t);
        }
        catch (Exception pe) {
            throw new BaseException((Throwable)pe);
        }
    }

    protected WfCreateProcessEventAuditWrapper(String userAuth, CreateProcessEventAuditPersistenceInterface po) {
        super(userAuth, (EventAuditPersistenceInterface)po);
    }

    public String p_activity_key() throws BaseException {
        return this.pActivityId;
    }

    public String p_process_key() throws BaseException {
        return this.pProcessId;
    }

    public String p_process_name() throws BaseException {
        return this.pProcessName;
    }

    public String p_process_mgr_name() throws BaseException {
        return this.pProcessMgrName;
    }

    public String p_process_mgr_version() throws BaseException {
        return this.pProcessMgrVersion;
    }

    public String p_activity_definition_id() throws BaseException {
        return this.pActivityDefinitionId;
    }

    public String p_activity_set_definition_id() throws BaseException {
        return this.pActivitySetDefinitionId;
    }

    public String p_process_definition_id() throws BaseException {
        return this.pProcessMgrVersion;
    }

    public String p_package_id() throws BaseException {
        return this.pProcessMgrVersion;
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return;
            }
            CreateProcessEventAuditPersistenceInterface po = eam.createCreateProcessEventAudit();
            this.fillPersistentObject((EventAuditPersistenceInterface)po);
            eam.persist(po, t);
        }
        catch (EventAuditException pe) {
            throw new TransactionException((Throwable)pe);
        }
    }

    public void refresh() {
    }

    public void delete(SharkTransaction t) throws TransactionException {
    }

    @Override
    protected void fillPersistentObject(EventAuditPersistenceInterface po) {
        super.fillPersistentObject(po);
        CreateProcessEventAuditPersistenceInterface cpo = (CreateProcessEventAuditPersistenceInterface)po;
        cpo.setPActivityId(this.pActivityId);
        cpo.setPProcessId(this.pProcessId);
        cpo.setPProcessName(this.pProcessName);
        cpo.setPProcessDefinitionName(this.pProcessMgrName);
        cpo.setPProcessDefinitionVersion(this.pProcessMgrVersion);
        cpo.setPActivityDefinitionId(this.pActivityDefinitionId);
        cpo.setPActivitySetDefinitionId(this.pActivitySetDefinitionId);
        cpo.setPProcessDefinitionId(this.pProcessDefinitionId);
        cpo.setPPackageId(this.pPackageId);
    }

    @Override
    protected void restore(EventAuditPersistenceInterface po) {
        super.restore(po);
        CreateProcessEventAuditPersistenceInterface cpo = (CreateProcessEventAuditPersistenceInterface)po;
        this.pActivityId = cpo.getPActivityId();
        this.pProcessId = cpo.getPProcessId();
        this.pProcessName = cpo.getPProcessName();
        this.pProcessMgrName = cpo.getPProcessDefinitionName();
        this.pProcessMgrVersion = cpo.getPProcessDefinitionVersion();
        this.pActivityDefinitionId = cpo.getPActivityDefinitionId();
        this.pActivitySetDefinitionId = cpo.getPActivitySetDefinitionId();
        this.pProcessDefinitionId = cpo.getPProcessDefinitionId();
        this.pPackageId = cpo.getPPackageId();
    }
}

