/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.Arrays;
import java.util.List;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.api.internal.usergroup.UserGroupManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;

public class UserGroupAdmin
implements UserGroupAdministration {
    UserGroupManager ugm;
    private CallbackUtilities cus = SharkEngineManager.getInstance().getCallbackUtilities();
    private String userId = "Unknown";

    protected UserGroupAdmin() {
        this.ugm = SharkEngineManager.getInstance().getUserGroupManager();
    }

    public void connect(String userId) {
        this.userId = userId;
    }

    public String[] getAllGroupnames() throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllGroupnames(t);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllGroupnames(UserTransaction t) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllGroupnames(t);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllUsers() throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllUsers(t);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllUsers(UserTransaction t) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllUsers(t);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllUsers(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllUsers(t, groupName);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllUsers(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllUsers(t, groupName);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllUsers(String[] groupNames) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllUsers(t, groupNames);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllUsers(UserTransaction t, String[] groupNames) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllUsers(t, Arrays.asList(groupNames));
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllImmediateUsers(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllImmediateUsers(t, groupName);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllImmediateUsers(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllImmediateUsers(t, groupName);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllSubgroups(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllSubgroups(t, groupName);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllSubgroups(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllSubgroups(t, groupName);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllSubgroups(String[] groupNames) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllSubgroups(t, groupNames);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllSubgroups(UserTransaction t, String[] groupNames) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllSubgroups(t, Arrays.asList(groupNames));
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String[] getAllImmediateSubgroups(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            String[] s;
            t = SharkUtilities.createUserTransaction();
            String[] stringArray = s = this.getAllImmediateSubgroups(t, groupName);
            return stringArray;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String[] getAllImmediateSubgroups(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            List l = this.ugm.getAllImmediateSubgroups(t, groupName);
            String[] ret = new String[l.size()];
            l.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void createGroup(String groupName, String description) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.createGroup(t, groupName, description);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void createGroup(UserTransaction t, String groupName, String description) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.createGroup(t, groupName, description);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeGroup(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeGroup(t, groupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeGroup(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeGroup(t, groupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public boolean doesGroupExist(String groupName) throws BaseException {
        boolean ret = false;
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            boolean bl = ret = this.doesGroupExist(t, groupName);
            return bl;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public boolean doesGroupExist(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            boolean ret = this.ugm.doesGroupExist(t, groupName);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public boolean doesGroupBelongToGroup(String groupName, String subgroupName) throws BaseException {
        boolean ret = false;
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            boolean bl = ret = this.doesGroupBelongToGroup(t, groupName, subgroupName);
            return bl;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public boolean doesGroupBelongToGroup(UserTransaction t, String groupName, String subgroupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            boolean ret = this.ugm.doesGroupBelongToGroup(t, groupName, subgroupName);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void updateGroup(String groupName, String description) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.updateGroup(t, groupName, description);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void updateGroup(UserTransaction t, String groupName, String description) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.updateGroup(t, groupName, description);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void addGroupToGroup(String groupName, String subgroupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.addGroupToGroup(t, groupName, subgroupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void addGroupToGroup(UserTransaction t, String groupName, String subgroupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.addGroupToGroup(t, groupName, subgroupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeGroupFromGroup(String groupName, String subgroupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeGroupFromGroup(t, groupName, subgroupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeGroupFromGroup(UserTransaction t, String groupName, String subgroupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeGroupFromGroup(t, groupName, subgroupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeGroupTree(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeGroupTree(t, groupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeGroupTree(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeGroupTree(t, groupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeUsersFromGroupTree(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeUsersFromGroupTree(t, groupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeUsersFromGroupTree(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeUsersFromGroupTree(t, groupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void moveGroup(String currentParentGroup, String newParentGroup, String subgroupName) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.moveGroup(t, currentParentGroup, newParentGroup, subgroupName);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void moveGroup(UserTransaction t, String currentParentGroup, String newParentGroup, String subgroupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.moveGroup(t, currentParentGroup, newParentGroup, subgroupName);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getGroupDescription(String groupName) throws BaseException {
        UserTransaction t = null;
        try {
            String s;
            t = SharkUtilities.createUserTransaction();
            String string = s = this.getGroupDescription(t, groupName);
            return string;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String getGroupDescription(UserTransaction t, String groupName) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            String ret = this.ugm.getGroupDescription(t, groupName);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void addUserToGroup(String groupName, String username) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.addUserToGroup(t, groupName, username);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void addUserToGroup(UserTransaction t, String groupName, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.addUserToGroup(t, groupName, username);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeUserFromGroup(String groupName, String username) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeUserFromGroup(t, groupName, username);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeUserFromGroup(UserTransaction t, String groupName, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeUserFromGroup(t, groupName, username);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void moveUser(String currentGroup, String newGroup, String username) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.moveUser(t, currentGroup, newGroup, username);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void moveUser(UserTransaction t, String currentGroup, String newGroup, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.moveUser(t, currentGroup, newGroup, username);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public boolean doesUserBelongToGroup(String groupName, String username) throws BaseException {
        boolean ret = false;
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            boolean bl = ret = this.doesUserBelongToGroup(t, groupName, username);
            return bl;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public boolean doesUserBelongToGroup(UserTransaction t, String groupName, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            boolean ret = this.ugm.doesUserBelongToGroup(t, groupName, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void createUser(String groupName, String username, String password, String firstName, String lastName, String emailAddress) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.createUser(t, groupName, username, password, firstName, lastName, emailAddress);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void createUser(UserTransaction t, String groupName, String username, String password, String firstName, String lastName, String emailAddress) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.createUser(t, groupName, username, password, firstName, lastName, emailAddress);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeUser(String username) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.removeUser(t, username);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void removeUser(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.removeUser(t, username);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void updateUser(String username, String firstName, String lastName, String emailAddress) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.updateUser(t, username, firstName, lastName, emailAddress);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void updateUser(UserTransaction t, String username, String firstName, String lastName, String emailAddress) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.updateUser(t, username, firstName, lastName, emailAddress);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void setPassword(String username, String password) throws BaseException {
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            this.setPassword(t, username, password);
            SharkUtilities.commitUserTransaction(t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackUserTransaction(t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public void setPassword(UserTransaction t, String username, String password) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            this.ugm.setPassword(t, username, password);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public boolean doesUserExist(String username) throws BaseException {
        boolean ret = false;
        UserTransaction t = null;
        try {
            t = SharkUtilities.createUserTransaction();
            boolean bl = ret = this.doesUserExist(t, username);
            return bl;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public boolean doesUserExist(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            boolean ret = this.ugm.doesUserExist(t, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getUserRealName(String username) throws BaseException {
        UserTransaction t = null;
        try {
            String s;
            t = SharkUtilities.createUserTransaction();
            String string = s = this.getUserRealName(t, username);
            return string;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String getUserRealName(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            String ret = this.ugm.getUserRealName(t, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getUserFirstName(String username) throws BaseException {
        UserTransaction t = null;
        try {
            String s;
            t = SharkUtilities.createUserTransaction();
            String string = s = this.getUserFirstName(t, username);
            return string;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String getUserFirstName(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            String ret = this.ugm.getUserFirstName(t, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getUserLastName(String username) throws BaseException {
        UserTransaction t = null;
        try {
            String s;
            t = SharkUtilities.createUserTransaction();
            String string = s = this.getUserLastName(t, username);
            return string;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String getUserLastName(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            String ret = this.ugm.getUserLastName(t, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getUserEMailAddress(String username) throws BaseException {
        UserTransaction t = null;
        try {
            String s;
            t = SharkUtilities.createUserTransaction();
            String string = s = this.getUserEMailAddress(t, username);
            return string;
        }
        catch (RootException e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseUserTransaction(t);
        }
    }

    public String getUserEMailAddress(UserTransaction t, String username) throws BaseException {
        if (this.ugm == null) {
            throw new BaseException("Shark is configured to work without internal UserGroup API implementation!");
        }
        try {
            String ret = this.ugm.getUserEMailAddress(t, username);
            return ret;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }
}

