/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfbase.InvalidQuery;
import org.enhydra.shark.api.client.wfbase.NameMismatch;
import org.enhydra.shark.api.client.wfmodel.AlreadyRunning;
import org.enhydra.shark.api.client.wfmodel.AlreadySuspended;
import org.enhydra.shark.api.client.wfmodel.CannotChangeRequester;
import org.enhydra.shark.api.client.wfmodel.CannotReopen;
import org.enhydra.shark.api.client.wfmodel.CannotResume;
import org.enhydra.shark.api.client.wfmodel.CannotStart;
import org.enhydra.shark.api.client.wfmodel.CannotStop;
import org.enhydra.shark.api.client.wfmodel.CannotSuspend;
import org.enhydra.shark.api.client.wfmodel.HistoryNotAvailable;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.InvalidState;
import org.enhydra.shark.api.client.wfmodel.NotRunning;
import org.enhydra.shark.api.client.wfmodel.NotSuspended;
import org.enhydra.shark.api.client.wfmodel.ResultNotAvailable;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfEventAuditIterator;
import org.enhydra.shark.api.client.wfmodel.WfExecutionObject;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.client.wfmodel.how_closedType;
import org.enhydra.shark.api.client.wfmodel.while_openType;
import org.enhydra.shark.api.client.wfmodel.why_not_runningType;
import org.enhydra.shark.api.client.wfmodel.workflow_stateType;
import org.enhydra.shark.api.common.SharkConstants;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;

public class WfProcessWrapper
implements WfProcess {
    private String userAuth;
    private String mgrName;
    private String processId;

    protected WfProcessWrapper(String userAuth, String mgrName, String processId) {
        this.userAuth = userAuth;
        this.mgrName = mgrName;
        this.processId = processId;
    }

    public WfRequester requester() throws BaseException {
        WfRequester ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.requester((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfRequester requester(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_requester(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            WfRequester req = null;
            WfRequesterInternal requester = procInternal.requester(t);
            if (requester instanceof WfActivityInternal) {
                WfActivityInternal act = (WfActivityInternal)requester;
                req = SharkEngineManager.getInstance().getObjectFactory().createActivityWrapper(this.userAuth, act.manager_name(t), act.process_id(t), act.key(t));
            } else {
                WfRequester r = requester.getExternalRequester(t);
                if (r != null) {
                    req = r;
                } else {
                    String reqUname = requester.getResourceRequesterUsername(t);
                    req = SharkEngineManager.getInstance().getObjectFactory().createRequesterWrapper(this.userAuth, reqUname);
                }
            }
            return req;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void set_requester(WfRequester new_value) throws BaseException, CannotChangeRequester {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_requester((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotChangeRequester) {
                throw (CannotChangeRequester)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_requester(SharkTransaction t, WfRequester new_value) throws BaseException, CannotChangeRequester {
        WfRequesterInternal requester;
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_set_requester(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((requester = procInternal.requester(t)) instanceof WfActivityInternal) {
            throw new CannotChangeRequester("Can't change requester for a process instantiated as a subflow!");
        }
        String extReqClassName = null;
        if (new_value != null) {
            extReqClassName = new_value.getClass().getName();
        }
        procInternal.setExternalRequesterClassName(t, extReqClassName);
    }

    public int how_many_step() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_step((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_step(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_how_many_step(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.how_many_step(t);
    }

    public WfActivityIterator get_iterator_step() throws BaseException {
        WfActivityIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_step((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivityIterator get_iterator_step(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_get_iterator_step(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createActivityIteratorWrapper(t, this.userAuth, this.processId);
    }

    public WfActivity[] get_sequence_step(int max_number) throws BaseException {
        WfActivity[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_step((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivity[] get_sequence_step(SharkTransaction t, int max_number) throws BaseException {
        List alist;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_get_sequence_step(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (alist = SharkUtilities.createProcessActivityWrappers(t, this.userAuth, this.processId)).size() || max_number <= 0) {
            max_number = alist.size();
        }
        WfActivity[] ret = new WfActivity[max_number];
        alist.subList(0, max_number).toArray(ret);
        return ret;
    }

    public boolean is_member_of_step(WfActivity member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_step((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_step(SharkTransaction t, WfActivity member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_is_member_of_step(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String pId = member.container(t).key(t);
        return pId.equals(this.processId);
    }

    public WfProcessMgr manager() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm == null) {
            return SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userAuth, this.mgrName);
        }
        WfProcessMgr ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.manager((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessMgr manager(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
                sm.check_process_manager(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createProcessMgrWrapper(this.userAuth, this.mgrName);
    }

    public Map result() throws BaseException, ResultNotAvailable {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.result((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof ResultNotAvailable) {
                throw (ResultNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map result(SharkTransaction t) throws BaseException, ResultNotAvailable {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_result(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.result(t);
    }

    public void start() throws BaseException, CannotStart, AlreadyRunning {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.start((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotStart) {
                throw (CannotStart)e;
            }
            if (e instanceof AlreadyRunning) {
                throw (AlreadyRunning)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void start(SharkTransaction t) throws BaseException, CannotStart, AlreadyRunning {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_start(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            procInternal.start(t);
        }
        catch (ToolAgentGeneralException tage) {
            throw new BaseException((Throwable)tage);
        }
    }

    public WfActivityIterator get_activities_in_state(String state) throws BaseException, InvalidState {
        WfActivityIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_activities_in_state((SharkTransaction)t, state);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof InvalidState) {
                throw (InvalidState)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfActivityIterator get_activities_in_state(SharkTransaction t, String state) throws BaseException, InvalidState {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_get_activities_in_state(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (!SharkConstants.possibleActivityStates.contains(state)) {
            throw new InvalidState("The activity state " + state + " is not valid - can't get activities in such state!");
        }
        WfActivityIterator ret = SharkEngineManager.getInstance().getObjectFactory().createActivityIteratorWrapper(t, this.userAuth, this.processId);
        try {
            ret.set_query_expression(t, "QUERY_STATE_ONLY()state.equals(\"" + state + "\")");
        }
        catch (InvalidQuery iq) {
            throw new BaseException((Throwable)iq);
        }
        return ret;
    }

    public workflow_stateType workflow_state() throws BaseException {
        workflow_stateType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.workflow_state((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public workflow_stateType workflow_state(SharkTransaction t) throws BaseException {
        String state;
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_workflow_state(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = procInternal.state(t)).startsWith("closed")) {
            return workflow_stateType.closed;
        }
        return workflow_stateType.open;
    }

    public while_openType while_open() throws BaseException {
        while_openType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.while_open((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public while_openType while_open(SharkTransaction t) throws BaseException {
        String state;
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_while_open(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = procInternal.state(t)).equals("open.running")) {
            return while_openType.running;
        }
        return while_openType.not_running;
    }

    public why_not_runningType why_not_running() throws BaseException {
        why_not_runningType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.why_not_running((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public why_not_runningType why_not_running(SharkTransaction t) throws BaseException {
        String state;
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_why_not_running(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = procInternal.state(t)).equals("open.not_running.suspended")) {
            return why_not_runningType.suspended;
        }
        return why_not_runningType.not_started;
    }

    public how_closedType how_closed() throws BaseException {
        how_closedType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_closed((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public how_closedType how_closed(SharkTransaction t) throws BaseException {
        String state;
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_how_closed(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if ((state = procInternal.state(t)).equals("closed.completed")) {
            return how_closedType.completed;
        }
        if (state.equals("closed.terminated")) {
            return how_closedType.terminated;
        }
        return how_closedType.aborted;
    }

    public String[] valid_states() throws BaseException {
        String[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.valid_states((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String[] valid_states(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_valid_states(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        List vs = SharkUtilities.valid_process_states(procInternal.state(t));
        String[] vss = new String[vs.size()];
        vs.toArray(vss);
        return vss;
    }

    public String state() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.state((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String state(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_state(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.state(t);
    }

    public void change_state(String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.change_state((SharkTransaction)t, new_state);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidState) {
                throw (InvalidState)e;
            }
            if (e instanceof TransitionNotAllowed) {
                throw (TransitionNotAllowed)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void change_state(SharkTransaction t, String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        String curState = procInternal.state(t);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_change_state(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t), curState, new_state);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (!SharkConstants.possibleProcessStates.contains(new_state)) {
            throw new InvalidState("Can't change process state to " + new_state + " - no such state!");
        }
        if (!SharkUtilities.valid_process_states(procInternal.state(t)).contains(new_state)) {
            throw new TransitionNotAllowed("Current process state is " + curState + " - can't change to state " + new_state + "!");
        }
        if (new_state.equals("closed.aborted")) {
            try {
                procInternal.abort(t);
            }
            catch (CannotStop cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        if (new_state.equals("closed.completed")) {
            throw new TransitionNotAllowed("Current process state is " + curState + " - can't change to state " + new_state + "!");
        }
        if (new_state.equals("closed.terminated")) {
            try {
                procInternal.terminate(t);
            }
            catch (CannotStop cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        if (new_state.equals("open.not_running.not_started")) {
            throw new TransitionNotAllowed("Current process state is " + curState + " - can't change to state " + new_state + "!");
        }
        if (new_state.equals("open.not_running.suspended")) {
            try {
                procInternal.suspend(t);
            }
            catch (AlreadySuspended as) {
                throw new TransitionNotAllowed((Throwable)as);
            }
            catch (CannotSuspend cns) {
                throw new TransitionNotAllowed((Throwable)cns);
            }
            catch (NotRunning nr) {
                throw new TransitionNotAllowed((Throwable)nr);
            }
        }
        try {
            procInternal.start(t);
        }
        catch (CannotStart cns) {
            throw new TransitionNotAllowed((Throwable)cns);
        }
        catch (AlreadyRunning ar) {
            throw new TransitionNotAllowed((Throwable)ar);
        }
        catch (ToolAgentGeneralException tage) {
            throw new BaseException((Throwable)tage);
        }
    }

    public String name() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.name((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String name(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_name(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.name(t);
    }

    public void set_name(String new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_name((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_name(SharkTransaction t, String new_value) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_set_name(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.set_name(t, new_value);
    }

    public String key() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm == null) {
            return this.processId;
        }
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.key((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String key(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_key(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.processId;
    }

    public String description() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.description((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String description(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_description(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.description(t);
    }

    public void set_description(String new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_description((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_description(SharkTransaction t, String new_value) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_set_description(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.set_description(t, new_value);
    }

    public Map process_context() throws BaseException {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.process_context((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map process_context(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_process_context(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.process_context(t);
    }

    public void set_process_context(Map new_value) throws BaseException, InvalidData, UpdateNotAllowed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_process_context((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof InvalidData) {
                throw (InvalidData)e;
            }
            if (e instanceof UpdateNotAllowed) {
                throw (UpdateNotAllowed)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_process_context(SharkTransaction t, Map new_value) throws BaseException, InvalidData, UpdateNotAllowed {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_set_process_context(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.set_process_context(t, new_value);
    }

    public short priority() throws BaseException {
        short ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.priority((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public short priority(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_priority(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.priority(t);
    }

    public void set_priority(short new_value) throws BaseException {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_priority((SharkTransaction)t, new_value);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_priority(SharkTransaction t, short new_value) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_set_priority(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.set_priority(t, new_value);
    }

    public void resume() throws BaseException, CannotResume, NotSuspended {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.resume((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotResume) {
                throw (CannotResume)e;
            }
            if (e instanceof NotSuspended) {
                throw (NotSuspended)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void resume(SharkTransaction t) throws BaseException, CannotResume, NotSuspended {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_resume(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.resume(t);
    }

    public void suspend() throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.suspend((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotSuspend) {
                throw (CannotSuspend)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof AlreadySuspended) {
                throw (AlreadySuspended)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void suspend(SharkTransaction t) throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_suspend(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.suspend(t);
    }

    public void terminate() throws BaseException, CannotStop, NotRunning {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.terminate((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotStop) {
                throw (CannotStop)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void terminate(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_terminate(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.terminate(t);
    }

    public void abort() throws BaseException, CannotStop, NotRunning {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.abort((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotStop) {
                throw (CannotStop)((Object)e);
            }
            if (e instanceof NotRunning) {
                throw (NotRunning)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void abort(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_abort(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        procInternal.abort(t);
    }

    public void reopen() throws BaseException, CannotReopen {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.reopen((SharkTransaction)t);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof CannotReopen) {
                throw (CannotReopen)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void reopen(SharkTransaction t) throws BaseException, CannotReopen {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        procInternal.reopen(t);
    }

    public int how_many_history() throws BaseException, HistoryNotAvailable {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_history((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_history(SharkTransaction t) throws BaseException, HistoryNotAvailable {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_how_many_history(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null == eam) {
                return 0;
            }
            return eam.restoreProcessHistory(this.processId, t).size();
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public WfEventAuditIterator get_iterator_history(String query, Map names_in_query) throws BaseException, HistoryNotAvailable {
        WfEventAuditIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_history((SharkTransaction)t, query, names_in_query);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAuditIterator get_iterator_history(SharkTransaction t, String query, Map names_in_query) throws BaseException, HistoryNotAvailable {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_get_iterator_history(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfEventAuditIterator ret = SharkEngineManager.getInstance().getObjectFactory().createEventAuditIteratorWrapper(t, this.userAuth, this.processId);
        try {
            ret.set_query_expression(t, query);
            ret.set_names_in_expression(t, names_in_query);
        }
        catch (NameMismatch e) {
            throw new HistoryNotAvailable((Throwable)e);
        }
        catch (InvalidQuery e) {
            throw new HistoryNotAvailable((Throwable)e);
        }
        return ret;
    }

    public WfEventAudit[] get_sequence_history(int max_number) throws BaseException, HistoryNotAvailable {
        WfEventAudit[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_history((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof HistoryNotAvailable) {
                throw (HistoryNotAvailable)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit[] get_sequence_history(SharkTransaction t, int max_number) throws BaseException, HistoryNotAvailable {
        List history;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_get_sequence_history(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (history = SharkUtilities.createProcessHistoryEvents(t, this.userAuth, this.processId)).size() || max_number <= 0) {
            max_number = history.size();
        }
        WfEventAudit[] eas = new WfEventAudit[max_number];
        history.subList(0, max_number).toArray(eas);
        return eas;
    }

    public boolean is_member_of_history(WfExecutionObject member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_history((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_history(SharkTransaction t, WfExecutionObject member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
            try {
                sm.check_process_is_member_of_history(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        boolean ret = false;
        List history = SharkUtilities.createProcessHistoryEvents(t, this.userAuth, this.processId);
        for (WfEventAudit ea : history) {
            if (member instanceof WfActivity) {
                WfActivity act = (WfActivity)member;
                if (!act.container(t).key(t).equals(ea.process_key()) || !act.key(t).equals(ea.activity_key())) continue;
                ret = true;
                break;
            }
            if (!member.key(t).equals(ea.process_key())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public UtcT last_state_time() throws BaseException {
        UtcT ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.last_state_time((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public UtcT last_state_time(SharkTransaction t) throws BaseException {
        WfProcessInternal procInternal = WfProcessWrapper.getProcessImpl(t, this.processId);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_process_last_state_time(t, this.processId, this.userAuth, procInternal.requester(t).getResourceRequesterUsername(t));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return procInternal.last_state_time(t);
    }

    public String toString() {
        return "[key=" + this.processId + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfProcess)) {
            return false;
        }
        WfProcess proc = (WfProcess)obj;
        try {
            if (obj instanceof WfProcessWrapper) {
                return ((WfProcessWrapper)obj).processId.equals(this.processId);
            }
            return proc.key().equals(this.processId);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static WfProcessInternal getProcessImpl(SharkTransaction t, String procId) throws BaseException {
        WfProcessInternal proc = SharkUtilities.getProcess(t, procId);
        if (proc == null) {
            throw new BaseException("Process does not exist");
        }
        return proc;
    }
}

