/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.List;
import java.util.Map;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.WfProcessWrapper;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidRequester;
import org.enhydra.shark.api.client.wfmodel.NotEnabled;
import org.enhydra.shark.api.client.wfmodel.RequesterRequired;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfProcessIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcessMgr;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.client.wfmodel.process_mgr_stateType;
import org.enhydra.shark.api.internal.security.SecurityManager;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;

public class WfProcessMgrWrapper
implements WfProcessMgr {
    private String userAuth;
    private String name;

    protected WfProcessMgrWrapper(String userAuth, String name) throws BaseException {
        this.userAuth = userAuth;
        this.name = name;
    }

    public int how_many_process() throws BaseException {
        int ret = -1;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.how_many_process((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public int how_many_process(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_how_many_process(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            return SharkEngineManager.getInstance().getInstancePersistenceManager().getAllProcessesForMgr(this.name, t).size();
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public WfProcessIterator get_iterator_process() throws BaseException {
        WfProcessIterator ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_iterator_process((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcessIterator get_iterator_process(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_get_iterator_process(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return SharkEngineManager.getInstance().getObjectFactory().createProcessIteratorWrapper(t, this.userAuth, this.name);
    }

    public WfProcess[] get_sequence_process(int max_number) throws BaseException {
        WfProcess[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_sequence_process((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess[] get_sequence_process(SharkTransaction t, int max_number) throws BaseException {
        List processes;
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_get_sequence_process(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (max_number > (processes = SharkUtilities.createProcessMgrsProcessWrappers(t, this.userAuth, this.name)).size() || max_number <= 0) {
            max_number = processes.size();
        }
        WfProcess[] procs = new WfProcessWrapper[max_number];
        processes.subList(0, max_number).toArray(procs);
        return procs;
    }

    public boolean is_member_of_process(WfProcess member) throws BaseException {
        boolean ret = false;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.is_member_of_process((SharkTransaction)t, member);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public boolean is_member_of_process(SharkTransaction t, WfProcess member) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_is_member_of_process(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        String mgrName = member.manager(t).name(t);
        return mgrName.equals(this.name);
    }

    public process_mgr_stateType process_mgr_state() throws BaseException {
        process_mgr_stateType ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.process_mgr_state((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public process_mgr_stateType process_mgr_state(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_process_mgr_state(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).process_mgr_state(t);
    }

    public void set_process_mgr_state(process_mgr_stateType new_state) throws BaseException, TransitionNotAllowed {
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            this.set_process_mgr_state((SharkTransaction)t, new_state);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof TransitionNotAllowed) {
                throw (TransitionNotAllowed)((Object)e);
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
    }

    public void set_process_mgr_state(SharkTransaction t, process_mgr_stateType new_state) throws BaseException, TransitionNotAllowed {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_set_process_mgr_state(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        WfProcessMgrInternal mgrInternal = WfProcessMgrWrapper.getProcessMgrImpl(t, this.name);
        mgrInternal.set_process_mgr_state(t, new_state);
    }

    public String name() throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm == null) {
            return this.name;
        }
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.name((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String name(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_name(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.name;
    }

    public String description() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.description((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String description(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_description(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).description(t);
    }

    public String category() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.category((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String category(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_category(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).category(t);
    }

    public String version() throws BaseException {
        String ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.version((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public String version(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_version(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).version(t);
    }

    public Map context_signature() throws BaseException {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.context_signature((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map context_signature(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_context_signature(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).context_signature(t);
    }

    public Map result_signature() throws BaseException {
        Map ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.result_signature((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public Map result_signature(SharkTransaction t) throws BaseException {
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_result_signature(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return WfProcessMgrWrapper.getProcessMgrImpl(t, this.name).result_signature(t);
    }

    public WfProcess create_process(WfRequester requester) throws BaseException, NotEnabled, InvalidRequester, RequesterRequired {
        WfProcess ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.create_process((SharkTransaction)t, requester);
            SharkUtilities.commitTransaction((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.rollbackTransaction((SharkTransaction)t, e);
            if (e instanceof NotEnabled) {
                throw (NotEnabled)e;
            }
            if (e instanceof InvalidRequester) {
                throw (InvalidRequester)e;
            }
            if (e instanceof RequesterRequired) {
                throw (RequesterRequired)e;
            }
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfProcess create_process(SharkTransaction t, WfRequester requester) throws BaseException, NotEnabled, InvalidRequester, RequesterRequired {
        WfProcessMgrInternal mgr = WfProcessMgrWrapper.getProcessMgrImpl(t, this.name);
        SecurityManager sm = SharkEngineManager.getInstance().getSecurityManager();
        if (sm != null) {
            try {
                sm.check_processmgr_create_process(t, this.name, this.userAuth, SharkUtilities.getProcessMgrPkgId(this.name), SharkUtilities.getProcessMgrVersion(this.name), SharkUtilities.getProcessMgrProcDefId(this.name));
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (mgr.category(t).equalsIgnoreCase("PRIVATE")) {
            throw new NotEnabled("The process definition defines only PRIVATE access!");
        }
        WfRequesterInternal req = SharkEngineManager.getInstance().getObjectFactory().createDefaultRequester(this.userAuth, requester);
        WfProcessInternal procInternal = mgr.create_process(t, req);
        WfProcess proc = SharkEngineManager.getInstance().getObjectFactory().createProcessWrapper(this.userAuth, procInternal.manager_name(t), procInternal.key(t));
        return proc;
    }

    public String toString() {
        return "[name=" + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfProcessMgr)) {
            return false;
        }
        WfProcessMgr mgr = (WfProcessMgr)obj;
        try {
            if (obj instanceof WfProcessMgrWrapper) {
                return ((WfProcessMgrWrapper)obj).name.equals(this.name);
            }
            return mgr.name().equals(this.name);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static WfProcessMgrInternal getProcessMgrImpl(SharkTransaction t, String name) throws BaseException {
        WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, name);
        if (mgr == null) {
            throw new BaseException("ProcessMgr does not exist");
        }
        return mgr;
    }
}

