/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.BaseIteratorWrapper;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfEventAuditIterator;
import org.enhydra.shark.api.internal.eventaudit.AssignmentEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.CreateProcessEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.DataEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.StateEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.transaction.SharkInternalTransaction;

public class WfEventAuditIteratorWrapper
extends BaseIteratorWrapper
implements WfEventAuditIterator {
    private String procId;
    private String actId;

    protected WfEventAuditIteratorWrapper(SharkTransaction t, String userAuth, String procId) throws BaseException {
        super(userAuth);
        this.procId = procId;
    }

    protected WfEventAuditIteratorWrapper(SharkTransaction t, String userAuth, String procId, String actId) throws BaseException {
        super(userAuth);
        this.procId = procId;
        this.actId = actId;
    }

    public WfEventAudit get_next_object() throws BaseException {
        WfEventAudit ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit get_next_object(SharkTransaction t) throws BaseException {
        return (WfEventAudit)super.getNextObject(t);
    }

    public WfEventAudit get_previous_object() throws BaseException {
        WfEventAudit ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_object((SharkTransaction)t);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit get_previous_object(SharkTransaction t) throws BaseException {
        return (WfEventAudit)super.getPreviousObject(t);
    }

    public WfEventAudit[] get_next_n_sequence(int max_number) throws BaseException {
        WfEventAudit[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_next_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit[] get_next_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getNextNSequence(t, max_number);
        WfEventAudit[] ret = new WfEventAudit[l.size()];
        l.toArray(ret);
        return ret;
    }

    public WfEventAudit[] get_previous_n_sequence(int max_number) throws BaseException {
        WfEventAudit[] ret = null;
        SharkInternalTransaction t = null;
        try {
            t = SharkUtilities.createTransaction();
            ret = this.get_previous_n_sequence((SharkTransaction)t, max_number);
        }
        catch (RootException e) {
            SharkUtilities.emptyCaches((SharkTransaction)t);
            if (e instanceof BaseException) {
                throw (BaseException)((Object)e);
            }
            throw new BaseException((Throwable)e);
        }
        finally {
            SharkUtilities.releaseTransaction((SharkTransaction)t);
        }
        return ret;
    }

    public WfEventAudit[] get_previous_n_sequence(SharkTransaction t, int max_number) throws BaseException {
        List l = super.getPreviousNSequence(t, max_number);
        WfEventAudit[] ret = new WfEventAudit[l.size()];
        l.toArray(ret);
        return ret;
    }

    @Override
    protected void fillObjectList(SharkTransaction t) throws BaseException {
        if (this.objectList != null) {
            return;
        }
        try {
            ArrayList<Object> events = new ArrayList<Object>();
            EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
            if (null != eam) {
                ArrayList l = new ArrayList();
                if (this.actId == null) {
                    l.addAll(eam.restoreProcessHistory(this.procId, t));
                } else {
                    l.addAll(eam.restoreActivityHistory(this.procId, this.actId, t));
                }
                Evaluator evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, this.queryGrammar);
                boolean eval = this.queryExpression != null && this.queryExpression.trim().length() > 0;
                for (int i = 0; i < l.size(); ++i) {
                    EventAuditPersistenceInterface po = (EventAuditPersistenceInterface)l.get(i);
                    boolean toAdd = true;
                    if (eval) {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("time_stamp", new Long(po.getUTCTime()));
                        context.put("event_type", po.getType());
                        context.put("activity_key", po.getActivityId());
                        context.put("activity_name", po.getActivityName());
                        context.put("process_key", po.getProcessId());
                        context.put("process_name", po.getProcessName());
                        context.put("process_mgr_name", po.getProcessDefinitionName());
                        context.put("process_mgr_version", po.getProcessDefinitionVersion());
                        context.put("package_id", po.getPackageId());
                        context.put("process_definition_id", po.getProcessDefinitionId());
                        context.put("activity_set_definition_id", po.getActivitySetDefinitionId());
                        context.put("activity_definition_id", po.getActivityDefinitionId());
                        if (po instanceof CreateProcessEventAuditPersistenceInterface) {
                            CreateProcessEventAuditPersistenceInterface cpo = (CreateProcessEventAuditPersistenceInterface)po;
                            context.put("p_activity_key", cpo.getPActivityId());
                            context.put("p_process_key", cpo.getPProcessId());
                            context.put("p_process_name", cpo.getPProcessName());
                            context.put("p_process_mgr_name", cpo.getPProcessDefinitionName());
                            context.put("p_process_mgr_version", cpo.getPProcessDefinitionVersion());
                            context.put("p_package_id", cpo.getPPackageId());
                            context.put("p_process_definition_id", cpo.getPProcessDefinitionId());
                            context.put("p_activity_set_definition_id", cpo.getPActivitySetDefinitionId());
                            context.put("p_activity_definition_id", cpo.getPActivityDefinitionId());
                        } else if (po instanceof DataEventAuditPersistenceInterface) {
                            Map nd;
                            Object value;
                            String name;
                            Map od;
                            DataEventAuditPersistenceInterface dpo = (DataEventAuditPersistenceInterface)po;
                            if (this.queryExpression.indexOf("old_data") != -1 && (od = dpo.getOldData()) != null) {
                                for (Map.Entry me : od.entrySet()) {
                                    try {
                                        name = "old_data" + me.getKey().toString();
                                        value = me.getValue();
                                        context.put(name, value);
                                    }
                                    catch (Exception ex) {
                                        throw new BaseException((Throwable)ex);
                                    }
                                }
                            }
                            if (this.queryExpression.indexOf("new_data_") != -1 && (nd = dpo.getNewData()) != null) {
                                for (Map.Entry me : nd.entrySet()) {
                                    try {
                                        name = "new_data_" + me.getKey().toString();
                                        value = me.getValue();
                                        context.put(name, value);
                                    }
                                    catch (Exception ex) {
                                        throw new BaseException((Throwable)ex);
                                    }
                                }
                            }
                        } else if (po instanceof StateEventAuditPersistenceInterface) {
                            StateEventAuditPersistenceInterface spo = (StateEventAuditPersistenceInterface)po;
                            context.put("old_state", spo.getOldState());
                            context.put("new_state", spo.getNewState());
                        } else if (po instanceof AssignmentEventAuditPersistenceInterface) {
                            AssignmentEventAuditPersistenceInterface apo = (AssignmentEventAuditPersistenceInterface)po;
                            context.put("old_resource_key", apo.getOldResourceUsername());
                            context.put("new_resource_key", apo.getNewResourceUsername());
                            context.put("is_accepted", new Boolean(apo.getIsAccepted()));
                        }
                        toAdd = evaluator.evaluateCondition(t, this.queryExpression, context);
                    }
                    if (!toAdd) continue;
                    if (po instanceof CreateProcessEventAuditPersistenceInterface) {
                        events.add(SharkEngineManager.getInstance().getObjectFactory().createCreateProcessEventAuditWrapper(this.userAuth, (CreateProcessEventAuditPersistenceInterface)po));
                        continue;
                    }
                    if (po instanceof DataEventAuditPersistenceInterface) {
                        events.add(SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(this.userAuth, (DataEventAuditPersistenceInterface)po));
                        continue;
                    }
                    if (po instanceof StateEventAuditPersistenceInterface) {
                        events.add(SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(this.userAuth, (StateEventAuditPersistenceInterface)po));
                        continue;
                    }
                    if (!(po instanceof AssignmentEventAuditPersistenceInterface)) continue;
                    events.add(SharkEngineManager.getInstance().getObjectFactory().createAssignmentEventAuditWrapper(this.userAuth, (AssignmentEventAuditPersistenceInterface)po));
                }
            }
            this.setObjectList(events);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

