/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.SharkEngineManager;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.WfExecutionObjectImpl;
import org.enhydra.shark.api.ParticipantMappingTransaction;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.AlreadyRunning;
import org.enhydra.shark.api.client.wfmodel.AlreadySuspended;
import org.enhydra.shark.api.client.wfmodel.CannotAcceptSuspended;
import org.enhydra.shark.api.client.wfmodel.CannotComplete;
import org.enhydra.shark.api.client.wfmodel.CannotReopen;
import org.enhydra.shark.api.client.wfmodel.CannotResume;
import org.enhydra.shark.api.client.wfmodel.CannotStart;
import org.enhydra.shark.api.client.wfmodel.CannotStop;
import org.enhydra.shark.api.client.wfmodel.CannotSuspend;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.InvalidPerformer;
import org.enhydra.shark.api.client.wfmodel.InvalidState;
import org.enhydra.shark.api.client.wfmodel.NotRunning;
import org.enhydra.shark.api.client.wfmodel.NotSuspended;
import org.enhydra.shark.api.client.wfmodel.ResultNotAvailable;
import org.enhydra.shark.api.client.wfmodel.TransitionNotAllowed;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfDataEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.api.common.DeadlineInfo;
import org.enhydra.shark.api.internal.assignment.PerformerData;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ActivityVariablePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.DeadlinePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.limitagent.LimitAgentException;
import org.enhydra.shark.api.internal.limitagent.LimitAgentManager;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMap;
import org.enhydra.shark.api.internal.partmappersistence.ParticipantMappingManager;
import org.enhydra.shark.api.internal.scripting.Evaluator;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.api.internal.usergroup.UserGroupManager;
import org.enhydra.shark.api.internal.working.ToolAgentManager;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.api.internal.working.WfAssignmentInternal;
import org.enhydra.shark.api.internal.working.WfExecutionObjectInternal;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.api.internal.working.WfProcessMgrInternal;
import org.enhydra.shark.api.internal.working.WfRequesterInternal;
import org.enhydra.shark.api.internal.working.WfResourceInternal;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ActualParameter;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.Deadline;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.Responsible;
import org.enhydra.shark.xpdl.elements.SubFlow;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class WfActivityImpl
extends WfExecutionObjectImpl
implements WfActivityInternal {
    private String mgrName;
    private String processId;
    private Activity activityDefinition;
    private WorkflowProcess processDefinition;
    private String activitySetDefinitionId;
    private String activityDefinitionId;
    private String blockActivityId;
    private boolean accepted = false;
    private String resourceUsername;
    private Map activitiesProcessContext;
    private String performerId;
    private boolean isSubflowSynchronous = true;
    private Set resultVariableIds;
    private Evaluator evaluator;
    private WfProcessInternal process;
    private long acceptedTime = 0x3FFFFFFFFFFFFFFFL;
    private long activatedTime = 0x3FFFFFFFFFFFFFFFL;
    protected List assignmentResourceIds;
    protected Set variableIdsToPersist = new HashSet();
    protected Thread startSubflowThread = null;
    protected WfActivityInternal blockActivity = null;
    protected WfActivityInternal[] previousActivities = new WfActivityInternal[0];
    protected ToolAgentGeneralException toolAgentException = null;
    protected String exceptionName = null;
    protected List deadlinesInfo;
    private boolean justCreated = false;
    private boolean justCreatedVariables = false;
    private boolean justCreatedDeadlines = false;

    protected WfActivityImpl(SharkTransaction t, WfProcessInternal process, String key, String activitySetDefId, String activityDefId, WfActivityInternal blockActivity) throws BaseException {
        this(t, process, key, activitySetDefId, activityDefId, blockActivity, null);
    }

    protected WfActivityImpl(SharkTransaction t, WfProcessInternal process, String key, String activitySetDefId, String activityDefId, WfActivityInternal blockActivity, WfActivityInternal[] previousActivities) throws BaseException {
        this.mgrName = process.manager_name(t);
        this.processId = process.key(t);
        this.key = key;
        this.process = process;
        this.activityDefinitionId = activityDefId;
        this.blockActivity = blockActivity;
        this.justCreated = true;
        this.justCreatedVariables = true;
        this.justCreatedDeadlines = true;
        WorkflowProcess wp = this.getProcessDefinition(t);
        if (this.blockActivity != null) {
            this.blockActivityId = this.blockActivity.key(t);
            this.activitySetDefinitionId = activitySetDefId;
        }
        if (previousActivities != null) {
            this.previousActivities = previousActivities;
        }
        this.getActivityDefinition(t);
        this.name = this.activityDefinition.getName();
        if (this.name.equals("")) {
            this.name = this.getActivityDefinition(t).getId();
        }
        this.description = this.activityDefinition.getDescription();
        if (this.description != null && this.description.length() > 254) {
            this.description = this.description.substring(0, 253);
        }
        try {
            this.priority = Integer.valueOf(this.activityDefinition.getPriority()).shortValue();
        }
        catch (Exception ex) {
            this.priority = (short)3;
        }
        this.lastStateTime = System.currentTimeMillis();
        this.lastStateEventAudit = SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(t, (WfExecutionObjectInternal)this, "activityStateChanged", null, this.state);
        this.activitiesProcessContext = this.getActivityContext(t);
        this.resultVariableIds = new HashSet();
        if (this.activitiesProcessContext.size() > 0) {
            this.variableIdsToPersist.addAll(this.getContext(t).keySet());
            if (SharkEngineManager.getInstance().getEventAuditManager() != null) {
                SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(t, (WfExecutionObjectInternal)this, "activityContextChanged", null, new HashMap(this.activitiesProcessContext));
            }
        }
        this.assignmentResourceIds = new ArrayList();
    }

    protected WfActivityImpl(ActivityPersistenceInterface po, WfProcessInternal proc) {
        this.process = proc;
        this.restore(po);
    }

    public List getAssignmentResourceIds(SharkTransaction t) throws BaseException {
        if (this.assignmentResourceIds == null) {
            try {
                this.assignmentResourceIds = new ArrayList();
                boolean createAssignments = Boolean.valueOf(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.createAssignments", "true"));
                if (createAssignments) {
                    List l = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllAssignmentsForActivity(this.key, t);
                    for (int i = 0; i < l.size(); ++i) {
                        AssignmentPersistenceInterface po = (AssignmentPersistenceInterface)l.get(i);
                        this.assignmentResourceIds.add(po.getResourceUsername());
                    }
                }
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        return this.assignmentResourceIds;
    }

    public WfProcessInternal container(SharkTransaction t) throws BaseException {
        return this.process;
    }

    public Map result(SharkTransaction t) throws BaseException, ResultNotAvailable {
        HashMap resultMap = new HashMap();
        for (Map.Entry me : this.resultMap(t).entrySet()) {
            try {
                resultMap.put(me.getKey(), MiscUtilities.cloneWRD(me.getValue()));
            }
            catch (Throwable thr) {
                throw new BaseException(thr);
            }
        }
        return resultMap;
    }

    private Map resultMap(SharkTransaction t) throws BaseException {
        HashMap resultMap = new HashMap();
        for (Object vId : this.getResultVariableIds(t)) {
            resultMap.put(vId, this.getContext(t).get(vId));
        }
        return resultMap;
    }

    public void set_result(SharkTransaction t, Map results) throws BaseException, InvalidData {
        try {
            this.setProcessContext(t, results, "activityResultChanged");
        }
        catch (InvalidData id) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Activity" + this.toString() + " - failed to set the activity result");
            throw id;
        }
        catch (BaseException be) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Activity" + this.toString() + " - failed to set the activity result");
            throw be;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void complete(SharkTransaction t) throws BaseException, CannotComplete {
        int type = this.getActivityDefinition(t).getActivityType();
        switch (type) {
            case 0: {
                throw new BaseException("Subflow activity can be finished only automatically");
            }
            case 1: {
                this.finish(t);
                break;
            }
            case 2: {
                int hmt = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getTools().size();
                if (hmt > 0) {
                    if (this.getActivityDefinition(t).getActivityStartMode() == 1) {
                        boolean shouldFinishImmediatelly = this.getActivityDefinition(t).getActivityFinishMode() == 0;
                        try {
                            if (shouldFinishImmediatelly || this.getAssignmentResourceIds(t).size() > 0) {
                                this.runTool(t);
                            }
                        }
                        catch (Exception ex) {
                            if (ex instanceof ToolAgentGeneralException) {
                                this.toolAgentException = (ToolAgentGeneralException)((Object)ex);
                                this.finishImproperlyAndNotifyProcess(t, SharkUtilities.extractExceptionName(this.toolAgentException));
                                return;
                            }
                            throw new BaseException((Throwable)ex);
                        }
                        if (shouldFinishImmediatelly || this.getAssignmentResourceIds(t).size() == 0) {
                            this.finish(t);
                        } else {
                            this.removeAssignments(t, true, true);
                        }
                        return;
                    }
                    this.finish(t);
                    break;
                }
                this.finish(t);
                break;
            }
            case 3: {
                throw new BaseException("Subflow activity can be finished only automatically");
            }
            case 4: {
                throw new BaseException("Block activity can be finished only automatically");
            }
        }
    }

    public void finish(SharkTransaction t) throws BaseException, CannotComplete {
        try {
            this.removeAssignments(t, true, true);
            this.change_state(t, "closed.completed");
            this.process.set_process_context(t, this.resultMap(t));
            this.process.activity_complete(t, (WfActivityInternal)this);
        }
        catch (InvalidState is) {
            throw new CannotComplete((Throwable)is);
        }
        catch (TransitionNotAllowed tna) {
            throw new CannotComplete((Throwable)tna);
        }
        catch (InvalidData e) {
            throw new CannotComplete("Invalid result data was passed");
        }
        catch (ResultNotAvailable rne) {
            throw new CannotComplete("Result of activity is not available");
        }
        catch (UpdateNotAllowed una) {
            throw new CannotComplete("Process context update is not allowed");
        }
        catch (Exception ex) {
            if (ex instanceof BaseException) {
                throw (BaseException)((Object)ex);
            }
            throw new BaseException((Throwable)ex);
        }
    }

    protected void change_state(SharkTransaction t, String new_state) throws BaseException, InvalidState, TransitionNotAllowed {
        LimitAgentManager mgr;
        if (!SharkUtilities.valid_activity_states(this.state(t)).contains(new_state)) {
            throw new TransitionNotAllowed("Current state is " + this.state + ", can't change to state " + new_state + "!");
        }
        String oldState = this.state;
        this.state = new_state;
        this.lastStateTime = System.currentTimeMillis();
        try {
            this.persist(t);
        }
        catch (TransactionException te) {
            throw new BaseException((Throwable)te);
        }
        this.lastStateEventAudit = SharkEngineManager.getInstance().getObjectFactory().createStateEventAuditWrapper(t, (WfExecutionObjectInternal)this, "activityStateChanged", oldState, new_state);
        if (this.state.startsWith("closed") && (mgr = SharkEngineManager.getInstance().getLimitAgentManager()) != null) {
            try {
                mgr.notifyStop(this.processId, this.key);
            }
            catch (LimitAgentException e) {
                throw new BaseException((Throwable)e);
            }
        }
    }

    @Override
    public void set_process_context(SharkTransaction t, Map new_value) throws BaseException, InvalidData, UpdateNotAllowed {
        try {
            this.setProcessContext(t, new_value, "activityContextChanged");
        }
        catch (InvalidData id) {
            throw id;
        }
        catch (UpdateNotAllowed una) {
            throw una;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    private void setProcessContext(SharkTransaction t, Map newValue, String eventType) throws BaseException, InvalidData, UpdateNotAllowed, Exception {
        if (newValue == null) {
            throw new BaseException("new value is null");
        }
        HashMap oldValues = new HashMap();
        HashMap newChanged = new HashMap();
        for (Map.Entry me : newValue.entrySet()) {
            String id = (String)me.getKey();
            Object val = me.getValue();
            if (this.getContext(t).containsKey(id)) {
                Object oldVal = this.getContext(t).get(id);
                if (SharkUtilities.checkDataType(t, this.getProcessDefinition(t), id, oldVal, val)) {
                    if ((oldVal == null || oldVal.equals(val)) && (oldVal != null || val == null)) continue;
                    oldValues.put(id, oldVal);
                    newChanged.put(id, val);
                    continue;
                }
                throw new InvalidData("Invalid data type for activity variable " + id);
            }
            throw new UpdateNotAllowed("Context attribute " + id + " does not exist in the activity context - adding new attributes to activity context is not allowed");
        }
        if (newChanged.size() > 0 || eventType.equals("activityResultChanged")) {
            this.getContext(t).putAll(newChanged);
            HashMap toPersist = new HashMap(newChanged);
            HashMap newSRVars = null;
            if (eventType.equals("activityResultChanged")) {
                newSRVars = new HashMap();
                HashSet oldRVIds = new HashSet(this.getResultVariableIds(t));
                this.getResultVariableIds(t).addAll(newValue.keySet());
                HashSet newRVIds = new HashSet(this.getResultVariableIds(t));
                newRVIds.removeAll(oldRVIds);
                for (String id : newRVIds) {
                    Object val = this.getContext(t).get(id);
                    toPersist.put(id, val);
                    newSRVars.put(id, val);
                }
            }
            this.variableIdsToPersist.addAll(toPersist.keySet());
            this.persistActivityContext(t);
            if (newChanged.size() > 0 && SharkEngineManager.getInstance().getEventAuditManager() != null) {
                boolean persistOldEventAuditData = new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("PERSIST_OLD_EVENT_AUDIT_DATA", "true"));
                if (!persistOldEventAuditData) {
                    oldValues = null;
                }
                SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(t, (WfExecutionObjectInternal)this, "activityContextChanged", oldValues, newChanged);
            }
            if (newSRVars != null && newSRVars.size() > 0 && SharkEngineManager.getInstance().getEventAuditManager() != null) {
                boolean persistOldEventAuditData = new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("PERSIST_OLD_EVENT_AUDIT_DATA", "true"));
                if (!persistOldEventAuditData) {
                    oldValues = null;
                }
                SharkEngineManager.getInstance().getObjectFactory().createDataEventAuditWrapper(t, (WfExecutionObjectInternal)this, eventType, null, newSRVars);
            }
        }
    }

    @Override
    public void resume(SharkTransaction t) throws BaseException, CannotResume, NotSuspended {
        block14: {
            int type;
            block13: {
                type = this.getActivityDefinition(t).getActivityType();
                if (!this.state(t).equals("open.not_running.suspended")) {
                    throw new NotSuspended("Can't resume activity that is not suspended");
                }
                if (this.process.state(t).equals("open.not_running.suspended")) {
                    throw new CannotResume("Can't resume activity which process is suspended");
                }
                if (this.blockActivityId != null && this.block_activity(t).state(t).equals("open.not_running.suspended")) {
                    throw new CannotResume("Can't resume activity which block is suspended");
                }
                try {
                    if (this.accepted || type == 4 || type == 3) {
                        this.change_state(t, "open.running");
                    } else {
                        this.change_state(t, "open.not_running.not_started");
                    }
                }
                catch (Exception ex) {
                    throw new CannotResume((Throwable)ex);
                }
                if (type != 3) break block13;
                if (!this.isSubflowSynchronous) break block14;
                WfProcessInternal performer = this.getPerformer(t);
                if (performer == null) {
                    String refSbflw;
                    SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
                    WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw = subflow.getId());
                    if (wp != null || this.performerId != null) {
                        throw new BaseException("Null performer of sync. subflow activity");
                    }
                    try {
                        SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().resume(t, this.performerId, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)));
                    }
                    catch (Exception ex) {
                        throw new BaseException((Throwable)ex);
                    }
                }
                if (!performer.state(t).equals("open.not_running.suspended")) break block14;
                performer.resume(t);
                break block14;
            }
            if (type == 4) {
                List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                for (WfActivityInternal act : actActs) {
                    if (!act.state(t).equals("open.not_running.suspended")) continue;
                    act.resume(t);
                }
            }
        }
    }

    @Override
    public void suspend(SharkTransaction t) throws BaseException, CannotSuspend, NotRunning, AlreadySuspended {
        block10: {
            int type;
            block9: {
                if (this.state(t).equals("open.not_running.suspended")) {
                    throw new AlreadySuspended("The activity is already suspended - can't suspend it twice!");
                }
                try {
                    this.change_state(t, "open.not_running.suspended");
                }
                catch (Exception ex) {
                    throw new CannotSuspend((Throwable)ex);
                }
                type = this.getActivityDefinition(t).getActivityType();
                if (type != 3) break block9;
                if (!this.isSubflowSynchronous) break block10;
                WfProcessInternal performer = this.getPerformer(t);
                if (performer == null) {
                    String refSbflw;
                    SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
                    WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw = subflow.getId());
                    if (wp != null || this.performerId != null) {
                        throw new BaseException("Null performer of sync. subflow activity");
                    }
                    try {
                        SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().suspend(t, this.performerId, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)));
                    }
                    catch (Exception ex) {
                        throw new BaseException((Throwable)ex);
                    }
                }
                String perfState = performer.state(t);
                if (!perfState.startsWith("open") || perfState.equals("open.not_running.suspended")) break block10;
                performer.suspend(t);
                break block10;
            }
            if (type == 4) {
                List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                for (WfActivityInternal act : actActs) {
                    String actState = act.state(t);
                    if (!actState.startsWith("open") || actState.equals("open.not_running.suspended")) continue;
                    act.suspend(t);
                }
            }
        }
    }

    public void terminateFromProcess(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.terminateActivity(t, true);
    }

    @Override
    public void terminate(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.terminateActivity(t, false);
    }

    protected void terminateActivity(SharkTransaction t, boolean fromProcess) throws BaseException, CannotStop, NotRunning {
        block13: {
            int type;
            block12: {
                String stateStr = "closed.terminated";
                if (!this.state(t).startsWith("open")) {
                    throw new CannotStop("The activity is already in the closed state - can't terminate it!");
                }
                this.removeAssignments(t, true, true);
                try {
                    this.change_state(t, stateStr);
                }
                catch (Exception ex) {
                    throw new CannotStop((Throwable)ex);
                }
                type = this.getActivityDefinition(t).getActivityType();
                if (type != 3) break block12;
                if (!this.isSubflowSynchronous) break block13;
                WfProcessInternal performer = this.getPerformer(t);
                if (performer == null) {
                    String refSbflw;
                    SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
                    WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw = subflow.getId());
                    if (wp != null || this.performerId != null) {
                        throw new BaseException("Null performer of sync. subflow activity");
                    }
                    try {
                        SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().terminate(t, this.performerId, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)));
                    }
                    catch (Exception ex) {
                        throw new BaseException((Throwable)ex);
                    }
                }
                if (!performer.state(t).startsWith("open")) break block13;
                performer.terminateFromActivity(t);
                break block13;
            }
            if (type == 4) {
                List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                for (WfActivityInternal act : actActs) {
                    if (!act.state(t).startsWith("open")) continue;
                    act.terminateFromProcess(t);
                }
            }
        }
        if (!fromProcess) {
            try {
                this.process.activity_terminate(t, (WfActivityInternal)this);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    public void abortFromProcess(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.abortActivity(t, true);
    }

    @Override
    public void abort(SharkTransaction t) throws BaseException, CannotStop, NotRunning {
        this.abortActivity(t, false);
    }

    protected void abortActivity(SharkTransaction t, boolean fromProcess) throws BaseException, CannotStop, NotRunning {
        block13: {
            int type;
            block12: {
                String stateStr = "closed.aborted";
                if (!this.state(t).startsWith("open")) {
                    throw new CannotStop("The activity is already in the closed state - can't abort it!");
                }
                this.removeAssignments(t, true, true);
                try {
                    this.change_state(t, stateStr);
                }
                catch (Exception ex) {
                    throw new CannotStop((Throwable)ex);
                }
                type = this.getActivityDefinition(t).getActivityType();
                if (type != 3) break block12;
                if (!this.isSubflowSynchronous) break block13;
                WfProcessInternal performer = this.getPerformer(t);
                if (performer == null) {
                    String refSbflw;
                    SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
                    WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw = subflow.getId());
                    if (wp != null || this.performerId != null) {
                        throw new BaseException("Null performer of sync. subflow activity");
                    }
                    try {
                        SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().abort(t, this.performerId, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)));
                    }
                    catch (Exception ex) {
                        throw new BaseException((Throwable)ex);
                    }
                }
                if (!performer.state(t).startsWith("open")) break block13;
                performer.abortFromActivity(t);
                break block13;
            }
            if (type == 4) {
                List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                for (WfActivityInternal act : actActs) {
                    if (!act.state(t).startsWith("open")) continue;
                    act.abortFromProcess(t);
                }
            }
        }
        if (!fromProcess) {
            try {
                this.process.activity_abort(t, (WfActivityInternal)this);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    public void reopen(SharkTransaction t) throws BaseException, CannotReopen {
        if (!this.state(t).startsWith("closed")) {
            throw new CannotReopen("The activity is already open - can't reopen it!");
        }
        try {
            this.change_state(t, "open.not_running.not_started");
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public void receive_event(SharkTransaction t, WfEventAudit event, WfProcessInternal performer) throws BaseException, InvalidPerformer {
        Activity aDef = this.getActivityDefinition(t);
        SubFlow subflow = aDef.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
        if (!this.isSubflowSynchronous) {
            return;
        }
        try {
            if (performer != null) {
                if (performer.state(t).equals("closed.completed") && !this.state(t).startsWith("closed")) {
                    Map rm = performer.result(t);
                    Iterator actualParameters = subflow.getActualParameters().toElements().iterator();
                    ArrayList<String> originalIds = new ArrayList<String>();
                    while (actualParameters.hasNext()) {
                        ActualParameter ap = (ActualParameter)actualParameters.next();
                        String apId = ap.toValue();
                        originalIds.add(apId);
                    }
                    HashMap updatedContext = new HashMap();
                    WorkflowProcess wp = SharkUtilities.getWorkflowProcess(performer.package_id(t), performer.manager_version(t), performer.process_definition_id(t));
                    for (Map.Entry me : rm.entrySet()) {
                        String fpId = (String)me.getKey();
                        int index = 0;
                        int foundIndex = -1;
                        for (FormalParameter fp : wp.getFormalParameters().toElements()) {
                            if (fpId.equals(fp.getId())) {
                                foundIndex = index;
                                break;
                            }
                            ++index;
                        }
                        if (foundIndex == -1) continue;
                        Object apId = originalIds.get(foundIndex);
                        updatedContext.put(apId, me.getValue());
                    }
                    this.set_result(t, updatedContext);
                    this.finish(t);
                }
            } else {
                if (this.performerId == null) {
                    throw new BaseException("This is not remote subflow activity!");
                }
                if (event instanceof WfDataEventAudit) {
                    WfDataEventAudit dea = (WfDataEventAudit)event;
                    Map res = dea.new_data();
                    res = SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().parseOutParams(t, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)), res, this.container(t).manager(t).context_signature(t));
                    this.set_result(t, res);
                }
                this.finish(t);
            }
        }
        catch (Exception ex) {
            SharkEngineManager.getInstance().getCallbackUtilities().error("Activity" + this.toString() + " - problems when receiving finishing event of subprocess");
            if (ex instanceof BaseException) {
                throw (BaseException)((Object)ex);
            }
            throw new BaseException((Throwable)ex);
        }
    }

    public final String activity_set_definition_id(SharkTransaction t) throws BaseException {
        return this.activitySetDefinitionId;
    }

    public final String activity_definition_id(SharkTransaction t) throws BaseException {
        return this.activityDefinitionId;
    }

    public final String block_activity_id(SharkTransaction t) throws BaseException {
        return this.blockActivityId;
    }

    public WfActivityInternal block_activity(SharkTransaction t) throws BaseException {
        if (this.blockActivity == null && this.blockActivityId != null) {
            this.blockActivity = this.process.getActiveActivity(t, this.blockActivityId);
            if (this.blockActivity == null) {
                this.blockActivity = this.process.getActivity(t, this.blockActivityId);
            }
        }
        return this.blockActivity;
    }

    public final String manager_name(SharkTransaction t) throws BaseException {
        return this.mgrName;
    }

    public final String process_id(SharkTransaction t) throws BaseException {
        return this.processId;
    }

    private Map getActivityContext(SharkTransaction t) throws BaseException {
        int type = this.getActivityDefinition(t).getActivityType();
        if (type != 0 && type != 4) {
            return this.process.process_context(t);
        }
        return new HashMap();
    }

    public void reevaluateAssignments(SharkTransaction t) throws BaseException {
        if (this.accepted) {
            return;
        }
        int ls = this.getAssignmentResourceIds(t).size();
        this.removeAssignments(t, true, true);
        if (ls == 0) {
            return;
        }
        this.assignmentResourceIds.clear();
        this.createAssignments(t);
    }

    protected void createAssignments(SharkTransaction t) throws BaseException {
        this.createAssignments(t, null);
    }

    protected void createAssignments(SharkTransaction t, String assignment) throws BaseException {
        boolean createAssignments = Boolean.valueOf(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.createAssignments", "true"));
        if (!createAssignments) {
            return;
        }
        int type = this.getActivityDefinition(t).getActivityType();
        if (type != 1 && type != 2) {
            return;
        }
        Participant p = this.findParticipant(t, this.getActivityDefinition(t).getPerformer());
        PerformerData xpdlParticipant = null;
        ArrayList<PerformerData> xpdlResponsibleParticipants = null;
        xpdlParticipant = this.checkParticipant(t, p, type);
        if (xpdlParticipant == null) {
            return;
        }
        Set performers = this.findResources(t, p);
        HashSet responsibles = new HashSet();
        List resps = XMLUtil.getResponsibles((WorkflowProcess)this.getProcessDefinition(t));
        Iterator it = resps.iterator();
        while (it.hasNext()) {
            Responsible resp;
            PerformerData pd;
            if (xpdlResponsibleParticipants == null) {
                xpdlResponsibleParticipants = new ArrayList<PerformerData>();
            }
            if ((pd = this.checkParticipant(t, p = this.findParticipant(t, (resp = (Responsible)it.next()).toValue()), type)) == null) continue;
            xpdlResponsibleParticipants.add(pd);
            responsibles.addAll(this.findResources(t, p));
        }
        List secUsers = null;
        List<String> users = new ArrayList<String>();
        try {
            if (assignment != null) {
                users.add(assignment);
            } else {
                users = SharkUtilities.getAssignments(t, SharkEngineManager.getInstance().getCallbackUtilities().getProperty("enginename", ""), this.processId, this.key, new ArrayList(performers), new ArrayList(responsibles), this.getResourceRequesterUsername(t), xpdlParticipant, xpdlResponsibleParticipants);
            }
            if (users.size() == 0) {
                users.add(this.getResourceRequesterUsername(t));
            }
            secUsers = SharkUtilities.getSecureAssignments(t, SharkEngineManager.getInstance().getCallbackUtilities().getProperty("enginename", ""), this.processId, this.key, users);
        }
        catch (RootException ex) {
            throw new BaseException((Throwable)ex);
        }
        for (String username : secUsers) {
            WfResourceInternal wr = SharkUtilities.getResource(t, username);
            if (wr == null) {
                try {
                    wr = SharkEngineManager.getInstance().getObjectFactory().createResource(t, username);
                }
                catch (Exception ex) {
                    throw new BaseException((Throwable)ex);
                }
            }
            WfAssignmentInternal ass = SharkEngineManager.getInstance().getObjectFactory().createAssignment(t, (WfActivityInternal)this, wr);
            wr.addAssignment(t, ass);
            this.assignmentResourceIds.add(username);
        }
    }

    protected PerformerData checkParticipant(SharkTransaction t, Participant p, int activityType) throws BaseException {
        if (p != null) {
            String participantType = p.getParticipantType().getType();
            if (participantType.equals("SYSTEM")) {
                return null;
            }
            String pDefId = null;
            if (p.getParent().getParent() instanceof WorkflowProcess) {
                pDefId = ((WorkflowProcess)p.getParent().getParent()).getId();
            }
            return new PerformerData(XMLUtil.getPackage((XMLElement)p).getId(), pDefId, p.getId(), false, participantType);
        }
        String performerExpr = this.getActivityDefinition(t).getPerformer();
        if (performerExpr.trim().length() == 0 && activityType == 2 && this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getTools().size() > 0) {
            return null;
        }
        try {
            performerExpr = this.evaluateParticipantExpression(t, performerExpr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PerformerData(XMLUtil.getPackage((XMLElement)this.getActivityDefinition(t)).getId(), XMLUtil.getWorkflowProcess((XMLElement)this.getActivityDefinition(t)).getId(), performerExpr.trim(), true, null);
    }

    protected Participant findParticipant(SharkTransaction t, String performerExpr) throws BaseException {
        Participant p = SharkUtilities.getParticipant((XMLElement)this.getActivityDefinition(t), performerExpr);
        if (p == null) {
            try {
                String participantId = this.evaluateParticipantExpression(t, performerExpr);
                return this.findParticipant(t, participantId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return p;
    }

    public void activate(SharkTransaction t) throws BaseException, CannotStart, AlreadyRunning {
        this.activate(t, null);
    }

    public void activate(SharkTransaction t, String username) throws BaseException, CannotStart, AlreadyRunning {
        if (this.state(t).equals("open.running")) {
            throw new AlreadyRunning("The activity is already running");
        }
        this.activatedTime = System.currentTimeMillis();
        try {
            this.reevaluateDeadlines(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        if (SharkEngineManager.getInstance().getLimitAgentManager() != null) {
            this.activateLimitAgent(t);
        }
        try {
            this.persist(t);
            this.persistActivityContext(t);
            this.persistDeadlines(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        this.createAssignments(t, username);
        EventAuditManagerInterface eam = SharkEngineManager.getInstance().getEventAuditManager();
        if (eam != null) {
            eam.activityCreated((WfActivityInternal)this, this.previousActivities, t);
        }
        try {
            this.startActivity(t);
        }
        catch (ToolAgentGeneralException tage) {
            this.toolAgentException = tage;
            this.finishImproperlyAndNotifyProcess(t, SharkUtilities.extractExceptionName(tage));
        }
        this.startSubflowThread = null;
    }

    protected void startActivity(SharkTransaction t) throws BaseException, CannotStart, ToolAgentGeneralException {
        int type = this.getActivityDefinition(t).getActivityType();
        if (type != 1 && type != 2) {
            try {
                this.change_state(t, "open.running");
            }
            catch (InvalidState is) {
                throw new CannotStart(is.getMessage());
            }
            catch (TransitionNotAllowed tna) {
                throw new CannotStart(tna.getMessage());
            }
            catch (BaseException be) {
                throw new CannotStart(be.getMessage());
            }
        }
        switch (type) {
            case 0: {
                try {
                    this.finish(t);
                    break;
                }
                catch (CannotComplete cc) {
                    throw new CannotStart((Throwable)cc);
                }
            }
            case 1: {
                this.runNo();
                break;
            }
            case 2: {
                String participantType;
                int hmt = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getTools().size();
                if (hmt > 0) {
                    if (this.getActivityDefinition(t).getActivityStartMode() != 0) break;
                    boolean shouldFinishImmediatelly = this.getActivityDefinition(t).getActivityFinishMode() == 0;
                    this.runTool(t);
                    try {
                        if (shouldFinishImmediatelly) {
                            this.finish(t);
                            break;
                        }
                        this.removeAssignments(t, true, true);
                        break;
                    }
                    catch (CannotComplete cnc) {
                        throw new BaseException((Throwable)cnc);
                    }
                }
                Participant p = this.findParticipant(t, this.getActivityDefinition(t).getPerformer());
                if (p != null && (participantType = p.getParticipantType().getType()).equals("SYSTEM")) {
                    try {
                        this.finish(t);
                        return;
                    }
                    catch (CannotComplete cc) {
                        throw new CannotStart((Throwable)cc);
                    }
                }
                this.runNo();
                break;
            }
            case 3: {
                this.startSubflowThread = Thread.currentThread();
                this.runSubFlow(t);
                this.startSubflowThread = null;
                break;
            }
            case 4: {
                this.runBlock(t);
            }
        }
    }

    protected void runNo() throws BaseException, CannotStart {
    }

    protected void runTool(SharkTransaction t) throws BaseException, CannotStart, ToolAgentGeneralException {
        if (!this.state(t).equals("open.running")) {
            try {
                this.change_state(t, "open.running");
            }
            catch (InvalidState is) {
                throw new CannotStart(is.getMessage());
            }
            catch (TransitionNotAllowed tna) {
                throw new CannotStart(tna.getMessage());
            }
            catch (BaseException be) {
                throw new CannotStart(be.getMessage());
            }
        }
        ToolAgentManager tam = SharkEngineManager.getInstance().getToolAgentManager();
        tam.executeActivity(t, (WfActivityInternal)this);
    }

    protected void runSubFlow(SharkTransaction t) throws BaseException, ToolAgentGeneralException {
        SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
        if (subflow == null) {
            return;
        }
        ActualParameters aps = subflow.getActualParameters();
        this.isSubflowSynchronous = this.getActivityDefinition(t).isSubflowSynchronous();
        String refSbflw = subflow.getId();
        WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw);
        String packageId = this.process.package_id(t);
        String packageVersion = this.process.manager_version(t);
        if (wp != null) {
            WfProcessInternal subProc;
            String sbflwProcId;
            String sbflwPkgVersion;
            String sbflwPkgId = XMLUtil.getPackage((XMLElement)wp).getId();
            String pmgrName = SharkUtilities.createProcessMgrKey(sbflwPkgId, sbflwPkgVersion = XMLUtil.getPackage((XMLElement)wp).getInternalVersion(), sbflwProcId = refSbflw);
            WfProcessMgrInternal mgr = SharkUtilities.getProcessMgr(t, pmgrName);
            if (mgr == null) {
                throw new BaseException("Subflow process is not found");
            }
            try {
                subProc = mgr.create_process(t, (WfRequesterInternal)this);
                if (new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.lockSubProcesses", "false")).booleanValue()) {
                    SharkEngineManager.getInstance().getLockMaster().lock(t, subProc.key(t));
                }
                subProc.set_name(t, this.process.name(t) + "-" + this.name(t));
            }
            catch (Exception ex) {
                SharkEngineManager.getInstance().getCallbackUtilities().error("Activity" + this.toString() + " - Error instantiating sub-process");
                throw new BaseException((Throwable)ex);
            }
            FormalParameters fps = SharkUtilities.getWorkflowProcess(sbflwPkgId, sbflwPkgVersion, sbflwProcId).getFormalParameters();
            Map m = null;
            try {
                m = SharkUtilities.createContextMap(t, this.getContext(t), aps, fps, packageId, packageVersion);
                subProc.set_process_context(t, m);
                this.performerId = subProc.key(t);
                this.persist(t);
                subProc.start(t);
            }
            catch (Exception ex) {
                if (ex instanceof ToolAgentGeneralException) {
                    throw (ToolAgentGeneralException)((Object)ex);
                }
                throw new BaseException((Throwable)ex);
            }
        }
        try {
            Object rsv;
            Map m = SharkUtilities.createContextMap(t, this.getContext(t), aps, packageId, packageVersion);
            String assId = SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t));
            if (this.getContext(t).containsKey(refSbflw) && (rsv = this.getContext(t).get(refSbflw)) instanceof String) {
                refSbflw = (String)rsv;
            }
            this.performerId = SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().start(t, refSbflw, this.processId, assId, this.isSubflowSynchronous, m);
            this.persist(t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        if (!this.isSubflowSynchronous) {
            try {
                this.finish(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    protected void runBlock(SharkTransaction t) throws BaseException, ToolAgentGeneralException {
    }

    protected void finishImproperlyAndNotifyProcess(SharkTransaction t, String excName) throws BaseException {
        try {
            block6: {
                int type;
                block7: {
                    WfProcessInternal performer;
                    block8: {
                        String refSbflw;
                        this.removeAssignments(t, true, true);
                        this.change_state(t, "closed.terminated");
                        this.exceptionName = excName;
                        if (this.toolAgentException != null || excName == null) break block6;
                        type = this.getActivityDefinition(t).getActivityType();
                        if (type != 3) break block7;
                        if (!this.isSubflowSynchronous) break block6;
                        performer = this.getPerformer(t);
                        if (performer != null) break block8;
                        SubFlow subflow = this.getActivityDefinition(t).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
                        WorkflowProcess wp = SharkUtilities.getWorkflowProcess((XMLElement)subflow, refSbflw = subflow.getId());
                        if (wp != null || this.performerId != null) {
                            throw new BaseException("Null performer of sync. subflow activity");
                        }
                        SharkEngineManager.getInstance().getWfEngineInteroperabilityMgr().abort(t, this.performerId, this.processId, SharkUtilities.createAssignmentKey(this.key, this.getResourceRequesterUsername(t)));
                        break block6;
                    }
                    if (!performer.state(t).startsWith("open")) break block6;
                    performer.terminateFromActivity(t);
                    break block6;
                }
                if (type == 4) {
                    List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                    for (WfActivityInternal act : actActs) {
                        act.terminateFromProcess(t);
                    }
                }
            }
            this.process.activity_terminate(t, (WfActivityInternal)this);
        }
        catch (Exception ex) {
            if (ex instanceof BaseException) {
                throw (BaseException)((Object)ex);
            }
            throw new BaseException((Throwable)ex);
        }
    }

    public void set_accepted_status(SharkTransaction t, boolean accept, String resourceUname) throws BaseException, CannotAcceptSuspended {
        if (this.state(t).startsWith("closed")) {
            throw new BaseException("Can't change accepted status - activity state is closed");
        }
        if (this.state(t).equals("open.not_running.suspended")) {
            throw new CannotAcceptSuspended("Can't accept or reject suspended activity");
        }
        if (this.accepted && accept) {
            throw new BaseException("Someone else already accepted assignment!");
        }
        if (SharkEngineManager.getInstance().getEventAuditManager() != null) {
            WfResourceInternal res = SharkUtilities.getResource(t, resourceUname);
            SharkEngineManager.getInstance().getObjectFactory().createAssignmentEventAuditWrapper(t, (WfActivityInternal)this, res, res, accept);
        }
        boolean deleteOtherAssignments = Boolean.valueOf(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.deleteOtherAssignments", "true"));
        boolean createAssignments = Boolean.valueOf(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.createAssignments", "true"));
        if (accept) {
            try {
                this.accepted = true;
                this.acceptedTime = System.currentTimeMillis();
                this.resourceUsername = resourceUname;
                if (createAssignments) {
                    this.removeAssignments(t, false, deleteOtherAssignments);
                    this.setAssignmentStatus(t, this.resourceUsername, true, true);
                    WfResourceInternal res = SharkUtilities.getResourceFromCache(t, this.resourceUsername);
                    if (res != null) {
                        res.restoreAssignment(t, this.mgrName, this.processId, this.key, true);
                    }
                }
                this.change_state(t, "open.running");
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (this.accepted) {
            try {
                this.change_state(t, "open.not_running.not_started");
            }
            catch (InvalidState is) {
                throw new BaseException((Throwable)is);
            }
            catch (TransitionNotAllowed tna) {
                throw new BaseException((Throwable)tna);
            }
            this.accepted = false;
            this.acceptedTime = 0x3FFFFFFFFFFFFFFFL;
            this.resourceUsername = null;
            try {
                if (createAssignments && !deleteOtherAssignments) {
                    String curResUsername = resourceUname;
                    for (String resUsername : this.getAssignmentResourceIds(t)) {
                        this.setAssignmentStatus(t, resUsername, true, false);
                        WfResourceInternal res = SharkUtilities.getResourceFromCache(t, resUsername);
                        if (res == null) continue;
                        res.restoreAssignment(t, this.mgrName, this.processId, this.key, false);
                    }
                }
                this.persist(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            if (createAssignments && deleteOtherAssignments) {
                this.reevaluateAssignments(t);
            }
        }
    }

    public final String getResourceUsername(SharkTransaction t) throws BaseException {
        return this.resourceUsername;
    }

    protected Activity getActivityDefinition(SharkTransaction t) throws BaseException {
        if (this.activityDefinition == null) {
            this.activityDefinition = SharkUtilities.getActivityDefinition(t, this, this.getProcessDefinition(t), this.block_activity(t));
        }
        return this.activityDefinition;
    }

    protected WorkflowProcess getProcessDefinition(SharkTransaction t) throws BaseException {
        if (this.processDefinition == null) {
            String packageId = this.process.package_id(t);
            String packageVer = this.process.manager_version(t);
            String pDefId = this.process.process_definition_id(t);
            this.processDefinition = SharkUtilities.getWorkflowProcess(packageId, packageVer, pDefId);
        }
        return this.processDefinition;
    }

    public String toString() {
        return "[Id=" + this.key + ", ba=" + this.blockActivityId + ", ActDefId=" + this.activityDefinitionId + "]";
    }

    private void setActivityVariables(SharkTransaction t) throws BaseException {
        try {
            String vdId;
            this.activitiesProcessContext = new HashMap();
            this.resultVariableIds = new HashSet();
            int type = this.getActivityDefinition(t).getActivityType();
            if (type == 0 || type == 4) {
                return;
            }
            WorkflowProcess wp = this.getProcessDefinition(t);
            List<Object> l = new ArrayList(wp.getAllVariables().values());
            if (l.size() == 0) {
                return;
            }
            PersistentManagerInterface ipm = SharkEngineManager.getInstance().getInstancePersistenceManager();
            Iterator<Object> it = l.iterator();
            ArrayList<String> variableIds = new ArrayList<String>();
            while (it.hasNext()) {
                XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)it.next();
                vdId = xMLCollectionElement.getId();
                variableIds.add(vdId);
            }
            l = ipm.getActivityVariables(this.key, variableIds, t);
            for (ActivityVariablePersistenceInterface activityVariablePersistenceInterface : l) {
                vdId = activityVariablePersistenceInterface.getDefinitionId();
                Object val = activityVariablePersistenceInterface.getValue();
                this.activitiesProcessContext.put(vdId, val);
                if (!activityVariablePersistenceInterface.isResultVariable()) continue;
                this.resultVariableIds.add(vdId);
            }
        }
        catch (Exception ex) {
            throw new BaseException("Restoring of process context failed!", (Throwable)ex);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WfActivityImpl)) {
            return false;
        }
        return ((WfActivityImpl)obj).key.equals(this.key);
    }

    protected String evaluateParticipantExpression(SharkTransaction t, String expr) throws Exception {
        if (expr == null || expr.trim().length() == 0) {
            throw new Exception("Improper participant expression!");
        }
        return this.evaluator(t).evaluateExpression(t, expr.trim(), this.process_context(t), String.class).toString();
    }

    private Evaluator evaluator(SharkTransaction t) throws Exception {
        if (this.evaluator == null) {
            this.evaluator = SharkEngineManager.getInstance().getScriptingManager().getEvaluator(t, SharkUtilities.getScriptType(this.process.package_id(t), this.process.manager_version(t)));
        }
        return this.evaluator;
    }

    private WfProcessInternal getPerformer(SharkTransaction t) throws BaseException {
        if (this.performerId != null) {
            return SharkUtilities.getProcess(t, this.performerId);
        }
        return null;
    }

    public String getResourceRequesterUsername(SharkTransaction t) throws BaseException {
        return this.process.requester(t).getResourceRequesterUsername(t);
    }

    public WfRequester getExternalRequester(SharkTransaction t) throws BaseException {
        return null;
    }

    public final boolean accepted_status(SharkTransaction t) throws BaseException {
        return this.accepted;
    }

    public void persist(SharkTransaction t) throws TransactionException {
        try {
            PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
            pmi.persist(this.createAndFillPersistentObject(), this.justCreated, t);
            this.justCreated = false;
        }
        catch (Exception pe) {
            throw new TransactionException((Throwable)pe);
        }
    }

    protected void persistActivityContext(SharkTransaction t) throws BaseException {
        try {
            if (this.variableIdsToPersist.size() == 0) {
                return;
            }
            PersistentManagerInterface pmgr = SharkEngineManager.getInstance().getInstancePersistenceManager();
            for (Map.Entry me : this.getContext(t).entrySet()) {
                String defId = (String)me.getKey();
                if (!this.variableIdsToPersist.contains(defId)) continue;
                Object val = me.getValue();
                ActivityVariablePersistenceInterface var = pmgr.createActivityVariable();
                var.setActivityId(this.key);
                var.setDefinitionId(defId);
                var.setValue(val);
                var.setResultVariable(this.getResultVariableIds(t).contains(defId));
                pmgr.persist(var, this.justCreatedVariables, t);
            }
            this.variableIdsToPersist.clear();
            this.justCreatedVariables = false;
        }
        catch (PersistenceException pe) {
            throw new BaseException((Throwable)pe);
        }
    }

    protected void persistDeadlines(SharkTransaction t) throws BaseException {
        if (this.deadlinesInfo == null || this.deadlinesInfo.size() == 0) {
            return;
        }
        try {
            PersistentManagerInterface pmgr = SharkEngineManager.getInstance().getInstancePersistenceManager();
            for (DeadlineInfo dinfo : this.deadlinesInfo) {
                DeadlinePersistenceInterface dpi = pmgr.createDeadline();
                dpi.setProcessId(this.processId);
                dpi.setActivityId(this.key);
                dpi.setExceptionName(dinfo.exceptionName);
                dpi.setSynchronous(dinfo.isSynchronous);
                dpi.setTimeLimit(dinfo.timeLimit);
                pmgr.persist(dpi, this.justCreatedDeadlines, t);
            }
            this.deadlinesInfo.clear();
            this.justCreatedDeadlines = false;
        }
        catch (PersistenceException pe) {
            throw new BaseException((Throwable)pe);
        }
    }

    protected void persistExecutedDeadline(String uniqueId, SharkTransaction t) throws BaseException {
        try {
            PersistentManagerInterface pmgr = SharkEngineManager.getInstance().getInstancePersistenceManager();
            DeadlinePersistenceInterface dpi = pmgr.createDeadline();
            dpi.setUniqueId(uniqueId);
            dpi.setExecuted(true);
            pmgr.persist(dpi, false, t);
        }
        catch (PersistenceException pe) {
            throw new BaseException((Throwable)pe);
        }
    }

    public void delete(SharkTransaction t) throws TransactionException {
        try {
            SharkEngineManager.getInstance().getInstancePersistenceManager().deleteActivity(this.key, t);
        }
        catch (Exception ex) {
            throw new TransactionException("Exception while deleting activity", (Throwable)ex);
        }
    }

    @Override
    protected XMLCollectionElement getXPDLObject(SharkTransaction t) throws BaseException {
        return this.getActivityDefinition(t);
    }

    public Map getContext(SharkTransaction t) throws BaseException {
        if (this.activitiesProcessContext == null) {
            this.setActivityVariables(t);
        }
        return this.activitiesProcessContext;
    }

    private Set getResultVariableIds(SharkTransaction t) throws BaseException {
        if (this.resultVariableIds == null) {
            this.setActivityVariables(t);
        }
        return this.resultVariableIds;
    }

    private ActivityPersistenceInterface createAndFillPersistentObject() {
        ActivityPersistenceInterface po = SharkEngineManager.getInstance().getInstancePersistenceManager().createActivity();
        this.fillPersistentObject(po);
        return po;
    }

    private void fillPersistentObject(ActivityPersistenceInterface po) {
        po.setId(this.key);
        po.setActivitySetDefinitionId(this.activitySetDefinitionId);
        po.setActivityDefinitionId(this.activityDefinitionId);
        po.setProcessMgrName(this.mgrName);
        po.setProcessId(this.processId);
        po.setResourceUsername(this.resourceUsername);
        po.setSubflowProcessId(this.performerId);
        po.setSubflowAsynchronous(!this.isSubflowSynchronous);
        po.setState(this.state);
        po.setBlockActivityId(this.blockActivityId);
        po.setName(this.name);
        po.setDescription(this.description);
        po.setPriority(this.priority);
        po.setAcceptedTime(this.acceptedTime);
        po.setActivatedTime(this.activatedTime);
        po.setLastStateTime(this.lastStateTime);
        po.setLimitTime(this.limitTime);
    }

    private void restore(ActivityPersistenceInterface po) {
        this.key = po.getId();
        this.activitySetDefinitionId = po.getActivitySetDefinitionId();
        this.activityDefinitionId = po.getActivityDefinitionId();
        this.mgrName = po.getProcessMgrName();
        this.processId = po.getProcessId();
        this.resourceUsername = po.getResourceUsername();
        this.accepted = this.resourceUsername != null;
        this.performerId = po.getSubflowProcessId();
        this.isSubflowSynchronous = !po.isSubflowAsynchronous();
        this.state = po.getState();
        this.blockActivityId = po.getBlockActivityId();
        this.name = po.getName();
        this.description = po.getDescription();
        this.priority = po.getPriority();
        this.acceptedTime = po.getAcceptedTime();
        this.activatedTime = po.getActivatedTime();
        this.lastStateTime = po.getLastStateTime();
        this.limitTime = po.getLimitTime();
    }

    protected Set findResources(SharkTransaction t, Participant p) throws BaseException {
        HashSet ress = new HashSet();
        if (p == null) {
            return ress;
        }
        String participantId = p.getId();
        XMLComplexElement cOwn = (XMLComplexElement)p.getParent().getParent();
        boolean isProcessParticipant = cOwn instanceof WorkflowProcess;
        HashSet<String> usernames = new HashSet<String>();
        List pMappings = new ArrayList();
        ParticipantMappingManager pms = SharkEngineManager.getInstance().getParticipantMapPersistenceManager();
        if (null != pms) {
            ParticipantMappingTransaction trans = null;
            try {
                trans = SharkUtilities.createParticipantMappingTransaction();
                String pkgId = XMLUtil.getPackage((XMLElement)p).getId();
                String pDefId = isProcessParticipant ? cOwn.get("Id").toValue() : null;
                pMappings = pms.getParticipantMappings(trans, pkgId, pDefId, participantId);
            }
            catch (RootException ex) {
                SharkEngineManager.getInstance().getCallbackUtilities().error("Error in WfActivityImpl.findResources()", ex);
                throw new BaseException((Throwable)ex);
            }
            finally {
                SharkUtilities.releaseMappingTransaction(trans);
            }
        }
        Iterator it = pMappings.iterator();
        UserGroupManager ugm = SharkEngineManager.getInstance().getUserGroupManager();
        if (ugm != null) {
            UserTransaction userTrans = null;
            try {
                userTrans = SharkUtilities.createUserTransaction();
                while (it.hasNext()) {
                    ParticipantMap pm = (ParticipantMap)it.next();
                    String uname = pm.getUsername();
                    if (pm.getIsGroupUser()) {
                        List unames = ugm.getAllUsers(userTrans, uname);
                        usernames.addAll(unames);
                        continue;
                    }
                    usernames.add(uname);
                }
            }
            catch (RootException ex) {
                SharkEngineManager.getInstance().getCallbackUtilities().error("Error in WfActivityImpl.findResources() : ", ex);
                throw new BaseException((Throwable)ex);
            }
            finally {
                SharkUtilities.releaseUserTransaction(userTrans);
            }
        }
        return usernames;
    }

    public final String getPerformerId(SharkTransaction t) {
        return this.performerId;
    }

    public final boolean isPerformerSynchronous(SharkTransaction t) {
        return this.isSubflowSynchronous;
    }

    @Override
    public final long getCreationTime(SharkTransaction t) throws BaseException {
        return this.activatedTime;
    }

    @Override
    public final long getStartTime(SharkTransaction t) throws BaseException {
        return this.acceptedTime;
    }

    public void updateAssignmentResourceIds(SharkTransaction t, String oldResUname, String newResUname) throws BaseException {
        if (this.assignmentResourceIds != null) {
            this.assignmentResourceIds.remove(oldResUname);
            if (!this.assignmentResourceIds.contains(newResUname)) {
                this.assignmentResourceIds.add(newResUname);
            }
        }
        if (this.resourceUsername != null && this.resourceUsername.equals(oldResUname)) {
            this.resourceUsername = newResUname;
            try {
                this.persist(t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
    }

    protected void removeAssignments(SharkTransaction t, boolean removeActiveOne, boolean deleteOtherAssignments) throws BaseException {
        boolean createAssignments = Boolean.valueOf(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("SharkKernel.createAssignments", "true"));
        if (!createAssignments) {
            return;
        }
        PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
        for (String resUsername : this.getAssignmentResourceIds(t)) {
            if (!removeActiveOne && resUsername.equals(this.resourceUsername)) continue;
            WfResourceInternal res = null;
            try {
                res = SharkUtilities.getResourceFromCache(t, resUsername);
                if (deleteOtherAssignments || removeActiveOne) {
                    pmi.deleteAssignment(this.key, resUsername, t);
                } else {
                    this.setAssignmentStatus(t, resUsername, false, false);
                }
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            if (res == null) continue;
            res.removeAssignment(t, this.processId, this.key);
        }
        if (deleteOtherAssignments) {
            this.assignmentResourceIds.clear();
            if (!removeActiveOne) {
                this.assignmentResourceIds.add(this.resourceUsername);
            }
        }
    }

    protected void setAssignmentStatus(SharkTransaction t, String resUsername, boolean isValid, boolean isAccepted) throws BaseException {
        try {
            PersistentManagerInterface pmi = SharkEngineManager.getInstance().getInstancePersistenceManager();
            AssignmentPersistenceInterface asspo = pmi.createAssignment();
            asspo.setProcessMgrName(this.mgrName);
            asspo.setProcessId(this.processId);
            asspo.setActivityId(this.key);
            asspo.setResourceUsername(resUsername);
            asspo.setValid(isValid);
            asspo.setAccepted(isAccepted);
            pmi.persist(asspo, false, t);
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
    }

    public List getDeadlineInfo(SharkTransaction t) throws BaseException {
        ArrayList<DeadlineInfo> ret = null;
        List pDeadlines = null;
        try {
            pDeadlines = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllDeadlinesForActivity(this.processId, this.key, t);
            Collections.sort(pDeadlines, new DeadlineComparator());
        }
        catch (Exception ex) {
            throw new BaseException((Throwable)ex);
        }
        if (pDeadlines == null || pDeadlines.size() == 0) {
            return new ArrayList();
        }
        if (!this.performDeadlineReevaluation()) {
            ret = new ArrayList<DeadlineInfo>();
            for (DeadlinePersistenceInterface dpo : pDeadlines) {
                DeadlineInfo info = new DeadlineInfo(this.processId, this.key, dpo.isExecuted(), dpo.getTimeLimit(), dpo.getExceptionName(), dpo.isSynchronous());
                ret.add(info);
            }
        } else {
            try {
                ret = new ArrayList(this.reevaluateDeadlines(t));
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
            for (int i = 0; i < ret.size(); ++i) {
                DeadlineInfo di = (DeadlineInfo)ret.get(i);
                DeadlinePersistenceInterface dpo = (DeadlinePersistenceInterface)pDeadlines.get(i);
                di.isExecuted = dpo.isExecuted();
            }
        }
        return ret;
    }

    public boolean checkDeadlines(SharkTransaction t, long timeLimitBoundary, Map actsToAsyncExcNames) throws BaseException {
        int i;
        String syncDeadlineExcName = null;
        ArrayList<DeadlinePersistenceInterface> brokenDeadlines = null;
        ArrayList<String> excNames = new ArrayList<String>();
        if (this.performDeadlineReevaluation()) {
            List pDeadlines = null;
            try {
                pDeadlines = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllDeadlinesForActivity(this.processId, this.key, t);
                Collections.sort(pDeadlines, new DeadlineComparator());
                this.reevaluateDeadlines(t);
                brokenDeadlines = new ArrayList<DeadlinePersistenceInterface>();
                for (i = 0; i < pDeadlines.size(); ++i) {
                    DeadlineInfo di = (DeadlineInfo)this.deadlinesInfo.get(i);
                    DeadlinePersistenceInterface dpo = (DeadlinePersistenceInterface)pDeadlines.get(i);
                    if (di.timeLimit >= timeLimitBoundary) continue;
                    dpo.setTimeLimit(di.timeLimit);
                    brokenDeadlines.add(dpo);
                }
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
            this.deadlinesInfo.clear();
        } else {
            try {
                brokenDeadlines = SharkEngineManager.getInstance().getInstancePersistenceManager().getAllDeadlinesForActivity(this.processId, this.key, timeLimitBoundary, t);
            }
            catch (Exception ex) {
                throw new BaseException((Throwable)ex);
            }
        }
        if (brokenDeadlines != null && brokenDeadlines.size() > 0) {
            boolean raiseAsyncDeadlineOnce = new Boolean(SharkEngineManager.getInstance().getCallbackUtilities().getProperty("Deadlines.raiseAsyncDeadlineOnlyOnce", "true"));
            for (i = 0; i < brokenDeadlines.size(); ++i) {
                DeadlinePersistenceInterface dpi = (DeadlinePersistenceInterface)brokenDeadlines.get(i);
                if (dpi.isExecuted() && raiseAsyncDeadlineOnce) continue;
                this.persistExecutedDeadline(dpi.getUniqueId(), t);
                String excName = dpi.getExceptionName();
                if (dpi.isSynchronous()) {
                    syncDeadlineExcName = excName;
                    break;
                }
                if (excNames.contains(excName)) continue;
                excNames.add(excName);
            }
        }
        if (syncDeadlineExcName != null) {
            this.finishImproperlyAndNotifyProcess(t, syncDeadlineExcName);
        } else {
            int type;
            if (excNames.size() > 0) {
                actsToAsyncExcNames.put(this, excNames);
            }
            if ((type = this.getActivityDefinition(t).getActivityType()) == 4) {
                List actActs = this.process.getAllActiveActivitiesForBlockActivity(t, this.key);
                Iterator it = actActs.iterator();
                while (it.hasNext()) {
                    HashMap ataens = new HashMap();
                    WfActivityInternal act = (WfActivityInternal)it.next();
                    boolean syncDeadlineHappened = act.checkDeadlines(t, timeLimitBoundary, ataens);
                    if (syncDeadlineHappened || ataens.size() <= 0) continue;
                    actsToAsyncExcNames.putAll(ataens);
                }
            }
        }
        return syncDeadlineExcName != null;
    }

    protected List reevaluateDeadlines(SharkTransaction t) throws Exception {
        Iterator dls = this.getActivityDefinition(t).getDeadlines().toElements().iterator();
        this.deadlinesInfo = new ArrayList();
        while (dls.hasNext()) {
            Deadline dl = (Deadline)dls.next();
            String dc = dl.getDeadlineCondition();
            String en = dl.getExceptionName();
            boolean isSynchronous = dl.getExecution().equals("SYNCHR");
            Map context = null;
            String useProcessContextStr = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("Deadlines.useProcessContext", "false");
            context = Boolean.valueOf(useProcessContextStr) != false ? this.process.process_context(t) : this.process_context(t);
            context.put("PROCESS_STARTED_TIME", new Date(this.process.getStartTime(t)));
            context.put("ACTIVITY_ACCEPTED_TIME", new Date(this.acceptedTime));
            context.put("ACTIVITY_ACTIVATED_TIME", new Date(this.activatedTime));
            long timeLimit = ((Date)this.evaluator(t).evaluateExpression(t, dc, context, Date.class)).getTime();
            DeadlineInfo dinfo = new DeadlineInfo(this.processId, this.key, false, timeLimit, en, isSynchronous);
            this.deadlinesInfo.add(dinfo);
        }
        return this.deadlinesInfo;
    }

    public final ToolAgentGeneralException getToolAgentException(SharkTransaction t) {
        return this.toolAgentException;
    }

    public final void setToolAgentException(SharkTransaction t, ToolAgentGeneralException tage) {
        this.toolAgentException = tage;
    }

    public final String getExceptionName(SharkTransaction t) {
        return this.exceptionName;
    }

    public final void setExceptionName(SharkTransaction t, String excName) {
        this.exceptionName = excName;
    }

    protected boolean performDeadlineReevaluation() {
        String reevalStr = SharkEngineManager.getInstance().getCallbackUtilities().getProperty("Deadlines.reevaluateDeadlines", "true");
        return Boolean.valueOf(reevalStr);
    }

    @Override
    protected void notifyStart(SharkTransaction t, Map context, long runtime) throws BaseException {
        LimitAgentManager mgr = SharkEngineManager.getInstance().getLimitAgentManager();
        try {
            mgr.notifyStart(this.processId, this.key, context, runtime);
        }
        catch (LimitAgentException e) {
            throw new BaseException("Unable to register time limit for activity " + this + " with limit agent", (Throwable)e);
        }
    }

    class DeadlineComparator
    implements Comparator {
        DeadlineComparator() {
        }

        public int compare(Object o1, Object o2) {
            DeadlinePersistenceInterface dd1 = (DeadlinePersistenceInterface)o1;
            DeadlinePersistenceInterface dd2 = (DeadlinePersistenceInterface)o2;
            String ui1 = dd1.getUniqueId();
            String ui2 = dd2.getUniqueId();
            return ui1.compareTo(ui2);
        }
    }
}

