/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.instancepersistence;

import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.dods.builder.generator.query.QueryBuilder;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.instancepersistence.ActivityPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ActivityVariablePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.AndJoinEntryInterface;
import org.enhydra.shark.api.internal.instancepersistence.AssignmentPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.DeadlinePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.PersistenceException;
import org.enhydra.shark.api.internal.instancepersistence.PersistentManagerInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessMgrPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessPersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ProcessVariablePersistenceInterface;
import org.enhydra.shark.api.internal.instancepersistence.ResourcePersistenceInterface;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.instancepersistence.DODSActivity;
import org.enhydra.shark.instancepersistence.DODSActivityVariable;
import org.enhydra.shark.instancepersistence.DODSAndJoinEntry;
import org.enhydra.shark.instancepersistence.DODSAssignment;
import org.enhydra.shark.instancepersistence.DODSDeadline;
import org.enhydra.shark.instancepersistence.DODSProcess;
import org.enhydra.shark.instancepersistence.DODSProcessMgr;
import org.enhydra.shark.instancepersistence.DODSProcessVariable;
import org.enhydra.shark.instancepersistence.DODSResource;
import org.enhydra.shark.instancepersistence.data.ActivityDO;
import org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO;
import org.enhydra.shark.instancepersistence.data.ActivityDataBLOBQuery;
import org.enhydra.shark.instancepersistence.data.ActivityDataDO;
import org.enhydra.shark.instancepersistence.data.ActivityDataQuery;
import org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO;
import org.enhydra.shark.instancepersistence.data.ActivityDataWOBQuery;
import org.enhydra.shark.instancepersistence.data.ActivityQuery;
import org.enhydra.shark.instancepersistence.data.ActivityStateDO;
import org.enhydra.shark.instancepersistence.data.ActivityStateQuery;
import org.enhydra.shark.instancepersistence.data.AndJoinEntryDO;
import org.enhydra.shark.instancepersistence.data.AndJoinEntryQuery;
import org.enhydra.shark.instancepersistence.data.AssignmentDO;
import org.enhydra.shark.instancepersistence.data.AssignmentQuery;
import org.enhydra.shark.instancepersistence.data.DeadlineDO;
import org.enhydra.shark.instancepersistence.data.DeadlineQuery;
import org.enhydra.shark.instancepersistence.data.ProcessDO;
import org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO;
import org.enhydra.shark.instancepersistence.data.ProcessDataBLOBQuery;
import org.enhydra.shark.instancepersistence.data.ProcessDataDO;
import org.enhydra.shark.instancepersistence.data.ProcessDataQuery;
import org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO;
import org.enhydra.shark.instancepersistence.data.ProcessDataWOBQuery;
import org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO;
import org.enhydra.shark.instancepersistence.data.ProcessDefinitionQuery;
import org.enhydra.shark.instancepersistence.data.ProcessQuery;
import org.enhydra.shark.instancepersistence.data.ProcessRequesterDO;
import org.enhydra.shark.instancepersistence.data.ProcessRequesterQuery;
import org.enhydra.shark.instancepersistence.data.ProcessStateDO;
import org.enhydra.shark.instancepersistence.data.ProcessStateQuery;
import org.enhydra.shark.instancepersistence.data.ResourceDO;
import org.enhydra.shark.instancepersistence.data.ResourceQuery;
import org.enhydra.shark.transaction.SharkDODSTransaction;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSPersistentManager
implements PersistentManagerInterface {
    protected static final String LOG_CHANNEL = "Persistence";
    protected static final int RESOURCE_TYPE_OBJECT = 0;
    protected static final int PROCESS_DEFINITION_TYPE_OBJECT = 1;
    protected static final int PROCESS_TYPE_OBJECT = 2;
    protected static final int ACTIVITY_TYPE_OBJECT = 3;
    protected static final int ASSIGNMENT_TYPE_OBJECT = 4;
    protected static final String[] activityAndProcessStates = new String[]{"open.running", "open.not_running.not_started", "open.not_running.suspended", "closed.completed", "closed.terminated", "closed.aborted"};
    protected static final short DB_TYPE_BOOLEAN = 0;
    protected static final short DB_TYPE_LONG = 1;
    protected static final short DB_TYPE_DOUBLE = 2;
    protected static final short DB_TYPE_VCHAR = 3;
    protected static final short DB_TYPE_DATE = 4;
    protected static final short DB_TYPE_BLOB = 5;
    protected static final int MAX_VCHAR_SIZE_LIMIT = 4000;
    protected static int max_vchar_size = 4000;
    protected CallbackUtilities cus;
    protected boolean deleteFinishedProcesses = false;
    protected Map _prStates;
    protected Map _acStates;
    protected List _prClosedStatesBigDecimals;
    protected List _actClosedStatesBigDecimals;
    protected List _actOpenStatesBigDecimals;
    protected boolean usingStandardVariableDataModel = true;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
        String del = cus.getProperty("DODSPersistentManager.deleteFinishedProcesses", "false");
        this.deleteFinishedProcesses = new Boolean(del);
        String shtd = cus.getProperty("DatabaseManager.DB.sharkdb.Connection.ShutDownString", "");
        String mvc = cus.getProperty("DODSPersistentManager.maxVARCHARSize", "4000");
        try {
            max_vchar_size = Integer.parseInt(mvc);
            if (max_vchar_size > 4000 || max_vchar_size < 1) {
                max_vchar_size = 4000;
                cus.warn("Invalid value " + mvc + " for property DODSPersistentManager.maxVARCHARSize. Using default value " + max_vchar_size);
            }
        }
        catch (Exception e) {
            cus.warn("Invalid value " + mvc + " for property DODSPersistentManager.maxVARCHARSize. Using default value " + max_vchar_size);
        }
        if (shtd.equals("SHUTDOWN")) {
            cus.info(LOG_CHANNEL, "DODSPersistentManager -> Adding shutdown hook for HSQL DB");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        DODS.shutdown();
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
            });
        }
        this.usingStandardVariableDataModel = new Boolean(cus.getProperty("DODSPersistentManager.useStandardVariableDataModel", "true"));
        this._prStates = new HashMap();
        this._acStates = new HashMap();
        this._prClosedStatesBigDecimals = new ArrayList();
        this._actClosedStatesBigDecimals = new ArrayList();
        this._actOpenStatesBigDecimals = new ArrayList();
        try {
            try {
                DODSUtilities.init((Properties)cus.getProperties());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.initActivityAndProcessStatesTable();
            cus.info("DODSPersistentManager -> manager configured - working with DB " + cus.getProperty("DatabaseManager.DB.sharkdb.Connection.Url"));
            cus.info("DODSPersistentManager ->                    - using DB Driver " + cus.getProperty("DatabaseManager.DB.sharkdb.JdbcDriver"));
            cus.info("DODSPersistentManager ->                    - persisting String variables into BLOB for sizes greater than " + max_vchar_size);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            cus.error(LOG_CHANNEL, "Problem with registering database manager with DODS !", new RootException(tr));
            throw new RootException("Problem with registering database manager with DODS !", tr);
        }
    }

    protected void initActivityAndProcessStatesTable() throws PersistenceException {
        DBTransaction t = null;
        try {
            t = DODS.getDatabaseManager().createTransaction();
            for (int i = 0; i < activityAndProcessStates.length; ++i) {
                ActivityStateDO asDO;
                String state = activityAndProcessStates[i];
                ProcessStateDO psDO = this.getPersistedProcessStateObject(state, true, t);
                if (!psDO.isPersistent()) {
                    psDO.setKeyValue(state);
                }
                psDO.setName(state);
                psDO.save(t);
                BigDecimal bd = psDO.get_OId().toBigDecimal();
                this._prStates.put(state, bd);
                if (state.startsWith("closed.")) {
                    this._prClosedStatesBigDecimals.add(bd);
                }
                if (!(asDO = this.getPersistedActivityStateObject(state, true, t)).isPersistent()) {
                    asDO.setKeyValue(state);
                }
                asDO.setName(state);
                asDO.save(t);
                BigDecimal bda = asDO.get_OId().toBigDecimal();
                this._acStates.put(state, bda);
                if (state.startsWith("closed.")) {
                    this._actClosedStatesBigDecimals.add(bda);
                    continue;
                }
                this._actOpenStatesBigDecimals.add(bda);
            }
            t.commit();
        }
        catch (Throwable thr) {
            throw new PersistenceException(thr);
        }
        finally {
            try {
                t.release();
            }
            catch (Exception i) {}
        }
    }

    public void shutdownDatabase() throws PersistenceException {
        try {
            DODS.shutdown();
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Database is not properly shudown !", new RootException(tr));
            throw new PersistenceException("Database is not properly shudown !", tr);
        }
    }

    public void persist(ProcessMgrPersistenceInterface pm, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ProcessDefinitionDO DO = null;
            DO = isInitialPersistence ? ProcessDefinitionDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(pm, ti);
            if (isInitialPersistence) {
                DO.setName(pm.getName());
                DO.setPackageId(pm.getPackageId());
                DO.setProcessDefinitionId(pm.getProcessDefinitionId());
                DO.setProcessDefinitionVersion(pm.getVersion());
                DO.setProcessDefinitionCreated(pm.getCreated());
            }
            DO.setState(pm.getState());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ProcessDefinition[packageId=" + pm.getPackageId() + ",id=" + pm.getProcessDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of ProcessDefinition " + pm.getProcessDefinitionId() + " failed");
            throw new PersistenceException("Persisting of ProcessDefinition " + pm.getProcessDefinitionId() + " failed", tr);
        }
    }

    public void persist(ProcessPersistenceInterface pr, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ProcessDO DO = null;
            DO = isInitialPersistence ? ProcessDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(pr, ti);
            if (isInitialPersistence) {
                DO.setId(pr.getId());
                DO.setProcessDefinition(this.getPersistedProcessMgrObject(pr.getProcessMgrName(), ti));
                ProcessRequesterDO rDO = ProcessRequesterDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                rDO.setId(pr.getId());
                if (pr.getActivityRequesterId() != null) {
                    rDO.setActivityRequester(this.getPersistedActivityObject(pr.getActivityRequesterId(), ti));
                }
                rDO.setResourceRequester(this.getPersistedResourceObject(pr.getResourceRequesterId(), ti));
                DO.setPDefName(pr.getProcessMgrName());
                DO.setActivityRequesterId(pr.getActivityRequesterId());
                DO.setActivityRequesterProcessId(pr.getActivityRequestersProcessId());
                DO.setResourceRequesterId(pr.getResourceRequesterId());
                ((SharkDODSTransaction)ti).store((CoreDO)rDO);
            }
            DO.setExternalRequesterClassName(pr.getExternalRequesterClassName());
            DO.setName(pr.getName());
            DO.setDescription(pr.getDescription());
            DO.setPriority(pr.getPriority());
            DO.oid_setState((BigDecimal)this._prStates.get(pr.getState()));
            DO.setCreated(pr.getCreatedTime());
            DO.setStarted(pr.getStartedTime());
            DO.setLastStateTime(pr.getLastStateTime());
            DO.setLimitTime(pr.getLimitTime());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Process[id=" + pr.getId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of Process " + pr.getId() + " failed");
            throw new PersistenceException("Persisting of Process " + pr.getId() + " failed", tr);
        }
    }

    public void persist(ActivityPersistenceInterface act, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ActivityDO DO = null;
            DO = isInitialPersistence ? ActivityDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(act, ti);
            if (isInitialPersistence) {
                DO.setId(act.getId());
                DO.setActivitySetDefinitionId(act.getActivitySetDefinitionId());
                DO.setActivityDefinitionId(act.getActivityDefinitionId());
                DO.setPDefName(act.getProcessMgrName());
                DO.setProcess(this.getPersistedProcessObject(act.getProcessId(), ti));
                DO.setProcessId(act.getProcessId());
                String bActId = act.getBlockActivityId();
                if (bActId != null) {
                    DO.setBlockActivityId(bActId);
                }
            }
            DO.setPerformer(act.getSubflowProcessId());
            DO.setIsPerformerAsynchronous(act.isSubflowAsynchronous());
            DO.setName(act.getName());
            DO.setDescription(act.getDescription());
            DO.setPriority(act.getPriority());
            if (!isInitialPersistence && DO.getResourceId() != act.getResourceUsername()) {
                DO.setTheResource(this.getPersistedResourceObject(act.getResourceUsername(), ti));
                DO.setResourceId(act.getResourceUsername());
            }
            DO.oid_setState((BigDecimal)this._acStates.get(act.getState()));
            DO.setLastStateTime(act.getLastStateTime());
            DO.setLimitTime(act.getLimitTime());
            DO.setAccepted(act.getAcceptedTime());
            DO.setActivated(act.getActivatedTime());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Activity[id=" + act.getId() + ",definitionId=" + act.getActivityDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of Activity " + act.getId() + " failed");
            throw new PersistenceException("Persisting of Activity " + act.getId() + " failed", tr);
        }
    }

    public void persist(ResourcePersistenceInterface res, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ResourceDO DO = null;
            DO = isInitialPersistence ? ResourceDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(res, ti);
            if (isInitialPersistence) {
                DO.setUsername(res.getUsername());
                DO.setName(res.getName());
            }
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Resource[username=" + res.getUsername() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of Resource " + res.getUsername() + " failed");
            throw new PersistenceException("Persisting of Resource " + res.getUsername() + " failed", tr);
        }
    }

    public void persist(AssignmentPersistenceInterface ass, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            AssignmentDO DO = null;
            DO = isInitialPersistence ? AssignmentDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(ass, ti);
            if (isInitialPersistence) {
                DO.setActivity(this.getPersistedActivityObject(ass.getActivityId(), ti));
                DO.setCNT(this.getNextDecId("_assignment_"));
                DO.setActivityId(ass.getActivityId());
                DO.setActivityProcessId(ass.getProcessId());
                DO.setActivityProcessDefName(ass.getProcessMgrName());
            }
            DO.setIsValid(ass.isValid());
            DO.setIsAccepted(ass.isAccepted());
            if (ass.getResourceUsername() != DO.getResourceId()) {
                DO.setResourceId(ass.getResourceUsername());
                DO.setTheResource(this.getPersistedResourceObject(ass.getResourceUsername(), ti));
            }
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Assignment[activityId=" + ass.getActivityId() + ", username=" + ass.getResourceUsername() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of  Assignment failed");
            throw new PersistenceException("Persisting of  Assignment failed", tr);
        }
    }

    public void persist(AssignmentPersistenceInterface ass, String oldResUname, SharkTransaction ti) throws PersistenceException {
        try {
            AssignmentDO DO = this.getPersistedAssignmentObject(ass.getActivityId(), oldResUname, ti);
            DO.setTheResource(this.getPersistedResourceObject(ass.getResourceUsername(), ti));
            DO.setResourceId(ass.getResourceUsername());
            DO.setIsValid(ass.isValid());
            DO.setIsAccepted(ass.isAccepted());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Assignment[activityId=" + ass.getActivityId() + ", username=" + ass.getResourceUsername() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of  Assignment failed");
            throw new PersistenceException("Persisting of  Assignment failed", tr);
        }
    }

    public void persist(ProcessVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            this.persistVariablesBLOB(var, isInitialPersistence, ti);
        } else {
            this.persistVariablesWOB(var, isInitialPersistence, ti);
        }
    }

    protected void persistVariablesBLOB(ProcessVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ProcessDataDO DO = null;
            DO = isInitialPersistence ? ProcessDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(var, ti);
            if (isInitialPersistence) {
                DO.setProcess(this.getPersistedProcessObject(var.getProcessId(), ti));
                DO.setVariableDefinitionId(var.getDefinitionId());
            }
            Object vv = var.getValue();
            boolean isBLOB = false;
            boolean wasBLOB = false;
            if (vv instanceof Boolean) {
                DO.setVariableValueBOOL((Boolean)vv);
                DO.setVariableType((short)0);
            } else if (vv instanceof Long) {
                DO.setVariableValueLONG((Long)vv);
                DO.setVariableType((short)1);
            } else if (vv instanceof String) {
                String sv = (String)vv;
                if (sv.length() <= max_vchar_size) {
                    DO.setVariableValueVCHAR(sv);
                    wasBLOB = true;
                    DO.setVariableType((short)3);
                } else {
                    DO.setVariableValueVCHAR(null);
                    isBLOB = true;
                }
            } else if (vv instanceof Double) {
                DO.setVariableValueDBL((Double)vv);
                DO.setVariableType((short)2);
            } else if (vv instanceof Date) {
                DO.setVariableValueDATE(new Timestamp(((Date)vv).getTime()));
                DO.setVariableType((short)4);
            } else if (vv == null) {
                short vt = DO.getVariableType();
                if (vt == 4) {
                    DO.setVariableValueDATE(null);
                } else if (vt == 3) {
                    DO.setVariableValueVCHAR(null);
                } else {
                    DO.setVariableValue(null);
                    DO.setVariableType((short)5);
                }
            } else {
                isBLOB = true;
            }
            if (isBLOB) {
                DO.setVariableValue(MiscUtilities.serialize((Object)vv));
                DO.setVariableType((short)5);
            }
            if (wasBLOB) {
                DO.setVariableValue(null);
            }
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ProcessVariable[processId=" + var.getProcessId() + ", definitionId=" + var.getDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of ProcessVariable failed");
            throw new PersistenceException("Persisting of ProcessVariable failed", tr);
        }
    }

    protected void persistVariablesWOB(ProcessVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ProcessDataWOBDO DO = null;
            DO = isInitialPersistence ? ProcessDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject2(var, ti);
            if (isInitialPersistence) {
                DO.setProcess(this.getPersistedProcessObject(var.getProcessId(), ti));
                DO.setVariableDefinitionId(var.getDefinitionId());
            }
            Object vv = var.getValue();
            boolean isBLOB = false;
            boolean wasBLOB = false;
            if (vv instanceof Boolean) {
                DO.setVariableValueBOOL((Boolean)vv);
                DO.setVariableType((short)0);
            } else if (vv instanceof Long) {
                DO.setVariableValueLONG((Long)vv);
                DO.setVariableType((short)1);
            } else if (vv instanceof String) {
                String sv = (String)vv;
                if (sv.length() <= max_vchar_size) {
                    DO.setVariableValueVCHAR(sv);
                    wasBLOB = true;
                    DO.setVariableType((short)3);
                } else {
                    DO.setVariableValueVCHAR(null);
                    isBLOB = true;
                }
            } else if (vv instanceof Double) {
                DO.setVariableValueDBL((Double)vv);
                DO.setVariableType((short)2);
            } else if (vv instanceof Date) {
                DO.setVariableValueDATE(new Timestamp(((Date)vv).getTime()));
                DO.setVariableType((short)4);
            } else if (vv == null) {
                short vt = DO.getVariableType();
                if (vt == 4) {
                    DO.setVariableValueDATE(null);
                } else if (vt == 3) {
                    DO.setVariableValueVCHAR(null);
                } else {
                    ProcessDataBLOBDO bDO = null;
                    bDO = isInitialPersistence ? ProcessDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(DO, ti);
                    bDO.setProcessDataWOB(DO);
                    bDO.setVariableValue(null);
                    DO.setVariableType((short)5);
                    ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                }
            } else {
                isBLOB = true;
            }
            if (isBLOB) {
                ProcessDataBLOBDO bDO = null;
                bDO = isInitialPersistence ? ProcessDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(DO, ti);
                bDO.setProcessDataWOB(DO);
                bDO.setVariableValue(MiscUtilities.serialize((Object)vv));
                DO.setVariableType((short)5);
                ((SharkDODSTransaction)ti).store((CoreDO)bDO);
            }
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ProcessVariable[processId=" + var.getProcessId() + ", definitionId=" + var.getDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of ProcessVariable failed");
            throw new PersistenceException("Persisting of ProcessVariable failed", tr);
        }
    }

    public void persist(ActivityVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            this.persistVariablesBLOB(var, isInitialPersistence, ti);
        } else {
            this.persistVariablesWOB(var, isInitialPersistence, ti);
        }
    }

    public void persistVariablesBLOB(ActivityVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ActivityDataDO DO = null;
            DO = isInitialPersistence ? ActivityDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(var, ti);
            if (isInitialPersistence) {
                DO.setActivity(this.getPersistedActivityObject(var.getActivityId(), ti));
                DO.setVariableDefinitionId(var.getDefinitionId());
            }
            Object vv = var.getValue();
            boolean isBLOB = false;
            boolean wasBLOB = false;
            if (vv instanceof Boolean) {
                DO.setVariableValueBOOL((Boolean)vv);
                DO.setVariableType((short)0);
            } else if (vv instanceof Long) {
                DO.setVariableValueLONG((Long)vv);
                DO.setVariableType((short)1);
            } else if (vv instanceof String) {
                String sv = (String)vv;
                if (sv.length() <= max_vchar_size) {
                    DO.setVariableValueVCHAR(sv);
                    wasBLOB = true;
                    DO.setVariableType((short)3);
                } else {
                    DO.setVariableValueVCHAR(null);
                    isBLOB = true;
                }
            } else if (vv instanceof Double) {
                DO.setVariableValueDBL((Double)vv);
                DO.setVariableType((short)2);
            } else if (vv instanceof Date) {
                DO.setVariableValueDATE(new Timestamp(((Date)vv).getTime()));
                DO.setVariableType((short)4);
            } else if (vv == null) {
                short vt = DO.getVariableType();
                if (vt == 4) {
                    DO.setVariableValueDATE(null);
                } else if (vt == 3) {
                    DO.setVariableValueVCHAR(null);
                } else {
                    DO.setVariableValue(null);
                    DO.setVariableType((short)5);
                }
            } else {
                isBLOB = true;
            }
            if (isBLOB) {
                DO.setVariableValue(MiscUtilities.serialize((Object)vv));
                DO.setVariableType((short)5);
            }
            if (wasBLOB) {
                DO.setVariableValue(null);
            }
            DO.setIsResult(var.isResultVariable());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ActivityVariable[activityId=" + var.getActivityId() + ", definitionId=" + var.getDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of ActivityVariable failed");
            throw new PersistenceException("Persisting of ActivityVariable failed", tr);
        }
    }

    public void persistVariablesWOB(ActivityVariablePersistenceInterface var, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            ActivityDataWOBDO DO = null;
            DO = isInitialPersistence ? ActivityDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject2(var, ti);
            if (isInitialPersistence) {
                DO.setActivity(this.getPersistedActivityObject(var.getActivityId(), ti));
                DO.setVariableDefinitionId(var.getDefinitionId());
            }
            Object vv = var.getValue();
            boolean isBLOB = false;
            boolean wasBLOB = false;
            if (vv instanceof Boolean) {
                DO.setVariableValueBOOL((Boolean)vv);
                DO.setVariableType((short)0);
            } else if (vv instanceof Long) {
                DO.setVariableValueLONG((Long)vv);
                DO.setVariableType((short)1);
            } else if (vv instanceof String) {
                String sv = (String)vv;
                if (sv.length() <= max_vchar_size) {
                    DO.setVariableValueVCHAR(sv);
                    wasBLOB = true;
                    DO.setVariableType((short)3);
                } else {
                    DO.setVariableValueVCHAR(null);
                    isBLOB = true;
                }
            } else if (vv instanceof Double) {
                DO.setVariableValueDBL((Double)vv);
                DO.setVariableType((short)2);
            } else if (vv instanceof Date) {
                DO.setVariableValueDATE(new Timestamp(((Date)vv).getTime()));
                DO.setVariableType((short)4);
            } else if (vv == null) {
                short vt = DO.getVariableType();
                if (vt == 4) {
                    DO.setVariableValueDATE(null);
                } else if (vt == 3) {
                    DO.setVariableValueVCHAR(null);
                } else {
                    ActivityDataBLOBDO bDO = null;
                    bDO = isInitialPersistence ? ActivityDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(DO, ti);
                    bDO.setActivityDataWOB(DO);
                    bDO.setVariableValue(null);
                    DO.setVariableType((short)5);
                    ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                }
            } else {
                isBLOB = true;
            }
            if (isBLOB) {
                ActivityDataBLOBDO bDO = null;
                bDO = isInitialPersistence ? ActivityDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(DO, ti);
                bDO.setActivityDataWOB(DO);
                bDO.setVariableValue(MiscUtilities.serialize((Object)vv));
                DO.setVariableType((short)5);
                ((SharkDODSTransaction)ti).store((CoreDO)bDO);
            }
            DO.setIsResult(var.isResultVariable());
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ActivityVariable[activityId=" + var.getActivityId() + ", definitionId=" + var.getDefinitionId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of ActivityVariable failed");
            throw new PersistenceException("Persisting of ActivityVariable failed", tr);
        }
    }

    public void persist(AndJoinEntryInterface aje, SharkTransaction ti) throws PersistenceException {
        try {
            AndJoinEntryDO DO = AndJoinEntryDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            DO.setProcess(this.getPersistedProcessObject(aje.getProcessId(), ti));
            DO.setActivitySetDefinitionId(aje.getActivitySetDefinitionId());
            DO.setActivityDefinitionId(aje.getActivityDefinitionId());
            DO.setActivity(this.getPersistedActivityObject(aje.getActivityId(), ti));
            DO.setCNT(this.getNextDecId("andjoinentry"));
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "AndJoinEntry[id=" + aje.getProcessId() + ",aDefId=" + aje.getActivityDefinitionId() + ",actId=" + aje.getActivityId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of AndJoinEntry [id=" + aje.getProcessId() + ",aDefId=" + aje.getActivityDefinitionId() + ",actId=" + aje.getActivityId() + "] failed");
            throw new PersistenceException("Persisting of AndJoinEntry [id=" + aje.getProcessId() + ",aDefId=" + aje.getActivityDefinitionId() + ",actId=" + aje.getActivityId() + "] failed", tr);
        }
    }

    public void persist(DeadlinePersistenceInterface dpe, boolean isInitialPersistence, SharkTransaction ti) throws PersistenceException {
        try {
            DeadlineDO DO = null;
            DO = isInitialPersistence ? DeadlineDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction()) : this.getPersistedObject(dpe, ti);
            if (isInitialPersistence) {
                DO.setProcess(this.getPersistedProcessObject(dpe.getProcessId(), ti));
                DO.setActivity(this.getPersistedActivityObject(dpe.getActivityId(), ti));
                DO.setExceptionName(dpe.getExceptionName());
                DO.setTimeLimit(dpe.getTimeLimit());
                DO.setIsSynchronous(dpe.isSynchronous());
                DO.setCNT(this.getNextDecId("deadline"));
            } else {
                DO.setIsExecuted(dpe.isExecuted());
            }
            ((SharkDODSTransaction)ti).store((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Deadline[actId=" + dpe.getActivityId() + ",ExcName=" + dpe.getExceptionName() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of Deadline[actId=" + dpe.getActivityId() + ",ExcName=" + dpe.getExceptionName() + "] failed");
            throw new PersistenceException("Persisting of Deadline[actId=" + dpe.getActivityId() + ",ExcName=" + dpe.getExceptionName() + "] failed", tr);
        }
    }

    public ProcessMgrPersistenceInterface restoreProcessMgr(String mgrName, SharkTransaction ti) throws PersistenceException {
        return this.restore(this.getPersistedProcessMgrObject(mgrName, ti));
    }

    protected ProcessMgrPersistenceInterface restore(ProcessDefinitionDO DO) throws PersistenceException {
        if (DO == null) {
            return null;
        }
        DODSProcessMgr engineObj = new DODSProcessMgr();
        try {
            engineObj.setName(DO.getName());
            engineObj.setPackageId(DO.getPackageId());
            engineObj.setProcessDefinitionId(DO.getProcessDefinitionId());
            engineObj.setVersion(DO.getProcessDefinitionVersion());
            engineObj.setCreated(DO.getProcessDefinitionCreated());
            engineObj.setState(DO.getState());
            this.cus.debug(LOG_CHANNEL, "ProcessDefinition[packageId=" + DO.getPackageId() + ",id=" + DO.getProcessDefinitionId() + " restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of ProcessDefinition failed");
            throw new PersistenceException("Restoring of ProcessDefinition failed", tr);
        }
        return engineObj;
    }

    public ProcessPersistenceInterface restoreProcess(String procId, SharkTransaction ti) throws PersistenceException {
        return this.restore(this.getPersistedProcessObject(procId, ti));
    }

    protected ProcessPersistenceInterface restore(ProcessDO DO) throws PersistenceException {
        if (DO == null) {
            return null;
        }
        DODSProcess engineObj = new DODSProcess();
        try {
            engineObj.setId(DO.getId());
            engineObj.setProcessMgrName(DO.getPDefName());
            engineObj.setName(DO.getName());
            engineObj.setDescription(DO.getDescription());
            engineObj.setPriority(DO.getPriority());
            engineObj.setState(DO.getState().getName());
            engineObj.setCreatedTime(DO.getCreated());
            engineObj.setStartedTime(DO.getStarted());
            engineObj.setLastStateTime(DO.getLastStateTime());
            engineObj.setLimitTime(DO.getLimitTime());
            engineObj.setActivityRequesterId(DO.getActivityRequesterId());
            engineObj.setActivityRequestersProcessId(DO.getActivityRequesterProcessId());
            engineObj.setResourceRequesterId(DO.getResourceRequesterId());
            engineObj.setExternalRequesterClassName(DO.getExternalRequesterClassName());
            this.cus.debug(LOG_CHANNEL, "Process[id=" + DO.getId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Process failed");
            throw new PersistenceException("Restoring of Process " + engineObj.getId() + " failed", tr);
        }
        return engineObj;
    }

    public ActivityPersistenceInterface restoreActivity(String actId, SharkTransaction ti) throws PersistenceException {
        return this.restore(this.getPersistedActivityObject(actId, ti));
    }

    protected ActivityPersistenceInterface restore(ActivityDO DO) throws PersistenceException {
        if (DO == null) {
            return null;
        }
        DODSActivity engineObj = new DODSActivity();
        try {
            engineObj.setActivitySetDefinitionId(DO.getActivitySetDefinitionId());
            engineObj.setActivityDefinitionId(DO.getActivityDefinitionId());
            engineObj.setId(DO.getId());
            engineObj.setProcessMgrName(DO.getPDefName());
            engineObj.setProcessId(DO.getProcessId());
            engineObj.setResourceUsername(DO.getResourceId());
            engineObj.setSubflowProcessId(DO.getPerformer());
            engineObj.setSubflowAsynchronous(DO.getIsPerformerAsynchronous());
            engineObj.setName(DO.getName());
            engineObj.setDescription(DO.getDescription());
            engineObj.setPriority(DO.getPriority());
            engineObj.setState(DO.getState().getName());
            engineObj.setLastStateTime(DO.getLastStateTime());
            engineObj.setLimitTime(DO.getLimitTime());
            engineObj.setAcceptedTime(DO.getAccepted());
            engineObj.setActivatedTime(DO.getActivated());
            engineObj.setBlockActivityId(DO.getBlockActivityId());
            this.cus.debug(LOG_CHANNEL, "Activity[id=" + DO.getId() + ",definitionId=" + DO.getActivityDefinitionId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Activity failed");
            throw new PersistenceException("Restoring of Activity failed", tr);
        }
        return engineObj;
    }

    public ResourcePersistenceInterface restoreResource(String resUsername, SharkTransaction ti) throws PersistenceException {
        return this.restore(this.getPersistedResourceObject(resUsername, ti));
    }

    protected ResourcePersistenceInterface restore(ResourceDO DO) throws PersistenceException {
        if (DO == null) {
            return null;
        }
        DODSResource engineObj = new DODSResource();
        try {
            engineObj.setName(DO.getName());
            engineObj.setUsername(DO.getUsername());
            this.cus.debug(LOG_CHANNEL, "Resource[username=" + DO.getUsername() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Resource failed");
            throw new PersistenceException("Restoring of Resource failed", tr);
        }
        return engineObj;
    }

    public AssignmentPersistenceInterface restoreAssignment(String actId, String resUsername, SharkTransaction ti) throws PersistenceException {
        return this.restore(this.getPersistedAssignmentObject(actId, resUsername, ti));
    }

    protected AssignmentPersistenceInterface restore(AssignmentDO DO) throws PersistenceException {
        if (DO == null) {
            return null;
        }
        DODSAssignment engineObj = new DODSAssignment();
        try {
            String actId = DO.getActivityId();
            String username = DO.getResourceId();
            String processId = DO.getActivityProcessId();
            engineObj.setActivityId(actId);
            engineObj.setResourceUsername(username);
            engineObj.setProcessId(processId);
            engineObj.setProcessMgrName(DO.getActivityProcessDefName());
            engineObj.setValid(DO.getIsValid());
            engineObj.setAccepted(DO.getIsAccepted());
            this.cus.debug(LOG_CHANNEL, "Assignment[activityId=" + actId + ", username=" + username + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Assignment failed");
            throw new PersistenceException("Restoring of Assignment failed", tr);
        }
        return engineObj;
    }

    public boolean restore(ProcessVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.restoreBLOB(var, this.getPersistedObject(var, ti));
        }
        return this.restoreWOB(var, this.getPersistedObject2(var, ti));
    }

    protected boolean restoreBLOB(ProcessVariablePersistenceInterface engineObj, ProcessDataDO DO) throws PersistenceException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setProcessId(DO.getProcess().getId());
            engineObj.setDefinitionId(DO.getVariableDefinitionId());
            short vtype = DO.getVariableType();
            switch (vtype) {
                case 0: {
                    engineObj.setValue((Object)new Boolean(DO.getVariableValueBOOL()));
                    break;
                }
                case 1: {
                    engineObj.setValue((Object)new Long(DO.getVariableValueLONG()));
                    break;
                }
                case 2: {
                    engineObj.setValue((Object)new Double(DO.getVariableValueDBL()));
                    break;
                }
                case 3: {
                    engineObj.setValue((Object)DO.getVariableValueVCHAR());
                    break;
                }
                case 4: {
                    Timestamp d = DO.getVariableValueDATE();
                    if (d != null) {
                        engineObj.setValue((Object)new Date(d.getTime()));
                        break;
                    }
                    engineObj.setValue(null);
                    break;
                }
                default: {
                    byte[] v = DO.getVariableValue();
                    if (v != null && v.length > 0) {
                        engineObj.setValue(MiscUtilities.deserialize((byte[])v));
                        break;
                    }
                    engineObj.setValue(null);
                }
            }
            this.cus.debug(LOG_CHANNEL, "ProcessVariable[processId=" + engineObj.getProcessId() + ", definitionId=" + engineObj.getDefinitionId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of ProcessVariable failed");
            throw new PersistenceException("Restoring of ProcessVariable failed", tr);
        }
        return true;
    }

    protected boolean restoreWOB(ProcessVariablePersistenceInterface engineObj, ProcessDataWOBDO DO) throws PersistenceException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setProcessId(DO.getProcess().getId());
            engineObj.setDefinitionId(DO.getVariableDefinitionId());
            short vtype = DO.getVariableType();
            switch (vtype) {
                case 0: {
                    engineObj.setValue((Object)new Boolean(DO.getVariableValueBOOL()));
                    break;
                }
                case 1: {
                    engineObj.setValue((Object)new Long(DO.getVariableValueLONG()));
                    break;
                }
                case 2: {
                    engineObj.setValue((Object)new Double(DO.getVariableValueDBL()));
                    break;
                }
                case 3: {
                    engineObj.setValue((Object)DO.getVariableValueVCHAR());
                    break;
                }
                case 4: {
                    Timestamp d = DO.getVariableValueDATE();
                    if (d != null) {
                        engineObj.setValue((Object)new Date(d.getTime()));
                        break;
                    }
                    engineObj.setValue(null);
                    break;
                }
                default: {
                    byte[] v = DO.getProcessDataBLOBDO().getVariableValue();
                    if (v != null && v.length > 0) {
                        engineObj.setValue(MiscUtilities.deserialize((byte[])v));
                        break;
                    }
                    engineObj.setValue(null);
                }
            }
            this.cus.debug(LOG_CHANNEL, "ProcessVariable[processId=" + engineObj.getProcessId() + ", definitionId=" + engineObj.getDefinitionId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of ProcessVariable failed");
            throw new PersistenceException("Restoring of ProcessVariable failed", tr);
        }
        return true;
    }

    public boolean restore(ActivityVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.restoreBLOB(var, this.getPersistedObject(var, ti));
        }
        return this.restoreWOB(var, this.getPersistedObject2(var, ti));
    }

    protected boolean restoreBLOB(ActivityVariablePersistenceInterface engineObj, ActivityDataDO DO) throws PersistenceException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setActivityId(DO.getActivity().getId());
            engineObj.setDefinitionId(DO.getVariableDefinitionId());
            short vtype = DO.getVariableType();
            switch (vtype) {
                case 0: {
                    engineObj.setValue((Object)new Boolean(DO.getVariableValueBOOL()));
                    break;
                }
                case 1: {
                    engineObj.setValue((Object)new Long(DO.getVariableValueLONG()));
                    break;
                }
                case 2: {
                    engineObj.setValue((Object)new Double(DO.getVariableValueDBL()));
                    break;
                }
                case 3: {
                    engineObj.setValue((Object)DO.getVariableValueVCHAR());
                    break;
                }
                case 4: {
                    Timestamp d = DO.getVariableValueDATE();
                    if (d != null) {
                        engineObj.setValue((Object)new Date(d.getTime()));
                        break;
                    }
                    engineObj.setValue(null);
                    break;
                }
                default: {
                    byte[] v = DO.getVariableValue();
                    if (v != null && v.length > 0) {
                        engineObj.setValue(MiscUtilities.deserialize((byte[])v));
                        break;
                    }
                    engineObj.setValue(null);
                }
            }
            engineObj.setResultVariable(DO.getIsResult());
            this.cus.debug(LOG_CHANNEL, "ActivityVariable[activityId=" + engineObj.getActivityId() + ", definitionId=" + engineObj.getDefinitionId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Variable failed");
            throw new PersistenceException("Restoring of Variable failed", tr);
        }
        return true;
    }

    protected boolean restoreWOB(ActivityVariablePersistenceInterface engineObj, ActivityDataWOBDO DO) throws PersistenceException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setActivityId(DO.getActivity().getId());
            engineObj.setDefinitionId(DO.getVariableDefinitionId());
            short vtype = DO.getVariableType();
            switch (vtype) {
                case 0: {
                    engineObj.setValue((Object)new Boolean(DO.getVariableValueBOOL()));
                    break;
                }
                case 1: {
                    engineObj.setValue((Object)new Long(DO.getVariableValueLONG()));
                    break;
                }
                case 2: {
                    engineObj.setValue((Object)new Double(DO.getVariableValueDBL()));
                    break;
                }
                case 3: {
                    engineObj.setValue((Object)DO.getVariableValueVCHAR());
                    break;
                }
                case 4: {
                    Timestamp d = DO.getVariableValueDATE();
                    if (d != null) {
                        engineObj.setValue((Object)new Date(d.getTime()));
                        break;
                    }
                    engineObj.setValue(null);
                    break;
                }
                default: {
                    byte[] v = DO.getActivityDataBLOBDO().getVariableValue();
                    if (v != null && v.length > 0) {
                        engineObj.setValue(MiscUtilities.deserialize((byte[])v));
                        break;
                    }
                    engineObj.setValue(null);
                }
            }
            engineObj.setResultVariable(DO.getIsResult());
            this.cus.debug(LOG_CHANNEL, "ActivityVariable[activityId=" + engineObj.getActivityId() + ", definitionId=" + engineObj.getDefinitionId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of Variable failed");
            throw new PersistenceException("Restoring of Variable failed", tr);
        }
        return true;
    }

    public void deleteProcessMgr(String mgrName, SharkTransaction ti) throws PersistenceException {
        try {
            ProcessDefinitionDO DO = this.getPersistedProcessMgrObject(mgrName, ti);
            if (DO.getProcessDOArrayCount() > 0) {
                return;
            }
            ((SharkDODSTransaction)ti).erase((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "ProcessDefinition[name=" + mgrName + "] deleted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Deleting of ProcessDefinition failed");
            throw new PersistenceException("Deleting of ProcessDefinition failed", tr);
        }
    }

    public void deleteProcess(String procId, boolean administrative, SharkTransaction ti) throws PersistenceException {
        if (!this.deleteFinishedProcesses && !administrative) {
            return;
        }
        try {
            HashSet procIds = new HashSet();
            this.performCascadeDeletion(procId, procIds, (SharkDODSTransaction)ti);
            procIds.remove(procId);
            this.cus.info(LOG_CHANNEL, "Main Process[id=" + procId + "] deleted");
            this.cus.info(LOG_CHANNEL, "Sub-Processes " + procIds + "] deleted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Deleting of Process failed");
            throw new PersistenceException("Deleting of Process failed", tr);
        }
    }

    protected void performCascadeDeletion(String procId, Set procIds, SharkDODSTransaction ti) throws Exception {
        ProcessDO pDO = this.getPersistedProcessObject(procId, (SharkTransaction)ti);
        ProcessRequesterDO pReqDO = this.getPersistedRequesterObject(procId, (SharkTransaction)ti);
        ti.erase((CoreDO)pDO);
        ti.erase((CoreDO)pReqDO);
        if (pDO == null) {
            return;
        }
        procIds.add(procId);
        this.performCascadeErasageFromBuffer(pDO, procIds, ti);
        String SQLWHERE = "Activities.Process=" + pDO.get_Handle() + " AND Activities.Performer IS NOT NULL";
        ActivityQuery query = new ActivityQuery(ti.getDODSTransaction());
        QueryBuilder qb = query.getQueryBuilder();
        qb.addWhere(SQLWHERE);
        ActivityDO[] DOs = query.getDOArray();
        HashSet<String> deleteFurther = new HashSet<String>();
        if (DOs != null) {
            for (int i = 0; i < DOs.length; ++i) {
                if (DOs[i].getIsPerformerAsynchronous()) continue;
                deleteFurther.add(DOs[i].getPerformer());
            }
        }
        deleteFurther.removeAll(procIds);
        for (String fpid : deleteFurther) {
            this.performCascadeDeletion(fpid, procIds, ti);
        }
    }

    protected void performCascadeErasageFromBuffer(ProcessDO pDO, Set procIds, SharkDODSTransaction sdt) throws Exception {
        try {
            GenericDO o;
            BigDecimal pOId = pDO.get_OId().toBigDecimal();
            HashSet<BigDecimal> actOIdsToRemove = new HashSet<BigDecimal>();
            HashSet<String> procIdsToRemove = new HashSet<String>();
            HashSet<GenericDO> toRemove = new HashSet<GenericDO>();
            Iterator it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                o = (ActivityDO)it.next();
                if (!pOId.equals(o.oid_getProcess())) continue;
                toRemove.add(o);
                actOIdsToRemove.add(o.get_OId().toBigDecimal());
                if (o.getPerformer() == null || o.getIsPerformerAsynchronous()) continue;
                procIdsToRemove.add(o.getPerformer());
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
            while (it.hasNext()) {
                o = (ProcessDataDO)it.next();
                if (!pOId.equals(o.oid_getProcess())) continue;
                toRemove.add(o);
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                o = (DeadlineDO)it.next();
                if (!pOId.equals(o.oid_getProcess())) continue;
                toRemove.add(o);
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO");
            while (it.hasNext()) {
                o = (AndJoinEntryDO)it.next();
                if (!pOId.equals(o.oid_getProcess())) continue;
                toRemove.add(o);
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
            while (it.hasNext()) {
                o = (AssignmentDO)it.next();
                if (!actOIdsToRemove.contains(o.oid_getActivity())) continue;
                toRemove.add(o);
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
            while (it.hasNext()) {
                o = (ActivityDataDO)it.next();
                if (!actOIdsToRemove.contains(o.oid_getActivity())) continue;
                toRemove.add(o);
            }
            it = sdt.iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO");
            while (it.hasNext()) {
                o = (ProcessRequesterDO)it.next();
                if (!actOIdsToRemove.contains(o.oid_getActivityRequester()) && !o.getId().equals(pDO.getId())) continue;
                toRemove.add(o);
            }
            sdt.erase(toRemove);
            it = procIdsToRemove.iterator();
            while (it.hasNext()) {
                this.performCascadeDeletion((String)it.next(), procIds, sdt);
            }
        }
        catch (Throwable tr) {
            throw new PersistenceException("Problems while performing cascade deletion from Buffer", tr);
        }
    }

    public void deleteActivity(String actId, SharkTransaction ti) throws PersistenceException {
    }

    public void deleteResource(String resUsername, SharkTransaction ti) throws PersistenceException {
    }

    public void deleteAssignment(String actId, String resUsername, SharkTransaction ti) throws PersistenceException {
        try {
            AssignmentDO DO = this.getPersistedAssignmentObject(actId, resUsername, ti);
            ((SharkDODSTransaction)ti).erase((CoreDO)DO);
            this.cus.info(LOG_CHANNEL, "Assignment[activityId=" + actId + ", username=" + resUsername + "] deleted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Deleting of Assignment failed");
            throw new PersistenceException("Deleting of Assignment failed", tr);
        }
    }

    public void deleteAndJoinEntries(String procId, String asDefId, String aDefId, SharkTransaction ti) throws PersistenceException {
        try {
            AndJoinEntryDO[] DOs = this.getPersistedAndJoinEntries(procId, asDefId, aDefId, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ((SharkDODSTransaction)ti).erase((CoreDO)DOs[i]);
                }
                this.cus.info(LOG_CHANNEL, "AndJoinEntries for [procId=" + procId + ", aDefId=" + aDefId + "] deleted");
            } else {
                this.cus.info(LOG_CHANNEL, "There are no AndJoinEntries for [procId=" + procId + ", aDefId=" + aDefId + "] to delete");
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Deleting of AndJoinEntries for [procId=" + procId + ", aDefId=" + aDefId + "] failed");
            throw new PersistenceException("Deleting of AndJoinEntries for [procId=" + procId + ", aDefId=" + aDefId + "] failed", tr);
        }
    }

    public void deleteDeadlines(String procId, SharkTransaction ti) throws PersistenceException {
    }

    public void deleteDeadlines(String procId, String actId, SharkTransaction ti) throws PersistenceException {
    }

    public void delete(ProcessVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
    }

    public void delete(ActivityVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
    }

    public List getAllProcessMgrs(SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessMgrPersistenceInterface> ret = new ArrayList<ProcessMgrPersistenceInterface>();
        ProcessDefinitionDO[] mgrs = this.getAllPersistedProcessMgrs(ti, null, null, null, null);
        if (mgrs != null) {
            for (int i = 0; i < mgrs.length; ++i) {
                ProcessMgrPersistenceInterface mgr = this.restore(mgrs[i]);
                ret.add(mgr);
            }
        }
        return ret;
    }

    public List getAllProcesses(SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, 0, null, null, null, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllRunningProcesses(SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, 1, null, null, null, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllFinishedProcesses(SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, -1, null, null, null, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllFinishedProcesses(SharkTransaction ti, Date finishedBefore) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, -1, null, null, null, finishedBefore, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllFinishedProcesses(SharkTransaction ti, String pkgId) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, -1, pkgId, null, null, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllFinishedProcesses(SharkTransaction ti, String pkgId, String procDefId) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, -1, pkgId, procDefId, null, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllFinishedProcesses(SharkTransaction ti, String pkgId, String procDefId, String pkgVer) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, -1, pkgId, procDefId, pkgVer, null, null);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllActivities(SharkTransaction ti) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        ActivityDO[] acts = this.getPersistedActivities(ti, 0, null, null);
        if (acts != null) {
            for (int i = 0; i < acts.length; ++i) {
                ActivityPersistenceInterface act = this.restore(acts[i]);
                ret.add(act);
            }
        }
        return ret;
    }

    public List getAllResources(SharkTransaction ti) throws PersistenceException {
        ArrayList<ResourcePersistenceInterface> ret = new ArrayList<ResourcePersistenceInterface>();
        ResourceDO[] ress = this.getAllPersistedResources(ti, null);
        if (ress != null) {
            for (int i = 0; i < ress.length; ++i) {
                ResourcePersistenceInterface res = this.restore(ress[i]);
                ret.add(res);
            }
        }
        return ret;
    }

    public List getAllAssignments(SharkTransaction ti) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        AssignmentDO[] ass = this.getAllPersistedAssignments(ti, null);
        if (ass != null) {
            for (int i = 0; i < ass.length; ++i) {
                AssignmentPersistenceInterface as = this.restore(ass[i]);
                ret.add(as);
            }
        }
        return ret;
    }

    public List getAllProcessesForMgr(String mgrName, SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        try {
            ProcessDefinitionDO pDO = this.getPersistedProcessMgrObject(mgrName, ti);
            if (pDO != null) {
                int index;
                ProcessDO o;
                ProcessDO[] procs = pDO.getProcessDOArray();
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                ArrayList<ProcessDO> list = new ArrayList<ProcessDO>(Arrays.asList(procs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDO");
                while (it.hasNext()) {
                    o = (ProcessDO)it.next();
                    if (!pOId.equals(o.oid_getProcessDefinition()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDO");
                while (it.hasNext()) {
                    o = (ProcessDO)it.next();
                    if (!pOId.equals(o.oid_getProcessDefinition())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                procs = new ProcessDO[list.size()];
                list.toArray(procs);
                for (int j = 0; j < procs.length; ++j) {
                    ProcessPersistenceInterface proc = this.restore(procs[j]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getProcessesForMgr(String mgrName, String procState, SharkTransaction ti) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] DOs = null;
        ProcessQuery query = null;
        try {
            query = new ProcessQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            BigDecimal state = (BigDecimal)this._prStates.get(procState);
            QueryBuilder qb = query.getQueryBuilder();
            qb.addWhere(ProcessDO.State, state, "=");
            DOs = query.getDOArray();
            ArrayList<ProcessDO> list = new ArrayList<ProcessDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                list.remove(it.next());
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                ProcessDO o = (ProcessDO)it.next();
                boolean stateOK = o.oid_getState().equals(state);
                int index = list.indexOf(o);
                if (-1 == index) {
                    if (!stateOK) continue;
                    list.add(o);
                    continue;
                }
                if (stateOK) {
                    list.set(index, o);
                    continue;
                }
                list.remove(o);
            }
            DOs = new ProcessDO[list.size()];
            list.toArray(DOs);
            for (int j = 0; j < DOs.length; ++j) {
                ProcessPersistenceInterface proc = this.restore(DOs[j]);
                ret.add(proc);
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllActivitiesForProcess(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null) {
                int index;
                ActivityDO o;
                ActivityDO[] acts = pDO.getActivityDOArray();
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                ArrayList<ActivityDO> list = new ArrayList<ActivityDO>(Arrays.asList(acts));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDO");
                while (it.hasNext()) {
                    o = (ActivityDO)it.next();
                    if (!pOId.equals(o.oid_getProcess()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDO");
                while (it.hasNext()) {
                    o = (ActivityDO)it.next();
                    if (!pOId.equals(o.oid_getProcess())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                acts = new ActivityDO[list.size()];
                list.toArray(acts);
                for (int j = 0; j < acts.length; ++j) {
                    ActivityPersistenceInterface act = this.restore(acts[j]);
                    ret.add(act);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getActivitiesForProcess(String procId, String actState, SharkTransaction ti) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            BigDecimal pOId = pDO.get_OId().toBigDecimal();
            BigDecimal state = (BigDecimal)this._acStates.get(actState);
            ActivityDO[] DOs = null;
            ActivityQuery query = null;
            query = new ActivityQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            QueryBuilder qb = query.getQueryBuilder();
            qb.addWhere(ActivityDO.Process, pOId, "=");
            qb.addWhere(ActivityDO.State, state, "=");
            DOs = query.getDOArray();
            ArrayList<ActivityDO> list = new ArrayList<ActivityDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                list.remove(it.next());
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                ActivityDO o = (ActivityDO)it.next();
                boolean stateOK = o.oid_getState().equals(state);
                int index = list.indexOf(o);
                if (-1 == index) {
                    if (!stateOK) continue;
                    list.add(o);
                    continue;
                }
                if (stateOK) {
                    list.set(index, o);
                    continue;
                }
                list.remove(o);
            }
            DOs = new ActivityDO[list.size()];
            list.toArray(DOs);
            for (int j = 0; j < DOs.length; ++j) {
                ActivityPersistenceInterface act = this.restore(DOs[j]);
                ret.add(act);
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllFinishedActivitiesForProcess(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        try {
            BigDecimal pOId;
            ActivityDO[] acts;
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null && (acts = this.getPersistedActivities(ti, -1, pOId = pDO.get_OId().toBigDecimal(), null)) != null) {
                for (int j = 0; j < acts.length; ++j) {
                    ActivityPersistenceInterface act = this.restore(acts[j]);
                    ret.add(act);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllActiveActivitiesForProcess(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        try {
            BigDecimal pOId;
            ActivityDO[] acts;
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null && (acts = this.getPersistedActivities(ti, 1, pOId = pDO.get_OId().toBigDecimal(), null)) != null) {
                for (int j = 0; j < acts.length; ++j) {
                    ActivityPersistenceInterface act = this.restore(acts[j]);
                    ret.add(act);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllAssignmentsForResource(String resUsername, SharkTransaction ti) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        try {
            ResourceDO rDO = this.getPersistedResourceObject(resUsername, ti);
            if (rDO != null) {
                int index;
                AssignmentDO o;
                AssignmentDO[] ass = rDO.getAssignmentDOArray();
                BigDecimal rOId = rDO.get_OId().toBigDecimal();
                ArrayList<AssignmentDO> list = new ArrayList<AssignmentDO>(Arrays.asList(ass));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!rOId.equals(o.oid_getTheResource()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!rOId.equals(o.oid_getTheResource())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                ass = new AssignmentDO[list.size()];
                list.toArray(ass);
                for (int i = 0; i < ass.length; ++i) {
                    AssignmentDO assDO = ass[i];
                    AssignmentPersistenceInterface as = this.restore(assDO);
                    ret.add(as);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllValidAssignmentsForResource(String resUsername, SharkTransaction ti) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        try {
            ResourceDO rDO = this.getPersistedResourceObject(resUsername, ti);
            if (rDO != null) {
                int index;
                AssignmentDO o;
                AssignmentDO[] ass = rDO.getAssignmentDOArray();
                BigDecimal rOId = rDO.get_OId().toBigDecimal();
                ArrayList<AssignmentDO> list = new ArrayList<AssignmentDO>(Arrays.asList(ass));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!rOId.equals(o.oid_getTheResource()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!rOId.equals(o.oid_getTheResource()) || !o.getIsValid()) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                ass = new AssignmentDO[list.size()];
                list.toArray(ass);
                for (int i = 0; i < ass.length; ++i) {
                    AssignmentDO assDO = ass[i];
                    if (!assDO.getIsValid()) continue;
                    AssignmentPersistenceInterface as = this.restore(assDO);
                    ret.add(as);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllAssignmentsForActivity(String actId, SharkTransaction ti) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        try {
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null) {
                int index;
                AssignmentDO o;
                AssignmentDO[] ass = aDO.getAssignmentDOArray();
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                ArrayList<AssignmentDO> list = new ArrayList<AssignmentDO>(Arrays.asList(ass));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!aOId.equals(o.oid_getActivity())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                ass = new AssignmentDO[list.size()];
                list.toArray(ass);
                for (int i = 0; i < ass.length; ++i) {
                    AssignmentDO assDO = ass[i];
                    AssignmentPersistenceInterface as = this.restore(assDO);
                    ret.add(as);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllValidAssignmentsForActivity(String actId, SharkTransaction ti) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        try {
            String actState;
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null && !(actState = aDO.getState().getKeyValue()).startsWith("closed")) {
                int index;
                AssignmentDO o;
                AssignmentDO[] ass = aDO.getAssignmentDOArray();
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                ArrayList<AssignmentDO> list = new ArrayList<AssignmentDO>(Arrays.asList(ass));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
                while (it.hasNext()) {
                    o = (AssignmentDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || !o.getIsValid()) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                ass = new AssignmentDO[list.size()];
                list.toArray(ass);
                for (int i = 0; i < ass.length; ++i) {
                    AssignmentDO assDO = ass[i];
                    if (!assDO.getIsValid()) continue;
                    AssignmentPersistenceInterface as = this.restore(assDO);
                    ret.add(as);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllVariablesForProcess(String procId, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.getAllVariablesForProcessBLOB(procId, ti);
        }
        return this.getAllVariablesForProcessWOB(procId, ti);
    }

    protected List getAllVariablesForProcessBLOB(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSProcessVariable> ret = new ArrayList<DODSProcessVariable>();
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null) {
                int index;
                ProcessDataDO o;
                ProcessDataDO[] DOs = pDO.getProcessDataDOArray();
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                ArrayList<ProcessDataDO> list = new ArrayList<ProcessDataDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    o = (ProcessDataDO)it.next();
                    if (!pOId.equals(o.oid_getProcess()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    o = (ProcessDataDO)it.next();
                    if (!pOId.equals(o.oid_getProcess())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new ProcessDataDO[list.size()];
                list.toArray(DOs);
                for (int i = 0; i < DOs.length; ++i) {
                    ProcessDataDO DO = DOs[i];
                    DODSProcessVariable var = new DODSProcessVariable();
                    this.restoreBLOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected List getAllVariablesForProcessWOB(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSProcessVariable> ret = new ArrayList<DODSProcessVariable>();
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null) {
                int index;
                ProcessDataWOBDO o;
                ProcessDataWOBDO[] DOs = pDO.getProcessDataWOBDOArray();
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                ArrayList<ProcessDataWOBDO> list = new ArrayList<ProcessDataWOBDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO");
                while (it.hasNext()) {
                    o = (ProcessDataWOBDO)it.next();
                    if (!pOId.equals(o.oid_getProcess()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO");
                while (it.hasNext()) {
                    o = (ProcessDataWOBDO)it.next();
                    if (!pOId.equals(o.oid_getProcess())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new ProcessDataWOBDO[list.size()];
                list.toArray(DOs);
                for (int i = 0; i < DOs.length; ++i) {
                    ProcessDataWOBDO DO = DOs[i];
                    DODSProcessVariable var = new DODSProcessVariable();
                    this.restoreWOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getProcessVariables(String procId, List variableIds, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.getProcessVariablesBLOB(procId, variableIds, ti);
        }
        return this.getProcessVariablesWOB(procId, variableIds, ti);
    }

    public List getProcessVariablesBLOB(String procId, List variableIds, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSProcessVariable> ret = new ArrayList<DODSProcessVariable>();
        try {
            ProcessDataDO[] DOs;
            HashMap<String, ProcessDataDO> map = new HashMap<String, ProcessDataDO>();
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null) {
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    ProcessDataDO o = (ProcessDataDO)it.next();
                    if (!pOId.equals(o.oid_getProcess()) || !variableIds.contains(o.getVariableDefinitionId())) continue;
                    map.put(o.getVariableDefinitionId(), o);
                }
            }
            if (pDO.isPersistent() && map.size() != variableIds.size()) {
                if (variableIds.size() - map.size() > 1) {
                    DOs = pDO.getProcessDataDOArray();
                    for (int i = 0; i < DOs.length; ++i) {
                        if (map.containsKey(DOs[i].getVariableDefinitionId())) continue;
                        map.put(DOs[i].getVariableDefinitionId(), DOs[i]);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DOs[i]);
                    }
                } else {
                    DBTransaction dbt = ((SharkDODSTransaction)ti).getDODSTransaction();
                    for (int i = 0; i < variableIds.size(); ++i) {
                        String varId = (String)variableIds.get(i);
                        if (map.containsKey(varId)) continue;
                        ProcessDataQuery q = new ProcessDataQuery(dbt);
                        q.setQueryProcess(pDO);
                        q.setQueryVariableDefinitionId(varId);
                        ProcessDataDO DO = q.getNextDO();
                        if (DO == null) continue;
                        map.put(varId, DO);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    }
                }
            }
            DOs = new ProcessDataDO[map.size()];
            DOs = map.values().toArray(DOs);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ProcessDataDO DO = DOs[i];
                    DODSProcessVariable var = new DODSProcessVariable();
                    this.restoreBLOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getProcessVariablesWOB(String procId, List variableIds, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSProcessVariable> ret = new ArrayList<DODSProcessVariable>();
        try {
            ProcessDataWOBDO[] DOs;
            HashMap<String, ProcessDataWOBDO> map = new HashMap<String, ProcessDataWOBDO>();
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (pDO != null) {
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO");
                while (it.hasNext()) {
                    ProcessDataWOBDO o = (ProcessDataWOBDO)it.next();
                    if (!pOId.equals(o.oid_getProcess()) || !variableIds.contains(o.getVariableDefinitionId())) continue;
                    map.put(o.getVariableDefinitionId(), o);
                }
            }
            if (pDO.isPersistent() && map.size() != variableIds.size()) {
                if (variableIds.size() - map.size() > 1) {
                    DOs = pDO.getProcessDataWOBDOArray();
                    for (int i = 0; i < DOs.length; ++i) {
                        if (map.containsKey(DOs[i].getVariableDefinitionId())) continue;
                        map.put(DOs[i].getVariableDefinitionId(), DOs[i]);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DOs[i]);
                    }
                } else {
                    DBTransaction dbt = ((SharkDODSTransaction)ti).getDODSTransaction();
                    for (int i = 0; i < variableIds.size(); ++i) {
                        String varId = (String)variableIds.get(i);
                        if (map.containsKey(varId)) continue;
                        ProcessDataWOBQuery q = new ProcessDataWOBQuery(dbt);
                        q.setQueryProcess(pDO);
                        q.setQueryVariableDefinitionId(varId);
                        ProcessDataWOBDO DO = q.getNextDO();
                        if (DO == null) continue;
                        map.put(varId, DO);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    }
                }
            }
            DOs = new ProcessDataWOBDO[map.size()];
            DOs = map.values().toArray(DOs);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ProcessDataWOBDO DO = DOs[i];
                    DODSProcessVariable var = new DODSProcessVariable();
                    this.restoreWOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllVariablesForActivity(String actId, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.getAllVariablesForActivityBLOB(actId, ti);
        }
        return this.getAllVariablesForActivityWOB(actId, ti);
    }

    public List getAllVariablesForActivityBLOB(String actId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSActivityVariable> ret = new ArrayList<DODSActivityVariable>();
        try {
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null) {
                int index;
                ActivityDataDO o;
                ActivityDataDO[] DOs = aDO.getActivityDataDOArray();
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                ArrayList<ActivityDataDO> list = new ArrayList<ActivityDataDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
                while (it.hasNext()) {
                    o = (ActivityDataDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
                while (it.hasNext()) {
                    o = (ActivityDataDO)it.next();
                    if (!aOId.equals(o.oid_getActivity())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new ActivityDataDO[list.size()];
                list.toArray(DOs);
                for (int i = 0; i < DOs.length; ++i) {
                    ActivityDataDO DO = DOs[i];
                    DODSActivityVariable var = new DODSActivityVariable();
                    this.restoreBLOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllVariablesForActivityWOB(String actId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSActivityVariable> ret = new ArrayList<DODSActivityVariable>();
        try {
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null) {
                int index;
                ActivityDataWOBDO o;
                ActivityDataWOBDO[] DOs = aDO.getActivityDataWOBDOArray();
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                ArrayList<ActivityDataWOBDO> list = new ArrayList<ActivityDataWOBDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO");
                while (it.hasNext()) {
                    o = (ActivityDataWOBDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO");
                while (it.hasNext()) {
                    o = (ActivityDataWOBDO)it.next();
                    if (!aOId.equals(o.oid_getActivity())) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new ActivityDataWOBDO[list.size()];
                list.toArray(DOs);
                for (int i = 0; i < DOs.length; ++i) {
                    ActivityDataWOBDO DO = DOs[i];
                    DODSActivityVariable var = new DODSActivityVariable();
                    this.restoreWOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getActivityVariables(String actId, List variableIds, SharkTransaction ti) throws PersistenceException {
        if (this.usingStandardVariableDataModel) {
            return this.getActivityVariablesBLOB(actId, variableIds, ti);
        }
        return this.getActivityVariablesWOB(actId, variableIds, ti);
    }

    public List getActivityVariablesBLOB(String actId, List variableIds, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSActivityVariable> ret = new ArrayList<DODSActivityVariable>();
        try {
            ActivityDataDO[] DOs;
            HashMap<String, ActivityDataDO> map = new HashMap<String, ActivityDataDO>();
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null) {
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
                while (it.hasNext()) {
                    ActivityDataDO o = (ActivityDataDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || !variableIds.contains(o.getVariableDefinitionId())) continue;
                    map.put(o.getVariableDefinitionId(), o);
                }
            }
            if (aDO.isPersistent() && map.size() != variableIds.size()) {
                if (map.size() == 0) {
                    DOs = aDO.getActivityDataDOArray();
                    for (int i = 0; i < DOs.length; ++i) {
                        if (map.containsKey(DOs[i].getVariableDefinitionId())) continue;
                        map.put(DOs[i].getVariableDefinitionId(), DOs[i]);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DOs[i]);
                    }
                } else {
                    DBTransaction dbt = ((SharkDODSTransaction)ti).getDODSTransaction();
                    for (int i = 0; i < variableIds.size(); ++i) {
                        String varId = (String)variableIds.get(i);
                        if (map.containsKey(varId)) continue;
                        ActivityDataQuery q = new ActivityDataQuery(dbt);
                        q.setQueryActivity(aDO);
                        q.setQueryVariableDefinitionId(varId);
                        ActivityDataDO DO = q.getNextDO();
                        if (DO == null) continue;
                        map.put(varId, DO);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    }
                }
            }
            DOs = new ActivityDataDO[map.size()];
            DOs = map.values().toArray(DOs);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ActivityDataDO DO = DOs[i];
                    DODSActivityVariable var = new DODSActivityVariable();
                    this.restoreBLOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getActivityVariablesWOB(String actId, List variableIds, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSActivityVariable> ret = new ArrayList<DODSActivityVariable>();
        try {
            ActivityDataWOBDO[] DOs;
            HashMap<String, ActivityDataWOBDO> map = new HashMap<String, ActivityDataWOBDO>();
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (aDO != null) {
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO");
                while (it.hasNext()) {
                    ActivityDataWOBDO o = (ActivityDataWOBDO)it.next();
                    if (!aOId.equals(o.oid_getActivity()) || !variableIds.contains(o.getVariableDefinitionId())) continue;
                    map.put(o.getVariableDefinitionId(), o);
                }
            }
            if (aDO.isPersistent() && map.size() != variableIds.size()) {
                if (map.size() == 0) {
                    DOs = aDO.getActivityDataWOBDOArray();
                    for (int i = 0; i < DOs.length; ++i) {
                        if (map.containsKey(DOs[i].getVariableDefinitionId())) continue;
                        map.put(DOs[i].getVariableDefinitionId(), DOs[i]);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DOs[i]);
                    }
                } else {
                    DBTransaction dbt = ((SharkDODSTransaction)ti).getDODSTransaction();
                    for (int i = 0; i < variableIds.size(); ++i) {
                        String varId = (String)variableIds.get(i);
                        if (map.containsKey(varId)) continue;
                        ActivityDataWOBQuery q = new ActivityDataWOBQuery(dbt);
                        q.setQueryActivity(aDO);
                        q.setQueryVariableDefinitionId(varId);
                        ActivityDataWOBDO DO = q.getNextDO();
                        if (DO == null) continue;
                        map.put(varId, DO);
                        ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    }
                }
            }
            DOs = new ActivityDataWOBDO[map.size()];
            DOs = map.values().toArray(DOs);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ActivityDataWOBDO DO = DOs[i];
                    DODSActivityVariable var = new DODSActivityVariable();
                    this.restoreWOB(var, DO);
                    ret.add(var);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getResourceRequestersProcessIds(String resUsername, SharkTransaction ti) throws PersistenceException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            ResourceDO rDO = this.getPersistedResourceObject(resUsername, ti);
            if (rDO != null) {
                int index;
                ProcessRequesterDO o;
                ProcessRequesterDO[] DOs = rDO.getProcessRequesterDOArray();
                BigDecimal rOId = rDO.get_OId().toBigDecimal();
                ArrayList<ProcessRequesterDO> list = new ArrayList<ProcessRequesterDO>(Arrays.asList(DOs));
                if (DOs != null) {
                    for (int i = 0; i < DOs.length; ++i) {
                        if (DOs[i].getActivityRequester() == null) continue;
                        list.remove(DOs[i]);
                    }
                }
                Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO");
                while (it.hasNext()) {
                    o = (ProcessRequesterDO)it.next();
                    if (!rOId.equals(o.oid_getResourceRequester()) || -1 == (index = list.indexOf(o))) continue;
                    list.remove(o);
                }
                it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO");
                while (it.hasNext()) {
                    o = (ProcessRequesterDO)it.next();
                    if (!rOId.equals(o.oid_getResourceRequester()) || o.getActivityRequester() != null) continue;
                    index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new ProcessRequesterDO[list.size()];
                list.toArray(DOs);
                for (int i = 0; i < DOs.length; ++i) {
                    ret.add(DOs[i].getId());
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAndJoinEntries(String procId, String asDefId, String aDefId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSAndJoinEntry> ret = new ArrayList<DODSAndJoinEntry>();
        try {
            AndJoinEntryDO[] DOs = this.getPersistedAndJoinEntries(procId, asDefId, aDefId, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    AndJoinEntryDO DO = DOs[i];
                    DODSAndJoinEntry aj = new DODSAndJoinEntry();
                    aj.setProcessId(DO.getProcess().getId());
                    aj.setActivitySetDefinitionId(DO.getActivitySetDefinitionId());
                    aj.setActivityDefinitionId(DO.getActivityDefinitionId());
                    aj.setActivityId(DO.getActivity().getId());
                    ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    ret.add(aj);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public int howManyAndJoinEntries(String procId, String asDefId, String aDefId, SharkTransaction ti) throws PersistenceException {
        try {
            AndJoinEntryDO[] DOs = this.getPersistedAndJoinEntries(procId, asDefId, aDefId, ti);
            if (DOs != null) {
                return DOs.length;
            }
            return 0;
        }
        catch (Throwable tr) {
            throw new PersistenceException(tr);
        }
    }

    public int getExecuteCount(String procId, String asDefId, String aDefId, SharkTransaction ti) throws PersistenceException {
        ActivityQuery qry = new ActivityQuery(((SharkDODSTransaction)ti).getDODSTransaction());
        try {
            qry.setQueryProcess(this.getPersistedProcessObject(procId, ti));
            qry.setQueryActivitySetDefinitionId(asDefId);
            qry.setQueryActivityDefinitionId(aDefId);
            return qry.getCount();
        }
        catch (Throwable e) {
            throw new PersistenceException(e);
        }
    }

    public List getAllDeadlinesForProcess(String procId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSDeadline> ret = new ArrayList<DODSDeadline>();
        try {
            DeadlineDO[] DOs = this.getPersistedDeadlines(procId, -1L, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    DeadlineDO DO = DOs[i];
                    DODSDeadline dl = new DODSDeadline();
                    dl.setProcessId(procId);
                    dl.setActivityId(DO.getActivity().getId());
                    dl.setExceptionName(DO.getExceptionName());
                    dl.setSynchronous(DO.getIsSynchronous());
                    dl.setExecuted(DO.getIsExecuted());
                    dl.setUniqueId(DO.getCNT().toString());
                    dl.setTimeLimit(DO.getTimeLimit());
                    ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    ret.add(dl);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllDeadlinesForProcess(String procId, long timeLimitBoundary, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSDeadline> ret = new ArrayList<DODSDeadline>();
        try {
            DeadlineDO[] DOs = this.getPersistedDeadlines(procId, timeLimitBoundary, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    DeadlineDO DO = DOs[i];
                    DODSDeadline dl = new DODSDeadline();
                    dl.setProcessId(procId);
                    dl.setActivityId(DO.getActivity().getId());
                    dl.setExceptionName(DO.getExceptionName());
                    dl.setSynchronous(DO.getIsSynchronous());
                    dl.setExecuted(DO.getIsExecuted());
                    dl.setUniqueId(DO.getCNT().toString());
                    dl.setTimeLimit(DO.getTimeLimit());
                    ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    ret.add(dl);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllDeadlinesForActivity(String procId, String actId, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSDeadline> ret = new ArrayList<DODSDeadline>();
        try {
            DeadlineDO[] DOs = this.getActivitiesPersistedDeadlines(actId, -1L, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    DeadlineDO DO = DOs[i];
                    DODSDeadline dl = new DODSDeadline();
                    dl.setProcessId(procId);
                    dl.setActivityId(actId);
                    dl.setExceptionName(DO.getExceptionName());
                    dl.setSynchronous(DO.getIsSynchronous());
                    dl.setExecuted(DO.getIsExecuted());
                    dl.setUniqueId(DO.getCNT().toString());
                    dl.setTimeLimit(DO.getTimeLimit());
                    ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    ret.add(dl);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllDeadlinesForActivity(String procId, String actId, long timeLimitBoundary, SharkTransaction ti) throws PersistenceException {
        ArrayList<DODSDeadline> ret = new ArrayList<DODSDeadline>();
        try {
            DeadlineDO[] DOs = this.getActivitiesPersistedDeadlines(actId, timeLimitBoundary, ti);
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    DeadlineDO DO = DOs[i];
                    DODSDeadline dl = new DODSDeadline();
                    dl.setProcessId(procId);
                    dl.setActivityId(actId);
                    dl.setExceptionName(DO.getExceptionName());
                    dl.setSynchronous(DO.getIsSynchronous());
                    dl.setExecuted(DO.getIsExecuted());
                    dl.setUniqueId(DO.getCNT().toString());
                    dl.setTimeLimit(DO.getTimeLimit());
                    ((SharkDODSTransaction)ti)._read((CoreDO)DO);
                    ret.add(dl);
                }
            }
            return ret;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    public List getAllIdsForProcessesWithExpiriedDeadlines(long timeLimitBoundary, SharkTransaction ti) throws PersistenceException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BigDecimal procOpenRunningState = (BigDecimal)this._prStates.get("open.running");
            BigDecimal actNotStartedState = (BigDecimal)this._acStates.get("open.not_running.not_started");
            BigDecimal actRunningState = (BigDecimal)this._acStates.get("open.running");
            String oidCol = ProcessDO.get_OIdColumnName();
            String sqlWherePS = "Processes.State=" + procOpenRunningState;
            String sqlWhereLT = "Processes.Id NOT IN (SELECT LockTable.Id FROM LockTable)";
            String sqlWhereDL = "Processes." + oidCol + " IN (SELECT Deadlines.Process FROM Deadlines WHERE Deadlines.TimeLimit < " + timeLimitBoundary + " AND (SELECT COUNT(*) AS counter FROM Activities WHERE Activities." + oidCol + "=Deadlines.Activity AND (Activities.State=" + actNotStartedState + " OR Activities.State=" + actRunningState + "))>0)";
            ProcessDO[] DOs = null;
            ProcessQuery query = null;
            query = new ProcessQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            QueryBuilder qb = query.getQueryBuilder();
            qb.addWhere(sqlWherePS);
            qb.addWhere(sqlWhereLT);
            qb.addWhere(sqlWhereDL);
            DOs = query.getDOArray();
            if (DOs != null) {
                for (int i = 0; i < DOs.length; ++i) {
                    ret.add(DOs[i].getId());
                }
            }
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
        return ret;
    }

    protected ProcessDefinitionDO getPersistedObject(ProcessMgrPersistenceInterface mgr, SharkTransaction ti) throws PersistenceException {
        ProcessDefinitionDO DO = this.getPersistedProcessMgrObject(mgr.getName(), ti);
        try {
            if (DO == null) {
                DO = ProcessDefinitionDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDefinitionDO getPersistedProcessMgrObject(String name, SharkTransaction ti) throws PersistenceException {
        ProcessDefinitionDO DO = null;
        ProcessDefinitionQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");
            while (it.hasNext()) {
                DO = (ProcessDefinitionDO)it.next();
                if (!name.equals(DO.getName())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");
            while (it.hasNext()) {
                DO = (ProcessDefinitionDO)it.next();
                if (!name.equals(DO.getName())) continue;
                return null;
            }
            query = new ProcessDefinitionQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryName(name);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDefinitionDO[] getAllPersistedProcessMgrs(SharkTransaction ti, String pkgId, String pDefId, String pkgVersion, String where) throws PersistenceException {
        ProcessDefinitionDO[] DOs = null;
        ProcessDefinitionQuery query = null;
        try {
            int index;
            ProcessDefinitionDO o;
            query = new ProcessDefinitionQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (pkgId != null) {
                query.setQueryPackageId(pkgId);
                if (pkgVersion != null) {
                    query.setQueryProcessDefinitionVersion(pkgVersion);
                }
                if (pDefId != null) {
                    query.setQueryProcessDefinitionId(pDefId);
                }
            } else if (null != where) {
                query.getQueryBuilder().addWhere(where);
            }
            DOs = query.getDOArray();
            ArrayList<ProcessDefinitionDO> list = new ArrayList<ProcessDefinitionDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");
            while (it.hasNext()) {
                o = (ProcessDefinitionDO)it.next();
                if (pkgId != null && (!pkgId.equals(o.getPackageId()) || pkgVersion != null && !pkgVersion.equals(o.getProcessDefinitionVersion()) || pDefId != null && !pDefId.equals(o.getProcessDefinitionId())) || -1 == (index = list.indexOf(o))) continue;
                list.remove(o);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDefinitionDO");
            while (it.hasNext()) {
                o = (ProcessDefinitionDO)it.next();
                if (pkgId != null && (!pkgId.equals(o.getPackageId()) || pkgVersion != null && !pkgVersion.equals(o.getProcessDefinitionVersion()) || pDefId != null && !pDefId.equals(o.getProcessDefinitionId()))) continue;
                index = list.indexOf(o);
                if (-1 == index) {
                    list.add(o);
                    continue;
                }
                list.set(index, o);
            }
            DOs = new ProcessDefinitionDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDO getPersistedObject(ProcessPersistenceInterface proc, SharkTransaction ti) throws PersistenceException {
        ProcessDO DO = this.getPersistedProcessObject(proc.getId(), ti);
        try {
            if (DO == null) {
                DO = ProcessDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDO[] getPersistedProcesses(SharkTransaction ti, int type, String pkgId, String pDefId, String pkgVer, Date lastStateTimeBoundary, String sqlWhere) throws PersistenceException {
        ProcessDefinitionDO[] pdefDOs = null;
        if (pkgId != null) {
            pdefDOs = this.getAllPersistedProcessMgrs(ti, pkgId, pDefId, pkgVer, null);
        }
        long lstb = -1L;
        if (lastStateTimeBoundary != null) {
            lstb = lastStateTimeBoundary.getTime();
        }
        ProcessDO[] DOs = null;
        ProcessQuery query = null;
        try {
            ProcessDO o;
            int i;
            query = new ProcessQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            BigDecimal openRunningState = null;
            QueryBuilder qb = query.getQueryBuilder();
            if (lastStateTimeBoundary != null) {
                qb.addWhere(ProcessDO.LastStateTime, lstb, "<");
            }
            if (pkgId != null && pdefDOs != null && pdefDOs.length > 0) {
                qb.addWhereOpenParen();
                for (i = 0; i < pdefDOs.length; ++i) {
                    qb.addWhere(ProcessDO.ProcessDefinition, pdefDOs[i].get_OId().toBigDecimal(), "=");
                    if (i >= pdefDOs.length - 1) continue;
                    qb.addWhereOr();
                }
                qb.addWhereCloseParen();
            }
            if (type == 1) {
                openRunningState = (BigDecimal)this._prStates.get("open.running");
                qb.addWhere(ProcessDO.State, openRunningState, "=");
            } else if (type == -1) {
                qb.addWhereOpenParen();
                for (i = 0; i < this._prClosedStatesBigDecimals.size(); ++i) {
                    qb.addWhere(ProcessDO.State, (BigDecimal)this._prClosedStatesBigDecimals.get(i), "=");
                    if (i >= this._prClosedStatesBigDecimals.size() - 1) continue;
                    qb.addWhereOr();
                }
                qb.addWhereCloseParen();
            }
            if (null != sqlWhere) {
                qb.addWhere(sqlWhere);
            }
            DOs = query.getDOArray();
            ArrayList<ProcessDO> list = new ArrayList<ProcessDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                int index;
                ProcessDefinitionDO pDefDO;
                o = (ProcessDO)it.next();
                if (type == 1 && !o.oid_getState().equals(openRunningState) || type == -1 && !this._prClosedStatesBigDecimals.contains(o.oid_getState()) || lastStateTimeBoundary != null && o.getLastStateTime() > lstb || pkgId != null && (!pkgId.equals((pDefDO = o.getProcessDefinition()).getPackageId()) || pDefId != null && !pDefId.equals(pDefDO.getProcessDefinitionId())) || -1 == (index = list.indexOf(o))) continue;
                list.remove(o);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                ProcessDefinitionDO pDefDO;
                o = (ProcessDO)it.next();
                if (type == 1 && !o.oid_getState().equals(openRunningState) || type == -1 && !this._prClosedStatesBigDecimals.contains(o.oid_getState()) || lastStateTimeBoundary != null && o.getLastStateTime() > lstb || pkgId != null && (!pkgId.equals((pDefDO = o.getProcessDefinition()).getPackageId()) || pDefId != null && !pDefId.equals(pDefDO.getProcessDefinitionId()))) continue;
                int index = list.indexOf(o);
                if (-1 == index) {
                    list.add(o);
                    continue;
                }
                list.set(index, o);
            }
            DOs = new ProcessDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDO getPersistedProcessObject(String procId, SharkTransaction ti) throws PersistenceException {
        ProcessDO DO = null;
        ProcessQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                DO = (ProcessDO)it.next();
                if (!procId.equals(DO.getId())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDO");
            while (it.hasNext()) {
                DO = (ProcessDO)it.next();
                if (!procId.equals(DO.getId())) continue;
                return null;
            }
            query = new ProcessQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryId(procId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessRequesterDO getProcessRequester(String procId, SharkTransaction ti) throws PersistenceException {
        ProcessRequesterDO DO = this.getPersistedRequesterObject(procId, ti);
        try {
            if (null == DO) {
                DO = ProcessRequesterDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessRequesterDO getPersistedRequesterObject(String procId, SharkTransaction ti) throws PersistenceException {
        ProcessRequesterDO DO = null;
        ProcessRequesterQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO");
            while (it.hasNext()) {
                DO = (ProcessRequesterDO)it.next();
                if (!procId.equals(DO.getId())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessRequesterDO");
            while (it.hasNext()) {
                DO = (ProcessRequesterDO)it.next();
                if (!procId.equals(DO.getId())) continue;
                return null;
            }
            query = new ProcessRequesterQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryId(procId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDO getPersistedObject(ActivityPersistenceInterface act, SharkTransaction ti) throws PersistenceException {
        ActivityDO DO = this.getPersistedActivityObject(act.getId(), ti);
        try {
            if (DO == null) {
                DO = ActivityDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDO[] getPersistedActivities(SharkTransaction ti, int type, BigDecimal procOId, String sqlWhere) throws PersistenceException {
        ActivityDO[] DOs = null;
        ActivityQuery query = null;
        try {
            int index;
            ActivityDO o;
            int i;
            query = new ActivityQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            QueryBuilder qb = query.getQueryBuilder();
            if (procOId != null) {
                qb.addWhere(ActivityDO.Process, procOId, "=");
            }
            if (sqlWhere != null) {
                qb.addWhere(sqlWhere);
            }
            if (type == 1) {
                qb.addWhereOpenParen();
                for (i = 0; i < this._actOpenStatesBigDecimals.size(); ++i) {
                    qb.addWhere(ActivityDO.State, (BigDecimal)this._actOpenStatesBigDecimals.get(i), "=");
                    if (i >= this._actOpenStatesBigDecimals.size() - 1) continue;
                    qb.addWhereOr();
                }
                qb.addWhereCloseParen();
            } else if (type == -1) {
                qb.addWhereOpenParen();
                for (i = 0; i < this._actClosedStatesBigDecimals.size(); ++i) {
                    qb.addWhere(ActivityDO.State, (BigDecimal)this._actClosedStatesBigDecimals.get(i), "=");
                    if (i >= this._actClosedStatesBigDecimals.size() - 1) continue;
                    qb.addWhereOr();
                }
                qb.addWhereCloseParen();
            }
            DOs = query.getDOArray();
            ArrayList<ActivityDO> list = new ArrayList<ActivityDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                o = (ActivityDO)it.next();
                if (procOId != null && !o.oid_getProcess().equals(procOId) || type == 1 && !this._actOpenStatesBigDecimals.contains(o.oid_getState()) || type == -1 && !this._actClosedStatesBigDecimals.contains(o.oid_getState()) || -1 == (index = list.indexOf(o))) continue;
                list.remove(o);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                o = (ActivityDO)it.next();
                if (procOId != null && !o.oid_getProcess().equals(procOId)) continue;
                if (type == 1 && !this._actOpenStatesBigDecimals.contains(o.oid_getState())) {
                    list.remove(o);
                    continue;
                }
                if (type == -1 && !this._actClosedStatesBigDecimals.contains(o.oid_getState())) continue;
                index = list.indexOf(o);
                if (-1 == index) {
                    list.add(o);
                    continue;
                }
                list.set(index, o);
            }
            DOs = new ActivityDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDO getPersistedActivityObject(String actId, SharkTransaction ti) throws PersistenceException {
        if (null == actId) {
            return null;
        }
        ActivityDO DO = null;
        ActivityQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                DO = (ActivityDO)it.next();
                if (!actId.equals(DO.getId())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDO");
            while (it.hasNext()) {
                DO = (ActivityDO)it.next();
                if (!actId.equals(DO.getId())) continue;
                return null;
            }
            query = new ActivityQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryId(actId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ResourceDO getPersistedObject(ResourcePersistenceInterface res, SharkTransaction ti) throws PersistenceException {
        ResourceDO DO = this.getPersistedResourceObject(res.getUsername(), ti);
        try {
            if (DO == null) {
                DO = ResourceDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ResourceDO getPersistedResourceObject(String username, SharkTransaction ti) throws PersistenceException {
        if (null == username) {
            return null;
        }
        ResourceDO DO = null;
        ResourceQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ResourceDO");
            while (it.hasNext()) {
                DO = (ResourceDO)it.next();
                if (!username.equals(DO.getUsername())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ResourceDO");
            while (it.hasNext()) {
                DO = (ResourceDO)it.next();
                if (!username.equals(DO.getUsername())) continue;
                return null;
            }
            query = new ResourceQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryUsername(username);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ResourceDO[] getAllPersistedResources(SharkTransaction ti, String sqlWhere) throws PersistenceException {
        ResourceDO[] DOs = null;
        ResourceQuery query = null;
        try {
            int index;
            Object o;
            query = new ResourceQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (null != sqlWhere) {
                query.getQueryBuilder().addWhere(sqlWhere);
            }
            DOs = query.getDOArray();
            ArrayList<ResourceDO> list = new ArrayList<ResourceDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ResourceDO");
            while (it.hasNext()) {
                o = it.next();
                index = list.indexOf(o);
                if (-1 == index) continue;
                list.remove(o);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ResourceDO");
            while (it.hasNext()) {
                o = it.next();
                index = list.indexOf(o);
                if (-1 == index) {
                    list.add((ResourceDO)o);
                    continue;
                }
                list.set(index, (ResourceDO)o);
            }
            DOs = new ResourceDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected AssignmentDO getPersistedObject(AssignmentPersistenceInterface ass, SharkTransaction ti) throws PersistenceException {
        AssignmentDO DO = this.getPersistedAssignmentObject(ass.getActivityId(), ass.getResourceUsername(), ti);
        try {
            if (DO == null) {
                DO = AssignmentDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected AssignmentDO getPersistedAssignmentObject(String actId, String username, SharkTransaction ti) throws PersistenceException {
        AssignmentDO DO = null;
        AssignmentQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
            while (it.hasNext()) {
                DO = (AssignmentDO)it.next();
                if (!username.equals(DO.getResourceId()) || !actId.equals(DO.getActivity().getId())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
            while (it.hasNext()) {
                DO = (AssignmentDO)it.next();
                if (!username.equals(DO.getResourceId()) || !actId.equals(DO.getActivityId())) continue;
                return null;
            }
            DBTransaction dbt = ((SharkDODSTransaction)ti).getDODSTransaction();
            query = new AssignmentQuery(dbt);
            query.setQueryActivityId(actId);
            query.setQueryResourceId(username);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected AssignmentDO[] getAllPersistedAssignments(SharkTransaction ti, String sqlWhere) throws PersistenceException {
        AssignmentDO[] DOs = null;
        AssignmentQuery query = null;
        try {
            int index;
            Object o;
            query = new AssignmentQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (null != sqlWhere) {
                query.getQueryBuilder().addWhere(sqlWhere);
            }
            DOs = query.getDOArray();
            ArrayList<AssignmentDO> list = new ArrayList<AssignmentDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
            while (it.hasNext()) {
                o = it.next();
                index = list.indexOf(o);
                if (-1 == index) continue;
                list.remove(o);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AssignmentDO");
            while (it.hasNext()) {
                o = it.next();
                index = list.indexOf(o);
                if (-1 == index) {
                    list.add((AssignmentDO)o);
                    continue;
                }
                list.set(index, (AssignmentDO)o);
            }
            DOs = new AssignmentDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected AndJoinEntryDO[] getPersistedAndJoinEntries(String procId, String asDefId, String aDefId, SharkTransaction ti) throws PersistenceException {
        AndJoinEntryDO[] DOs = null;
        AndJoinEntryQuery query = null;
        try {
            int index;
            AndJoinEntryDO ajedo;
            query = new AndJoinEntryQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcess(this.getPersistedProcessObject(procId, ti));
            query.setQueryActivitySetDefinitionId(asDefId);
            query.setQueryActivityDefinitionId(aDefId);
            DOs = query.getDOArray();
            ArrayList<AndJoinEntryDO> list = new ArrayList<AndJoinEntryDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO");
            while (it.hasNext()) {
                ajedo = (AndJoinEntryDO)it.next();
                index = list.indexOf(ajedo);
                if ((asDefId != null || ajedo.getActivitySetDefinitionId() != null) && (asDefId == null || !asDefId.equals(ajedo.getActivitySetDefinitionId())) || !aDefId.equals(ajedo.getActivityDefinitionId()) || !procId.equals(ajedo.getProcess().getId()) || -1 == index) continue;
                list.remove(ajedo);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.AndJoinEntryDO");
            while (it.hasNext()) {
                ajedo = (AndJoinEntryDO)it.next();
                index = list.indexOf(ajedo);
                if ((asDefId != null || ajedo.getActivitySetDefinitionId() != null) && (asDefId == null || !asDefId.equals(ajedo.getActivitySetDefinitionId())) || !aDefId.equals(ajedo.getActivityDefinitionId()) || !procId.equals(ajedo.getProcess().getId())) continue;
                if (-1 == index) {
                    list.add(ajedo);
                    continue;
                }
                list.set(index, ajedo);
            }
            DOs = new AndJoinEntryDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected DeadlineDO[] getPersistedDeadlines(String procId, long timeLimitBoundary, SharkTransaction ti) throws PersistenceException {
        DeadlineDO[] DOs = null;
        DeadlineQuery query = null;
        try {
            int index;
            DeadlineDO ddo;
            query = new DeadlineQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcess(this.getPersistedProcessObject(procId, ti));
            if (timeLimitBoundary >= 0L) {
                query.setQueryTimeLimit(timeLimitBoundary, "<");
            }
            DOs = query.getDOArray();
            ArrayList<DeadlineDO> list = new ArrayList<DeadlineDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                ddo = (DeadlineDO)it.next();
                index = list.indexOf(ddo);
                if (!procId.equals(ddo.getProcess().getId()) || -1 == index) continue;
                list.remove(ddo);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                ddo = (DeadlineDO)it.next();
                index = list.indexOf(ddo);
                if (!procId.equals(ddo.getProcess().getId())) continue;
                if (-1 == index) {
                    list.add(ddo);
                    continue;
                }
                list.set(index, ddo);
            }
            DOs = new DeadlineDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected DeadlineDO[] getActivitiesPersistedDeadlines(String actId, long timeLimitBoundary, SharkTransaction ti) throws PersistenceException {
        DeadlineDO[] DOs = null;
        DeadlineQuery query = null;
        try {
            int index;
            DeadlineDO ddo;
            query = new DeadlineQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryActivity(this.getPersistedActivityObject(actId, ti));
            if (timeLimitBoundary >= 0L) {
                query.setQueryTimeLimit(timeLimitBoundary, "<");
            }
            DOs = query.getDOArray();
            ArrayList<DeadlineDO> list = new ArrayList<DeadlineDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                ddo = (DeadlineDO)it.next();
                index = list.indexOf(ddo);
                if (!actId.equals(ddo.getActivity().getId()) || -1 == index) continue;
                list.remove(ddo);
            }
            it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                ddo = (DeadlineDO)it.next();
                index = list.indexOf(ddo);
                if (!actId.equals(ddo.getActivity().getId())) continue;
                if (-1 == index) {
                    list.add(ddo);
                    continue;
                }
                list.set(index, ddo);
            }
            DOs = new DeadlineDO[list.size()];
            list.toArray(DOs);
            return DOs;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected DeadlineDO getPersistedObject(DeadlinePersistenceInterface dpe, SharkTransaction ti) throws PersistenceException {
        DeadlineDO DO = this.getPersistedDeadlineObject(dpe.getUniqueId(), ti);
        try {
            if (DO == null) {
                DO = DeadlineDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected DeadlineDO getPersistedDeadlineObject(String uniqueId, SharkTransaction ti) throws PersistenceException {
        if (uniqueId == null) {
            return null;
        }
        DeadlineDO DO = null;
        DeadlineQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                DO = (DeadlineDO)it.next();
                if (!uniqueId.equals(DO.getCNT())) continue;
                return DO;
            }
            it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.DeadlineDO");
            while (it.hasNext()) {
                DO = (DeadlineDO)it.next();
                if (!uniqueId.equals(DO.getCNT())) continue;
                return null;
            }
            query = new DeadlineQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryCNT(new BigDecimal(uniqueId));
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataDO getPersistedObject(ProcessVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        ProcessDataDO DO = this.getPersistedProcessVariableObject(var.getProcessId(), var.getDefinitionId(), ti);
        try {
            if (DO == null) {
                DO = ProcessDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataDO getPersistedProcessVariableObject(String procId, String defId, SharkTransaction ti) throws PersistenceException {
        ProcessDataDO DO = null;
        ProcessDataQuery query = null;
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (null != pDO) {
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    DO = (ProcessDataDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !pOId.equals(DO.oid_getProcess())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    DO = (ProcessDataDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !pOId.equals(DO.oid_getProcess())) continue;
                    return null;
                }
            }
            query = new ProcessDataQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcess(pDO);
            query.setQueryVariableDefinitionId(defId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataWOBDO getPersistedObject2(ProcessVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        ProcessDataWOBDO DO = this.getPersistedProcessVariableObject2(var.getProcessId(), var.getDefinitionId(), ti);
        try {
            if (DO == null) {
                DO = ProcessDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataWOBDO getPersistedProcessVariableObject2(String procId, String defId, SharkTransaction ti) throws PersistenceException {
        ProcessDataWOBDO DO = null;
        try {
            ProcessDO pDO = this.getPersistedProcessObject(procId, ti);
            if (null != pDO) {
                BigDecimal pOId = pDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataWOBDO");
                while (it.hasNext()) {
                    DO = (ProcessDataWOBDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !pOId.equals(DO.oid_getProcess())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDataDO");
                while (it.hasNext()) {
                    DO = (ProcessDataWOBDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !pOId.equals(DO.oid_getProcess())) continue;
                    return null;
                }
            }
            ProcessDataWOBQuery query = new ProcessDataWOBQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcess(pDO);
            query.setQueryVariableDefinitionId(defId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataBLOBDO getPersistedObject(ProcessDataWOBDO pdDO, SharkTransaction ti) throws PersistenceException {
        ProcessDataBLOBDO DO = this.getPersistedProcessVariableBLOBObject(pdDO, ti);
        try {
            if (DO == null) {
                DO = ProcessDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ProcessDataBLOBDO getPersistedProcessVariableBLOBObject(ProcessDataWOBDO pdDO, SharkTransaction ti) throws PersistenceException {
        ProcessDataBLOBDO DO = null;
        try {
            if (null != pdDO) {
                BigDecimal pdOId = pdDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO");
                while (it.hasNext()) {
                    DO = (ProcessDataBLOBDO)it.next();
                    if (!pdOId.equals(DO.oid_getProcessDataWOB())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ProcessDataBLOBDO");
                while (it.hasNext()) {
                    DO = (ProcessDataBLOBDO)it.next();
                    if (!pdOId.equals(DO.oid_getProcessDataWOB())) continue;
                    return null;
                }
            }
            ProcessDataBLOBQuery query = new ProcessDataBLOBQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessDataWOB(pdDO);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataDO getPersistedObject(ActivityVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        ActivityDataDO DO = this.getPersistedActivityVariableObject(var.getActivityId(), var.getDefinitionId(), ti);
        try {
            if (DO == null) {
                DO = ActivityDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataDO getPersistedActivityVariableObject(String actId, String defId, SharkTransaction ti) throws PersistenceException {
        ActivityDataDO DO = null;
        ActivityDataQuery query = null;
        try {
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (null != aDO) {
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
                while (it.hasNext()) {
                    DO = (ActivityDataDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !aOId.equals(DO.oid_getActivity())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDataDO");
                while (it.hasNext()) {
                    DO = (ActivityDataDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !aOId.equals(DO.oid_getActivity())) continue;
                    return null;
                }
            }
            query = new ActivityDataQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryActivity(aDO);
            query.setQueryVariableDefinitionId(defId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataWOBDO getPersistedObject2(ActivityVariablePersistenceInterface var, SharkTransaction ti) throws PersistenceException {
        ActivityDataWOBDO DO = this.getPersistedActivityVariableObject2(var.getActivityId(), var.getDefinitionId(), ti);
        try {
            if (DO == null) {
                DO = ActivityDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataWOBDO getPersistedActivityVariableObject2(String actId, String defId, SharkTransaction ti) throws PersistenceException {
        ActivityDataWOBDO DO = null;
        try {
            ActivityDO aDO = this.getPersistedActivityObject(actId, ti);
            if (null != aDO) {
                BigDecimal aOId = aDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO");
                while (it.hasNext()) {
                    DO = (ActivityDataWOBDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !aOId.equals(DO.oid_getActivity())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDataWOBDO");
                while (it.hasNext()) {
                    DO = (ActivityDataWOBDO)it.next();
                    if (!defId.equals(DO.getVariableDefinitionId()) || !aOId.equals(DO.oid_getActivity())) continue;
                    return null;
                }
            }
            ActivityDataWOBQuery query = new ActivityDataWOBQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryActivity(aDO);
            query.setQueryVariableDefinitionId(defId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataBLOBDO getPersistedObject(ActivityDataWOBDO adDO, SharkTransaction ti) throws PersistenceException {
        ActivityDataBLOBDO DO = this.getPersistedActivityVariableBLOBObject(adDO, ti);
        try {
            if (DO == null) {
                DO = ActivityDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityDataBLOBDO getPersistedActivityVariableBLOBObject(ActivityDataWOBDO adDO, SharkTransaction ti) throws PersistenceException {
        ActivityDataBLOBDO DO = null;
        try {
            if (null != adDO) {
                BigDecimal pdOId = adDO.get_OId().toBigDecimal();
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO");
                while (it.hasNext()) {
                    DO = (ActivityDataBLOBDO)it.next();
                    if (!pdOId.equals(DO.oid_getActivityDataWOB())) continue;
                    return DO;
                }
                it = ((SharkDODSTransaction)ti).iterator4typeDeleted("class org.enhydra.shark.instancepersistence.data.ActivityDataBLOBDO");
                while (it.hasNext()) {
                    DO = (ActivityDataBLOBDO)it.next();
                    if (!pdOId.equals(DO.oid_getActivityDataWOB())) continue;
                    return null;
                }
            }
            ActivityDataBLOBQuery query = new ActivityDataBLOBQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryActivityDataWOB(adDO);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            return DO;
        }
        catch (Throwable t) {
            throw new PersistenceException(t);
        }
    }

    protected ActivityStateDO getPersistedActivityStateObject(String value, boolean searchByKeyValue, DBTransaction ti) throws PersistenceException {
        ActivityStateDO DO = null;
        ActivityStateQuery query = null;
        try {
            query = new ActivityStateQuery(ti);
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            if (DO == null) {
                DO = ActivityStateDO.createVirgin(ti);
            }
            return DO;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new PersistenceException(t);
        }
    }

    protected ProcessStateDO getPersistedProcessStateObject(String value, boolean searchByKeyValue, DBTransaction ti) throws PersistenceException {
        ProcessStateDO DO = null;
        ProcessStateQuery query = null;
        try {
            query = new ProcessStateQuery(ti);
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            if (DO == null) {
                DO = ProcessStateDO.createVirgin(ti);
            }
            return DO;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new PersistenceException(t);
        }
    }

    public ActivityPersistenceInterface createActivity() {
        return new DODSActivity();
    }

    public ProcessPersistenceInterface createProcess() {
        return new DODSProcess();
    }

    public ProcessMgrPersistenceInterface createProcessMgr() {
        return new DODSProcessMgr();
    }

    public AssignmentPersistenceInterface createAssignment() {
        return new DODSAssignment();
    }

    public ResourcePersistenceInterface createResource() {
        return new DODSResource();
    }

    public ProcessVariablePersistenceInterface createProcessVariable() {
        return new DODSProcessVariable();
    }

    public ActivityVariablePersistenceInterface createActivityVariable() {
        return new DODSActivityVariable();
    }

    public AndJoinEntryInterface createAndJoinEntry() {
        return new DODSAndJoinEntry();
    }

    public DeadlinePersistenceInterface createDeadline() {
        return new DODSDeadline();
    }

    public BigDecimal getNextDecId(String idName) throws PersistenceException {
        try {
            return DODSUtilities.getNext((String)idName);
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't allocate id", (Throwable)e);
        }
    }

    public String getNextId(String idName) throws PersistenceException {
        return this.getNextDecId(idName).toString();
    }

    public List getProcessMgrsWhere(SharkTransaction ti, String sqlWhere) throws PersistenceException {
        ArrayList<ProcessMgrPersistenceInterface> ret = new ArrayList<ProcessMgrPersistenceInterface>();
        ProcessDefinitionDO[] mgrs = this.getAllPersistedProcessMgrs(ti, null, null, null, sqlWhere);
        if (mgrs != null) {
            for (int i = 0; i < mgrs.length; ++i) {
                ProcessMgrPersistenceInterface mgr = this.restore(mgrs[i]);
                ret.add(mgr);
            }
        }
        return ret;
    }

    public List getResourcesWhere(SharkTransaction t, String sqlWhere) throws PersistenceException {
        ResourceDO[] ress;
        ArrayList<ResourcePersistenceInterface> ret = new ArrayList<ResourcePersistenceInterface>();
        if (null != sqlWhere && sqlWhere.trim().length() < 1) {
            sqlWhere = null;
        }
        if ((ress = this.getAllPersistedResources(t, sqlWhere)) != null) {
            for (int i = 0; i < ress.length; ++i) {
                ResourcePersistenceInterface res = this.restore(ress[i]);
                ret.add(res);
            }
        }
        return ret;
    }

    public List getAssignmentsWhere(SharkTransaction t, String sqlWhere) throws PersistenceException {
        ArrayList<AssignmentPersistenceInterface> ret = new ArrayList<AssignmentPersistenceInterface>();
        AssignmentDO[] ass = this.getAllPersistedAssignments(t, sqlWhere);
        if (ass != null) {
            for (int i = 0; i < ass.length; ++i) {
                try {
                    if (!ass[i].getIsValid()) continue;
                    AssignmentPersistenceInterface as = this.restore(ass[i]);
                    ret.add(as);
                    continue;
                }
                catch (Throwable ex) {
                    throw new PersistenceException(ex);
                }
            }
        }
        return ret;
    }

    public List getProcessesWhere(SharkTransaction ti, String sqlWhere) throws PersistenceException {
        ArrayList<ProcessPersistenceInterface> ret = new ArrayList<ProcessPersistenceInterface>();
        ProcessDO[] procs = this.getPersistedProcesses(ti, 0, null, null, null, null, sqlWhere);
        try {
            if (procs != null) {
                for (int i = 0; i < procs.length; ++i) {
                    ProcessPersistenceInterface proc = this.restore(procs[i]);
                    ret.add(proc);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public List getActivitiesWhere(SharkTransaction ti, String sqlWhere) throws PersistenceException {
        ArrayList<ActivityPersistenceInterface> ret = new ArrayList<ActivityPersistenceInterface>();
        ActivityDO[] acts = this.getPersistedActivities(ti, 0, null, sqlWhere);
        if (acts != null) {
            for (int i = 0; i < acts.length; ++i) {
                ActivityPersistenceInterface act = this.restore(acts[i]);
                ret.add(act);
            }
        }
        return ret;
    }
}

