/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.eventaudit;

import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBTransaction;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.eventaudit.AssignmentEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.CreateProcessEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.DataEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.eventaudit.EventAuditException;
import org.enhydra.shark.api.internal.eventaudit.EventAuditManagerInterface;
import org.enhydra.shark.api.internal.eventaudit.StateEventAuditPersistenceInterface;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.enhydra.shark.eventaudit.DODSAssignmentEventAudit;
import org.enhydra.shark.eventaudit.DODSCreateProcessEventAudit;
import org.enhydra.shark.eventaudit.DODSDataEventAudit;
import org.enhydra.shark.eventaudit.DODSEventAudit;
import org.enhydra.shark.eventaudit.DODSStateEventAudit;
import org.enhydra.shark.eventaudit.data.ActivityStateEventAuditDO;
import org.enhydra.shark.eventaudit.data.ActivityStateEventAuditQuery;
import org.enhydra.shark.eventaudit.data.AssignmentEventAuditDO;
import org.enhydra.shark.eventaudit.data.AssignmentEventAuditQuery;
import org.enhydra.shark.eventaudit.data.CreateProcessEventAuditDO;
import org.enhydra.shark.eventaudit.data.CreateProcessEventAuditQuery;
import org.enhydra.shark.eventaudit.data.DataEventAuditDO;
import org.enhydra.shark.eventaudit.data.DataEventAuditQuery;
import org.enhydra.shark.eventaudit.data.EventTypeDO;
import org.enhydra.shark.eventaudit.data.EventTypeQuery;
import org.enhydra.shark.eventaudit.data.NewEventAuditDataBLOBDO;
import org.enhydra.shark.eventaudit.data.NewEventAuditDataDO;
import org.enhydra.shark.eventaudit.data.NewEventAuditDataQuery;
import org.enhydra.shark.eventaudit.data.NewEventAuditDataWOBDO;
import org.enhydra.shark.eventaudit.data.OldEventAuditDataBLOBDO;
import org.enhydra.shark.eventaudit.data.OldEventAuditDataDO;
import org.enhydra.shark.eventaudit.data.OldEventAuditDataQuery;
import org.enhydra.shark.eventaudit.data.OldEventAuditDataWOBDO;
import org.enhydra.shark.eventaudit.data.ProcessStateEventAuditDO;
import org.enhydra.shark.eventaudit.data.ProcessStateEventAuditQuery;
import org.enhydra.shark.eventaudit.data.StateEventAuditDO;
import org.enhydra.shark.eventaudit.data.StateEventAuditQuery;
import org.enhydra.shark.transaction.SharkDODSTransaction;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSEventAuditManager
implements EventAuditManagerInterface {
    protected static final String LOG_CHANNEL = "Persistence";
    protected static final String PACKAGE_LOADED = "packageLoaded";
    protected static final String PACKAGE_UNLOADED = "packageUnloaded";
    protected static final String PACKAGE_UPDATED = "packageUpdated";
    protected static final String PROCESS_CREATED = "processCreated";
    protected static final String PROCESS_STATE_CHANGED = "processStateChanged";
    protected static final String PROCESS_CONTEXT_CHANGED = "processContextChanged";
    protected static final String ACTIVITY_STATE_CHANGED = "activityStateChanged";
    protected static final String ACTIVITY_CONTEXT_CHANGED = "activityContextChanged";
    protected static final String ACTIVITY_RESULT_CHANGED = "activityResultChanged";
    protected static final String ACTIVITY_ASSIGNMENT_CHANGED = "activityAssignmentChanged";
    protected static final int RESOURCE_TYPE_OBJECT = 0;
    protected static final int PROCESS_DEFINITION_TYPE_OBJECT = 1;
    protected static final int PROCESS_TYPE_OBJECT = 2;
    protected static final int ACTIVITY_TYPE_OBJECT = 3;
    protected static final int ASSIGNMENT_TYPE_OBJECT = 4;
    protected static final int EVENT_AUDIT_ASSIGNMENT_TYPE_OBJECT = 5;
    protected static final int EVENT_AUDIT_DATA_TYPE_OBJECT = 6;
    protected static final int EVENT_AUDIT_STATE_TYPE_OBJECT = 7;
    protected static final int EVENT_AUDIT_CREATE_PROCESS_TYPE_OBJECT = 8;
    protected static final int EVENT_AUDIT_PACKAGE_TYPE_OBJECT = 9;
    protected static final String[] activityAndProcessStates = new String[]{"open.running", "open.not_running.not_started", "open.not_running.suspended", "closed.completed", "closed.terminated", "closed.aborted"};
    protected static final String[] eventTypes = new String[]{"packageLoaded", "packageUnloaded", "packageUpdated", "processCreated", "processStateChanged", "processContextChanged", "activityStateChanged", "activityContextChanged", "activityResultChanged", "activityAssignmentChanged"};
    protected static final short DB_TYPE_BOOLEAN = 0;
    protected static final short DB_TYPE_LONG = 1;
    protected static final short DB_TYPE_DOUBLE = 2;
    protected static final short DB_TYPE_VCHAR = 3;
    protected static final short DB_TYPE_DATE = 4;
    protected static final short DB_TYPE_BLOB = 5;
    protected static final int MAX_VCHAR_SIZE_LIMIT = 4000;
    protected static int max_vchar_size = 4000;
    protected CallbackUtilities cus;
    protected Map _prStates;
    protected Map _acStates;
    protected Map _evTypes;
    protected boolean usingStandardVariableDataModel = true;
    protected boolean persistOldEventAuditData = true;

    public void activityCreated(WfActivityInternal activity, WfActivityInternal[] previousActivities, SharkTransaction transaction) {
        throw new RuntimeException("Not implemented error!");
    }

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
        String mvc = cus.getProperty("DODSEventAuditManager.maxVARCHARSize", "4000");
        try {
            max_vchar_size = Integer.parseInt(mvc);
            if (max_vchar_size > 4000 || max_vchar_size < 1) {
                max_vchar_size = 4000;
                cus.warn("Invalid value " + mvc + " for property DODSEventAuditManager.maxVARCHARSize. Using default value " + max_vchar_size);
            }
        }
        catch (Exception e) {
            cus.warn("Invalid value " + mvc + " for property DODSEventAuditManager.maxVARCHARSize. Using default value " + max_vchar_size);
        }
        this.usingStandardVariableDataModel = new Boolean(cus.getProperty("DODSEventAuditManager.useStandardVariableDataModel", "true"));
        this.persistOldEventAuditData = new Boolean(cus.getProperty("PERSIST_OLD_EVENT_AUDIT_DATA", "true"));
        this._prStates = new HashMap();
        this._acStates = new HashMap();
        this._evTypes = new HashMap();
        try {
            try {
                DODSUtilities.init((Properties)cus.getProperties());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.initActivityAndProcessStatesTable();
            this.initEventTypesTable();
        }
        catch (Throwable tr) {
            cus.error(LOG_CHANNEL, "Problem with registering database manager with DODS !", new RootException(tr));
            throw new RootException("Problem with registering database manager with DODS !", tr);
        }
    }

    protected void initActivityAndProcessStatesTable() throws EventAuditException {
        DBTransaction t = null;
        try {
            t = DODS.getDatabaseManager().createTransaction();
            for (int i = 0; i < activityAndProcessStates.length; ++i) {
                String state = activityAndProcessStates[i];
                ProcessStateEventAuditDO psDO = this.getPersistedProcessStateObject(state, true, t);
                if (!psDO.isPersistent()) {
                    psDO.setKeyValue(state);
                }
                psDO.setName(state);
                psDO.save(t);
                this._prStates.put(state, psDO.get_OId().toBigDecimal());
                ActivityStateEventAuditDO asDO = this.getPersistedActivityStateObject(state, true, t);
                if (!asDO.isPersistent()) {
                    asDO.setKeyValue(state);
                }
                asDO.setName(state);
                asDO.save(t);
                this._acStates.put(state, asDO.get_OId().toBigDecimal());
            }
            t.commit();
        }
        catch (Throwable thr) {
            throw new EventAuditException(thr);
        }
        finally {
            try {
                t.release();
            }
            catch (Exception i) {}
        }
    }

    protected void initEventTypesTable() throws EventAuditException {
        DBTransaction t = null;
        try {
            t = DODS.getDatabaseManager().createTransaction();
            for (int i = 0; i < eventTypes.length; ++i) {
                String eventType = eventTypes[i];
                EventTypeDO etDO = this.getPersistedEventTypeObject(eventType, true, t);
                if (!etDO.isPersistent()) {
                    etDO.setKeyValue(eventType);
                }
                etDO.setName(eventType);
                etDO.save(t);
                this._evTypes.put(eventType, etDO.get_OId().toBigDecimal());
            }
            t.commit();
        }
        catch (Throwable thr) {
            throw new EventAuditException(thr);
        }
        finally {
            try {
                t.release();
            }
            catch (Exception i) {}
        }
    }

    public void persist(AssignmentEventAuditPersistenceInterface aea, SharkTransaction ti) throws EventAuditException {
        try {
            AssignmentEventAuditDO DO = AssignmentEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            if (!DO.isPersistent()) {
                DO.setUTCTime(aea.getUTCTime());
                DO.oid_setTheType((BigDecimal)this._evTypes.get(aea.getType()));
                DO.setProcessId(aea.getProcessId());
                DO.setActivityId(aea.getActivityId());
                if (aea.getActivityName() != null) {
                    DO.setActivityName(aea.getActivityName());
                }
                DO.setProcessName(aea.getProcessName());
                DO.setProcessDefinitionName(aea.getProcessDefinitionName());
                DO.setProcessDefinitionVersion(aea.getProcessDefinitionVersion());
                if (aea.getActivityDefinitionId() != null) {
                    DO.setActivityDefinitionId(aea.getActivityDefinitionId());
                    DO.setActivitySetDefinitionId(aea.getActivitySetDefinitionId());
                }
                DO.setProcessDefinitionId(aea.getProcessDefinitionId());
                DO.setPackageId(aea.getPackageId());
                DO.setNewResourceUsername(aea.getNewResourceUsername());
                if (aea.getNewResourceName() != null) {
                    DO.setNewResourceName(aea.getNewResourceName());
                }
                if (aea.getOldResourceUsername() != null) {
                    DO.setOldResourceUsername(aea.getOldResourceUsername());
                }
                if (aea.getOldResourceName() != null) {
                    DO.setOldResourceName(aea.getOldResourceName());
                }
                DO.setIsAccepted(aea.getIsAccepted());
                DO.setCNT(this.getNextDecId("assignmenteventaudit"));
                ((SharkDODSTransaction)ti).store((CoreDO)DO);
            }
            this.cus.info(LOG_CHANNEL, "AssignmentEventAudit[processId=" + aea.getProcessId() + ",activityId=" + aea.getActivityId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of AssignmentEventAudit failed");
            throw new EventAuditException("Persisting of AssignmentEventAudit failed", tr);
        }
    }

    public void persist(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        try {
            DataEventAuditDO DO = DataEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            if (!DO.isPersistent()) {
                DO.setUTCTime(dea.getUTCTime());
                DO.oid_setTheType((BigDecimal)this._evTypes.get(dea.getType()));
                DO.setProcessId(dea.getProcessId());
                if (dea.getActivityId() != null) {
                    DO.setActivityId(dea.getActivityId());
                }
                if (dea.getActivityName() != null) {
                    DO.setActivityName(dea.getActivityName());
                }
                DO.setProcessName(dea.getProcessName());
                DO.setProcessDefinitionName(dea.getProcessDefinitionName());
                DO.setProcessDefinitionVersion(dea.getProcessDefinitionVersion());
                if (dea.getActivityDefinitionId() != null) {
                    DO.setActivityDefinitionId(dea.getActivityDefinitionId());
                    DO.setActivitySetDefinitionId(dea.getActivitySetDefinitionId());
                }
                DO.setProcessDefinitionId(dea.getProcessDefinitionId());
                DO.setPackageId(dea.getPackageId());
                DO.setCNT(this.getNextDecId("dataeventaudit"));
                ((SharkDODSTransaction)ti).store((CoreDO)DO);
                if (this.usingStandardVariableDataModel) {
                    if (this.persistOldEventAuditData) {
                        this.persistOldEventAuditDataBLOB(dea, DO, ti);
                    }
                    this.persistNewEventAuditDataBLOB(dea, DO, ti);
                } else {
                    if (this.persistOldEventAuditData) {
                        this.persistOldEventAuditDataWOB(dea, DO, ti);
                    }
                    this.persistNewEventAuditDataWOB(dea, DO, ti);
                }
            }
            if (dea.getActivityId() != null) {
                this.cus.info(LOG_CHANNEL, "DataEventAudit[processId=" + dea.getProcessId() + ",activityId=" + dea.getActivityId() + "] persisted");
            } else {
                this.cus.info(LOG_CHANNEL, "DataEventAudit[processId=" + dea.getProcessId() + "] persisted");
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of DataEventAudit failed");
            throw new EventAuditException("Persisting of DataEventAudit failed", tr);
        }
    }

    public void persist(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        try {
            StateEventAuditDO DO = StateEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            if (!DO.isPersistent()) {
                DO.setUTCTime(sea.getUTCTime());
                DO.oid_setTheType((BigDecimal)this._evTypes.get(sea.getType()));
                DO.setProcessId(sea.getProcessId());
                if (sea.getActivityId() != null) {
                    DO.setActivityId(sea.getActivityId());
                    DO.oid_setNewActivityState((BigDecimal)this._acStates.get(sea.getNewState()));
                    if (sea.getOldState() != null) {
                        DO.oid_setOldActivityState((BigDecimal)this._acStates.get(sea.getOldState()));
                    }
                } else {
                    DO.oid_setNewProcessState((BigDecimal)this._prStates.get(sea.getNewState()));
                    if (sea.getOldState() != null) {
                        DO.oid_setOldProcessState((BigDecimal)this._prStates.get(sea.getOldState()));
                    }
                }
                if (sea.getActivityName() != null) {
                    DO.setActivityName(sea.getActivityName());
                }
                DO.setProcessName(sea.getProcessName());
                DO.setProcessDefinitionName(sea.getProcessDefinitionName());
                DO.setProcessDefinitionVersion(sea.getProcessDefinitionVersion());
                if (sea.getActivityDefinitionId() != null) {
                    DO.setActivityDefinitionId(sea.getActivityDefinitionId());
                    DO.setActivitySetDefinitionId(sea.getActivitySetDefinitionId());
                }
                DO.setProcessDefinitionId(sea.getProcessDefinitionId());
                DO.setPackageId(sea.getPackageId());
                DO.setCNT(this.getNextDecId("stateeventaudit"));
                ((SharkDODSTransaction)ti).store((CoreDO)DO);
            }
            if (sea.getActivityId() != null) {
                this.cus.info(LOG_CHANNEL, "StateEventAudit[processId=" + sea.getProcessId() + ",activityId=" + sea.getActivityId() + "] persisted");
            } else {
                this.cus.info(LOG_CHANNEL, "StateEventAudit[processId=" + sea.getProcessId() + "] persisted");
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of StateEventAudit failed");
            throw new EventAuditException("Persisting of StateEventAudit failed", tr);
        }
    }

    public void persist(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        try {
            CreateProcessEventAuditDO DO = CreateProcessEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            if (!DO.isPersistent()) {
                DO.setUTCTime(cpea.getUTCTime());
                DO.oid_setTheType((BigDecimal)this._evTypes.get(cpea.getType()));
                DO.setProcessId(cpea.getProcessId());
                DO.setProcessName(cpea.getProcessName());
                DO.setProcessDefinitionId(cpea.getProcessDefinitionId());
                DO.setProcessDefinitionName(cpea.getProcessDefinitionName());
                DO.setProcessDefinitionVersion(cpea.getProcessDefinitionVersion());
                DO.setPackageId(cpea.getPackageId());
                if (cpea.getPProcessId() != null) {
                    DO.setPProcessId(cpea.getPProcessId());
                }
                if (cpea.getPProcessName() != null) {
                    DO.setPProcessName(cpea.getPProcessName());
                }
                if (cpea.getPActivityId() != null) {
                    DO.setPActivityId(cpea.getPActivityId());
                }
                if (cpea.getPPackageId() != null) {
                    DO.setPPackageId(cpea.getPPackageId());
                }
                if (cpea.getPProcessDefinitionId() != null) {
                    DO.setPProcessDefinitionId(cpea.getPProcessDefinitionId());
                }
                if (cpea.getPActivityDefinitionId() != null) {
                    DO.setPActivityDefinitionId(cpea.getPActivityDefinitionId());
                    DO.setPActivitySetDefinitionId(cpea.getPActivitySetDefinitionId());
                }
                if (cpea.getPProcessDefinitionName() != null) {
                    DO.setPProcessDefinitionName(cpea.getPProcessDefinitionName());
                }
                if (cpea.getPProcessDefinitionVersion() != null) {
                    DO.setPProcessDefinitionVersion(cpea.getPProcessDefinitionVersion());
                }
                DO.setCNT(this.getNextDecId("createprocesseventaudit"));
                ((SharkDODSTransaction)ti).store((CoreDO)DO);
            }
            this.cus.info(LOG_CHANNEL, "CreateProcessEventAudit[processId=" + cpea.getProcessId() + "] persisted");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of CreateProcessEventAudit failed");
            throw new EventAuditException("Persisting of CreateProcessEventAudit failed", tr);
        }
    }

    protected void persistOldEventAuditDataBLOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        try {
            Map od = dea.getOldData();
            if (null != od) {
                for (Map.Entry me : od.entrySet()) {
                    String vdId = (String)me.getKey();
                    Object val = me.getValue();
                    OldEventAuditDataDO oedDO = OldEventAuditDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                    oedDO.setDataEventAudit(deaDO);
                    oedDO.setVariableDefinitionId(vdId);
                    boolean isBLOB = false;
                    if (val instanceof Boolean) {
                        oedDO.setVariableValueBOOL((Boolean)val);
                        oedDO.setVariableType((short)0);
                    } else if (val instanceof Long) {
                        oedDO.setVariableValueLONG((Long)val);
                        oedDO.setVariableType((short)1);
                    } else if (val instanceof String) {
                        String sv = (String)val;
                        if (sv.length() <= max_vchar_size) {
                            oedDO.setVariableValueVCHAR(sv);
                            oedDO.setVariableType((short)3);
                        } else {
                            isBLOB = true;
                        }
                    } else if (val instanceof Double) {
                        oedDO.setVariableValueDBL((Double)val);
                        oedDO.setVariableType((short)2);
                    } else if (val instanceof Date) {
                        oedDO.setVariableValueDATE(new Timestamp(((Date)val).getTime()));
                        oedDO.setVariableType((short)4);
                    } else if (val == null) {
                        short vt = oedDO.getVariableType();
                        if (vt == 4) {
                            oedDO.setVariableValueDATE(null);
                        } else if (vt == 3) {
                            oedDO.setVariableValueVCHAR(null);
                        } else {
                            oedDO.setVariableValue(null);
                            oedDO.setVariableType((short)5);
                        }
                    } else {
                        isBLOB = true;
                    }
                    if (isBLOB) {
                        oedDO.setVariableValue(MiscUtilities.serialize(val));
                        oedDO.setVariableType((short)5);
                    }
                    ((SharkDODSTransaction)ti).store((CoreDO)oedDO);
                }
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of OldEventAuditData failed");
            throw new EventAuditException("Persisting of OldEventAuditData failed", tr);
        }
    }

    protected void persistOldEventAuditDataWOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        try {
            Map od = dea.getOldData();
            if (null != od) {
                for (Map.Entry me : od.entrySet()) {
                    String vdId = (String)me.getKey();
                    Object val = me.getValue();
                    OldEventAuditDataWOBDO oedDO = OldEventAuditDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                    oedDO.setDataEventAudit(deaDO);
                    oedDO.setVariableDefinitionId(vdId);
                    boolean isBLOB = false;
                    if (val instanceof Boolean) {
                        oedDO.setVariableValueBOOL((Boolean)val);
                        oedDO.setVariableType((short)0);
                    } else if (val instanceof Long) {
                        oedDO.setVariableValueLONG((Long)val);
                        oedDO.setVariableType((short)1);
                    } else if (val instanceof String) {
                        String sv = (String)val;
                        if (sv.length() <= max_vchar_size) {
                            oedDO.setVariableValueVCHAR(sv);
                            oedDO.setVariableType((short)3);
                        } else {
                            isBLOB = true;
                        }
                    } else if (val instanceof Double) {
                        oedDO.setVariableValueDBL((Double)val);
                        oedDO.setVariableType((short)2);
                    } else if (val instanceof Date) {
                        oedDO.setVariableValueDATE(new Timestamp(((Date)val).getTime()));
                        oedDO.setVariableType((short)4);
                    } else if (val == null) {
                        short vt = oedDO.getVariableType();
                        if (vt == 4) {
                            oedDO.setVariableValueDATE(null);
                        } else if (vt == 3) {
                            oedDO.setVariableValueVCHAR(null);
                        } else {
                            OldEventAuditDataBLOBDO bDO = OldEventAuditDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                            bDO.setOldEventAuditDataWOB(oedDO);
                            bDO.setVariableValue(null);
                            oedDO.setVariableType((short)5);
                            ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                        }
                    } else {
                        isBLOB = true;
                    }
                    if (isBLOB) {
                        OldEventAuditDataBLOBDO bDO = OldEventAuditDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                        bDO.setOldEventAuditDataWOB(oedDO);
                        bDO.setVariableValue(MiscUtilities.serialize(val));
                        oedDO.setVariableType((short)5);
                        ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                    }
                    ((SharkDODSTransaction)ti).store((CoreDO)oedDO);
                }
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of OldEventAuditData failed");
            throw new EventAuditException("Persisting of OldEventAuditData failed", tr);
        }
    }

    protected void persistNewEventAuditDataBLOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        try {
            Map nd = dea.getNewData();
            for (Map.Entry me : nd.entrySet()) {
                String vdId = (String)me.getKey();
                Object val = me.getValue();
                NewEventAuditDataDO nedDO = NewEventAuditDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                nedDO.setDataEventAudit(deaDO);
                nedDO.setVariableDefinitionId(vdId);
                boolean isBLOB = false;
                if (val instanceof Boolean) {
                    nedDO.setVariableValueBOOL((Boolean)val);
                    nedDO.setVariableType((short)0);
                } else if (val instanceof Long) {
                    nedDO.setVariableValueLONG((Long)val);
                    nedDO.setVariableType((short)1);
                } else if (val instanceof String) {
                    String sv = (String)val;
                    if (sv.length() <= max_vchar_size) {
                        nedDO.setVariableValueVCHAR(sv);
                        nedDO.setVariableType((short)3);
                    } else {
                        isBLOB = true;
                    }
                } else if (val instanceof Double) {
                    nedDO.setVariableValueDBL((Double)val);
                    nedDO.setVariableType((short)2);
                } else if (val instanceof Date) {
                    nedDO.setVariableValueDATE(new Timestamp(((Date)val).getTime()));
                    nedDO.setVariableType((short)4);
                } else if (val == null) {
                    short vt = nedDO.getVariableType();
                    if (vt == 4) {
                        nedDO.setVariableValueDATE(null);
                    } else if (vt == 3) {
                        nedDO.setVariableValueVCHAR(null);
                    } else {
                        nedDO.setVariableValue(null);
                        nedDO.setVariableType((short)5);
                    }
                } else {
                    isBLOB = true;
                }
                if (isBLOB) {
                    nedDO.setVariableValue(MiscUtilities.serialize(val));
                    nedDO.setVariableType((short)5);
                }
                ((SharkDODSTransaction)ti).store((CoreDO)nedDO);
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of NewEventAuditData failed");
            throw new EventAuditException("Persisting of NewEventAuditData failed", tr);
        }
    }

    protected void persistNewEventAuditDataWOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        try {
            Map nd = dea.getNewData();
            for (Map.Entry me : nd.entrySet()) {
                String vdId = (String)me.getKey();
                Object val = me.getValue();
                NewEventAuditDataWOBDO nedDO = NewEventAuditDataWOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                nedDO.setDataEventAudit(deaDO);
                nedDO.setVariableDefinitionId(vdId);
                boolean isBLOB = false;
                if (val instanceof Boolean) {
                    nedDO.setVariableValueBOOL((Boolean)val);
                    nedDO.setVariableType((short)0);
                } else if (val instanceof Long) {
                    nedDO.setVariableValueLONG((Long)val);
                    nedDO.setVariableType((short)1);
                } else if (val instanceof String) {
                    String sv = (String)val;
                    if (sv.length() <= max_vchar_size) {
                        nedDO.setVariableValueVCHAR(sv);
                        nedDO.setVariableType((short)3);
                    } else {
                        isBLOB = true;
                    }
                } else if (val instanceof Double) {
                    nedDO.setVariableValueDBL((Double)val);
                    nedDO.setVariableType((short)2);
                } else if (val instanceof Date) {
                    nedDO.setVariableValueDATE(new Timestamp(((Date)val).getTime()));
                    nedDO.setVariableType((short)4);
                } else if (val == null) {
                    short vt = nedDO.getVariableType();
                    if (vt == 4) {
                        nedDO.setVariableValueDATE(null);
                    } else if (vt == 3) {
                        nedDO.setVariableValueVCHAR(null);
                    } else {
                        NewEventAuditDataBLOBDO bDO = NewEventAuditDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                        bDO.setNewEventAuditDataWOB(nedDO);
                        bDO.setVariableValue(null);
                        nedDO.setVariableType((short)5);
                        ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                    }
                } else {
                    isBLOB = true;
                }
                if (isBLOB) {
                    NewEventAuditDataBLOBDO bDO = NewEventAuditDataBLOBDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
                    bDO.setNewEventAuditDataWOB(nedDO);
                    bDO.setVariableValue(MiscUtilities.serialize(val));
                    nedDO.setVariableType((short)5);
                    ((SharkDODSTransaction)ti).store((CoreDO)bDO);
                }
                ((SharkDODSTransaction)ti).store((CoreDO)nedDO);
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Persisting of NewEventAuditData failed");
            throw new EventAuditException("Persisting of NewEventAuditData failed", tr);
        }
    }

    public boolean restore(AssignmentEventAuditPersistenceInterface aea, SharkTransaction ti) throws EventAuditException {
        return this.restore(aea, this.getPersistedObject(aea, ti), ti);
    }

    protected boolean restore(AssignmentEventAuditPersistenceInterface engineObj, AssignmentEventAuditDO DO, SharkTransaction ti) throws EventAuditException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setUTCTime(DO.getUTCTime());
            engineObj.setType(DO.getTheType().getName());
            engineObj.setProcessId(DO.getProcessId());
            engineObj.setActivityId(DO.getActivityId());
            if (DO.getActivityName() != null) {
                engineObj.setActivityName(DO.getActivityName());
            }
            engineObj.setProcessName(DO.getProcessName());
            engineObj.setProcessDefinitionName(DO.getProcessDefinitionName());
            engineObj.setProcessDefinitionVersion(DO.getProcessDefinitionVersion());
            engineObj.setActivityDefinitionId(DO.getActivityDefinitionId());
            engineObj.setActivitySetDefinitionId(DO.getActivitySetDefinitionId());
            engineObj.setProcessDefinitionId(DO.getProcessDefinitionId());
            engineObj.setPackageId(DO.getPackageId());
            engineObj.setNewResourceUsername(DO.getNewResourceUsername());
            if (DO.getNewResourceName() != null) {
                engineObj.setNewResourceName(DO.getNewResourceName());
            }
            if (DO.getOldResourceUsername() != null) {
                engineObj.setOldResourceUsername(DO.getOldResourceUsername());
            }
            if (DO.getOldResourceName() != null) {
                engineObj.setOldResourceName(DO.getOldResourceName());
            }
            engineObj.setIsAccepted(DO.getIsAccepted());
            this.cus.info(LOG_CHANNEL, "AssignmentEventAudit[processId=" + DO.getProcessId() + ",activityId=" + DO.getActivityId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of AssignmentEventAudit failed");
            throw new EventAuditException("Restoring of AssignmentEventAudit failed", tr);
        }
        return true;
    }

    public boolean restore(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        return this.restore(dea, this.getPersistedObject(dea, ti), ti);
    }

    protected boolean restore(DataEventAuditPersistenceInterface engineObj, DataEventAuditDO DO, SharkTransaction ti) throws EventAuditException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setUTCTime(DO.getUTCTime());
            engineObj.setType(DO.getTheType().getName());
            engineObj.setProcessId(DO.getProcessId());
            if (DO.getActivityId() != null) {
                engineObj.setActivityId(DO.getActivityId());
            }
            if (DO.getActivityName() != null) {
                engineObj.setActivityName(DO.getActivityName());
            }
            engineObj.setProcessName(DO.getProcessName());
            engineObj.setProcessDefinitionName(DO.getProcessDefinitionName());
            engineObj.setProcessDefinitionVersion(DO.getProcessDefinitionVersion());
            if (DO.getActivityDefinitionId() != null) {
                engineObj.setActivityDefinitionId(DO.getActivityDefinitionId());
                engineObj.setActivitySetDefinitionId(DO.getActivitySetDefinitionId());
            }
            engineObj.setProcessDefinitionId(DO.getProcessDefinitionId());
            engineObj.setPackageId(DO.getPackageId());
            if (this.usingStandardVariableDataModel) {
                if (this.persistOldEventAuditData) {
                    this.restoreOldEventAuditDataBLOB(engineObj, DO, ti);
                }
                this.restoreNewEventAuditDataBLOB(engineObj, DO, ti);
            } else {
                if (this.persistOldEventAuditData) {
                    this.restoreOldEventAuditDataWOB(engineObj, DO, ti);
                }
                this.restoreNewEventAuditDataWOB(engineObj, DO, ti);
            }
            if (DO.getActivityId() != null) {
                this.cus.info(LOG_CHANNEL, "DataEventAudit[processId=" + DO.getProcessId() + ",activityId=" + DO.getActivityId() + "] restored");
            } else {
                this.cus.info(LOG_CHANNEL, "DataEventAudit[processId=" + DO.getProcessId() + "] restored");
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of DataEventAudit failed");
            throw new EventAuditException("Restoring of DataEventAudit failed", tr);
        }
        return true;
    }

    public boolean restore(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        return this.restore(sea, this.getPersistedObject(sea, ti), ti);
    }

    protected boolean restore(StateEventAuditPersistenceInterface engineObj, StateEventAuditDO DO, SharkTransaction ti) throws EventAuditException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setUTCTime(DO.getUTCTime());
            engineObj.setType(DO.getTheType().getName());
            engineObj.setProcessId(DO.getProcessId());
            if (DO.getActivityId() != null) {
                engineObj.setActivityId(DO.getActivityId());
                engineObj.setNewState(DO.getNewActivityState().getName());
                if (DO.getOldActivityState() != null) {
                    engineObj.setOldState(DO.getOldActivityState().getName());
                }
            } else {
                engineObj.setNewState(DO.getNewProcessState().getName());
                if (DO.getOldProcessState() != null) {
                    engineObj.setOldState(DO.getOldProcessState().getName());
                }
            }
            if (DO.getActivityName() != null) {
                engineObj.setActivityName(DO.getActivityName());
            }
            engineObj.setProcessName(DO.getProcessName());
            engineObj.setProcessDefinitionName(DO.getProcessDefinitionName());
            engineObj.setProcessDefinitionVersion(DO.getProcessDefinitionVersion());
            if (DO.getActivityDefinitionId() != null) {
                engineObj.setActivityDefinitionId(DO.getActivityDefinitionId());
                engineObj.setActivitySetDefinitionId(DO.getActivitySetDefinitionId());
            }
            engineObj.setProcessDefinitionId(DO.getProcessDefinitionId());
            engineObj.setPackageId(DO.getPackageId());
            if (DO.getActivityId() != null) {
                this.cus.info(LOG_CHANNEL, "StateEventAudit[processId=" + DO.getProcessId() + ",activityId=" + DO.getActivityId() + "] restored");
            } else {
                this.cus.info(LOG_CHANNEL, "StateEventAudit[processId=" + DO.getProcessId() + "] restored");
            }
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of StateEventAudit failed");
            throw new EventAuditException("Restoring of StateEventAudit failed", tr);
        }
        return true;
    }

    public boolean restore(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        return this.restore(cpea, this.getPersistedObject(cpea, ti), ti);
    }

    protected boolean restore(CreateProcessEventAuditPersistenceInterface engineObj, CreateProcessEventAuditDO DO, SharkTransaction ti) throws EventAuditException {
        if (DO == null) {
            return false;
        }
        try {
            engineObj.setUTCTime(DO.getUTCTime());
            engineObj.setType(DO.getTheType().getName());
            engineObj.setProcessId(DO.getProcessId());
            engineObj.setProcessName(DO.getProcessName());
            engineObj.setProcessDefinitionId(DO.getProcessDefinitionId());
            engineObj.setProcessDefinitionName(DO.getProcessDefinitionName());
            engineObj.setProcessDefinitionVersion(DO.getProcessDefinitionVersion());
            engineObj.setPackageId(DO.getPackageId());
            if (DO.getPProcessId() != null) {
                engineObj.setPProcessId(DO.getPProcessId());
            }
            if (DO.getPProcessName() != null) {
                engineObj.setPProcessName(DO.getPProcessName());
            }
            if (DO.getPActivityId() != null) {
                engineObj.setPActivityId(DO.getPActivityId());
            }
            if (DO.getPPackageId() != null) {
                engineObj.setPPackageId(DO.getPPackageId());
            }
            if (DO.getPProcessDefinitionId() != null) {
                engineObj.setPProcessDefinitionId(DO.getPProcessDefinitionId());
            }
            if (DO.getPActivityDefinitionId() != null) {
                engineObj.setPActivityDefinitionId(DO.getPActivityDefinitionId());
                engineObj.setPActivitySetDefinitionId(DO.getPActivitySetDefinitionId());
            }
            if (DO.getPProcessDefinitionName() != null) {
                engineObj.setPProcessDefinitionName(DO.getPProcessDefinitionName());
            }
            if (DO.getPProcessDefinitionVersion() != null) {
                engineObj.setPProcessDefinitionVersion(DO.getPProcessDefinitionVersion());
            }
            this.cus.info(LOG_CHANNEL, "CreateProcessEventAudit[processId=" + DO.getProcessId() + "] restored");
        }
        catch (Throwable tr) {
            this.cus.error(LOG_CHANNEL, "Restoring of CreateProcessEventAudit failed");
            throw new EventAuditException("Restoring of CreateProcessEventAudit failed", tr);
        }
        return true;
    }

    protected void restoreOldEventAuditDataBLOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        if (deaDO == null) {
            return;
        }
        try {
            HashMap<String, Object> od = new HashMap<String, Object>();
            OldEventAuditDataDO[] DOs = deaDO.getOldEventAuditDataDOArray();
            if (DOs != null) {
                BigDecimal dOId = deaDO.get_OId().toBigDecimal();
                ArrayList<OldEventAuditDataDO> list = new ArrayList<OldEventAuditDataDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.OldEventAuditDataDO");
                while (it.hasNext()) {
                    OldEventAuditDataDO o = (OldEventAuditDataDO)it.next();
                    if (!dOId.equals(o.oid_getDataEventAudit())) continue;
                    int index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new OldEventAuditDataDO[list.size()];
                if ((DOs = list.toArray(DOs)) != null) {
                    for (int j = 0; j < DOs.length; ++j) {
                        Object val;
                        String vdId = DOs[j].getVariableDefinitionId();
                        short vtype = DOs[j].getVariableType();
                        switch (vtype) {
                            case 0: {
                                val = new Boolean(DOs[j].getVariableValueBOOL());
                                break;
                            }
                            case 1: {
                                val = new Long(DOs[j].getVariableValueLONG());
                                break;
                            }
                            case 2: {
                                val = new Double(DOs[j].getVariableValueDBL());
                                break;
                            }
                            case 3: {
                                val = DOs[j].getVariableValueVCHAR();
                                break;
                            }
                            case 4: {
                                Timestamp d = DOs[j].getVariableValueDATE();
                                if (d != null) {
                                    val = new Date(d.getTime());
                                    break;
                                }
                                val = null;
                                break;
                            }
                            default: {
                                byte[] v = DOs[j].getVariableValue();
                                val = v != null && v.length > 0 ? MiscUtilities.deserialize((byte[])v) : null;
                            }
                        }
                        od.put(vdId, val);
                    }
                }
            }
            dea.setOldData(od);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected void restoreOldEventAuditDataWOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        if (deaDO == null) {
            return;
        }
        try {
            HashMap<String, Object> od = new HashMap<String, Object>();
            OldEventAuditDataWOBDO[] DOs = deaDO.getOldEventAuditDataWOBDOArray();
            if (DOs != null) {
                BigDecimal dOId = deaDO.get_OId().toBigDecimal();
                ArrayList<OldEventAuditDataWOBDO> list = new ArrayList<OldEventAuditDataWOBDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.OldEventAuditDataWOBDO");
                while (it.hasNext()) {
                    OldEventAuditDataWOBDO o = (OldEventAuditDataWOBDO)it.next();
                    if (!dOId.equals(o.oid_getDataEventAudit())) continue;
                    int index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new OldEventAuditDataWOBDO[list.size()];
                if ((DOs = list.toArray(DOs)) != null) {
                    for (int j = 0; j < DOs.length; ++j) {
                        Object val;
                        String vdId = DOs[j].getVariableDefinitionId();
                        short vtype = DOs[j].getVariableType();
                        switch (vtype) {
                            case 0: {
                                val = new Boolean(DOs[j].getVariableValueBOOL());
                                break;
                            }
                            case 1: {
                                val = new Long(DOs[j].getVariableValueLONG());
                                break;
                            }
                            case 2: {
                                val = new Double(DOs[j].getVariableValueDBL());
                                break;
                            }
                            case 3: {
                                val = DOs[j].getVariableValueVCHAR();
                                break;
                            }
                            case 4: {
                                Timestamp d = DOs[j].getVariableValueDATE();
                                if (d != null) {
                                    val = new Date(d.getTime());
                                    break;
                                }
                                val = null;
                                break;
                            }
                            default: {
                                byte[] v = DOs[j].getOldEventAuditDataBLOBDO().getVariableValue();
                                val = v != null && v.length > 0 ? MiscUtilities.deserialize((byte[])v) : null;
                            }
                        }
                        od.put(vdId, val);
                    }
                }
            }
            dea.setOldData(od);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected void restoreNewEventAuditDataBLOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        if (deaDO == null) {
            return;
        }
        try {
            HashMap<String, Object> nd = new HashMap<String, Object>();
            NewEventAuditDataDO[] DOs = deaDO.getNewEventAuditDataDOArray();
            if (DOs != null) {
                BigDecimal dOId = deaDO.get_OId().toBigDecimal();
                ArrayList<NewEventAuditDataDO> list = new ArrayList<NewEventAuditDataDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.NewEventAuditDataDO");
                while (it.hasNext()) {
                    NewEventAuditDataDO o = (NewEventAuditDataDO)it.next();
                    if (!dOId.equals(o.oid_getDataEventAudit())) continue;
                    int index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new NewEventAuditDataDO[list.size()];
                if ((DOs = list.toArray(DOs)) != null) {
                    for (int j = 0; j < DOs.length; ++j) {
                        Object val;
                        String vdId = DOs[j].getVariableDefinitionId();
                        short vtype = DOs[j].getVariableType();
                        switch (vtype) {
                            case 0: {
                                val = new Boolean(DOs[j].getVariableValueBOOL());
                                break;
                            }
                            case 1: {
                                val = new Long(DOs[j].getVariableValueLONG());
                                break;
                            }
                            case 2: {
                                val = new Double(DOs[j].getVariableValueDBL());
                                break;
                            }
                            case 3: {
                                val = DOs[j].getVariableValueVCHAR();
                                break;
                            }
                            case 4: {
                                Timestamp d = DOs[j].getVariableValueDATE();
                                if (d != null) {
                                    val = new Date(d.getTime());
                                    break;
                                }
                                val = null;
                                break;
                            }
                            default: {
                                byte[] v = DOs[j].getVariableValue();
                                val = v != null && v.length > 0 ? MiscUtilities.deserialize((byte[])v) : null;
                            }
                        }
                        nd.put(vdId, val);
                    }
                }
            }
            dea.setNewData(nd);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected void restoreNewEventAuditDataWOB(DataEventAuditPersistenceInterface dea, DataEventAuditDO deaDO, SharkTransaction ti) throws EventAuditException {
        if (deaDO == null) {
            return;
        }
        try {
            HashMap<String, Object> nd = new HashMap<String, Object>();
            NewEventAuditDataWOBDO[] DOs = deaDO.getNewEventAuditDataWOBDOArray();
            if (DOs != null) {
                BigDecimal dOId = deaDO.get_OId().toBigDecimal();
                ArrayList<NewEventAuditDataWOBDO> list = new ArrayList<NewEventAuditDataWOBDO>(Arrays.asList(DOs));
                Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.NewEventAuditDataWOBDO");
                while (it.hasNext()) {
                    NewEventAuditDataWOBDO o = (NewEventAuditDataWOBDO)it.next();
                    if (!dOId.equals(o.oid_getDataEventAudit())) continue;
                    int index = list.indexOf(o);
                    if (-1 == index) {
                        list.add(o);
                        continue;
                    }
                    list.set(index, o);
                }
                DOs = new NewEventAuditDataWOBDO[list.size()];
                if ((DOs = list.toArray(DOs)) != null) {
                    for (int j = 0; j < DOs.length; ++j) {
                        Object val;
                        String vdId = DOs[j].getVariableDefinitionId();
                        short vtype = DOs[j].getVariableType();
                        switch (vtype) {
                            case 0: {
                                val = new Boolean(DOs[j].getVariableValueBOOL());
                                break;
                            }
                            case 1: {
                                val = new Long(DOs[j].getVariableValueLONG());
                                break;
                            }
                            case 2: {
                                val = new Double(DOs[j].getVariableValueDBL());
                                break;
                            }
                            case 3: {
                                val = DOs[j].getVariableValueVCHAR();
                                break;
                            }
                            case 4: {
                                Timestamp d = DOs[j].getVariableValueDATE();
                                if (d != null) {
                                    val = new Date(d.getTime());
                                    break;
                                }
                                val = null;
                                break;
                            }
                            default: {
                                byte[] v = DOs[j].getNewEventAuditDataBLOBDO().getVariableValue();
                                val = v != null && v.length > 0 ? MiscUtilities.deserialize((byte[])v) : null;
                            }
                        }
                        nd.put(vdId, val);
                    }
                }
            }
            dea.setNewData(nd);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    public List restoreProcessHistory(String procId, SharkTransaction ti) throws EventAuditException {
        int i;
        ArrayList<DODSEventAudit> history = new ArrayList<DODSEventAudit>();
        CreateProcessEventAuditDO[] createProcessHistoryDOs = this.getPersistedCreateProcessEventObjects(procId, ti);
        DataEventAuditDO[] dataHistoryDOs = this.getPersistedDataEventObjects(procId, null, ti);
        StateEventAuditDO[] stateHistoryDOs = this.getPersistedStateEventObjects(procId, null, ti);
        if (createProcessHistoryDOs != null) {
            for (i = 0; i < createProcessHistoryDOs.length; ++i) {
                DODSCreateProcessEventAudit a = new DODSCreateProcessEventAudit();
                this.restore(a, createProcessHistoryDOs[i], ti);
                history.add(a);
            }
        }
        if (dataHistoryDOs != null) {
            for (i = 0; i < dataHistoryDOs.length; ++i) {
                DODSDataEventAudit d = new DODSDataEventAudit();
                this.restore(d, dataHistoryDOs[i], ti);
                history.add(d);
            }
        }
        if (stateHistoryDOs != null) {
            for (i = 0; i < stateHistoryDOs.length; ++i) {
                DODSStateEventAudit s = new DODSStateEventAudit();
                this.restore(s, stateHistoryDOs[i], ti);
                history.add(s);
            }
        }
        return history;
    }

    public List restoreActivityHistory(String procId, String actId, SharkTransaction ti) throws EventAuditException {
        int i;
        ArrayList<DODSEventAudit> history = new ArrayList<DODSEventAudit>();
        AssignmentEventAuditDO[] assignmentHistoryDOs = this.getPersistedAssignmentEventObjects(procId, actId, ti);
        DataEventAuditDO[] dataHistoryDOs = this.getPersistedDataEventObjects(procId, actId, ti);
        StateEventAuditDO[] stateHistoryDOs = this.getPersistedStateEventObjects(procId, actId, ti);
        if (assignmentHistoryDOs != null) {
            for (i = 0; i < assignmentHistoryDOs.length; ++i) {
                DODSAssignmentEventAudit a = new DODSAssignmentEventAudit();
                this.restore(a, assignmentHistoryDOs[i], ti);
                history.add(a);
            }
        }
        if (dataHistoryDOs != null) {
            for (i = 0; i < dataHistoryDOs.length; ++i) {
                DODSDataEventAudit d = new DODSDataEventAudit();
                this.restore(d, dataHistoryDOs[i], ti);
                history.add(d);
            }
        }
        if (stateHistoryDOs != null) {
            for (i = 0; i < stateHistoryDOs.length; ++i) {
                DODSStateEventAudit s = new DODSStateEventAudit();
                this.restore(s, stateHistoryDOs[i], ti);
                history.add(s);
            }
        }
        return history;
    }

    public void delete(AssignmentEventAuditPersistenceInterface aea, SharkTransaction ti) throws EventAuditException {
    }

    public void delete(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
    }

    public void delete(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
    }

    public void delete(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
    }

    protected AssignmentEventAuditDO getPersistedObject(AssignmentEventAuditPersistenceInterface aea, SharkTransaction ti) throws EventAuditException {
        AssignmentEventAuditDO DO = null;
        AssignmentEventAuditQuery query = null;
        try {
            String procId = aea.getProcessId();
            String actId = aea.getActivityId();
            String utcTime = aea.getUTCTime();
            String eType = aea.getType();
            String newResUserName = aea.getNewResourceUsername();
            String oldResUserName = aea.getOldResourceUsername();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.AssignmentEventAuditDO");
            while (it.hasNext()) {
                DO = (AssignmentEventAuditDO)it.next();
                if (!procId.equals(DO.getProcessId()) || !actId.equals(DO.getActivityId()) || !utcTime.equals(DO.getUTCTime()) || !eType.equals(DO.getTheType().getName()) || !newResUserName.equals(DO.getNewResourceUsername()) || oldResUserName != null && !oldResUserName.equals(DO.getOldResourceName())) continue;
                return DO;
            }
            query = new AssignmentEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(procId);
            query.setQueryActivityId(actId);
            query.setQueryUTCTime(utcTime);
            query.setQueryTheType(this.getPersistedEventTypeObject(eType, false, ti));
            query.setQueryNewResourceUsername(newResUserName);
            if (oldResUserName != null) {
                query.setQueryOldResourceUsername(oldResUserName);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = AssignmentEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected AssignmentEventAuditDO[] getPersistedAssignmentEventObjects(String pId, String aId, SharkTransaction ti) throws EventAuditException {
        AssignmentEventAuditDO[] DOs = null;
        AssignmentEventAuditQuery query = null;
        try {
            query = new AssignmentEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(pId);
            query.setQueryActivityId(aId);
            DOs = query.getDOArray();
            ArrayList<AssignmentEventAuditDO> list = new ArrayList<AssignmentEventAuditDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.AssignmentEventAuditDO");
            while (it.hasNext()) {
                AssignmentEventAuditDO DO = (AssignmentEventAuditDO)it.next();
                if (!pId.equals(DO.getProcessId()) || !aId.equals(DO.getActivityId())) continue;
                int index = list.indexOf(DO);
                if (-1 == index) {
                    list.add(DO);
                    continue;
                }
                list.set(index, DO);
            }
            DOs = new AssignmentEventAuditDO[list.size()];
            return list.toArray(DOs);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected DataEventAuditDO getPersistedObject(DataEventAuditPersistenceInterface dea, SharkTransaction ti) throws EventAuditException {
        DataEventAuditDO DO = null;
        DataEventAuditQuery query = null;
        try {
            String procId = dea.getProcessId();
            String actId = dea.getActivityId();
            String utcTime = dea.getUTCTime();
            String eType = dea.getType();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.DataEventAuditDO");
            while (it.hasNext()) {
                DO = (DataEventAuditDO)it.next();
                if (!procId.equals(DO.getProcessId()) || !utcTime.equals(DO.getUTCTime()) || !(actId != null ? actId.equals(DO.getActivityId()) && (ACTIVITY_CONTEXT_CHANGED.equals(DO.getTheType().getName()) || ACTIVITY_RESULT_CHANGED.equals(DO.getTheType().getName())) : PROCESS_CONTEXT_CHANGED.equals(DO.getTheType().getName()))) continue;
                return DO;
            }
            query = new DataEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(procId);
            if (actId != null) {
                query.setQueryActivityId(actId);
                query.openParen();
                query.setQueryTheType(this.getPersistedEventTypeObject(ACTIVITY_CONTEXT_CHANGED, false, ti));
                query.or();
                query.setQueryTheType(this.getPersistedEventTypeObject(ACTIVITY_RESULT_CHANGED, false, ti));
                query.closeParen();
            } else {
                query.setQueryTheType(this.getPersistedEventTypeObject(PROCESS_CONTEXT_CHANGED, false, ti));
            }
            query.setQueryUTCTime(utcTime);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = DataEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected DataEventAuditDO[] getPersistedDataEventObjects(String pId, String aId, SharkTransaction ti) throws EventAuditException {
        DataEventAuditDO[] DOs = null;
        DataEventAuditQuery query = null;
        try {
            query = new DataEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(pId);
            if (aId != null) {
                query.setQueryActivityId(aId);
                query.openParen();
                query.setQueryTheType(this.getPersistedEventTypeObject(ACTIVITY_CONTEXT_CHANGED, false, ti));
                query.or();
                query.setQueryTheType(this.getPersistedEventTypeObject(ACTIVITY_RESULT_CHANGED, false, ti));
                query.closeParen();
            } else {
                query.setQueryTheType(this.getPersistedEventTypeObject(PROCESS_CONTEXT_CHANGED, false, ti));
            }
            DOs = query.getDOArray();
            ArrayList<DataEventAuditDO> list = new ArrayList<DataEventAuditDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.DataEventAuditDO");
            while (it.hasNext()) {
                int index;
                DataEventAuditDO DO = (DataEventAuditDO)it.next();
                if (!pId.equals(DO.getProcessId())) continue;
                if (aId != null) {
                    if (!aId.equals(DO.getActivityId()) || !ACTIVITY_CONTEXT_CHANGED.equals(DO.getTheType().getName()) && !ACTIVITY_RESULT_CHANGED.equals(DO.getTheType().getName())) continue;
                    index = list.indexOf(DO);
                    if (-1 == index) {
                        list.add(DO);
                        continue;
                    }
                    list.set(index, DO);
                    continue;
                }
                if (!PROCESS_CONTEXT_CHANGED.equals(DO.getTheType().getName())) continue;
                index = list.indexOf(DO);
                if (-1 == index) {
                    list.add(DO);
                    continue;
                }
                list.set(index, DO);
            }
            DOs = new DataEventAuditDO[list.size()];
            return list.toArray(DOs);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected StateEventAuditDO getPersistedObject(StateEventAuditPersistenceInterface sea, SharkTransaction ti) throws EventAuditException {
        StateEventAuditDO DO = null;
        StateEventAuditQuery query = null;
        try {
            String procId = sea.getProcessId();
            String actId = sea.getActivityId();
            String utcTime = sea.getUTCTime();
            String eType = sea.getType();
            String nState = sea.getNewState();
            String oState = sea.getOldState();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.StateEventAuditDO");
            while (it.hasNext()) {
                DO = (StateEventAuditDO)it.next();
                if (!procId.equals(DO.getProcessId()) || !utcTime.equals(DO.getUTCTime()) || !eType.equals(DO.getTheType().getName()) || !(actId != null ? actId.equals(DO.getActivityId()) && nState.equals(DO.getNewActivityState().getName()) && (oState == null || DO.getOldActivityState() != null && oState.equals(DO.getOldActivityState().getName())) : nState.equals(DO.getNewProcessState().getName()) && (oState == null || DO.getOldProcessState() != null && oState.equals(DO.getOldProcessState().getName())))) continue;
                return DO;
            }
            query = new StateEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(procId);
            if (actId != null) {
                query.setQueryActivityId(actId);
                query.setQueryNewActivityState(this.getPersistedActivityStateObject(sea.getNewState(), false, ti));
                query.setQueryOldActivityState(this.getPersistedActivityStateObject(sea.getOldState(), false, ti));
            } else {
                query.setQueryNewProcessState(this.getPersistedProcessStateObject(sea.getNewState(), false, ti));
                query.setQueryOldProcessState(this.getPersistedProcessStateObject(sea.getOldState(), false, ti));
            }
            query.setQueryTheType(this.getPersistedEventTypeObject(eType, false, ti));
            query.setQueryUTCTime(utcTime);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = StateEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected StateEventAuditDO[] getPersistedStateEventObjects(String pId, String aId, SharkTransaction ti) throws EventAuditException {
        StateEventAuditDO[] DOs = null;
        StateEventAuditQuery query = null;
        try {
            query = new StateEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(pId);
            if (aId != null) {
                query.setQueryActivityId(aId);
                query.setQueryTheType(this.getPersistedEventTypeObject(ACTIVITY_STATE_CHANGED, false, ti));
            } else {
                query.setQueryTheType(this.getPersistedEventTypeObject(PROCESS_STATE_CHANGED, false, ti));
            }
            DOs = query.getDOArray();
            ArrayList<StateEventAuditDO> list = new ArrayList<StateEventAuditDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.StateEventAuditDO");
            while (it.hasNext()) {
                int index;
                StateEventAuditDO DO = (StateEventAuditDO)it.next();
                if (!pId.equals(DO.getProcessId())) continue;
                if (aId != null) {
                    if (!aId.equals(DO.getActivityId()) || !ACTIVITY_CONTEXT_CHANGED.equals(DO.getTheType().getName())) continue;
                    index = list.indexOf(DO);
                    if (-1 == index) {
                        list.add(DO);
                        continue;
                    }
                    list.set(index, DO);
                    continue;
                }
                if (!PROCESS_CONTEXT_CHANGED.equals(DO.getTheType().getName())) continue;
                index = list.indexOf(DO);
                if (-1 == index) {
                    list.add(DO);
                    continue;
                }
                list.set(index, DO);
            }
            DOs = new StateEventAuditDO[list.size()];
            return list.toArray(DOs);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected CreateProcessEventAuditDO getPersistedObject(CreateProcessEventAuditPersistenceInterface cpea, SharkTransaction ti) throws EventAuditException {
        CreateProcessEventAuditDO DO = null;
        CreateProcessEventAuditQuery query = null;
        try {
            String procId = cpea.getProcessId();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.CreateProcessEventAuditDO");
            while (it.hasNext()) {
                DO = (CreateProcessEventAuditDO)it.next();
                if (!procId.equals(DO.getProcessId())) continue;
                return DO;
            }
            query = new CreateProcessEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(procId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = CreateProcessEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected OldEventAuditDataDO getPersistedOldEventAuditDataObject(DataEventAuditDO deaDO, String vdId, SharkTransaction ti) throws EventAuditException {
        OldEventAuditDataDO DO = null;
        OldEventAuditDataQuery query = null;
        try {
            BigDecimal dOId = deaDO.get_OId().toBigDecimal();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.OldEventAuditDataDO");
            while (it.hasNext()) {
                DO = (OldEventAuditDataDO)it.next();
                if (!dOId.equals(DO.oid_getDataEventAudit()) || !vdId.equals(DO.getVariableDefinitionId())) continue;
                return DO;
            }
            query = new OldEventAuditDataQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryDataEventAudit(deaDO);
            query.setQueryVariableDefinitionId(vdId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = OldEventAuditDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected NewEventAuditDataDO getPersistedNewEventAuditDataObject(DataEventAuditDO deaDO, String vdId, SharkTransaction ti) throws EventAuditException {
        NewEventAuditDataDO DO = null;
        NewEventAuditDataQuery query = null;
        try {
            BigDecimal dOId = deaDO.get_OId().toBigDecimal();
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.NewEventAuditDataDO");
            while (it.hasNext()) {
                DO = (NewEventAuditDataDO)it.next();
                if (!dOId.equals(DO.oid_getDataEventAudit()) || !vdId.equals(DO.getVariableDefinitionId())) continue;
                return DO;
            }
            query = new NewEventAuditDataQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryDataEventAudit(deaDO);
            query.setQueryVariableDefinitionId(vdId);
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = NewEventAuditDataDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected CreateProcessEventAuditDO[] getPersistedCreateProcessEventObjects(String pId, SharkTransaction ti) throws EventAuditException {
        CreateProcessEventAuditDO[] DOs = null;
        CreateProcessEventAuditQuery query = null;
        try {
            query = new CreateProcessEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            query.setQueryProcessId(pId);
            DOs = query.getDOArray();
            ArrayList<CreateProcessEventAuditDO> list = new ArrayList<CreateProcessEventAuditDO>(Arrays.asList(DOs));
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.CreateProcessEventAuditDO");
            while (it.hasNext()) {
                CreateProcessEventAuditDO DO = (CreateProcessEventAuditDO)it.next();
                if (!pId.equals(DO.getProcessId())) continue;
                int index = list.indexOf(DO);
                if (-1 == index) {
                    list.add(DO);
                    continue;
                }
                list.set(index, DO);
            }
            DOs = new CreateProcessEventAuditDO[list.size()];
            return list.toArray(DOs);
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected ProcessStateEventAuditDO getPersistedProcessStateObject(String value, boolean searchByKeyValue, SharkTransaction ti) throws EventAuditException {
        ProcessStateEventAuditDO DO = null;
        ProcessStateEventAuditQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.ProcessStateEventAuditDO");
            while (it.hasNext()) {
                DO = (ProcessStateEventAuditDO)it.next();
                if (!(searchByKeyValue ? value.equals(DO.getKeyValue()) : value.equals(DO.getName()))) continue;
                return DO;
            }
            query = new ProcessStateEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = ProcessStateEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected ActivityStateEventAuditDO getPersistedActivityStateObject(String value, boolean searchByKeyValue, DBTransaction ti) throws EventAuditException {
        ActivityStateEventAuditDO DO = null;
        ActivityStateEventAuditQuery query = null;
        try {
            query = new ActivityStateEventAuditQuery(ti);
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            if (DO == null) {
                DO = ActivityStateEventAuditDO.createVirgin(ti);
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected ActivityStateEventAuditDO getPersistedActivityStateObject(String value, boolean searchByKeyValue, SharkTransaction ti) throws EventAuditException {
        ActivityStateEventAuditDO DO = null;
        ActivityStateEventAuditQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.ActivityStateEventAuditDO");
            while (it.hasNext()) {
                DO = (ActivityStateEventAuditDO)it.next();
                if (!(searchByKeyValue ? value.equals(DO.getKeyValue()) : value.equals(DO.getName()))) continue;
                return DO;
            }
            query = new ActivityStateEventAuditQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = ActivityStateEventAuditDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected ProcessStateEventAuditDO getPersistedProcessStateObject(String value, boolean searchByKeyValue, DBTransaction ti) throws EventAuditException {
        ProcessStateEventAuditDO DO = null;
        ProcessStateEventAuditQuery query = null;
        try {
            query = new ProcessStateEventAuditQuery(ti);
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            if (DO == null) {
                DO = ProcessStateEventAuditDO.createVirgin(ti);
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected EventTypeDO getPersistedEventTypeObject(String value, boolean searchByKeyValue, SharkTransaction ti) throws EventAuditException {
        EventTypeDO DO = null;
        EventTypeQuery query = null;
        try {
            Iterator it = ((SharkDODSTransaction)ti).iterator4type("class org.enhydra.shark.eventaudit.data.EventTypeDO");
            while (it.hasNext()) {
                DO = (EventTypeDO)it.next();
                if (!(searchByKeyValue ? value.equals(DO.getKeyValue()) : value.equals(DO.getName()))) continue;
                return DO;
            }
            query = new EventTypeQuery(((SharkDODSTransaction)ti).getDODSTransaction());
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            ((SharkDODSTransaction)ti)._read((CoreDO)DO);
            if (DO == null) {
                DO = EventTypeDO.createVirgin(((SharkDODSTransaction)ti).getDODSTransaction());
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    protected EventTypeDO getPersistedEventTypeObject(String value, boolean searchByKeyValue, DBTransaction ti) throws EventAuditException {
        EventTypeDO DO = null;
        EventTypeQuery query = null;
        try {
            query = new EventTypeQuery(ti);
            if (searchByKeyValue) {
                query.setQueryKeyValue(value);
            } else {
                query.setQueryName(value);
            }
            query.requireUniqueInstance();
            DO = query.getNextDO();
            if (DO == null) {
                DO = EventTypeDO.createVirgin(ti);
            }
            return DO;
        }
        catch (Throwable t) {
            throw new EventAuditException(t);
        }
    }

    public AssignmentEventAuditPersistenceInterface createAssignmentEventAudit() {
        return new DODSAssignmentEventAudit();
    }

    public CreateProcessEventAuditPersistenceInterface createCreateProcessEventAudit() {
        return new DODSCreateProcessEventAudit();
    }

    public DataEventAuditPersistenceInterface createDataEventAudit() {
        return new DODSDataEventAudit();
    }

    public StateEventAuditPersistenceInterface createStateEventAudit() {
        return new DODSStateEventAudit();
    }

    public BigDecimal getNextDecId(String idName) throws EventAuditException {
        try {
            return DODSUtilities.getNext((String)idName);
        }
        catch (Exception e) {
            throw new EventAuditException("Couldn't allocate id");
        }
    }

    public String getNextId(String idName) throws EventAuditException {
        return this.getNextDecId(idName).toString();
    }
}

