/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.caching;

import java.util.ArrayList;
import java.util.List;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.internal.caching.ProcessCache;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.api.internal.working.WfProcessInternal;
import org.enhydra.shark.utilities.LRUMap;

public class LRUProcessCache
implements ProcessCache {
    private final int defaultCacheSize = 100;
    protected LRUMap cache;

    public void configure(CallbackUtilities cus) throws RootException {
        cus.getProperties();
        String procCacheSize = cus.getProperty("LRUProcessCache.Size");
        try {
            int cacheSize = Integer.parseInt(procCacheSize.trim());
            this.cache = new LRUMap(cacheSize);
        }
        catch (Exception ex) {
            this.cache = new LRUMap(100);
        }
        cus.info("Process Cache configured - max. size is " + this.cache.getMaximumSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String procId, WfProcessInternal proc) throws RootException {
        LRUProcessCache lRUProcessCache = this;
        synchronized (lRUProcessCache) {
            this.cache.put((Object)procId, (Object)proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String procId) throws RootException {
        LRUProcessCache lRUProcessCache = this;
        synchronized (lRUProcessCache) {
            this.cache.remove((Object)procId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WfProcessInternal get(String procId) throws RootException {
        WfProcessInternal proc = null;
        LRUProcessCache lRUProcessCache = this;
        synchronized (lRUProcessCache) {
            proc = (WfProcessInternal)this.cache.get((Object)procId);
        }
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) throws RootException {
        if (size < 0) {
            throw new RootException("Can't set negative process cache size");
        }
        LRUProcessCache lRUProcessCache = this;
        synchronized (lRUProcessCache) {
            this.cache.setMaximumSize(size);
        }
    }

    public int getSize() throws RootException {
        return this.cache.getMaximumSize();
    }

    public int howManyEntries() throws RootException {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAll() throws RootException {
        if (this.cache.size() > 0) {
            LRUProcessCache lRUProcessCache = this;
            synchronized (lRUProcessCache) {
                return new ArrayList(this.cache.values());
            }
        }
        return new ArrayList();
    }
}

