/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.authentication;

import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import java.sql.SQLException;
import java.util.Properties;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.internal.authentication.AuthenticationManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.usergroup.data.UserDO;
import org.enhydra.shark.usergroup.data.UserQuery;
import org.enhydra.shark.usertransaction.SharkDODSUserTransaction;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSAuthenticationManager
implements AuthenticationManager {
    private static final String LDB_PARAM_NAME = "DODSAuthenticationManager.DatabaseName";
    private CallbackUtilities callback;
    private LogicalDatabase db;

    public void configure(CallbackUtilities cus) throws RootException {
        if (null == cus) {
            throw new RootException("Cannot configure without call back impl.");
        }
        this.callback = cus;
        DODSUtilities.init((Properties)this.callback.getProperties());
        String dbName = this.callback.getProperty(LDB_PARAM_NAME, DODS.getDatabaseManager().getDefaultDB());
        try {
            this.db = DODS.getDatabaseManager().findLogicalDatabase(dbName);
        }
        catch (DatabaseManagerException e) {
            throw new RootException("Couldn't find logical database.", (Throwable)e);
        }
        this.callback.debug("DODSUserGroupManager configured");
    }

    public boolean validateUser(UserTransaction t, String username, String password) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            ret = null != user ? MiscUtilities.passwordDigest((String)password).equals(user.getPasswd()) : false;
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    private void endTransaction(UserTransaction t, DBTransaction dbt, boolean commitToo) throws RootException {
        if (!dbt.getDatabaseName().equals(this.db.getName())) {
            try {
                if (commitToo) {
                    dbt.commit();
                }
            }
            catch (SQLException e) {
                throw new RootException((Throwable)e);
            }
            finally {
                dbt.release();
            }
        }
    }

    private DBTransaction beginTransaction(UserTransaction t) throws RootException {
        DBTransaction dbt = ((SharkDODSUserTransaction)t).getDODSTransaction();
        if (!dbt.getDatabaseName().equals(this.db.getName())) {
            try {
                dbt = this.db.createTransaction();
            }
            catch (SQLException e) {
                throw new RootException((Throwable)e);
            }
        }
        return dbt;
    }
}

