package org.enhydra.shark.plusworkflow.databasemanager;

import com.zaxxer.hikari.HikariDataSource;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.plusworkflow.databasemanager.oid.CounterAllocatorException;
import org.enhydra.shark.plusworkflow.databasemanager.oid.ObjectIdAllocatorException;
import org.hibernate.SessionFactory;

import java.math.BigDecimal;

public interface HibernateDatabaseManager
{

    void configure( CallbackUtilities callbackUtilities )
        throws RootException;

    HikariDataSource getHikariDataSource();

    SessionFactory buildSessionFactory( HibernateConfigBundle configBundle )
        throws RootException;

    HibernateTransaction createHibernateTransaction( SessionFactory sessionFactory )
        throws TransactionException;

    BigDecimal allocateObjectId()
        throws ObjectIdAllocatorException;

    BigDecimal allocateNextXpdlDataCnt()
        throws CounterAllocatorException;

    BigDecimal allocateNextXpdlHistoryDataCnt()
        throws CounterAllocatorException;

}
