/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.plusworkflow.util;

import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import lombok.NonNull;
import org.enhydra.shark.plusworkflow.util.ContextNotActiveException;
import org.enhydra.shark.plusworkflow.util.ContextNotStackableException;

public class ThreadLocalContext<T> {
    private final ThreadLocal<Deque<T>> localContextStack = ThreadLocal.withInitial(() -> new ArrayDeque(4));
    private final String name;
    private final boolean stackable;

    public ThreadLocalContext(@NonNull String name, boolean stackable) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.stackable = stackable;
    }

    public T current() {
        return this.currentOptional().orElseThrow(() -> new ContextNotActiveException(String.format("Context [%s] is not active.", this.name)));
    }

    public Optional<T> currentOptional() {
        T topContext = this.localContextStack.get().peek();
        return Optional.ofNullable(topContext);
    }

    public boolean isActive() {
        return !this.localContextStack.get().isEmpty();
    }

    public ExecuteStep withNewContext(@NonNull T context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.stackable && this.isActive()) {
            throw new ContextNotStackableException(String.format("Context [%s] is not stackable", this.name));
        }
        return new ExecuteStep(context);
    }

    public void pushContext(@NonNull T context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.stackable && this.isActive()) {
            throw new ContextNotStackableException(String.format("Context [%s] is not stackable", this.name));
        }
        Deque<T> contextStack = this.localContextStack.get();
        contextStack.push(context);
    }

    public void popContext() {
        Deque<T> contextStack = this.localContextStack.get();
        contextStack.pop();
    }

    @FunctionalInterface
    public static interface WithContextFunction<T, R> {
        public R execute(T var1);
    }

    @FunctionalInterface
    public static interface WithContextRunnable<T> {
        public void execute(T var1);
    }

    public class ExecuteStep {
        private T context;

        public void execute(@NonNull WithContextRunnable<T> runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable");
            }
            Deque contextStack = (Deque)ThreadLocalContext.this.localContextStack.get();
            try {
                contextStack.push(this.context);
                runnable.execute(this.context);
            }
            finally {
                contextStack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R execute(@NonNull WithContextFunction<T, R> supplier) {
            if (supplier == null) {
                throw new NullPointerException("supplier");
            }
            Deque contextStack = (Deque)ThreadLocalContext.this.localContextStack.get();
            try {
                contextStack.push(this.context);
                R r = supplier.execute(this.context);
                return r;
            }
            finally {
                contextStack.pop();
            }
        }

        @ConstructorProperties(value={"context"})
        private ExecuteStep(T context) {
            this.context = context;
        }
    }
}

